<?php
// Deep Debug: Check users table structure

// First, try to include the config file
if (file_exists('config/db.php')) {
    require_once 'config/db.php';
    $conn = $connection;
} elseif (file_exists('includes/config.php')) {
    include 'includes/config.php';
} elseif (file_exists('auth-system/config.php')) {
    include 'auth-system/config.php';
}

// If config didn't work, connect directly
if (!isset($conn) || !$conn) {
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    if ($conn->connect_error) {
        $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    }
}

if ($conn->connect_error) {
    die('Database connection failed: ' . $conn->connect_error);
}

echo "<h1>Deep Debug: Users Table Analysis</h1>";

// Check if users table exists
echo "<h2>1. Check if 'users' table exists:</h2>";
$tables_result = $conn->query("SHOW TABLES LIKE 'users'");
if ($tables_result->num_rows > 0) {
    echo "<p style='color:green;'><strong>✓ Users table exists</strong></p>";
} else {
    echo "<p style='color:red;'><strong>✗ Users table NOT found!</strong></p>";
    echo "<p>Available tables:</p>";
    $all_tables = $conn->query("SHOW TABLES");
    echo "<ul>";
    while ($table = $all_tables->fetch_row()) {
        echo "<li>" . htmlspecialchars($table[0]) . "</li>";
    }
    echo "</ul>";
}

// Check users table structure
echo "<h2>2. Users table structure:</h2>";
$columns_result = $conn->query("DESCRIBE users");
if ($columns_result && $columns_result->num_rows > 0) {
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($col = $columns_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($col['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Default']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Extra']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:red;'><strong>Could not get table structure!</strong></p>";
}

// Count users
echo "<h2>3. Count users:</h2>";
$count_result = $conn->query("SELECT COUNT(*) as total FROM users");
if ($count_result) {
    $count_row = $count_result->fetch_assoc();
    echo "<p><strong>Total users:</strong> " . $count_row['total'] . "</p>";
} else {
    echo "<p style='color:red;'>Error: " . $conn->error . "</p>";
}

// List all users with all fields
echo "<h2>4. All users with all fields:</h2>";
$all_users = $conn->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 20");
if ($all_users && $all_users->num_rows > 0) {
    echo "<p>Found " . $all_users->num_rows . " users:</p>";
    echo "<table border='1' cellpadding='10'>";
    
    // Get field names
    $fields = [];
    while ($field = $all_users->fetch_field()) {
        $fields[] = $field->name;
    }
    
    // Print header
    echo "<tr>";
    foreach ($fields as $field) {
        echo "<th>" . htmlspecialchars($field) . "</th>";
    }
    echo "</tr>";
    
    // Reset result pointer
    $all_users = $conn->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 20");
    
    // Print rows
    while ($user = $all_users->fetch_assoc()) {
        echo "<tr>";
        foreach ($fields as $field) {
            echo "<td>" . htmlspecialchars($user[$field] ?? 'NULL') . "</td>";
        }
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p><strong>No users found.</strong></p>";
}

echo "<hr>";
echo "<p><a href='admin-dashboard.php'>Back to Admin Dashboard</a></p>";

$conn->close();
?>
