<?php
// Debug: Check if users exist in database

// First, try to include the config file
$config_included = false;
if (file_exists('includes/config.php')) {
    include 'includes/config.php';
    $config_included = true;
} elseif (file_exists('auth-system/config.php')) {
    include 'auth-system/config.php';
    $config_included = true;
}

// If config didn't work, connect directly
if (!$config_included || !isset($conn)) {
   $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    if ($conn->connect_error) {
        $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    }
}

if ($conn->connect_error) {
    die('Database connection failed: ' . $conn->connect_error);
}

echo "<h2>Debug: Users Query Test</h2>";

// Test 1: Count all users
$count_result = $conn->query("SELECT COUNT(*) as total FROM users");
$count_row = $count_result->fetch_assoc();
echo "<p><strong>Total users in database:</strong> " . $count_row['total'] . "</p>";

// Test 2: Run the exact query from admin-dashboard
$users_query = "
    SELECT id, name, email, phone, created_at
    FROM users
    ORDER BY created_at DESC
";

echo "<p><strong>Running query:</strong></p>";
echo "<pre>" . htmlspecialchars($users_query) . "</pre>";

$users_result = $conn->query($users_query);

if (!$users_result) {
    echo "<p style='color:red;'><strong>Query failed!</strong></p>";
    echo "<p>Error: " . $conn->error . "</p>";
} else {
    echo "<p style='color:green;'><strong>Query successful!</strong></p>";
    echo "<p>Rows returned: " . $users_result->num_rows . "</p>";
    
    if ($users_result->num_rows > 0) {
        echo "<h3>Users Found:</h3>";
        echo "<table border='1' cellpadding='10'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Created At</th></tr>";
        
        while ($user = $users_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['phone']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_at']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color:orange;'><strong>No users found in database.</strong></p>";
    }
}

$conn->close();
?>
