@echo off
REM Download PHPMailer files manually (without Composer)
REM This script creates the PHPMailer folder and downloads the 3 essential files

setlocal enabledelayedexpansion

REM Set paths
set "phpmailer_dir=C:\xampp\htdocs\interior\auth-system\PHPMailer"

REM Create folder if it doesn't exist
if not exist "%phpmailer_dir%" (
    mkdir "%phpmailer_dir%"
    echo. Created folder: %phpmailer_dir%
)

echo.
echo =========================================
echo Downloading PHPMailer files...
echo =========================================
echo.

REM Download PHPMailer.php
echo Downloading PHPMailer.php...
powershell -Command "Invoke-WebRequest -Uri 'https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/PHPMailer.php' -OutFile '%phpmailer_dir%\PHPMailer.php'"
if exist "%phpmailer_dir%\PHPMailer.php" (
    echo ✓ PHPMailer.php downloaded successfully
) else (
    echo ✗ Failed to download PHPMailer.php
)

REM Download SMTP.php
echo Downloading SMTP.php...
powershell -Command "Invoke-WebRequest -Uri 'https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/SMTP.php' -OutFile '%phpmailer_dir%\SMTP.php'"
if exist "%phpmailer_dir%\SMTP.php" (
    echo ✓ SMTP.php downloaded successfully
) else (
    echo ✗ Failed to download SMTP.php
)

REM Download Exception.php
echo Downloading Exception.php...
powershell -Command "Invoke-WebRequest -Uri 'https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/Exception.php' -OutFile '%phpmailer_dir%\Exception.php'"
if exist "%phpmailer_dir%\Exception.php" (
    echo ✓ Exception.php downloaded successfully
) else (
    echo ✗ Failed to download Exception.php
)

echo.
echo =========================================
echo.
echo Checking files...
dir "%phpmailer_dir%"

echo.
echo =========================================
echo NEXT STEPS:
echo =========================================
echo.
echo 1. Get Gmail App Password:
echo    Go to: https://myaccount.google.com/apppasswords
echo.
echo 2. Update EmailService.php:
echo    Edit: C:\xampp\htdocs\interior\auth-system\EmailService.php
echo    Find: $mail->Username = 'your-email@gmail.com'
echo    Replace with your email
echo.
echo 3. Test it works:
echo    Visit: http://localhost/interior/test-send-email.php
echo.
echo =========================================

pause
