@echo off
REM PHP Configuration Fix for Composer
REM This script fixes the duplicate openssl module issue in php.ini

echo.
echo ========================================
echo PHP Configuration Fix
echo ========================================
echo.

REM Backup the original php.ini
echo Backing up original php.ini...
copy "C:\xampp\php\php.ini" "C:\xampp\php\php.ini.backup"

if errorlevel 1 (
    echo ERROR: Could not backup php.ini
    pause
    exit /b 1
)

echo Backup created: C:\xampp\php\php.ini.backup
echo.

REM Create a fixed version
echo Creating fixed php.ini...
echo.

REM The issue: openssl is loaded multiple times
REM Solution: Use PowerShell to remove duplicate extension=php_openssl.dll lines

powershell -Command "
$filePath = 'C:\xampp\php\php.ini'
$content = Get-Content $filePath | Select-Object -Unique
$content | Set-Content $filePath
Write-Host 'Removed duplicate extensions from php.ini'
"

if errorlevel 1 (
    echo ERROR: Could not fix php.ini
    echo Restoring backup...
    copy "C:\xampp\php\php.ini.backup" "C:\xampp\php\php.ini"
    pause
    exit /b 1
)

echo.
echo ========================================
echo Fix Complete!
echo ========================================
echo.
echo Changes made:
echo - Removed duplicate extensions
echo - Backup saved to: C:\xampp\php\php.ini.backup
echo.
echo You can now run:
echo composer require phpmailer/phpmailer
echo.
pause
