@echo off
REM PHP Configuration Fix for Composer - Enhanced Version
REM This script fixes the duplicate openssl module issue in php.ini

setlocal enabledelayedexpansion

echo.
echo ========================================
echo PHP Configuration Fix for Composer
echo ========================================
echo.

REM Check if running as administrator
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo WARNING: This script should be run as Administrator
    echo for best results.
    echo.
)

set PHP_INI=C:\xampp\php\php.ini

REM Verify php.ini exists
if not exist "%PHP_INI%" (
    echo ERROR: php.ini not found at: %PHP_INI%
    echo.
    echo Please check your XAMPP installation path.
    pause
    exit /b 1
)

echo Found php.ini: %PHP_INI%
echo.

REM Backup the original php.ini
echo Creating backup...
set BACKUP_FILE=%PHP_INI%.backup.%date:~-4,4%%date:~-10,2%%date:~-7,2%_%time:~0,2%%time:~3,2%
copy "%PHP_INI%" "%BACKUP_FILE%"

if errorlevel 1 (
    echo ERROR: Could not backup php.ini
    pause
    exit /b 1
)

echo ✓ Backup created: %BACKUP_FILE%
echo.

REM Now use PowerShell to remove duplicates
echo Analyzing and fixing php.ini...
echo.

powershell -NoProfile -ExecutionPolicy Bypass -Command "
try {
    $filePath = '%PHP_INI%'
    
    # Read all lines
    $allLines = Get-Content $filePath
    
    # Create ordered hashtable to track unique lines
    $uniqueLines = [ordered]@{}
    
    # Process each line
    foreach ($line in $allLines) {
        # Get the key (normalize the line for comparison)
        if ($line -match '^extension=') {
            # Extract the extension name
            $key = $line.Trim()
            
            # Only add if not already seen
            if (-not $uniqueLines.ContainsKey($key)) {
                $uniqueLines[$key] = $true
                $line  # Output the line to keep it
            } else {
                # Skip duplicate
                Write-Host '  Removed duplicate: '$key
            }
        } else {
            # Keep non-extension lines as is
            $line  # Output the line
        }
    }
} catch {
    Write-Host 'ERROR: '$_.Exception.Message
    exit 1
}
" | Out-File -FilePath "%PHP_INI%" -Encoding UTF8

if errorlevel 1 (
    echo ERROR: Could not fix php.ini
    echo.
    echo Restoring backup...
    copy "%BACKUP_FILE%" "%PHP_INI%"
    echo Restored from: %BACKUP_FILE%
    pause
    exit /b 1
)

echo.
echo ✓ Duplicates removed!
echo.

REM Verify the fix
echo Verifying PHP configuration...
echo.

php -v >nul 2>&1
if errorlevel 1 (
    echo WARNING: PHP validation failed
    echo.
    echo Possible solutions:
    echo 1. Restart XAMPP Apache service
    echo 2. Manually review: %PHP_INI%
    echo 3. Restore backup: %BACKUP_FILE%
) else (
    echo ✓ PHP is working correctly!
)

echo.
echo ========================================
echo Fix Complete!
echo ========================================
echo.
echo Summary:
echo - Original: %PHP_INI%
echo - Backup:   %BACKUP_FILE%
echo.
echo Next step: Run composer installation
echo.
echo Command:
echo   cd C:\xampp\htdocs\interior
echo   composer require phpmailer/phpmailer
echo.

pause
