<?php
session_start();
require_once __DIR__ . '/config/db.php';

$page_title = 'Gallery - Faren Interior Design';
$user_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
   <!-- header -->
     <?php include 'header-section.html'; ?>
    <!--  -->
    <!--  -->

    <div class="overflow-hidden space overflow-hidden" id="project-sec">
        
        <div class="container">
        <style>
 /* ----------------------------------------------
   GALLERY RESPONSIVE FIX (BEST RESULT)
------------------------------------------------ */

#project-sec {
    margin-top: 280px;
}

.gallery-row {
    display: flex;
    flex-wrap: wrap;
    gap: 30px;
}

.gallery-card {
    background: #0d1c17;
    border-radius: 14px;
    overflow: hidden;
    transition: .3s;
}

.gallery-card:hover {
    transform: translateY(-6px);
}

.gallery-card .box-img img {
    width: 100%;
    height: 280px;
    object-fit: cover;
}

/* Reduce image height on tablets */
@media (max-width: 992px) {
    .gallery-card .box-img img {
        height: 240px;
    }
}

/* Mobile responsive */
@media (max-width: 576px) {
    #project-sec {
        margin-top: 0;
    }

    .gallery-card .box-img img {
        height: 200px;
    }

    .gallery-card h2.box-title {
        font-size: 16px;
        text-align: center;
    }

    .filter-menu {
        text-align: center;
    }
}

</style>
            
            <div class="row justify-content-center">
                <div class="col-xl-7">
                    <div class="filter-menu indicator-active mb-60 filter-menu-active"><button data-filter="*"
                            class="tab-btn active" type="button">View All</button> <button data-filter=".cat1"
                            class="tab-btn" type="button">Interior</button> <button data-filter=".cat2" class="tab-btn"
                            type="button">Architecture</button> <button data-filter=".cat3" class="tab-btn"
                            type="button">Building</button> <button data-filter=".cat4" class="tab-btn"
                            type="button">Exterior</button> <button data-filter=".cat5" class="tab-btn"
                            type="button">Shape</button>
                    </div>
                </div>
            </div>
            <div class="row gy-4 gallery-row filter-active">
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat1" data-gallery-id="6">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/img/gallery/gallery_2_6.jpg" alt="Open Kitchen Interior Design"> <a href="assets/img/gallery/gallery_2_6.jpg" class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat3 cat5" data-gallery-id="7">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/img/gallery/gallery_2_7.jpg"
                                alt="gallery image"> <a href="assets/img/gallery/gallery_2_7.jpg"
                                class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat1" data-gallery-id="8">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/img/gallery/gallery_2_8.jpg" alt="kitchen"> <a href="assets/img/gallery/gallery_2_8.jpg" class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">kitchen</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat4 cat2 cat1" data-gallery-id="9">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/img/gallery/gallery_2_9.jpg"
                                alt="gallery image"> <a href="assets/img/gallery/gallery_2_9.jpg"
                                class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat1" data-gallery-id="10">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/uploads/gallery/1766572543_694bc1ff3e06f.jpg" alt="interior"> <a href="assets/uploads/gallery/1766572543_694bc1ff3e06f.jpg" class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">interior</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat1" data-gallery-id="11">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img src="assets/uploads/gallery/1766680133_694d66454610c.jpg" alt="room"> <a href="assets/uploads/gallery/1766680133_694d66454610c.jpg" class="icon-btn th-popup-image"><i class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">room</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- FOOTER -->

    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
   
    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg></div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php include 'footer-section.html'; ?>