<?php
// This header checks actual session for PHP pages
$isLoggedIn = isset($_SESSION['user_id']);
$userName = $isLoggedIn ? ($_SESSION['name'] ?? 'User') : 'User';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- Compact mobile header fallback: ensures header is visible on small screens -->
    <div class="mobile-header-fixed" aria-hidden="false">
        <div class="mobile-header-inner">
            <a href="index.php" class="mobile-logo"><img src="assets/img/logo-white.svg"
                    alt="Faren" /></a>
            <div id="mobile-welcome" style="display:none; margin-left:12px; font-size:14px; color:#333; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:40%;">Welcome, <span id="mobile-welcome-name"></span></div>
            <button class="mobile-menu-btn" aria-label="Open menu">
                <span class="mh-bars">☰</span>
            </button>
        </div>
    </div>
    <style>
        .mobile-header-fixed {
            display: none;
        }

        /* Mobile: 320px to 768px */
        @media (max-width: 768px) {
            .mobile-header-fixed {
                display: block;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                height: 56px;
                background: #000000;
                z-index: 11000;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
            }

            .mobile-header-inner {
                max-width: 100%;
                margin: 0;
                padding: 8px 12px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                height: 100%;
            }

            .mobile-logo img {
                height: 40px;
                display: block;
                width: auto;
            }

            .mobile-menu-btn {
                background: aliceblue;
                border: none;
                font-size: 22px;
                padding: 6px 10px;
                cursor: pointer;
                z-index: 11001;
                position: relative;
            }

            #mobile-welcome {
                display: block !important;
            }

            /* push page content down so header doesn't overlap */
            body {
                padding-top: 56px;
            }

            /* Hide desktop header on mobile */
            .sticky-wrapper,
            .th-header {
                display: none !important;
            }

            /* Ensure menu wrapper works on mobile */
            .th-menu-wrapper {
                display: block;
                pointer-events: auto;
            }

            .th-menu-wrapper .th-menu-toggle {
                z-index: 11002;
            }
        }

        /* Tablet: 769px to 1024px */
        @media (min-width: 769px) and (max-width: 1024px) {
            .mobile-header-fixed {
                display: block;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                height: 60px;
                background: #000000;
                z-index: 11000;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
            }

            .mobile-header-inner {
                max-width: 100%;
                margin: 0;
                padding: 10px 16px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                height: 100%;
            }

            .mobile-logo img {
                height: 45px;
                display: block;
                width: auto;
            }

            .mobile-menu-btn {
                background: aliceblue;
                border: none;
                font-size: 24px;
                padding: 8px 12px;
                cursor: pointer;
                z-index: 11001;
                position: relative;
            }

            #mobile-welcome {
                display: block !important;
                font-size: 15px;
            }

            body {
                padding-top: 60px;
            }

            .sticky-wrapper,
            .th-header {
                display: none !important;
            }

            .th-menu-wrapper {
                display: block;
                pointer-events: auto;
            }

            .th-menu-wrapper .th-menu-toggle {
                z-index: 11002;
            }
        }

        /* Desktop: 1025px and above */
        @media (min-width: 1025px) {
            .mobile-header-fixed {
                display: none !important;
            }

            .mobile-menu-btn {
                display: none !important;
            }

            #mobile-welcome {
                display: none !important;
            }

            body {
                padding-top: 0 !important;
            }

            .sticky-wrapper,
            .th-header {
                display: block !important;
            }

            /* Hide mobile menu on desktop */
            .th-menu-wrapper {
                display: none !important;
            }
        }
    </style>
    <div class="cursor"></div>
    <div class="cursor2"></div>
    <!-- <div class="color-scheme-wrap active"><button class="switchIcon"><i class="fa-solid fa-palette"></i></button>
        <h4 class="color-scheme-wrap-title"><i class="far fa-palette me-2"></i>Style Swicher</h4>
        <div class="color-switch-btns"><button data-color="#3E66F3"><i class="fa-solid fa-droplet"></i></button> <button
                data-color="#684DF4"><i class="fa-solid fa-droplet"></i></button> <button data-color="#008080"><i
                    class="fa-solid fa-droplet"></i></button> <button data-color="#323F7C"><i
                    class="fa-solid fa-droplet"></i></button> <button data-color="#FC3737"><i
                    class="fa-solid fa-droplet"></i></button> <button data-color="#8a2be2"><i
                    class="fa-solid fa-droplet"></i></button></div><a href="https://themeforest.net/user/themeholy"
            class="th-btn text-center w-100"><i class="fa fa-shopping-cart me-2"></i> Purchase</a>
    </div> -->
    <div class="loader-wrap"><svg viewbox="0 0 1000 1000" preserveaspectratio="none">
            <path id="svg" d="M0,1005S175,995,500,995s500,5,500,5V0H0Z"></path>
        </svg>
        <div class="loader-wrap-heading">
            <div class="load-text"><span>  LOADING  </span>
            </div>
        </div>
    </div>
    <div class="sidemenu-wrapper">
        <div class="sidemenu-content"><button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>
            <div class="widget footer-widget mb-0">
                <div class="th-widget-about">
                    <div class="about-logo"><a href="index.php"><img src="assets/img/logo.svg" alt="Faren  "></a></div>
                    <p class="about-text">Minimal interiors often feel larger than they are. Neutral colors, natural
                        materials, and an uncluttered layout help reflect light and create an airy,</p>
                </div>
            </div>
            <div class="widget footer-widget">
                <h3 class="widget_title">Featured Blog</h3>
                <div class="recent-post-wrap">
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.php"><img
                                    src="assets/img/blog/recent-post-1-1.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.html">June 12, 2025</a> <a href="blog.html">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.php">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.html"><img
                                    src="assets/img/blog/recent-post-1-2.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.html">June 12, 2025</a> <a href="blog.php">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.html">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.html"><img
                                    src="assets/img/blog/recent-post-1-3.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.html">June 12, 2025</a> <a href="blog.html">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.html">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.html"><img
                                    src="assets/img/blog/recent-post-1-4.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.php">June 12, 2025</a> <a href="blog.html">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.html">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="widget footer-widget">
                <h3 class="widget_title">Social Media:</h3>
                <div class="th-social"><a href="https://facebook.com"><i class="fab fa-facebook-f"></i></a> <a
                        href="https://twitter.com"><i class="fab fa-twitter"></i></a> <a href="https://pinterest.com"><i
                            class="fab fa-pinterest-p"></i></a> <a href="https://linkedin.com"><i
                            class="fab fa-linkedin-in"></i></a> <a href="https://linkedin.com"><i
                            class="fab fa-instagram"></i></a></div>
            </div>
        </div>
    </div>
    <div class="popup-search-box d-none d-lg-block"><button class="searchClose"><i class="fal fa-times"></i></button>
        <form action="#"><input type="text" placeholder="What are you looking for?"> <button type="submit"><i
                    class="fal fa-search"></i></button></form>
    </div>
    <div class="th-menu-wrapper">
        <div class="th-menu-area text-center"><button class="th-menu-toggle"><i class="fal fa-times"></i></button>
            <div class="  mobile-logo ">
                <div class="company-welcome" style="margin-bottom:8px; font-size:14px; color:var(--body-color);">Welcome to FAREN INTERIOR</div>
                <a href="index.php"><img src="assets/img/logo.svg" alt="Faren  "></a>
            </div>
            <div class="th-mobile-menu">
                <ul>
                    <li class="menu-item-has-children"><a href="index.php">Home</a>
                        
                    </li>
                    <li class="menu-item-has-children"><a href="about.php">About</a>
                        <ul class="sub-menu">
                            <li><a href="team.php">Team</a></li>
                            <li><a href="blog-grid-sidebar.html">Blog</a></li>
                            <li><a href="faq.html">FAQ</a></li>
                        </ul>
                    </li>
                    <li class="menu-item-has-children"><a href="service.php">Services</a>
                        <ul class="sub-menu">
                            <li><a href="commercial.php">Commercial</a></li>
                            <li><a href="exterior.php">Exterior</a></li>
                            <li><a href="decor.php">Decor & Art</a></li>
                            <li><a href="multipurpose.php">Residential</a></li>
                            
                        </ul>
                    </li>
                    <li class="menu-item-has-children"><a href="project.php">Projects</a>
                       
                    </li>
                    <li class="menu-item-has-children"><a href="gallery.php">gallery</a>
                    </li>
                    <li class="menu-item-has-children"><a href="shop.php">shop</a>
                        <!-- <ul class="sub-menu">
                            <li><a href="shop.php">Shop</a></li>
                            <li><a href="shop-details.php">Shop Details</a></li>
                        </ul> -->


                    <li class="menu-item-has-children"><a href="cart.php">cart</a>
                        <ul class="sub-menu">
                           
                            <li><a href="orders.php">orders</a></li>
                            <li><a href="checkout.php">Checkout</a></li>
                            <li><a href="my-wishlist.php">Wishlist</a></li>
                        </ul>
                    </li>
                    </li>
                    
                    </li>
                    <li><a href="contact.php">Contact</a></li>
                    
                </ul>
                
            </div>
        </div>
    </div>
    <style>
        /* Responsive styles for mobile auth buttons inside the mobile menu */
        .th-mobile-menu .mobile-auth-links button,
        .th-mobile-menu .mobile-user-item > .mobile-user-toggle,
        .th-mobile-menu .mobile-user-item .sub-menu button.mobile-logout {
            display: block;
            width: 100%;
            text-align: left;
            padding: 12px 16px;
            font-size: 16px;
            border: none;
            background: transparent;
            color: #111;
            cursor: pointer;
        }

        /* Primary style for Login/Register buttons */
        .th-mobile-menu .mobile-auth-links button {
            background: #d4a33a;
            color: #ffffff;
            border-radius: 6px;
            margin: 6px 0;
        }

        .th-mobile-menu .mobile-auth-links button:hover {
            opacity: 0.95;
        }

        /* Keep user submenu hidden by default and indented */
        .th-mobile-menu .mobile-user-item .sub-menu {
            display: none;
            padding-left: 12px;
            margin: 6px 0 12px 0;
        }

        /* Smaller devices adjustments */
        @media (max-width: 480px) {
            .th-mobile-menu .mobile-auth-links button,
            .th-mobile-menu .mobile-user-item > .mobile-user-toggle {
                font-size: 14px;
                padding: 10px 12px;
            }
        }
    </style>
    
    <header class="th-header header-layout8 header-absolute">
        <div class="top-header">
            <style>
                .top-header {
                    width: 100%;
                    background: #000000;
                    padding: 6px 0;
                }

                /* White text + icons */
                .top-header-inner,
                .top-header-inner a,
                .top-header-inner i {
                    color: #ffffff !important;
                }

                /* Hover turns black */
                .top-header-inner a:hover,
                .top-header-inner i:hover {
                    color: #f44646 !important;
                }

                /* Flex alignment stays same */
                .top-header-inner {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    padding: 0 5%;
                }


                .welcome-text {
                    color: #ffffff !important;
                    font-size: 15px;
                    font-weight: 500;
                }


                .social-icons a {
                    color: #111A1E;
                    margin-left: 15px;
                    font-size: 16px;
                    transition: .3s;
                }

                .social-icons a:hover {
                    color: #ffffff;
                    transform: scale(1.15);
                }

                /* Auth Buttons */
                .auth-buttons {
                    display: flex;
                    gap: 12px;
                    justify-content: center;
                }

                .auth-btn {
                    padding: 10px 20px;
                    border-radius: 4px;
                    font-weight: 600;
                    font-size: 14px;
                    text-decoration: none;
                    transition: all 0.3s ease;
                    border: 2px solid #d4a33a;
                }

                .login-btn {
                    background-color: #d4a33a;
                    color: #ffffff;
                }

                .login-btn:hover {
                    background-color: #ffffff;
                    color: #d4a33a;
                }

                .register-btn {
                    background-color: transparent;
                    color: #d4a33a;
                }

                .register-btn:hover {
                    background-color: #d4a33a;
                    color: #ffffff;
                }
            </style>
            <div class="container-fluid top-header-inner">

                <div class="welcome-text">
                    Welcome to Faren Interior Design
                </div>

                <div class="social-icons">
                    <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i class="fa-brands fa-twitter"></i></a>
                    <a href="#"><i class="fa-brands fa-instagram"></i></a>
                    <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
                    <a href="#"><i class="fa-brands fa-youtube"></i></a>
                </div>

            </div>
            <!--  -->
            <div class="contact-strip" style="padding-left: 135px;">
                <style>
                    .contact-strip {
                        width: 100%;
                        background: #ffffff;
                        display: grid;
                        grid-template-columns: repeat(4, 1fr);
                        padding: 7px 10px;
                        align-items: center;
                        border-bottom: 3px solid #d4a33a;
                    }

                    .strip-logo {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }

                    .contact-item {
                        display: flex;
                        align-items: center;
                        gap: 12px;
                    }

                    .contact-icon {
                        font-size: 26px;
                        color: #d4a33a;
                    }

                    .contact-title {
                        margin: 0;
                        font-size: 16px;
                        font-weight: 700;
                        color: #000;
                    }

                    .contact-text {
                        margin: 0;
                        font-size: 15px;
                        color: #666;
                    }

                    /* ================= RESPONSIVE ================= */

                    /* Tablet */
                    @media(max-width: 992px) {
                        .contact-strip {
                            grid-template-columns: repeat(2, 1fr);
                            row-gap: 15px;
                        }
                    }

                    /* MOBILE — RESPONSIVE LAYOUT */
                    @media(max-width: 600px) {

                        /* Hide entire top header */
                        .top-header {
                            display: none;
                        }

                        /* Make contact strip mobile responsive */
                        .contact-strip {
                            display: grid;
                            grid-template-columns: 1fr;
                            gap: 10px;
                            padding: 10px;
                            padding-left: 10px !important;
                        }

                        /* Hide contact info items on mobile, keep only auth/profile */
                        .contact-strip>.contact-item:nth-child(1),
                        .contact-strip>.contact-item:nth-child(2),
                        .contact-strip>.contact-item:nth-child(3) {
                            display: none;
                        }

                        /* Auth buttons - stack vertically on mobile */
                        #auth-section {
                            display: flex;
                            flex-direction: row;
                            gap: 8px;
                            justify-content: center;
                            width: 100%;
                        }

                        .auth-btn {
                            padding: 8px 14px;
                            font-size: 12px;
                            flex: 1;
                            max-width: 120px;
                        }

                        /* User profile section - center on mobile */
                        #user-profile-section {
                            display: flex !important;
                            justify-content: center;
                            width: 100%;
                            cursor: pointer;
                            transition: all 0.3s ease;
                        }

                        #user-profile-section:hover {
                            background: rgba(212, 163, 58, 0.05);
                            border-radius: 5px;
                        }

                        /* User profile wrapper adjustments */
                        .user-profile-wrapper {
                            position: relative;
                            display: flex;
                            align-items: center;
                            gap: 8px;
                        }

                        /* Mobile avatar size */
                        .user-profile-wrapper>div:first-child {
                            width: 38px;
                            height: 38px;
                            font-size: 14px;
                        }

                        /* Mobile text sizing */
                        .user-profile-wrapper .contact-title {
                            font-size: 12px;
                        }

                        .user-profile-wrapper .contact-text {
                            font-size: 11px;
                        }

                        /* Dropdown positioning for mobile */
                        #userDropdown {
                            position: absolute;
                            top: 50px;
                            left: 0;
                            min-width: 160px;
                        }
                    }

                    /* ================= TABLET (768px to 1024px) ================= */
                    @media (min-width: 769px) and (max-width: 1024px) {
                        .user-profile-wrapper {
                            gap: 10px;
                        }

                        .user-profile-wrapper>div:first-child {
                            width: 42px;
                            height: 42px;
                            font-size: 15px;
                        }

                        .user-profile-wrapper .contact-title {
                            font-size: 13px;
                        }

                        .user-profile-wrapper .contact-text {
                            font-size: 12px;
                        }

                        #userDropdown {
                            position: absolute;
                            top: 55px;
                            left: 0;
                            min-width: 170px;
                            background: white;
                            border: 1px solid #ddd;
                            border-radius: 5px;
                            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                            z-index: 999;
                        }

                        .dropdown-item {
                            padding: 10px 12px;
                            font-size: 13px;
                            width: 100%;
                        }
                    }

                    /* ================= LARGE DESKTOP (1025px and above) ================= */
                    @media (min-width: 1025px) {
                        .user-profile-wrapper {
                            gap: 12px;
                        }

                        .user-profile-wrapper>div:first-child {
                            width: 45px;
                            height: 45px;
                            font-size: 16px;
                        }

                        .user-profile-wrapper .contact-title {
                            font-size: 14px;
                        }

                        .user-profile-wrapper .contact-text {
                            font-size: 13px;
                        }

                        #userDropdown {
                            position: absolute;
                            top: 65px;
                            left: 0;
                            min-width: 180px;
                            background: white;
                            border: 1px solid #ddd;
                            border-radius: 5px;
                            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                            z-index: 999;
                        }

                        .dropdown-item {
                            padding: 12px 15px;
                            font-size: 14px;
                            width: 100%;
                        }
                    }

                    /* ================= DROPDOWN ITEM STYLING ================= */
                    .dropdown-item {
                        display: block;
                        border: none;
                        background: transparent;
                        text-align: left;
                        cursor: pointer;
                        transition: 0.3s ease;
                        color: #333;
                        border-bottom: 1px solid #eee;
                    }

                    .dropdown-item:last-child {
                        border-bottom: none;
                    }

                    .dropdown-item:hover {
                        background-color: #f5f5f5;
                        color: #d4a33a;
                    }

                    /* ================= DROPDOWN ARROW ================= */
                    .dropdown-arrow {
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        margin-left: 6px;
                        transition: transform 0.3s ease, color 0.3s ease;
                        font-size: 14px;
                        color: #d4a33a;
                        font-weight: bold;
                        min-width: 20px;
                        text-align: center;
                    }

                    .dropdown-arrow.active {
                        transform: rotate(180deg);
                        color: #FF833B;
                    }

                    /* Mobile dropdown arrow */
                    @media (max-width: 480px) {
                        .dropdown-arrow {
                            margin-left: 3px;
                            font-size: 12px;
                            min-width: 18px;
                        }
                    }

                    /* Small tablet dropdown arrow */
                    @media (max-width: 768px) and (min-width: 481px) {
                        .dropdown-arrow {
                            margin-left: 4px;
                            font-size: 13px;
                            min-width: 19px;
                        }
                    }

                    /* Tablet dropdown arrow */
                    @media (min-width: 769px) and (max-width: 1024px) {
                        .dropdown-arrow {
                            margin-left: 5px;
                            font-size: 14px;
                            min-width: 20px;
                        }
                    }

                    /* Desktop dropdown arrow */
                    @media (min-width: 1025px) {
                        .dropdown-arrow {
                            margin-left: 6px;
                            font-size: 15px;
                            min-width: 21px;
                        }
                    }

                    /* ================= PROFILE AVATAR RESPONSIVE ================= */
                    .user-avatar-circle {
                        transition: all 0.3s ease;
                        box-shadow: 0 4px 12px rgba(212, 163, 58, 0.3);
                    }

                    .user-avatar-circle img {
                        object-fit: cover;
                        object-position: center;
                    }

                    .user-avatar-circle:hover {
                        transform: scale(1.08);
                        box-shadow: 0 6px 18px rgba(212, 163, 58, 0.5);
                    }

                    /* ================= USER PROFILE WRAPPER HOVER ================= */
                    .user-profile-wrapper {
                        transition: all 0.3s ease;
                    }

                    .user-profile-wrapper:hover {
                        background: rgba(212, 163, 58, 0.08);
                        border-radius: 8px;
                        padding: 8px 12px;
                        margin: -8px -12px;
                    }

                    .user-profile-wrapper:hover .contact-text {
                        color: #d4a33a;
                        font-weight: 600;
                    }

                    .user-profile-wrapper:hover .dropdown-arrow {
                        color: #d4a33a;
                        transform: scale(1.15);
                    }

                    /* Mobile avatar sizing */
                    @media (max-width: 480px) {
                        .user-avatar-circle {
                            width: 36px !important;
                            height: 36px !important;
                            font-size: 14px;
                            flex-shrink: 0;
                        }
                    }

                    /* Small mobile (480-576px) */
                    @media (min-width: 481px) and (max-width: 576px) {
                        .user-avatar-circle {
                            width: 40px !important;
                            height: 40px !important;
                            font-size: 15px;
                            flex-shrink: 0;
                        }
                    }

                    /* Tablet mobile (577-768px) */
                    @media (min-width: 577px) and (max-width: 768px) {
                        .user-avatar-circle {
                            width: 42px !important;
                            height: 42px !important;
                            font-size: 15px;
                            flex-shrink: 0;
                        }
                    }

                    /* Tablet (769-1024px) */
                    @media (min-width: 769px) and (max-width: 1024px) {
                        .user-avatar-circle {
                            width: 44px !important;
                            height: 44px !important;
                            font-size: 16px;
                            flex-shrink: 0;
                        }
                    }

                    /* Desktop (1025px+) */
                    @media (min-width: 1025px) {
                        .user-avatar-circle {
                            width: 45px !important;
                            height: 45px !important;
                            font-size: 16px;
                            flex-shrink: 0;
                        }
                    }
                </style>

                <div class="contact-item">
                    <i class="fa-solid fa-phone contact-icon"></i>
                    <div>
                        <p class="contact-title">Call Us:</p>
                        <p class="contact-text">+00 (123) 666 000 666</p>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fa-solid fa-envelope contact-icon"></i>
                    <div>
                        <p class="contact-title">Mail Us:</p>
                        <p class="contact-text">info@feren.com</p>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fa-solid fa-location-dot contact-icon"></i>
                    <div>
                        <p class="contact-title">Location:</p>
                        <p class="contact-text">Coimbatore, Tamil Nadu</p>
                    </div>
                </div>

                <!-- Auth Section: Show login/register for non-logged-in users -->
                <div class="contact-item auth-buttons" id="auth-section" style="display: flex;">
                    <a href="auth-system/login.php" class="auth-btn login-btn">Login</a>
                    <a href="auth-system/register.php" class="auth-btn register-btn">Register</a>
                </div>

                <!-- User Profile Section with Dropdown: Show for logged-in users -->
                <div class="contact-item user-profile" id="user-profile-section" style="display: none !important;">
                    <div class="user-profile-wrapper"
                        style="position: relative; display: flex; align-items: center; gap: 10px;">
                        <div class="user-avatar-circle" style="width: 45px; height: 45px; background: #d4a33a; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; cursor: pointer; overflow: hidden;">
                            <img id="user-avatar-img" src="" alt="User avatar" style="display:none; width:100%; height:100%; object-fit:fill;">
                            <span id="user-avatar">U</span>
                        </div>
                        <div style="cursor: pointer; display: flex; align-items: center;">
                            <div>
                                <p class="contact-title" style="margin-bottom: 2px;">Welcome</p>
                                <p class="contact-text" id="user-name-display">User</p>
                            </div>
                            <span class="dropdown-arrow">⮟</span>
                        </div>

                        <!-- Dropdown Menu -->
                        <div id="userDropdown" style="
                display: none;
                position: absolute;
                top: 65px;
                left: 0;
                background: white;
                border: 1px solid #ddd;
                border-radius: 5px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                min-width: 180px;
                z-index: 999;
            ">
                                <button type="button" class="dropdown-item" data-href="customer-dashboard.php">📊 Dashboard</button>
                                <button type="button" class="dropdown-item" data-href="auth-system/logout.php">🚪 Logout</button>
                        </div>
                    </div>
                </div>

                <script>
                    // Update auth UI based on localStorage and add dropdown functionality
                    document.addEventListener('DOMContentLoaded', function () {
                        const userProfile = document.querySelector('.user-profile-wrapper');
                        const dropdown = document.getElementById('userDropdown');
                        const dropdownArrow = document.querySelector('.dropdown-arrow');
                        let dropdownTimeout;

                        if (userProfile && dropdown) {
                            // Show dropdown on hover
                            userProfile.addEventListener('mouseenter', function (e) {
                                clearTimeout(dropdownTimeout);
                                dropdown.style.display = 'block';
                                if (dropdownArrow) {
                                    dropdownArrow.classList.add('active');
                                }
                            });

                            // Hide dropdown when leaving user profile area
                            userProfile.addEventListener('mouseleave', function (e) {
                                dropdownTimeout = setTimeout(() => {
                                    dropdown.style.display = 'none';
                                    if (dropdownArrow) {
                                        dropdownArrow.classList.remove('active');
                                    }
                                }, 200);
                            });

                            // Keep dropdown visible when hovering over it
                            dropdown.addEventListener('mouseenter', function () {
                                clearTimeout(dropdownTimeout);
                                dropdown.style.display = 'block';
                            });

                            dropdown.addEventListener('mouseleave', function () {
                                dropdownTimeout = setTimeout(() => {
                                    dropdown.style.display = 'none';
                                    if (dropdownArrow) {
                                        dropdownArrow.classList.remove('active');
                                    }
                                }, 200);
                            });

                            // Keep click functionality as backup
                            userProfile.addEventListener('click', function (e) {
                                e.stopPropagation();
                                const isOpen = dropdown.style.display === 'none' ? false : true;
                                dropdown.style.display = isOpen ? 'none' : 'block';
                                
                                // Toggle arrow rotation
                                if (dropdownArrow) {
                                    if (isOpen) {
                                        dropdownArrow.classList.remove('active');
                                    } else {
                                        dropdownArrow.classList.add('active');
                                    }
                                }
                            });

                            // delegated handler for dropdown buttons (Dashboard / Logout)
                            dropdown.addEventListener('click', function (evt) {
                                const t = evt.target;
                                if (!t) return;
                                
                                // Dashboard button: route based on user role
                                if (t.matches('.dropdown-item') && t.textContent.includes('Dashboard')) {
                                    const role = localStorage.getItem('userRole');
                                    const target = role === 'admin' ? 'admin-dashboard.php' : 'customer-dashboard.php';
                                    window.location.href = target;
                                    return;
                                }
                                
                                // Other dropdown items
                                if (t.matches('.dropdown-item')) {
                                    const href = t.getAttribute('data-href');
                                    if (!href) return;
                                    // if logout, clear local state first
                                    if (href.indexOf('logout') !== -1) {
                                        localStorage.setItem('userLoggedIn', 'false');
                                        localStorage.removeItem('userName');
                                    }
                                    window.location.href = href;
                                }
                            });

                            document.addEventListener('click', function () {
                                dropdown.style.display = 'none';
                                // Remove active class from arrow when clicking outside
                                if (dropdownArrow) {
                                    dropdownArrow.classList.remove('active');
                                }
                            });
                        }
                        try { updateMobileAvatar(); } catch (e) {}
                    });

                    // Update auth UI based on localStorage - runs immediately
                    (function updateAuthUI() {
                        const isLoggedIn = localStorage.getItem('userLoggedIn') === 'true';
                        const authSection = document.getElementById('auth-section');
                        const userProfileSection = document.getElementById('user-profile-section');
                        const mobileMenuList = document.querySelector('.th-mobile-menu ul');

                        // Function to load user profile with avatar from API/database
                        function loadUserProfile() {
                            fetch('auth-system/get-user-profile.php')
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success && data.user) {
                                        const { name, avatar } = data.user;
                                        
                                        // Update display name
                                        if (name) {
                                            localStorage.setItem('userName', name);
                                            const userNameDisplay = document.getElementById('user-name-display');
                                            if (userNameDisplay) {
                                                userNameDisplay.textContent = name;
                                            }
                                        }
                                        
                                        // Update avatar
                                        if (avatar) {
                                            localStorage.setItem('userAvatarUrl', avatar);
                                            const userAvatarImg = document.getElementById('user-avatar-img');
                                            const userAvatar = document.getElementById('user-avatar');
                                            const profileWrapper = document.querySelector('.user-profile-wrapper');
                                            
                                            if (userAvatarImg) {
                                                userAvatarImg.src = avatar;
                                                userAvatarImg.style.display = 'block';
                                                if (userAvatar) userAvatar.style.display = 'none';
                                                if (profileWrapper) profileWrapper.classList.add('has-avatar');
                                            }
                                        }
                                    }
                                })
                                .catch(error => console.log('Profile load:', error));
                        }

                        // Load user profile if logged in
                        if (isLoggedIn) {
                            setTimeout(loadUserProfile, 500);
                        }

                        function renderMobileAuth() {
                            if (!mobileMenuList) return;
                                if (isLoggedIn) {
                                const userName = localStorage.getItem('userName') || 'User';
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-user-item th-item-has-children">\n                                        <button type="button" class="mobile-user-toggle">\n                                            <span class="mobile-avatar">${(localStorage.getItem('userName')||'U').charAt(0).toUpperCase()}</span>\n                                            <span class="mobile-user-name">${userName}</span>\n                                        </button>\n                                        <ul class="sub-menu th-submenu">\n                                            <li><button type="button" class="mobile-dashboard th-submenu-btn">Dashboard</button></li>\n                                            <li><button type="button" data-href="auth-system/logout.php" class="mobile-logout th-submenu-btn">Logout</button></li>\n                                        </ul>\n                                    </li>`);
                            } else {
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-auth-links">\n                                        <button type="button" data-href="auth-system/login.php" class="mobile-login-btn">Login</button>\n                                    </li>\n                                    <li class="mobile-auth-links">\n                                        <button type="button" data-href="auth-system/register.php" class="mobile-register-btn">Register</button>\n                                    </li>`);
                            }
                        }

                        // clear any previous mobile auth items then re-render
                        if (mobileMenuList) {
                            mobileMenuList.querySelectorAll('.mobile-user-item, .mobile-auth-links').forEach(n => n.remove());
                        }

                        if (isLoggedIn) {
                            if (authSection) authSection.style.display = 'none';
                            if (userProfileSection) {
                                userProfileSection.style.display = 'flex';
                                const userName = localStorage.getItem('userName') || 'User';
                                const userNameDisplay = document.getElementById('user-name-display');
                                const userAvatar = document.getElementById('user-avatar');
                                const userAvatarImg = document.getElementById('user-avatar-img');
                                const profileWrapper = document.querySelector('.user-profile-wrapper');
                                if (userNameDisplay) userNameDisplay.textContent = userName;
                                const avatarUrl = localStorage.getItem('userAvatarUrl');
                                if (avatarUrl && userAvatarImg) {
                                    userAvatarImg.src = avatarUrl;
                                    userAvatarImg.style.display = 'block';
                                    if (userAvatar) userAvatar.style.display = 'none';
                                    if (profileWrapper) profileWrapper.classList.add('has-avatar');
                                } else {
                                    if (userAvatarImg) userAvatarImg.style.display = 'none';
                                    if (userAvatar) { userAvatar.style.display = 'inline-block'; userAvatar.textContent = userName.charAt(0).toUpperCase(); }
                                    if (profileWrapper) profileWrapper.classList.remove('has-avatar');
                                }
                            }
                        } else {
                            if (authSection) authSection.style.display = 'flex';
                            if (userProfileSection) userProfileSection.style.display = 'none';
                        }

                        renderMobileAuth();

                        // update mobile welcome strip (top header) when on small screens
                        (function updateMobileWelcome() {
                            const mw = document.getElementById('mobile-welcome');
                            const mwName = document.getElementById('mobile-welcome-name');
                            if (!mw) return;
                            if (isLoggedIn) {
                                const name = localStorage.getItem('userName') || 'User';
                                if (mwName) mwName.textContent = name;
                                mw.style.display = 'block';
                            } else {
                                mw.style.display = 'none';
                            }
                        })();

                        // update avatar images if uploaded
                        try { updateMobileAvatar(); } catch (e) {}

                        // attach delegated handlers for mobile auth buttons
                        if (mobileMenuList) {
                            mobileMenuList.addEventListener('click', function (e) {
                                const t = e.target;
                                // logout button: clear state then navigate to server logout
                                if (t && t.matches('.mobile-logout')) {
                                    localStorage.setItem('userLoggedIn', 'false');
                                    localStorage.removeItem('userName');
                                    const href = t.getAttribute('data-href') || 'auth-system/logout.php';
                                    window.location.href = href;
                                    return;
                                }
                                // mobile dashboard button: route based on stored userRole
                                if (t && t.matches('.mobile-dashboard')) {
                                    const role = localStorage.getItem('userRole');
                                    const target = role === 'admin' ? 'admin-dashboard.php' : 'customer-dashboard.php';
                                    const loggedInLocal = localStorage.getItem('userLoggedIn') === 'true';
                                    if (loggedInLocal) {
                                        window.location.href = target;
                                    } else {
                                        // Probe the target on the server to see if an active session allows access.
                                        // If the server returns 200 we navigate directly; otherwise fall back to login with next.
                                        fetch(target, { method: 'HEAD', credentials: 'same-origin', redirect: 'manual' })
                                            .then(function (resp) {
                                                if (resp && resp.status >= 200 && resp.status < 300) {
                                                    window.location.href = target;
                                                } else {
                                                    try { localStorage.setItem('redirectTo', target); } catch (e) {}
                                                    window.location.href = 'auth-system/login.php?next=' + encodeURIComponent(target);
                                                }
                                            })
                                            .catch(function () {
                                                try { localStorage.setItem('redirectTo', target); } catch (e) {}
                                                window.location.href = 'auth-system/login.php?next=' + encodeURIComponent(target);
                                            });
                                    }
                                    return;
                                }
                                // login/register buttons: navigate to pages
                                if (t && t.matches('.mobile-login-btn')) {
                                    const href = t.getAttribute('data-href') || 'auth-system/login.php';
                                    window.location.href = href;
                                    return;
                                }
                                if (t && t.matches('.mobile-register-btn')) {
                                    const href = t.getAttribute('data-href') || 'auth-system/register.php';
                                    window.location.href = href;
                                    return;
                                }
                                // toggle user sub-menu when clicking the user button
                                if (t && t.matches('.mobile-user-toggle')) {
                                    const li = t.closest('li');
                                    if (!li) return;
                                    const submenu = li.querySelector('.sub-menu');
                                    if (submenu) submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
                                }
                            });
                        }
                    })();

                    // Listen for storage changes across tabs and update mobile menu as well
                    window.addEventListener('storage', function () {
                        const isLoggedIn = localStorage.getItem('userLoggedIn') === 'true';
                        const authSection = document.getElementById('auth-section');
                        const userProfileSection = document.getElementById('user-profile-section');
                        const mobileMenuList = document.querySelector('.th-mobile-menu ul');

                        // update header sections
                        if (isLoggedIn) {
                            if (authSection) authSection.style.display = 'none';
                            if (userProfileSection) {
                                userProfileSection.style.display = 'flex';
                                const userName = localStorage.getItem('userName') || 'User';
                                const userNameDisplay = document.getElementById('user-name-display');
                                const userAvatar = document.getElementById('user-avatar');
                                if (userNameDisplay) userNameDisplay.textContent = userName;
                                if (userAvatar) userAvatar.textContent = userName.charAt(0).toUpperCase();
                            }
                        } else {
                            if (authSection) authSection.style.display = 'flex';
                            if (userProfileSection) userProfileSection.style.display = 'none';
                        }

                        // update mobile menu auth links
                        if (mobileMenuList) {
                            // remove old mobile auth items
                            mobileMenuList.querySelectorAll('.mobile-user-item, .mobile-auth-links').forEach(n => n.remove());
                            if (isLoggedIn) {
                                const userName = localStorage.getItem('userName') || 'User';
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-user-item th-item-has-children">\n                                        <button type="button" class="mobile-user-toggle">\n                                            <span class="mobile-avatar">${(localStorage.getItem('userName')||'U').charAt(0).toUpperCase()}</span>\n                                            <span class="mobile-user-name">${userName}</span>\n                                        </button>\n                                        <ul class="sub-menu th-submenu">\n                                            <li><button type="button" class="mobile-dashboard th-submenu-btn">Dashboard</button></li>\n                                            <li><button type="button" data-href="auth-system/logout.php" class="mobile-logout th-submenu-btn">Logout</button></li>\n                                        </ul>\n                                    </li>`);
                            } else {
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-auth-links">\n                                        <a href="auth-system/login.php">Login</a>\n                                    </li>\n                                    <li class="mobile-auth-links">\n                                        <a href="auth-system/register.php">Register</a>\n                                    </li>`);
                            }
                        }
                    });
                </script>
                <style>
                    /* Responsive user profile and dropdown styles */
                    #user-profile-section .user-profile-wrapper { align-items: center; }
                    #user-profile-section #user-avatar { font-size: 18px; }
                    #user-profile-section #user-avatar-img { width: 45px; height: 45px; border-radius: 50%; display: none; }
                    .user-profile-wrapper.has-avatar #user-avatar { display: none; }
                    .user-profile-wrapper.has-avatar #user-avatar-img { display: block; }
                    #userDropdown .dropdown-item {
                        display: block;
                        width: 100%;
                        text-align: left;
                        padding: 10px 14px;
                        border: none;
                        background: transparent;
                        color: #333;
                        font-size: 15px;
                        cursor: pointer;
                    }
                    #userDropdown .dropdown-item:hover { background: #f5f5f5; color: #d4a33a; }

                    /* on small screens make the dropdown full-width below header */
                    @media (max-width: 768px) {
                        #userDropdown {
                            position: fixed !important;
                            top: 56px !important;
                            right: 8px !important;
                            left: 8px !important;
                            min-width: unset !important;
                            border-radius: 8px !important;
                            padding: 6px 0 !important;
                        }
                        #user-profile-section .user-profile-wrapper { gap: 8px; }
                        #user-profile-section .contact-title { display: none; }
                        #user-profile-section .contact-text { font-size: 14px; }
                        #userDropdown .dropdown-item { font-size: 16px; padding: 12px 18px; }
                    }
                    /* Mobile user item styles */
                    .mobile-user-toggle {
                        display: inline-flex;
                        align-items: center;
                        gap: 10px;
                        width: 100%;
                        padding: 10px 14px;
                        border: none;
                        background: transparent;
                        text-align: left;
                        cursor: pointer;
                        font-size: 15px;
                        color: #111;
                    }
                    .mobile-avatar {
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        width: 36px;
                        height: 36px;
                        border-radius: 50%;
                        background: var(--theme-color);
                        color: #fff;
                        font-weight: 700;
                        font-size: 14px;
                        flex: 0 0 36px;
                    }
                    .mobile-avatar-img {
                        width: 36px;
                        height: 36px;
                        border-radius: 50%;
                        object-fit: cover;
                        display: inline-block;
                    }
                    .mobile-user-name { font-weight: 700; }
                    .th-submenu { padding-left: 12px; }
                    .th-submenu .th-submenu-btn {
                        display: block;
                        width: 100%;
                        padding: 12px 14px;
                        border: none;
                        background: transparent;
                        text-align: left;
                        font-size: 15px;
                        color: #222;
                        cursor: pointer;
                    }
                    .th-submenu .th-submenu-btn:hover { background: #f7f7f7; color: var(--theme-color); }
                </style>
                <script>
                    // Utility: Replace avatar initials with uploaded image if available
                    function updateMobileAvatar() {
                        try {
                            const avatarUrl = localStorage.getItem('userAvatarUrl');
                            document.querySelectorAll('.mobile-user-item .mobile-avatar').forEach(function (el) {
                                const name = localStorage.getItem('userName') || 'User';
                                if (avatarUrl) {
                                    // if image already present, update src
                                    let img = el.querySelector('img.mobile-avatar-img');
                                    if (!img) {
                                        img = document.createElement('img');
                                        img.className = 'mobile-avatar-img';
                                        el.innerHTML = '';
                                        el.appendChild(img);
                                    }
                                    img.src = avatarUrl;
                                    img.alt = name;
                                } else {
                                    // show initial
                                    el.textContent = (name || 'U').charAt(0).toUpperCase();
                                }
                            });
                        } catch (e) { /* ignore */ }
                    }
                    // Hook mobile header button to menu toggle
                    (function () {
                        const mobileBtn = document.querySelector('.mobile-menu-btn');
                        if (!mobileBtn) return;
                        mobileBtn.addEventListener('click', function (e) {
                            e.preventDefault();
                            const wrapper = document.querySelector('.th-menu-wrapper');
                            if (wrapper) {
                                wrapper.classList.toggle('th-body-visible');
                                document.body.classList.toggle('th-body-visible');
                            }
                        });
                    })();
                    // Hook close button inside menu
                    (function () {
                        const closeBtn = document.querySelector('.th-menu-wrapper .th-menu-toggle');
                        if (!closeBtn) return;
                        closeBtn.addEventListener('click', function (e) {
                            e.preventDefault();
                            const wrapper = document.querySelector('.th-menu-wrapper');
                            if (wrapper) {
                                wrapper.classList.remove('th-body-visible');
                                document.body.classList.remove('th-body-visible');
                            }
                        });
                    })();
                </script>

            </div>

            <div class="sticky-wrapper">
                <div class="container th-container5">
                    <div class="menu-area">
                        <div class="row align-items-center justify-content-between">
                            <div class="col-auto">
                                <div class="header-logo"><a href="index.php"><img
                                            src="assets/img/logo-white.svg" alt="Faren  "></a></div>
                            </div>
                            <div class="col-auto">
                                <nav class="main-menu d-none d-lg-inline-block">
                                    <ul>
                                        <li class="menu-item-has-children"><a
                                                href="index.php">Home</a>

                                        </li>
                                        <li class="menu-item-has-children"><a href="about.php">About</a>
                                            <ul class="sub-menu">
                                                <li><a href="team.php">Team</a></li>
                                                <li><a href="blog-grid-sidebar.html">Blog</a></li>
                                                <li><a href="faq.html">FAQ</a></li>
                                            </ul>
                                        </li>
                                        <li class="menu-item-has-children"><a href="service.php">Services</a>
                                            <ul class="sub-menu">
                                                <li><a href="commercial-page.html">Commercial</a></li>
                                                <li><a href="exterier-design.html">Exterior</a></li>
                                                <li><a href="decor-art-page.html">Decor & Art</a></li>
                                                <li><a href="multipurpose.html">Residential</a></li>
                                            </ul>
                                        </li>
                                        <li class="menu-item-has-children"><a href="project.php">Projects</a>
                                            <!-- <ul class="sub-menu"> -->
                                            <!-- <li><a href="project.html">project</a></li> -->
                                            <!-- <li><a href="project-details.html">project details</a></li> -->
                                            <!-- </ul> -->
                                        </li>
                                        <li class="menu-item-has-children"><a href="gallery.php">gallery</a>
                                        </li>
                                        <li class="menu-item-has-children"><a href="shop.php">shop</a>
                                            <!-- <ul class="sub-menu">
                                            <li><a href="shop.php">Shop</a></li>
                                            <li><a href="shop-details.php">Shop Details</a></li>
                                        </ul> -->


                                        <li class="menu-item-has-children"><a href="cart.php">cart</a>
                                            <ul class="sub-menu">
                                                <!-- <li><a href="pricing.html">Price Table</a></li> -->
                                                <li><a href="orders.php">Orders</a></li>
                                                <li><a href="checkout.php">Checkout</a></li>
                                                <li><a href="my-wishlist.php">Wishlist</a></li>
                                            </ul>
                                        </li>
                                        </li>
                                       
                                        </li>
                                        <li><a href="contact.php">Contact</a></li>
                                    </ul>
                                </nav>
                            </div>
                            <div class="col-auto">
                                <div class="header-button d-none d-lg-flex"><a href="consultation.php"
                                        class="th-btn white-border">Get Free Consultant</a> <button type="button"
                                        class="icon-btn sideMenuToggler d-none d-lg-block"><i
                                            class="fa-regular fa-bars"></i></button></div>
                                <div class="header-button"><button type="button"
                                        class="th-menu-toggle d-inline-block d-lg-none"><i
                                            class="far fa-bars"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </header>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>



