<?php
// Alternative mail sending using SMTP configuration
// This is a fallback if PHP mail() doesn't work

function sendEmailViaSMTP($to, $subject, $htmlBody, $from = 'info@zemaraimgroups.com') {
    // Using a simple SMTP implementation
    // For production, consider using a mail service API
    
    $smtp_server = 'localhost';
    $smtp_port = 465; // Or 587 for TLS, 465 for SSL
    
    try {
        $mail_headers = "MIME-Version: 1.0\r\n";
        $mail_headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $mail_headers .= "From: " . $from . "\r\n";
        $mail_headers .= "Reply-To: iiidsumma@gmail.com\r\n";
        $mail_headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";
        
        $result = mail($to, $subject, $htmlBody, $mail_headers);
        
        error_log("Mail sending result: " . ($result ? 'SUCCESS' : 'FAILED') . " to: " . $to);
        
        return $result;
    } catch (Exception $e) {
        error_log("Mail error: " . $e->getMessage());
        return false;
    }
}

?>
