<?php
session_start();
require_once __DIR__ . '/config/db.php';

// Redirect old index.html requests to index.php
if ($_SERVER['REQUEST_URI'] === '/interior/' || $_SERVER['REQUEST_URI'] === '/interior/index.php') {
    header('Location: index.php', true, 301);
    exit;
}

$page_title = 'Faren Interior Design - Architecture & Interior Design';
$page_description = 'Professional interior design and architecture services. Explore our portfolio of premium designs.';

// Get user info if logged in
$user_name = '';
$user_role = '';
if (isset($_SESSION['user_id'])) {
    $user_name = $_SESSION['user_name'] ?? '';
    $user_role = $_SESSION['user_role'] ?? '';
}
?>



<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- header -->
    <?php include 'header-section.html'; ?>
    <!--  -->
    <div class="th-hero-wrapper hero-8 position-relative">
        <style>
            /* ================= HERO BASE ================= */
            .th-hero-wrapper {
                position: relative;
                width: 100%;
                overflow: hidden;
            }

            .hero-inner {
                max-height: 120vh;
                display: flex;
                align-items: center;
                position: relative;
                padding-top: 60px;
            }

            /* Background image */
            .th-hero-bg {
                position: absolute;
                inset: 0;
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                z-index: -1;
                filter: brightness(0.7);
            }

            /* Text block */
            .hero-style8 {
                padding: 213px 0;
            }

            .hero-style8 .sub-title {
                display: block;
                font-size: 16px;
                letter-spacing: 1px;
                margin-bottom: 12px;
                color: #d4a33a;
                font-weight: 600;
            }

            .hero-title {
                font-size: 64px;
                line-height: 1.1;
                margin-bottom: 24px;
                color: #fff;
                font-weight: 800;
            }

            /* Buttons */
            .btn-group {
                display: flex;
                gap: 15px;
                flex-wrap: wrap;
            }

            /* Hero image */
            .hero-img img {
                padding-top: 150px;
                max-width: 100%;
                height: auto;
                display: block;
            }

            /* ================= EXTRA LARGE (1400px+) ================= */
            @media (min-width: 1400px) {
                .hero-title {
                    font-size: clamp(64px, 5vw, 80px);
                }

                .hero-style8 {
                    padding: 220px 0;
                }

                .hero-style8 .sub-title {
                    font-size: 18px;
                }

                .btn-group {
                    gap: 18px;
                }
            }

            /* ================= LARGE DESKTOP (1200-1399px) ================= */
            @media (max-width: 1399px) and (min-width: 1200px) {
                .hero-title {
                    font-size: 68px;
                }

                .hero-style8 {
                    padding: 200px 0;
                }

                .hero-style8 .sub-title {
                    font-size: 17px;
                }

                .hero-inner {
                    min-height: 75vh;
                    padding-top: 70px;
                }
            }

            /* ================= DESKTOP (992-1199px) ================= */
            @media (max-width: 1199px) {
                .hero-title {
                    font-size: 52px;
                }

                .hero-inner {
                    min-height: 70vh;
                    padding-top: 60px;
                }

                .hero-style8 {
                    padding: 150px 0;
                }

                .hero-style8 .sub-title {
                    font-size: 15px;
                }

                .btn-group {
                    gap: 14px;
                }
            }

            /* ================= LARGE TABLET (768-991px) ================= */
            @media (max-width: 991px) {
                .hero-inner {
                    min-height: 70vh;
                    padding: 100px 15px 60px;
                }

                .row.align-items-end {
                    align-items: center !important;
                }

                .hero-style8 {
                    text-align: center;
                    padding: 0;
                }

                .hero-style8 .sub-title {
                    font-size: 14px;
                    margin-bottom: 10px;
                }

                .hero-title {
                    font-size: 44px;
                    margin-bottom: 20px;
                    line-height: 1.2;
                }

                .btn-group {
                    justify-content: center;
                    gap: 12px;
                }

                .btn-group a {
                    padding: 12px 20px;
                    font-size: 13px;
                }

                .hero-img {
                    margin-top: 40px;
                    text-align: center;
                }

                .container {
                    padding-right: 15px !important;
                    padding-left: 15px !important;
                }
            }

            /* ================= TABLET (576-767px) ================= */
            @media (max-width: 767px) {
                .hero-inner {
                    padding: 100px 15px 60px;
                    min-height: auto;
                }

                .hero-title {
                    font-size: 36px;
                    line-height: 1.3;
                    margin-bottom: 18px;
                    word-spacing: auto;
                }

                .hero-style8 {
                    padding: 0;
                }

                .hero-style8 .sub-title {
                    font-size: 13px;
                    margin-bottom: 10px;
                }

                .btn-group {
                    flex-direction: row;
                    gap: 10px;
                    flex-wrap: wrap;
                }

                .btn-group a {
                    flex: 1;
                    min-width: 140px;
                    padding: 12px 16px;
                    font-size: 13px;
                }

                .hero-img img {
                    max-width: 85%;
                    margin: 0 auto;
                }

                .container {
                    padding-right: 15px !important;
                    padding-left: 15px !important;
                }
            }

            /* ================= SMALL MOBILE (480-575px) ================= */
            @media (max-width: 575px) {
                .hero-inner {
                    padding: 80px 15px 45px;
                    min-height: auto;
                }

                .th-hero-wrapper {
                    margin-top: -50px;
                }

                .hero-title {
                    font-size: 28px;
                    line-height: 1.25;
                    margin-bottom: 14px;
                    font-weight: 700;
                }

                .hero-style8 {
                    padding: 0;
                }

                .hero-style8 .sub-title {
                    font-size: 11px;
                    letter-spacing: 0.5px;
                    margin-bottom: 8px;
                }

                .btn-group {
                    flex-direction: row;
                    gap: 8px;
                    flex-wrap: wrap;
                }

                .btn-group a {
                    flex: 1;
                    min-width: 120px;
                    padding: 10px 12px;
                    font-size: 12px;
                }

                .hero-img img {
                    max-width: 90%;
                    margin: 0 auto;
                }

                .container {
                    padding-right: 12px !important;
                    padding-left: 12px !important;
                }
            }

            /* ================= EXTRA SMALL MOBILE (320-479px) ================= */
            @media (max-width: 479px) {
                .hero-inner {
                    padding: 70px 12px 35px;
                    max-height: 60vh;
                }

                .th-hero-wrapper {
                    margin-top: -30px;
                    padding: 0;
                }

                .hero-title {
                    font-size: 24px;
                    line-height: 1.2;
                    margin-bottom: 12px;
                    font-weight: 700;
                }

                .hero-style8 {
                    padding: 150px;
                }

                .hero-style8 .sub-title {
                    font-size: 10px;
                    letter-spacing: 0.3px;
                    margin-bottom: 6px;
                }

                .btn-group {
                    flex-direction: column;
                    gap: 8px;
                }

                .btn-group a {
                    width: 100%;
                    padding: 10px 12px;
                    font-size: 12px;
                    border-radius: 3px;
                }

                .hero-img {
                    margin-top: 20px;
                }

                .hero-img img {
                    max-width: 100%;
                    margin: 0 auto;
                    padding-top: 40px;
                }

                .container {
                    padding-right: 12px !important;
                    padding-left: 12px !important;
                }

                .row.align-items-end {
                    margin-right: 0;
                    margin-left: 0;
                }
            }
        </style>


        <div class="swiper th-slider" data-slider-options='{"effect":"fade","loop":true}' style="padding-top: 30px;">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/1349902.jpeg"></div>
                        <div class="container" style="padding-top: 50px;">
                            <div class="row align-items-end">
                                <div class="col-xl-8">
                                    <div class="hero-style8"><span class="sub-title" data-ani="slideinleft"
                                            data-ani-delay="0.3s">Innovative solutions</span>
                                        <h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">
                                            Interior Design Luxury for Living Spaces. <span class="text-theme">Luxury</span> 
                                        </h1>
                                        <div class="btn-group justify-content-xl-start justify-content-center"
                                            data-ani="slideinleft" data-ani-delay="0.6s"><a href="contact.php"
                                                class="th-btn style3">Know More Us</a> <a href="project.php"
                                                class="th-btn white-btn">Explore Projects</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/1349902.jpeg"></div>
                        <div class="container" style="padding-top: 50px;">
                            <div class="row align-items-end">
                                <div class="col-xl-8">
                                    <div class="hero-style8"><span class="sub-title" data-ani="slideinleft"
                                            data-ani-delay="0.3s">Innovative solutions</span>
                                        <h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">
                                            Commercial <span class="text-theme">Interiors</span> for Modern Businesses
                                        </h1>
                                        <div class="btn-group justify-content-xl-start justify-content-center"
                                            data-ani="slideinleft" data-ani-delay="0.6s"><a href="contact.php"
                                                class="th-btn style3">Know More Us</a> <a href="project.php"
                                                class="th-btn white-btn">Explore Projects</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/362537.jpg"></div>
                        <div class="container" style="padding-top: 50px;">
                            <div class="row align-items-end">
                                <div class="col-xl-8">
                                    <div class="hero-style8"><span class="sub-title" data-ani="slideinleft"
                                            data-ani-delay="0.3s">Innovative solutions</span>
                                        <h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">
                                            Interior Design for Inspired Living Spaces. <span class="text-theme">Inspired</span> 
                                        </h1>
                                        <div class="btn-group justify-content-xl-start justify-content-center"
                                            data-ani="slideinleft" data-ani-delay="0.6s"><a href="contact.php"
                                                class="th-btn style3">Know More Us</a> <a href="project.php"
                                                class="th-btn white-btn">Explore Projects</a></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/647571.jpg"></div>
                        <div class="container" style="padding-top: 50px;">
                            <div class="row align-items-end">
                                <div class="col-xl-8">
                                    <div class="hero-style8"><span class="sub-title" data-ani="slideinleft"
                                            data-ani-delay="0.3s">Innovative solutions</span>
                                        <h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">
                                            Interior Design for <span class="text-theme">Elegant</span> Homes.</h1>
                                        <div class="btn-group justify-content-xl-start justify-content-center"
                                            data-ani="slideinleft" data-ani-delay="0.6s"><a href="contact.php"
                                                class="th-btn style3">Know More Us</a> <a href="project.php"
                                                class="th-btn white-btn">Explore Projects</a></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="slider-pagination"></div>
        </div>

        <div class="scroll-down"><a href="#about-sec" class="hero-scroll-wrap">Scroll Down</a></div>

    </div>

    <!-- ABOUT US -->
    <section class="about-modern" id="about-sec">

        <style>
            /* ================= ABOUT MODERN ================= */

            .about-modern {
                padding: 20px;
                background: #ffffff;
            }

            .about-grid {
                display: grid;
                grid-template-columns: minmax(300px, 520px) 1fr;
                gap: clamp(40px, 6vw, 90px);
                align-items: center;
            }

            /* LEFT IMAGE */
            .about-image img {
                width: 100%;
                border-radius: 18px;
                box-shadow: 0 30px 70px rgba(0, 0, 0, 0.18);
                object-fit: cover;
            }

            /* RIGHT CONTENT */
            .about-content {
                max-width: 910px;
            }

            .about-subtitle {
                display: inline-block;
                font-size: 13px;
                letter-spacing: 4px;
                text-transform: uppercase;
                color: #ff8a3d;
                margin-bottom: 14px;
                font-weight: 500;
            }

            .about-title {
                font-size: clamp(1.9rem, 3.5vw, 2.8rem);
                line-height: 1.25;
                margin-bottom: 20px;
                color: #111;
            }

            .about-description {
                font-size: clamp(15px, 1.15vw, 17px);
                line-height: 1.85;
                color: #555;
                margin-bottom: 35px;
                max-width: 1000px;
            }

            /* FEATURE CARDS */
            .about-features {
                display: grid;
                grid-template-columns: repeat(2, 1fr);
                gap: 16px;
                margin-bottom: 40px;
            }

            .feature-card {
                display: flex;
                align-items: center;
                gap: 14px;
                padding: 16px 18px;
                border-radius: 14px;
                background: #f7f8fc;
                transition: all .3s ease;
            }

            .feature-card img {
                width: 36px;
            }

            .feature-card span {
                font-size: 15px;
                font-weight: 500;
                color: #222;
            }

            .feature-card:hover {
                transform: translateY(-4px);
                background: #ffffff;
                box-shadow: 0 15px 30px rgba(0, 0, 0, 0.08);
            }

            /* BUTTON */
            .about-btn {
                display: inline-block;
                padding: 14px 38px;
                border-radius: 999px;
                background: #000;
                color: #fff;
                font-size: 15px;
                transition: all .3s ease;
            }

            .about-btn:hover {
                background: #ff8a3d;
                color: #fff;
            }

            /* ================= TABLET ================= */
            @media (max-width: 991px) {
                .about-grid {
                    grid-template-columns: 1fr;
                }

                .about-image {
                    text-align: center;
                }

                .about-image img {
                    max-width: 480px;
                    margin: 0 auto;
                }

                .about-content {
                    text-align: center;
                    margin: 0 auto;
                }

                .about-description {
                    margin-left: auto;
                    margin-right: auto;
                }

                .about-features {
                    grid-template-columns: 1fr 1fr;
                }
            }

            /* ================= MOBILE ================= */
            @media (max-width: 480px) {
                .about-image img {
                    max-width: 320px;
                }

                .about-features {
                    grid-template-columns: 1fr;
                }

                .about-btn {
                    width: 100%;
                    text-align: center;
                }
            }

            /* ================= FONT CHANGE ================= */

            /* Title */
            .about-title {
                font-family: 'DM Serif Display', serif;
                font-weight: 400;
                letter-spacing: 0.2px;
            }

            /* Subtitle */
            .about-subtitle {
                font-family: 'Manrope', sans-serif;
                font-weight: 600;
                letter-spacing: 4px;
            }

            /* Paragraph */
            .about-description {
                font-family: 'Manrope', sans-serif;
                font-size: clamp(16px, 1.2vw, 18px);
                line-height: 1.9;
                color: #444;
            }

            /* Feature text */
            .feature-card span {
                font-family: 'Manrope', sans-serif;
                font-weight: 500;
            }

            /* Button */
            .about-btn {
                font-family: 'Manrope', sans-serif;
                font-weight: 600;
            }

            /* ================= IMAGE HEIGHT INCREASE ================= */

            .about-image img {
                width: 100%;
                height: 560px;
                /* 👈 increased height */
                object-fit: fill;
                border-radius: 20px;
                box-shadow: 0 35px 80px rgba(0, 0, 0, 0.22);
            }

            /* ================= RESPONSIVE IMAGE HEIGHT ================= */

            /* Tablet */
            @media (max-width: 991px) {
                .about-image img {
                    height: 460px;
                }
            }

            /* Mobile */
            @media (max-width: 480px) {
                .about-image img {
                    height: 320px;
                }

                .about-description {
                    font-size: 15.5px;
                    line-height: 1.75;
                }
            }
        </style>
        <div class="container">
            <div class="about-grid">

                <!-- LEFT IMAGE -->
                <div class="about-image">
                    <img src="assets/img/713688.jpg" alt="Faren Architects">
                </div>

                <!-- RIGHT CONTENT -->
                <!-- RIGHT CONTENT -->
                <div class="about-content">

                    <span class="about-subtitle">[ ABOUT US ]</span>

                    <h2 class="about-title">
                        Designing refined interiors that elevate everyday living
                    </h2>

                    <p class="about-description">
                        FAREN Interior Studio is a creative interior design firm focused on crafting
                        sophisticated, functional, and timeless spaces. Since 1999, we have been
                        transforming residential, commercial, and hospitality interiors through
                        thoughtful planning, premium materials, and detail-driven execution.
                        Our designs balance comfort, aesthetics, and practicality to create spaces
                        that truly reflect your lifestyle and brand identity.
                    </p>

                    <!-- FEATURE CARDS -->
                    <div class="about-features">
                        <div class="feature-card">
                            <img src="assets/img/icon/feature_1_1.svg" alt="">
                            <span>Space Planning & Layout</span>
                        </div>

                        <div class="feature-card">
                            <img src="assets/img/icon/feature_1_2.svg" alt="">
                            <span>3D Interior Visualization</span>
                        </div>

                        <div class="feature-card">
                            <img src="assets/img/icon/feature_1_3.svg" alt="">
                            <span>Custom Furniture & Finishes</span>
                        </div>

                        <div class="feature-card">
                            <img src="assets/img/icon/feature_1_4.svg" alt="">
                            <span>Turnkey Interior Execution</span>
                        </div>
                    </div>

                    <a href="about.php" class="about-btn">Explore Our Story</a>

                </div>

            </div>
        </div>
    </section>

    <!-- OUR SERVICE -->
    <section class="overflow-hidden space overflow-hidden" id="service-sec">
        <style>
            /* ===============================
   SERVICE SLIDER SECTION
================================ */
            .service-sec-title {
                text-align: start;
                margin-bottom: 60px;
            }

            .service-sec-title .sub-title {
                display: inline-block;
                font-size: 13px;
                letter-spacing: 3px;
                text-transform: uppercase;
                color: #d4a33a;
                margin-bottom: 12px;
                font-weight: 600;
            }

            .service-sec-title .sec-title {
                font-size: clamp(2rem, 3.5vw, 2.8rem);
                font-weight: 700;
                color: #111;
                margin: 0;
            }

            /* Service slider wrapper */
            .service-slider-wrap {
                position: relative;
                padding: 0 20px;
            }

            /* Swiper Container */
            .service-swiper {
                overflow: hidden;
                padding: 0;
            }

            /* Individual Service Card */
            .service-card {
                background: #ffffff;
                border-radius: 16px;
                overflow: hidden;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                transition: all 0.4s ease;
                height: 100%;
                display: flex;
                flex-direction: column;
            }

            .service-card:hover {
                transform: translateY(-12px);
                box-shadow: 0 20px 50px rgba(0, 0, 0, 0.2);
            }

            .service-card .card-img {
                width: 100%;
                height: 240px;
                overflow: hidden;
            }

            .service-card .card-img img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.5s ease;
            }

            .service-card:hover .card-img img {
                transform: scale(1.08);
            }

            .service-card .card-content {
                padding: 10px 24px;
                flex-grow: 1;
                display: flex;
                flex-direction: column;
            }

            .service-card .card-title {
                font-size: 1.35rem;
                font-weight: 700;
                margin-bottom: 14px;
                color: #111;
            }

            .service-card .card-title a {
                color: inherit;
                text-decoration: none;
                transition: color 0.3s ease;
            }

            .service-card .card-title a:hover {
                color: #d4a33a;
            }

            .service-card .card-text {
                font-size: 15px;
                line-height: 1.7;
                color: #666;
                margin-bottom: 20px;
                flex-grow: 1;
            }

            .service-card .card-link {
                display: inline-block;
                font-size: 14px;
                font-weight: 600;
                color: #d4a33a;
                text-decoration: none;
                border-bottom: 2px solid #d4a33a;
                transition: all 0.3s ease;
            }

            .service-card .card-link:hover {
                color: #111;
                border-bottom-color: #111;
            }

            /* Slider Navigation Buttons */
            .service-slider-button {
                position: absolute;
                top: 50%;
                transform: translateY(-50%);
                z-index: 10;
                width: 50px;
                height: 50px;
                background: #d4a33a;
                border: none;
                border-radius: 50%;
                cursor: pointer;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-size: 20px;
                transition: all 0.3s ease;
            }

            .service-slider-button:hover {
                background: #111;
                transform: translateY(-50%) scale(1.1);
            }

            .service-slider-button.prev {
                left: -30px;
            }

            .service-slider-button.next {
                right: -30px;
            }

            .service-slider-button:disabled {
                opacity: 0.5;
                cursor: not-allowed;
            }

            /* Slider Pagination Dots */
            .service-slider-pagination {
                text-align: center;
                margin-top: 40px;
            }

            .service-slider-pagination .swiper-pagination-bullet {
                width: 12px;
                height: 12px;
                background: #ddd;
                opacity: 1;
                margin: 0 6px;
                transition: all 0.3s ease;
            }

            .service-slider-pagination .swiper-pagination-bullet-active {
                background: #d4a33a;
                width: 28px;
                border-radius: 6px;
            }

            /* ===============================
   RESPONSIVE DESIGN
================================ */

            @media (max-width: 1200px) {
                .service-slider-button.prev {
                    left: 0;
                }

                .service-slider-button.next {
                    right: 0;
                }

                .service-card .card-img {
                    height: 200px;
                }
            }

            @media (max-width: 992px) {
                .service-sec-title {
                    margin-bottom: 40px;
                }

                .service-sec-title .sec-title {
                    font-size: 2.2rem;
                }

                .service-card .card-content {
                    padding: 24px 20px;
                }

                .service-card .card-title {
                    font-size: 1.2rem;
                }
            }

            @media (max-width: 768px) {
                .service-slider-wrap {
                    padding: 0 50px;
                }

                .service-card .card-img {
                    height: 180px;
                }

                .service-card .card-content {
                    padding: 20px 16px;
                }

                .service-card .card-title {
                    font-size: 1.1rem;
                    margin-bottom: 10px;
                }

                .service-card .card-text {
                    font-size: 14px;
                    margin-bottom: 15px;
                }

                .service-slider-button {
                    width: 40px;
                    height: 40px;
                    font-size: 16px;
                }
            }

            @media (max-width: 480px) {
                .service-slider-wrap {
                    padding: 0 40px;
                }

                .service-sec-title .sec-title {
                    font-size: 1.8rem;
                }

                .service-card .card-img {
                    height: 160px;
                }

                .service-card .card-content {
                    padding: 18px 14px;
                }

                .service-card .card-title {
                    font-size: 1rem;
                }

                .service-card .card-text {
                    font-size: 13px;
                }

                .service-slider-button {
                    width: 36px;
                    height: 36px;
                    font-size: 14px;
                }
            }
        </style>

        <div class="container">
            <div class="service-sec-title">
                <span class="sub-title">[ Our services ]</span>
                <h2 class="sec-title">What We Do</h2>
            </div>

            <div class="service-slider-wrap" style="margin-top: -33px;">
                <div class="swiper service-swiper">
                    <div class="swiper-wrapper">
                        <!-- Service 1 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_1.jpg" alt="Commercial inter"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="">Commercial inter</a></h3>
                                    <p class="card-text">Designing elegant and functional commercial interiors that elevate brand identity,
                                enhance workflow, and create impactful client experiences.</p>
                                    <a href="" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 2 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_2.jpg"
                                        alt="Multipurpose Interiors"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="multipurpose.html">Multipurpose Interiors</a></h3>
                                    <p class="card-text">Creating adaptable interior spaces that seamlessly transform to
                                        meet diverse functional, professional, and lifestyle requirements.</p>
                                    <a href="multipurpose.html" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 3 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_3.jpg"
                                        alt="Residential Interiors"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="index.html">Residential Interiors</a></h3>
                                    <p class="card-text">Crafting refined residential interiors that blend comfort,
                                        luxury, and personalization to reflect modern living and timeless elegance.</p>
                                    <a href="index.html" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 4 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_4.jpg"
                                        alt="Interior Consultation"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="service.php">Interior Consultation</a></h3>
                                    <p class="card-text">Providing expert interior guidance, space planning, material
                                        selection, and design direction to achieve cohesive and elegant interiors.</p>
                                    <a href="service.php" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 5 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_5.jpg"
                                        alt="Space Planning"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="service.php">Space Planning</a></h3>
                                    <p class="card-text">Optimizing interior layouts through intelligent space planning
                                        that improves flow, functionality, and spatial harmony.</p>
                                    <a href="service.php" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 6 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_6.jpg"
                                        alt="Décor & Art Styling"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="decor-art-page.html">Décor & Art Styling</a></h3>
                                    <p class="card-text">Curating décor elements, artworks, textures, and finishes that
                                        enhance interior ambience and express refined aesthetics.</p>
                                    <a href="decor-art-page.html" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 7 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_7.jpg"
                                        alt="Luxury Interior Styling"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="service.php">Luxury Interior Styling</a>
                                    </h3>
                                    <p class="card-text">Designing sophisticated luxury interiors with premium
                                        materials, custom detailing, and timeless design principles.</p>
                                    <a href="service.php" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 8 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_8.jpg"
                                        alt="Custom Furniture Design"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="service.php">Custom Furniture Design</a>
                                    </h3>
                                    <p class="card-text">Designing bespoke furniture tailored to interior spaces,
                                        ensuring harmony, comfort, and exclusivity in every detail.</p>
                                    <a href="service.php" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>

                        <!-- Service 9 -->
                        <div class="swiper-slide">
                            <div class="service-card">
                                <div class="card-img"><img src="assets/img/service/service_2_9.jpg"
                                        alt="Lighting & Ambience"></div>
                                <div class="card-content">
                                    <h3 class="card-title"><a href="service.php">Lighting & Ambience</a></h3>
                                    <p class="card-text">Creating layered lighting concepts that enhance mood, highlight
                                        textures, and bring warmth and depth to interior spaces.</p>
                                    <a href="service.php" class="card-link">More Information →</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Navigation Buttons -->
                <button class="service-slider-button prev" id="service-slider-prev"><i
                        class="fa-solid fa-chevron-left"></i></button>
                <button class="service-slider-button next" id="service-slider-next"><i
                        class="fa-solid fa-chevron-right"></i></button>
            </div>

            <!-- Pagination -->
            <div class="service-slider-pagination">
                <div class="swiper-pagination" id="service-slider-pagination"></div>
            </div>
        </div>

        <script>
            // Initialize Service Slider
            document.addEventListener('DOMContentLoaded', function () {
                const serviceSlider = new Swiper('.service-swiper', {
                    slidesPerView: 1,
                    spaceBetween: 24,
                    loop: true,
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false
                    },
                    pagination: {
                        el: '#service-slider-pagination',
                        clickable: true
                    },
                    navigation: {
                        nextEl: '#service-slider-next',
                        prevEl: '#service-slider-prev'
                    },
                    breakpoints: {
                        480: {
                            slidesPerView: 1,
                            spaceBetween: 16
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20
                        },
                        992: {
                            slidesPerView: 2,
                            spaceBetween: 24
                        },
                        1200: {
                            slidesPerView: 3,
                            spaceBetween: 28
                        }
                    }
                });
            });
        </script>
    </section>
    <!-- OUR PROCESS  -->
    <section class="process-area overflow-hidden position-relative space overflow-hidden">
        <style>
            /* ===============================
   PROCESS SECTION - MODERN LUXURY DESIGN
================================ */
            .process-area {
                position: relative;
                padding: 20px;
                background: linear-gradient(135deg, #fafafa 0%, #f0ebe5 100%);
                color: #1a1a1a;
                overflow: hidden;
            }

            /* Decorative background elements */
            .process-area::before {
                content: "";
                position: absolute;
                top: -40%;
                right: -10%;
                width: 500px;
                height: 500px;
                background: radial-gradient(circle, rgba(139, 69, 19, 0.08) 0%, transparent 70%);
                border-radius: 50%;
                pointer-events: none;
            }

            .process-area::after {
                content: "";
                position: absolute;
                bottom: -30%;
                left: -5%;
                width: 400px;
                height: 400px;
                background: radial-gradient(circle, rgba(184, 134, 11, 0.06) 0%, transparent 70%);
                border-radius: 50%;
                pointer-events: none;
            }

            /* ===============================
   TITLE AREA
================================ */
            .process-title-area {
                text-align: start;
                margin-bottom: 70px;
                position: relative;
                z-index: 1;
                margin-bottom: -21px;
            }

            .process-title-area .sub-title {
                display: inline-block;
                font-size: 13px;
                letter-spacing: 4px;
                text-transform: uppercase;
                background: linear-gradient(135deg, #8b4513, #b8860b);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                margin-bottom: 12px;
                font-weight: 700;
            }

            .process-title-area .sec-title {
                font-size: clamp(2.2rem, 3.8vw, 3rem);
                font-weight: 800;
                margin: 0;
                color: #1a1a1a;
                letter-spacing: -1px;
            }

            /* ===============================
   PROCESS GRID
================================ */
            .process-grid {
                display: grid;
                grid-template-columns: repeat(4, 1fr);
                gap: 28px;
                position: relative;
                z-index: 1;
            }

            /* Subtle connector line */
            .process-grid::before {
                content: "";
                position: absolute;
                top: 100px;
                left: 6%;
                right: 6%;
                height: 2px;
                background: linear-gradient(to right, transparent, #b8860b 20%, #b8860b 80%, transparent);
                opacity: 0.3;
            }

            /* ===============================
   PROCESS BOX - GRADIENT CARDS
================================ */
            .process-box {
                position: relative;
                padding: 45px 32px 36px;
                border-radius: 24px;
                background: linear-gradient(135deg, #ffffff 0%, #f9f5f0 100%);
                border: 2px solid rgba(184, 134, 11, 0.15);
                transition: all 0.6s cubic-bezier(0.23, 1, 0.320, 1);
                text-align: center;
                min-height: 340px;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.06);
                overflow: hidden;
            }

            /* Gradient overlay on hover */
            .process-box::before {
                content: "";
                position: absolute;
                inset: 0;
                background: linear-gradient(135deg, rgba(184, 134, 11, 0.08), rgba(139, 69, 19, 0.06));
                opacity: 0;
                transition: opacity 0.6s ease;
                pointer-events: none;
            }

            .process-box:hover {
                transform: translateY(-20px) scale(1.03);
                border-color: rgba(184, 134, 11, 0.4);
                box-shadow: 0 30px 80px rgba(139, 69, 19, 0.15);
            }

            .process-box:hover::before {
                opacity: 1;
            }

            /* ===============================
   PROCESS NUMBER BADGE
================================ */
            .process-box .box-number {
                position: absolute;
                top: 15%;
                left: 76%;
                transform: translateX(-50%);
                width: 57px;
                height: 57px;
                border-radius: 50%;
                display: grid;
                place-items: center;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                box-shadow: 0 20px 50px rgba(184, 134, 11, 0.35);
                transition: all 0.4s ease;
                border: 4px solid #f9f5f0;
            }

            .process-box .box-number span {
                font-size: 32px;
                font-weight: 900;
                color: #fff;
                letter-spacing: -1px;
            }

            .process-box:hover .box-number {
                transform: translateX(-50%) scale(1.15) rotateZ(5deg);
                box-shadow: 0 25px 60px rgba(184, 134, 11, 0.45);
            }

            /* ===============================
   CONTENT STYLING
================================ */
            .process-box .box-content {
                padding-top: 30px;
                position: relative;
                z-index: 1;
            }

            .process-box .box-subtitle {
                font-size: 11px;
                letter-spacing: 3px;
                text-transform: uppercase;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                margin-bottom: 12px;
                font-weight: 700;
                display: block;
            }

            .process-box .box-title {
                font-size: 1.35rem;
                margin: 14px 0;
                color: #1a1a1a;
                font-weight: 800;
                line-height: 1.4;
            }

            .process-box .box-text {
                font-size: 14px;
                line-height: 1.8;
                color: #666;
                margin: 0;
                font-weight: 500;
            }

            /* ===============================
   RESPONSIVE BREAKPOINTS
================================ */

            /* Tablet - 2 columns */
            @media (max-width: 1199px) {
                .process-grid {
                    grid-template-columns: repeat(2, 1fr);
                    gap: 24px;
                }

                .process-grid::before {
                    display: none;
                }

                .process-box {
                    min-height: auto;
                    padding: 40px 28px 32px;
                }
            }

            /* iPad - Still 2 columns */
            @media (max-width: 991px) {
                .process-area {
                    padding: 50px 20px;
                }

                .process-title-area {
                    margin-bottom: 60px;
                }

                .process-title-area .sec-title {
                    font-size: 2.4rem;
                }

                .process-box {
                    padding: 36px 26px 30px;
                }

                .process-box .box-number {
                    width: 50px;
                    height: 50px;
                    top: 7px;
                }

                .process-box .box-number span {
                    font-size: 28px;
                }

                .process-box .box-title {
                    font-size: 1.2rem;
                }
            }

            /* Mobile - 1 column */
            @media (max-width: 768px) {
                .process-area {
                    padding: 45px 15px;
                }

                .process-grid {
                    grid-template-columns: 1fr;
                    gap: 22px;
                }

                .process-title-area {
                    margin-bottom: 50px;
                }

                .process-title-area .sec-title {
                    font-size: 2.1rem;
                }

                .process-box {
                    padding: 32px 24px 28px;
                    min-height: auto;
                }

                .process-box .box-number {
                    width: 65px;
                    height: 65px;
                    top: -28px;
                }

                .process-box .box-number span {
                    font-size: 24px;
                }

                .process-box .box-subtitle {
                    font-size: 10px;
                }

                .process-box .box-title {
                    font-size: 1.15rem;
                    margin: 12px 0;
                }

                .process-box .box-text {
                    font-size: 13px;
                    line-height: 1.7;
                }
            }

            /* Small mobile */
            @media (max-width: 480px) {
                .process-area {
                    padding: 35px 12px;
                }

                .process-title-area {
                    margin-bottom: 40px;
                }

                .process-title-area .sub-title {
                    font-size: 11px;
                }

                .process-title-area .sec-title {
                    font-size: 1.9rem;
                }

                .process-box {
                    padding: 28px 18px 22px;
                }

                .process-box .box-number {
                    width: 50px;
                    height: 50px;
                    top: 7px;
                }

                .process-box .box-number span {
                    font-size: 22px;
                }

                .process-box .box-subtitle {
                    font-size: 9px;
                    letter-spacing: 2px;
                }

                .process-box .box-title {
                    font-size: 1.05rem;
                    margin: 10px 0;
                }

                .process-box .box-text {
                    font-size: 12px;
                }
            }
        </style>

        <div class="container">
            <div class="process-title-area">
                <span class="sub-title">[ our Process ]</span>
                <h2 class="sec-title">Work Process</h2>
            </div>

            <div class="process-grid">
                <!-- Process 1 -->
                <div class="process-box">
                    <div class="box-number" style="line-height: 50px;"><span>01</span></div>
                    <div class="box-content">
                        <span class="box-subtitle">Client Consultation</span>
                        <h3 class="box-title">Understanding Your Space</h3>
                        <p class="box-text">
                            We begin by understanding your lifestyle, requirements, and space layout to create a strong
                            foundation for interior design.
                        </p>
                    </div>
                </div>

                <!-- Process 2 -->
                <div class="process-box">
                    <div class="box-number" style="line-height: 50px;"><span>02</span></div>
                    <div class="box-content">
                        <span class="box-subtitle">Concept & Planning</span>
                        <h3 class="box-title">Designing the Interior Vision</h3>
                        <p class="box-text">
                            Our designers develop space plans, color palettes, and material selections aligned with your
                            taste
                            and interior theme.
                        </p>
                    </div>
                </div>

                <!-- Process 3 -->
                <div class="process-box">
                    <div class="box-number" style="line-height: 50px;"><span>03</span></div>
                    <div class="box-content">
                        <span class="box-subtitle">3D Visualization</span>
                        <h3 class="box-title">Bringing Designs to Life</h3>
                        <p class="box-text">
                            Realistic 3D views and walkthroughs help you visualize the final interiors before execution
                            begins.
                        </p>
                    </div>
                </div>

                <!-- Process 4 -->
                <div class="process-box">
                    <div class="box-number" style="line-height: 50px;"><span>04</span></div>
                    <div class="box-content">
                        <span class="box-subtitle">Execution & Styling</span>
                        <h3 class="box-title">Perfect Interior Finish</h3>
                        <p class="box-text">
                            Our expert team executes the design with precision, ensuring quality craftsmanship and
                            timely
                            delivery of your interior space.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Project Section Styles -->

    <!-- OUR PROJECT  -->
    <section class="position-relative overflow-hidden space overflow-hidden" id="project-sec">
        <style>
            /* ===============================
   PROJECT SECTION – MODERN RESPONSIVE
================================ */
            #project-sec {
                position: relative;
                padding: 20px;
                background: linear-gradient(135deg, #ffffff 0%, #f9f5f0 100%);
                overflow: hidden;
            }

            /* Decorative elements */
            #project-sec::before {
                content: "";
                position: absolute;
                top: -20%;
                right: -10%;
                width: 400px;
                height: 400px;
                background: radial-gradient(circle, rgba(184, 134, 11, 0.05) 0%, transparent 70%);
                border-radius: 50%;
                pointer-events: none;
            }

            /* ===============================
   TITLE AREA
================================ */
            .project-title-area {
                display: flex;
                justify-content: space-between;
                align-items: flex-end;
                margin-bottom: 60px;
                gap: clamp(20px, 4vw, 40px);
                position: relative;
                z-index: 1;
            }

            .project-title-area .title-area {
                flex: 1;
            }

            .project-title-area .sub-title {
                display: block;
                font-size: 13px;
                letter-spacing: 3px;
                text-transform: uppercase;
                background: linear-gradient(135deg, #8b4513, #b8860b);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                margin-bottom: 12px;
                font-weight: 700;
            }

            .project-title-area .sec-title {
                font-size: clamp(2rem, 3.5vw, 2.8rem);
                font-weight: 800;
                color: #1a1a1a;
                margin: 0;
                letter-spacing: -1px;
            }

            .project-title-area .explore-btn {
                padding: 14px 36px;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                color: #fff;
                border: none;
                border-radius: 8px;
                font-size: 15px;
                font-weight: 600;
                cursor: pointer;
                transition: all 0.4s ease;
                text-decoration: none;
                display: inline-block;
                white-space: nowrap;
            }

            .project-title-area .explore-btn:hover {
                transform: translateY(-4px);
                box-shadow: 0 15px 40px rgba(184, 134, 11, 0.3);
                background: linear-gradient(135deg, #8b4513, #b8860b);
            }

            /* ===============================
   PROJECT GRID – RESPONSIVE LAYOUT
================================ */
            .projects-grid {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: clamp(24px, 3vw, 32px);
                position: relative;
                z-index: 1;
            }

            /* ===============================
   PROJECT CARD
================================ */
            .project-card {
                position: relative;
                overflow: hidden;
                border-radius: 20px;
                height: 360px;
                background: #ffffff;
                box-shadow: 0 10px 35px rgba(0, 0, 0, 0.08);
                transition: all 0.6s cubic-bezier(0.23, 1, 0.320, 1);
                cursor: pointer;
                display: flex;
                align-items: flex-end;
            }

            .project-card:hover {
                transform: translateY(-15px);
                box-shadow: 0 25px 60px rgba(0, 0, 0, 0.15);
            }

            /* ===============================
   PROJECT IMAGE
================================ */
            .project-card .card-image {
                position: absolute;
                inset: 0;
                width: 100%;
                height: 100%;
                overflow: hidden;
            }

            .project-card .card-image img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.7s cubic-bezier(0.23, 1, 0.320, 1);
            }

            .project-card:hover .card-image img {
                transform: scale(1.12);
            }

            /* ===============================
   PROJECT OVERLAY
================================ */
            .project-card::before {
                content: "";
                position: absolute;
                inset: 0;
                background: linear-gradient(180deg, transparent 0%, rgba(26, 26, 26, 0.3) 40%, rgba(26, 26, 26, 0.8) 100%);
                opacity: 1;
                transition: opacity 0.5s ease;
                z-index: 2;
            }

            .project-card:hover::before {
                background: linear-gradient(180deg, transparent 0%, rgba(26, 26, 26, 0.4) 40%, rgba(139, 69, 19, 0.9) 100%);
            }

            /* ===============================
   PROJECT CONTENT
================================ */
            .project-content {
                position: relative;
                z-index: 3;
                padding: clamp(24px, 4vw, 32px);
                width: 100%;
                color: #fff;
                transform: translateY(20px);
                opacity: 0;
                transition: all 0.5s cubic-bezier(0.23, 1, 0.320, 1);
            }

            .project-card:hover .project-content {
                transform: translateY(0);
                opacity: 1;
            }

            .project-content .category {
                display: inline-block;
                font-size: 11px;
                letter-spacing: 2px;
                text-transform: uppercase;
                background: rgba(184, 134, 11, 0.3);
                color: #f0ebe5;
                padding: 6px 14px;
                border-radius: 20px;
                margin-bottom: 12px;
                font-weight: 600;
            }

            .project-content .project-title {
                font-size: clamp(1.1rem, 1.5vw, 1.4rem);
                font-weight: 800;
                margin: 0 0 16px 0;
                line-height: 1.3;
                color: #fff;
            }

            .project-content .project-title a {
                color: inherit;
                text-decoration: none;
                transition: color 0.3s ease;
            }

            .project-content .project-title a:hover {
                color: #b8860b;
            }

            .project-actions {
                display: flex;
                gap: 14px;
                align-items: center;
                margin-top: 16px;
            }

            .project-popup-btn {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                width: 44px;
                height: 44px;
                border-radius: 50%;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                color: #fff;
                border: none;
                cursor: pointer;
                transition: all 0.3s ease;
                font-size: 18px;
            }

            .project-popup-btn:hover {
                transform: scale(1.15) rotate(90deg);
                background: linear-gradient(135deg, #8b4513, #b8860b);
            }

            .project-learn-btn {
                padding: 10px 22px;
                background: rgba(255, 255, 255, 0.2);
                color: #fff;
                border: 1px solid rgba(255, 255, 255, 0.4);
                border-radius: 6px;
                font-size: 13px;
                font-weight: 600;
                cursor: pointer;
                text-decoration: none;
                transition: all 0.3s ease;
                display: inline-block;
            }

            .project-learn-btn:hover {
                background: #b8860b;
                border-color: #b8860b;
                color: #fff;
            }

            /* ===============================
   STATIC CONTENT (VISIBLE ALWAYS)
================================ */
            .project-card-footer {
                position: absolute;
                bottom: 0;
                left: 0;
                right: 0;
                padding: 24px;
                background: linear-gradient(180deg, transparent 0%, rgba(0, 0, 0, 0.6) 100%);
                z-index: 2;
                color: #fff;
            }

            .project-card-footer .category {
                display: inline-block;
                font-size: 10px;
                letter-spacing: 2px;
                text-transform: uppercase;
                color: #b8860b;
                font-weight: 700;
                margin-bottom: 8px;
            }

            .project-card-footer .title {
                font-size: 1.15rem;
                font-weight: 700;
                color: #fff;
                margin: 0;
                line-height: 1.3;
            }

            /* ===============================
   RESPONSIVE BREAKPOINTS
================================ */

            /* Tablet – 2 columns */
            @media (max-width: 1199px) {
                .projects-grid {
                    grid-template-columns: repeat(2, 1fr);
                    gap: clamp(20px, 3vw, 28px);
                }

                #project-sec {
                    padding: 45px 20px;
                }

                .project-title-area {
                    flex-direction: column;
                    align-items: flex-start;
                    margin-bottom: 50px;
                }

                .project-card {
                    height: 320px;
                }
            }

            /* iPad – Still 2 columns */
            @media (max-width: 991px) {
                .projects-grid {
                    grid-template-columns: repeat(2, 1fr);
                    gap: 20px;
                }

                .project-card {
                    height: 300px;
                }

                .project-title-area .sec-title {
                    font-size: 2.2rem;
                }

                #project-sec::before {
                    width: 300px;
                    height: 300px;
                }
            }

            /* Mobile – 1 column */
            @media (max-width: 768px) {
                .projects-grid {
                    grid-template-columns: 1fr;
                    gap: 18px;
                }

                .project-card {
                    height: 280px;
                }

                .project-title-area {
                    margin-bottom: 40px;
                }

                .project-title-area .sec-title {
                    font-size: 1.9rem;
                }

                .project-content {
                    padding: 20px;
                }

                .project-card-footer {
                    padding: 20px;
                }

                #project-sec {
                    padding: 40px 15px;
                }
            }

            /* Small mobile */
            @media (max-width: 480px) {
                .projects-grid {
                    gap: 16px;
                }

                .project-card {
                    height: 240px;
                }

                .project-title-area {
                    margin-bottom: 30px;
                }

                .project-title-area .sub-title {
                    font-size: 11px;
                }

                .project-title-area .sec-title {
                    font-size: 1.6rem;
                }

                .project-title-area .explore-btn {
                    padding: 12px 28px;
                    font-size: 13px;
                }

                .project-content .category {
                    font-size: 9px;
                    padding: 5px 12px;
                }

                .project-content .project-title {
                    font-size: 1rem;
                    margin-bottom: 12px;
                }

                .project-popup-btn {
                    width: 40px;
                    height: 40px;
                    font-size: 16px;
                }

                .project-learn-btn {
                    padding: 8px 16px;
                    font-size: 12px;
                }

                #project-sec {
                    padding: 35px 12px;
                }
            }
        </style>
        <div class="container">
            <div class="project-title-area">
                <div class="title-area">
                    <span class="sub-title">[ Our projects ]</span>
                    <h2 class="sec-title">Recent Project</h2>
                </div>
                <a href="project.php" class="explore-btn" style="margin-bottom: 70px;">Explore All</a>
            </div>

            <div class="projects-grid" style="margin-top: -70px;">
                <!-- Project 1 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_1.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Building</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Building</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_1.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 2 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_2.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Masonry</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Masonry</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_2.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 3 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_3.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Masonry</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Masonry</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_3.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 4 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_4.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Masonry</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Masonry</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_4.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 5 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_3_2.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Masonry</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Masonry</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_3_2.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 6 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_3_3.jpg" alt="Modern Factory Architecture">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Masonry</span>
                        <h3 class="title">Modern Factory Architecture</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Masonry</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Factory Architecture</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_3_3.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- testimonial section -->
    <section class="test-sec overflow-hidden" id="testi-sec">
        <!--  -->
        <style>
            /* =================================
   TESTIMONIAL SECTION – STRUCTURE
================================= */
            #testi-sec {
                position: relative;
                padding: 15px;
                ;
                overflow: hidden;
            }

            /* =================================
   TITLE AREA REFINEMENT
================================= */
            #testi-sec .title-area {
                max-width: 520px;
            }

            #testi-sec .sec-title {
                font-size: clamp(1.9rem, 3vw, 2.8rem);
                line-height: 1.2;
            }

            /* =================================
   SLIDER WRAP
================================= */
            #testi-sec .slider-wrap {
                margin-top: clamp(40px, 5vw, 80px);
            }

            /* =================================
   TESTIMONIAL CARD
================================= */
            .testi-grid2 {
                position: relative;
                height: 100%;
                padding: clamp(28px, 3vw, 40px);
                border-radius: 22px;
                overflow: hidden;
                transform-style: preserve-3d;
                transition: transform .6s cubic-bezier(.2, .8, .2, 1),
                    box-shadow .6s ease;
            }

            /* floating effect */
            .swiper-slide-active .testi-grid2,
            .testi-grid2:hover {
                transform: translateY(-14px);
            }

            /* =================================
   PROFILE AREA
================================= */
            .testi-grid2 .box-profile {
                display: flex;
                align-items: center;
                gap: 16px;
                margin-bottom: 20px;
            }

            .testi-grid2 .box-author {
                flex-shrink: 0;
            }

            .testi-grid2 .box-author img {
                width: 56px;
                height: 56px;
                border-radius: 50%;
                object-fit: cover;
            }

            /* =================================
   TEXT CONTENT
================================= */
            .testi-grid2 .box-text {
                font-size: clamp(14px, 1.2vw, 16px);
                line-height: 1.7;
                margin-bottom: 26px;
            }

            /* =================================
   FOOTER AREA
================================= */
            .testi-grid2 .box-wrapp {
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 14px;
                flex-wrap: wrap;
            }

            /* quote icon depth */
            .testi-grid2 .box-quote img {
                transform: translateZ(20px);
            }

            /* rating alignment */
            .testi-grid2 .box-rating {
                display: flex;
                align-items: center;
                gap: 10px;
                white-space: nowrap;
            }

            /* =================================
   SLIDER ARROWS REFINEMENT
================================= */
            #testi-sec .slider-arrow {
                width: 54px;
                height: 54px;
                display: grid;
                place-items: center;
                transition: transform .4s ease;
            }

            #testi-sec .slider-arrow:hover {
                transform: translateY(-4px);
            }

            /* =================================
   RESPONSIVE BEHAVIOR
================================= */

            /* tablets */
            @media (max-width: 991px) {
                #testi-sec .title-area {
                    text-align: center;
                    margin: 0 auto;
                }

                .testi-grid2 {
                    padding: 30px;
                }
            }

            /* mobile */
            @media (max-width: 767px) {
                #testi-sec {
                    text-align: center;
                }

                .testi-grid2 {
                    padding: 26px;
                }

                .testi-grid2 .box-profile {
                    justify-content: center;
                    text-align: left;
                }

                .testi-grid2 .box-wrapp {
                    justify-content: center;
                }
            }

            /* ultra-wide screens */
            @media (min-width: 1600px) {
                #testi-sec .swiper {
                    max-width: 1400px;
                }
            }
        </style>

        <div class="container">
            <div class="testi-area4">
                <div class="row justify-content-between align-items-center" style="margin-top: -40px;">
                    <div class="col-xl-6">
                        <div class="title-area align-self-end"><span class="sub-title style2 text-anime">[ TESTIMONIALS
                                ]</span>
                            <h2 class="sec-title split-text">Our clients trust us to deliver exceptional results</h2>
                        </div>
                    </div>
                    <div class="col-md-auto d-none d-lg-block">
                        <div class="sec-btn mt-n3 mt-md-0">
                            <div class="icon-box"><button data-slider-prev="#testiSlide3"
                                    class="slider-arrow style2 default slider-prev"><img
                                        src="assets/img/icon/right-arrow4.svg" alt=""></button> <button
                                    data-slider-next="#testiSlide3" class="slider-arrow style2 default slider-next"><img
                                        src="assets/img/icon/left-arrow4.svg" alt=""></button></div>
                        </div>
                    </div>
                </div>
                <div class="slider-wrap" style="margin-top: -36px; margin-bottom: -97px;">
                    <div class="swiper th-slider has-shadow" id="testiSlide3"
                        data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1300":{"slidesPerView":"2"}}}'>
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="testi-grid2">
                                    <div class="box-profile">
                                        <div class="box-author"><img class="img"
                                                src="assets/img/testimonial/testi_6_1.png" alt="Avater"></div>
                                        <div class="box-info">
                                            <h3 class="box-title">Carlos Mendez</h3><span class="box-desig">Local Arts
                                                Council President</span>
                                        </div>
                                    </div>
                                    <div class="box-content">
                                        <p class="box-text">"It was clear from the start that sustainability wasn�t an
                                            afterthought � it was central to every design decision. The passive cooling
                                            and natural materials make our building both eco-friendly and elegant."</p>
                                    </div>
                                    <div class="box-wrapp">
                                        <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="testi-grid2">
                                    <div class="box-profile">
                                        <div class="box-author"><img class="img"
                                                src="assets/img/testimonial/testi_6_2.png" alt="Avater"></div>
                                        <div class="box-info">
                                            <h3 class="box-title">Michel John</h3><span class="box-desig">Local Arts
                                                Council President</span>
                                        </div>
                                    </div>
                                    <div class="box-content">
                                        <p class="box-text">"It was clear from the start that sustainability wasn�t an
                                            afterthought � it was central to every design decision. The passive cooling
                                            and natural materials make our building both eco-friendly and elegant."</p>
                                    </div>
                                    <div class="box-wrapp">
                                        <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="testi-grid2">
                                    <div class="box-profile">
                                        <div class="box-author"><img class="img"
                                                src="assets/img/testimonial/testi_6_1.png" alt="Avater"></div>
                                        <div class="box-info">
                                            <h3 class="box-title">Carlos Mendez</h3><span class="box-desig">Local Arts
                                                Council President</span>
                                        </div>
                                    </div>
                                    <div class="box-content">
                                        <p class="box-text">"It was clear from the start that sustainability wasn�t an
                                            afterthought � it was central to every design decision. The passive cooling
                                            and natural materials make our building both eco-friendly and elegant."</p>
                                    </div>
                                    <div class="box-wrapp">
                                        <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="testi-grid2">
                                    <div class="box-profile">
                                        <div class="box-author"><img class="img"
                                                src="assets/img/testimonial/testi_6_2.png" alt="Avater"></div>
                                        <div class="box-info">
                                            <h3 class="box-title">Michel John</h3><span class="box-desig">Local Arts
                                                Council President</span>
                                        </div>
                                    </div>
                                    <div class="box-content">
                                        <p class="box-text">"It was clear from the start that sustainability wasn�t an
                                            afterthought � it was central to every design decision. The passive cooling
                                            and natural materials make our building both eco-friendly and elegant."</p>
                                    </div>
                                    <div class="box-wrapp">
                                        <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-left="0%"><img
                        src="assets/img/shape/element-19.png" alt=""></div> -->
            </div>
        </div>
    </section>
    <!-- GET IN TOUCH -->
    <div class="contact-area overflow-hidden space" id="contact-sec">
       <style>
/* =================================
   CONTACT IMAGE – FULL RESPONSIVE FIX
================================= */

/* reset previous behavior */
.contact-image.style2 {
  position: relative;
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: clamp(12px, 2vw, 20px);
  align-items: stretch;
}

/* base image wrapper */
.contact-image.style2 > div {
  position: relative;
  width: 100%;
  overflow: hidden;
  border-radius: 20px;
}

/* image itself */
.contact-image.style2 img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  aspect-ratio: 4 / 3;
  transition: transform .6s ease;
}

/* subtle interaction */
.contact-image.style2 img:hover {
  transform: scale(1.05);
}

/* =================================
   DESKTOP LAYOUT (ASYMMETRIC)
================================= */
.contact-image.style2 .img1 {
  grid-column: span 7;
  aspect-ratio: 4 / 5;
}

.contact-image.style2 .img2 {
  grid-column: span 5;
  aspect-ratio: 1 / 1;
}

.contact-image.style2 .img3 {
  grid-column: span 5;
  aspect-ratio: 3 / 2;
}

.contact-image.style2 .img4 {
  grid-column: span 7;
  aspect-ratio: 16 / 9;
}

/* force aspect control */
.contact-image.style2 .img1 img,
.contact-image.style2 .img2 img,
.contact-image.style2 .img3 img,
.contact-image.style2 .img4 img {
  aspect-ratio: inherit;
}

/* =================================
   TABLET (BALANCED GRID)
================================= */
@media (max-width: 1199px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
  }

  .contact-image.style2 > div {
    grid-column: span 1 !important;
    aspect-ratio: 4 / 3;
  }
}

/* =================================
   MOBILE (2-COLUMN GRID LAYOUT)
================================= */
@media (max-width: 767px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
    gap: clamp(10px, 1.5vw, 15px);
  }

  .contact-image.style2 > div {
    aspect-ratio: 4 / 3;
  }

  .contact-image.style2 .img1,
  .contact-image.style2 .img2,
  .contact-image.style2 .img3,
  .contact-image.style2 .img4 {
    grid-column: span 1 !important;
  }
}

/* =================================
   MOBILE FORM OPTIMIZATION
================================= */
@media (max-width: 767px) {
  .contact-area .row {
    --bs-gutter-y: 1rem;
  }

  .contact-area .title-area {
    margin-bottom: 25px;
  }

  .contact-area .title-area .sub-title {
    font-size: 13px;
  }

  .contact-area .title-area .sec-title {
    font-size: 24px;
    line-height: 1.3;
  }

  .contact-area .form-group {
    margin-bottom: 12px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 15px;
    padding: 12px 14px;
    height: auto;
  }

  .contact-area .form-group input::placeholder,
  .contact-area .form-group textarea::placeholder {
    font-size: 14px;
  }

  .contact-area .form-group textarea {
    min-height: 100px;
  }

  .contact-area .form-btn {
    margin-top: 15px;
  }

  .contact-area .form-messages {
    font-size: 13px;
  }

  .contact-area .col-xl-6 {
    margin-bottom: 30px;
  }
}

/* =================================
   ULTRA-SMALL MOBILE (=380px)
================================= */
@media (max-width: 380px) {
  .contact-area .title-area .sec-title {
    font-size: 20px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 14px;
    padding: 10px 12px;
  }

  .contact-area .form-group textarea {
    min-height: 80px;
    font-size: 14px;
  }

  .contact-area .th-btn {
    font-size: 14px;
    padding: 12px 20px;
  }
}

/* =================================
   ULTRA-WIDE SCREENS
================================= */
@media (min-width: 1600px) {
  .contact-image.style2 img {
    aspect-ratio: 16 / 9;
  }
}
</style>


        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact">
                        <div class="title-area pe-xl-5 me-xl-5"><span class="sub-title style2 text-anime">get in
                                touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into
                                Reality</h2>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6"><input type="text" class="form-control" name="name"
                                    id="name" placeholder="Full Name"> <i class="fa-solid fa-user"></i></div>
                            <div class="form-group col-md-6"><input type="email" class="form-control" name="email"
                                    id="email" placeholder="Email Address"> <i class="fa-solid fa-envelope"></i></div>
                            <div class="form-group col-md-6"><input type="tel" class="form-control" name="number"
                                    id="number" placeholder="Phone Number"> <i class="fa-solid fa-phone"></i></div>
                            <div class="form-group col-md-6"><select name="subject" id="subject"
                                    class="form-select nice-select">
                                    <option value="" disabled="disabled" selected="selected" hidden="">Inquire Services
                                    </option>
                                    <option value="Interior Consultingt">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select></div>
                            <div class="form-group col-12"><textarea name="message" id="message" cols="30" rows="3"
                                    class="form-control" placeholder="Your Message"></textarea> <i
                                    class="fa-solid fa-comment"></i></div>
                            <div class="col-12 form-group"><input type="checkbox" id="html"> <label for="html">I agree
                                    with the privacy policy</label></div>
                            <div class="form-btn mt-20 col-12"><button class="th-btn style4">Send Message</button></div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image style2">
                        <div class="img1 img-anim-left"><img src="assets/img/normal/contact-2-1.jpg" alt=""></div>
                        <div class="img2 img-anim-right"><img src="assets/img/normal/contact-2-2.jpg" alt=""></div>
                        <div class="img3 img-anim-left"><img src="assets/img/normal/contact-2-3.jpg" alt=""></div>
                        <div class="img4 img-anim-right"><img src="assets/img/normal/contact-2-4.jpg" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="shape-mockup spin d-none d-xxl-block" data-top="10%" data-right="13%"><img
                src="assets/img/shape/element-5.png" alt=""></div> -->
    </div>
    <!-- blog section -->
    <section class="overflow-hidden space" id="blog-sec">
        <style>
            /* ===============================
   BLOG SECTION – SLIDER LAYOUT
================================ */
            #blog-sec {
                position: relative;
                padding: 20px;
                background: linear-gradient(135deg, #f9f5f0 0%, #ffffff 100%);
                overflow: hidden;
            }

            /* Decorative elements */
            #blog-sec::before {
                content: "";
                position: absolute;
                top: -30%;
                left: -10%;
                width: 450px;
                height: 450px;
                background: radial-gradient(circle, rgba(184, 134, 11, 0.06) 0%, transparent 70%);
                border-radius: 50%;
                pointer-events: none;
            }

            #blog-sec::after {
                content: "";
                position: absolute;
                bottom: -20%;
                right: -10%;
                width: 380px;
                height: 380px;
                background: radial-gradient(circle, rgba(139, 69, 19, 0.05) 0%, transparent 70%);
                border-radius: 50%;
                pointer-events: none;
            }

            /* ===============================
   TITLE AREA
================================ */
            .blog-sec-title {
                text-align: start;
                margin-bottom: 60px;
                position: relative;
                z-index: 1;
            }

            .blog-sec-title .sub-title {
                display: inline-block;
                font-size: 13px;
                letter-spacing: 3px;
                text-transform: uppercase;
                background: linear-gradient(135deg, #8b4513, #b8860b);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                margin-bottom: 12px;
                font-weight: 700;
            }

            .blog-sec-title .sec-title {
                font-size: clamp(2rem, 3.5vw, 2.8rem);
                font-weight: 800;
                color: #1a1a1a;
                margin: 0;
                letter-spacing: -1px;
            }

            .blog-sec-title .sec-title .text-theme {
                background: linear-gradient(135deg, #b8860b, #8b4513);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            }

            /* ===============================
   BLOG SLIDER WRAPPER
================================ */
            .blog-slider-wrap {
                position: relative;
                padding: 0 20px;
                z-index: 1;
            }

            .blog-swiper {
                overflow: hidden;
                padding: 20px 0;
            }

            /* ===============================
   BLOG CARD
================================ */
            .blog-card-slider {
                background: #ffffff;
                border-radius: 18px;
                overflow: hidden;
                box-shadow: 0 12px 40px rgba(0, 0, 0, 0.08);
                transition: all 0.6s cubic-bezier(0.23, 1, 0.320, 1);
                height: 100%;
                display: flex;
                flex-direction: column;
                border: 1px solid rgba(184, 134, 11, 0.1);
            }

            .blog-card-slider:hover {
                transform: translateY(-16px);
                box-shadow: 0 25px 60px rgba(0, 0, 0, 0.12);
                border-color: rgba(184, 134, 11, 0.3);
            }

            /* ===============================
   BLOG IMAGE
================================ */
            .blog-card-slider .blog-img {
                width: 100%;
                height: 240px;
                overflow: hidden;
                position: relative;
            }

            .blog-card-slider .blog-img img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.7s cubic-bezier(0.23, 1, 0.320, 1);
            }

            .blog-card-slider:hover .blog-img img {
                transform: scale(1.1);
            }

            /* ===============================
   BLOG CONTENT
================================ */
            .blog-card-slider .blog-content {
                padding: 20px;
                flex-grow: 1;
                display: flex;
                flex-direction: column;
            }

            .blog-card-slider .blog-meta {
                display: flex;
                gap: 16px;
                flex-wrap: wrap;
                margin-bottom: 14px;
                font-size: 12px;
            }

            .blog-card-slider .blog-meta a {
                color: #b8860b;
                text-decoration: none;
                font-weight: 600;
                transition: color 0.3s ease;
                letter-spacing: 0.5px;
            }

            .blog-card-slider .blog-meta a:hover {
                color: #8b4513;
            }

            .blog-card-slider .blog-title {
                font-size: clamp(1.1rem, 1.4vw, 1.35rem);
                font-weight: 800;
                margin: 0 0 16px 0;
                line-height: 1.4;
                color: #1a1a1a;
                flex-grow: 1;
            }

            .blog-card-slider .blog-title a {
                color: inherit;
                text-decoration: none;
                transition: color 0.3s ease;
            }

            .blog-card-slider .blog-title a:hover {
                color: #b8860b;
            }

            /* ===============================
   BLOG FOOTER
================================ */
            .blog-card-slider .blog-footer {
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 16px;
                flex-wrap: wrap;
                padding-top: 16px;
                border-top: 1px solid rgba(184, 134, 11, 0.1);
            }

            .blog-card-slider .blog-date {
                font-size: 13px;
                color: #666;
                font-weight: 600;
            }

            .blog-card-slider .blog-link {
                display: inline-block;
                padding: 10px 22px;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                color: #fff;
                border: none;
                border-radius: 6px;
                font-size: 13px;
                font-weight: 600;
                text-decoration: none;
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .blog-card-slider .blog-link:hover {
                transform: translateY(-3px);
                box-shadow: 0 10px 25px rgba(184, 134, 11, 0.3);
                background: linear-gradient(135deg, #8b4513, #b8860b);
            }

            /* ===============================
   SLIDER NAVIGATION
================================ */
            .blog-slider-button {
                position: absolute;
                top: 50%;
                transform: translateY(-50%);
                z-index: 10;
                width: 50px;
                height: 50px;
                background: linear-gradient(135deg, #b8860b, #8b4513);
                border: none;
                border-radius: 50%;
                cursor: pointer;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-size: 20px;
                transition: all 0.3s ease;
            }

            .blog-slider-button:hover {
                background: linear-gradient(135deg, #8b4513, #b8860b);
                transform: translateY(-50%) scale(1.1);
                box-shadow: 0 12px 30px rgba(184, 134, 11, 0.3);
            }

            .blog-slider-button.prev {
                left: -30px;
            }

            .blog-slider-button.next {
                right: -30px;
            }

            .blog-slider-button:disabled {
                opacity: 0.5;
                cursor: not-allowed;
            }

            /* ===============================
   SLIDER PAGINATION
================================ */
            .blog-slider-pagination {
                text-align: center;
                margin-top: 40px;
                position: relative;
                z-index: 1;
            }

            .blog-slider-pagination .swiper-pagination-bullet {
                width: 12px;
                height: 12px;
                background: #ddd;
                opacity: 1;
                margin: 0 6px;
                transition: all 0.3s ease;
                border-radius: 50%;
            }

            .blog-slider-pagination .swiper-pagination-bullet-active {
                background: linear-gradient(135deg, #b8860b, #8b4513);
                width: 28px;
                border-radius: 6px;
            }

            /* ===============================
   RESPONSIVE BREAKPOINTS
================================ */

            /* Extra Large (1400px+) */
            @media (min-width: 1400px) {
                #blog-sec {
                    padding: 60px 20px;
                }

                .blog-sec-title {
                    margin-bottom: 70px;
                }

                .blog-sec-title .sec-title {
                    font-size: 3rem;
                }

                .blog-card-slider .blog-img {
                    height: 280px;
                }

                .blog-card-slider .blog-content {
                    padding: 28px 24px;
                }

                .blog-slider-wrap {
                    padding: 0 30px;
                }
            }

            /* Large Desktop (1200-1399px) */
            @media (max-width: 1399px) and (min-width: 1200px) {
                #blog-sec {
                    padding: 55px 20px;
                }

                .blog-sec-title {
                    margin-bottom: 65px;
                }

                .blog-sec-title .sec-title {
                    font-size: 2.8rem;
                }

                .blog-card-slider .blog-img {
                    height: 250px;
                }

                .blog-slider-wrap {
                    padding: 0 25px;
                }
            }

            /* Desktop (1024-1199px) - 3 columns */
            @media (max-width: 1199px) and (min-width: 1024px) {
                .blog-slider-button.prev {
                    left: 5px;
                }

                .blog-slider-button.next {
                    right: 5px;
                }

                .blog-card-slider .blog-img {
                    height: 220px;
                }

                #blog-sec {
                    padding: 50px 20px;
                }

                .blog-sec-title .sec-title {
                    font-size: 2.6rem;
                }
            }

            /* Laptop (992-1023px) - 2 columns */
            @media (max-width: 1023px) and (min-width: 992px) {
                .blog-slider-button.prev {
                    left: 0;
                }

                .blog-slider-button.next {
                    right: 0;
                }

                .blog-card-slider .blog-img {
                    height: 210px;
                }

                #blog-sec {
                    padding: 45px 20px;
                }

                .blog-sec-title {
                    margin-bottom: 50px;
                }

                .blog-sec-title .sec-title {
                    font-size: 2.4rem;
                }

                .blog-card-slider .blog-content {
                    padding: 24px 20px;
                }

                .blog-card-slider .blog-title {
                    font-size: 1.2rem;
                }

                .blog-slider-wrap {
                    padding: 0 15px;
                }
            }

            /* Tablet Landscape (768-991px) */
            @media (max-width: 991px) and (min-width: 768px) {
                #blog-sec {
                    padding: 45px 15px;
                }

                .blog-sec-title {
                    margin-bottom: 45px;
                }

                .blog-sec-title .sec-title {
                    font-size: 2.1rem;
                }

                .blog-sec-title .sub-title {
                    font-size: 12px;
                    margin-bottom: 10px;
                }

                .blog-slider-wrap {
                    padding: 0 40px;
                    margin-top: -40px;
                }

                .blog-card-slider .blog-img {
                    height: 200px;
                }

                .blog-card-slider .blog-content {
                    padding: 20px 18px;
                }

                .blog-card-slider .blog-title {
                    font-size: 1.15rem;
                    margin-bottom: 12px;
                }

                .blog-card-slider .blog-meta {
                    font-size: 12px;
                    gap: 12px;
                    margin-bottom: 12px;
                }

                .blog-card-slider .blog-footer {
                    gap: 12px;
                    padding-top: 12px;
                }

                .blog-slider-button {
                    width: 40px;
                    height: 40px;
                    font-size: 16px;
                    top: 45%;
                }

                .blog-slider-pagination {
                    margin-top: 30px;
                }

                .blog-slider-pagination .swiper-pagination-bullet {
                    width: 10px;
                    height: 10px;
                    margin: 0 5px;
                }
            }

            /* Tablet Portrait (600-767px) - Single column */
            @media (max-width: 767px) and (min-width: 600px) {
                #blog-sec {
                    padding: 40px 15px;
                }

                .blog-sec-title {
                    margin-bottom: 40px;
                }

                .blog-sec-title .sec-title {
                    font-size: 1.95rem;
                    line-height: 1.3;
                }

                .blog-sec-title .sub-title {
                    font-size: 11px;
                }

                .blog-slider-wrap {
                    padding: 0 45px;
                    margin-top: -35px;
                }

                .blog-card-slider {
                    border-radius: 14px;
                }

                .blog-card-slider .blog-img {
                    height: 190px;
                }

                .blog-card-slider .blog-content {
                    padding: 18px 16px;
                }

                .blog-card-slider .blog-title {
                    font-size: 1.1rem;
                    margin-bottom: 12px;
                    line-height: 1.35;
                }

                .blog-card-slider .blog-meta {
                    font-size: 11px;
                    gap: 12px;
                    margin-bottom: 10px;
                }

                .blog-card-slider .blog-meta a {
                    font-size: 11px;
                }

                .blog-card-slider .blog-footer {
                    gap: 10px;
                    padding-top: 12px;
                    flex-wrap: wrap;
                }

                .blog-card-slider .blog-date {
                    font-size: 12px;
                }

                .blog-card-slider .blog-link {
                    padding: 8px 16px;
                    font-size: 12px;
                }

                .blog-slider-button {
                    width: 38px;
                    height: 38px;
                    font-size: 15px;
                    top: 40%;
                }

                .blog-slider-button.prev {
                    left: 5px;
                }

                .blog-slider-button.next {
                    right: 5px;
                }

                .blog-slider-pagination {
                    margin-top: 25px;
                }

                .blog-slider-pagination .swiper-pagination-bullet {
                    width: 9px;
                    height: 9px;
                    margin: 0 4px;
                }
            }

            /* Mobile Landscape (480-599px) */
            @media (max-width: 599px) and (min-width: 480px) {
                #blog-sec {
                    padding: 35px 12px;
                }

                .blog-sec-title {
                    margin-bottom: 35px;
                }

                .blog-sec-title .sec-title {
                    font-size: 1.75rem;
                    line-height: 1.3;
                }

                .blog-sec-title .sub-title {
                    font-size: 10px;
                    letter-spacing: 2px;
                }

                .blog-slider-wrap {
                    padding: 0 42px;
                    margin-top: -30px;
                }

                .blog-card-slider .blog-img {
                    height: 175px;
                }

                .blog-card-slider .blog-content {
                    padding: 16px 14px;
                }

                .blog-card-slider .blog-title {
                    font-size: 1rem;
                    margin-bottom: 10px;
                    line-height: 1.3;
                }

                .blog-card-slider .blog-meta {
                    font-size: 10px;
                    gap: 10px;
                    margin-bottom: 8px;
                }

                .blog-card-slider .blog-footer {
                    gap: 8px;
                    padding-top: 10px;
                }

                .blog-card-slider .blog-date {
                    font-size: 11px;
                }

                .blog-card-slider .blog-link {
                    padding: 7px 14px;
                    font-size: 11px;
                }

                .blog-slider-button {
                    width: 36px;
                    height: 36px;
                    font-size: 14px;
                    top: 35%;
                }

                .blog-slider-button.prev {
                    left: 2px;
                }

                .blog-slider-button.next {
                    right: 2px;
                }

                .blog-slider-pagination {
                    margin-top: 20px;
                }

                .blog-slider-pagination .swiper-pagination-bullet {
                    width: 8px;
                    height: 8px;
                    margin: 0 3px;
                }
            }

            /* Small Mobile (380-479px) */
            @media (max-width: 479px) and (min-width: 380px) {
                #blog-sec {
                    padding: 30px 10px;
                }

                #blog-sec::before,
                #blog-sec::after {
                    display: none;
                }

                .blog-sec-title {
                    margin-bottom: 30px;
                }

                .blog-sec-title .sec-title {
                    font-size: 1.6rem;
                    line-height: 1.25;
                }

                .blog-sec-title .sub-title {
                    font-size: 9px;
                    letter-spacing: 1.5px;
                }

                .blog-slider-wrap {
                    padding: 0 38px;
                    margin-top: -25px;
                }

                .blog-card-slider {
                    border-radius: 12px;
                }

                .blog-card-slider .blog-img {
                    height: 160px;
                }

                .blog-card-slider .blog-content {
                    padding: 14px 12px;
                }

                .blog-card-slider .blog-title {
                    font-size: 0.95rem;
                    margin-bottom: 8px;
                    line-height: 1.25;
                }

                .blog-card-slider .blog-meta {
                    font-size: 9px;
                    gap: 8px;
                    margin-bottom: 6px;
                }

                .blog-card-slider .blog-footer {
                    gap: 6px;
                    padding-top: 8px;
                    font-size: 10px;
                }

                .blog-card-slider .blog-date {
                    font-size: 10px;
                }

                .blog-card-slider .blog-link {
                    padding: 6px 12px;
                    font-size: 10px;
                }

                .blog-slider-button {
                    width: 34px;
                    height: 34px;
                    font-size: 12px;
                    top: 32%;
                }

                .blog-slider-button.prev {
                    left: 0;
                }

                .blog-slider-button.next {
                    right: 0;
                }

                .blog-slider-pagination {
                    margin-top: 18px;
                }

                .blog-slider-pagination .swiper-pagination-bullet {
                    width: 7px;
                    height: 7px;
                    margin: 0 2px;
                }
            }

            /* Extra Small Mobile (320-379px) */
            @media (max-width: 379px) {
                #blog-sec {
                    padding: 25px 8px;
                }

                #blog-sec::before,
                #blog-sec::after {
                    display: none;
                }

                .blog-sec-title {
                    margin-bottom: 25px;
                }

                .blog-sec-title .sec-title {
                    font-size: 1.4rem;
                    line-height: 1.2;
                    letter-spacing: -0.5px;
                }

                .blog-sec-title .sub-title {
                    font-size: 8px;
                    letter-spacing: 1px;
                    margin-bottom: 8px;
                }

                .blog-slider-wrap {
                    padding: 0 32px;
                    margin-top: -20px;
                }

                .blog-card-slider {
                    border-radius: 10px;
                }

                .blog-card-slider .blog-img {
                    height: 150px;
                }

                .blog-card-slider .blog-content {
                    padding: 12px 10px;
                }

                .blog-card-slider .blog-title {
                    font-size: 0.9rem;
                    margin-bottom: 6px;
                    line-height: 1.2;
                }

                .blog-card-slider .blog-meta {
                    font-size: 8px;
                    gap: 6px;
                    margin-bottom: 4px;
                    flex-wrap: wrap;
                }

                .blog-card-slider .blog-footer {
                    gap: 4px;
                    padding-top: 6px;
                }

                .blog-card-slider .blog-date {
                    font-size: 9px;
                }

                .blog-card-slider .blog-link {
                    padding: 5px 10px;
                    font-size: 9px;
                }

                .blog-slider-button {
                    width: 32px;
                    height: 32px;
                    font-size: 11px;
                    top: 30%;
                }

                .blog-slider-button.prev {
                    left: 0;
                }

                .blog-slider-button.next {
                    right: 0;
                }

                .blog-slider-pagination {
                    margin-top: 15px;
                }

                .blog-slider-pagination .swiper-pagination-bullet {
                    width: 6px;
                    height: 6px;
                    margin: 0 2px;
                }

                .blog-slider-pagination .swiper-pagination-bullet-active {
                    width: 20px;
                    border-radius: 4px;
                }
            }
        </style>

        <div class="container">
            <div class="blog-sec-title">
                <span class="sub-title">[ Blog & Interiors ]</span>
                <h2 class="sec-title">Explore Our Latest <span class="text-theme">Interior</span> Ideas & Stories</h2>
            </div>

            <div class="blog-slider-wrap" style="margin-top: -50px;">
                <div class="swiper blog-swiper">
                    <div class="swiper-wrapper">
                        <!-- Blog 1 -->
                        <div class="swiper-slide">
                            <div class="blog-card-slider">
                                <div class="blog-img">
                                    <img src="assets/img/blog/blog_6_3.jpg" alt="Modern Living Room Ideas">
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta">
                                        <a href="blog.html">By Alex John</a>
                                        <a href="blog.html">Interior Design</a>
                                    </div>
                                    <h3 class="blog-title">
                                        <a href="blog-details.html">Modern Living Room Ideas That Blend Comfort and
                                            Style</a>
                                    </h3>
                                    <div class="blog-footer">
                                        <span class="blog-date">Aug 25, 2025</span>
                                        <a href="blog-details.html" class="blog-link">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Blog 2 -->
                        <div class="swiper-slide">
                            <div class="blog-card-slider">
                                <div class="blog-img">
                                    <img src="assets/img/blog/blog-grid-6.jpg" alt="Smart Interior Design Solutions">
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta">
                                        <a href="blog.html">By Michel Bruis</a>
                                        <a href="blog.html">Home Interiors</a>
                                    </div>
                                    <h3 class="blog-title">
                                        <a href="blog-details.html">Smart Interior Design Solutions for Small Homes</a>
                                    </h3>
                                    <div class="blog-footer">
                                        <span class="blog-date">Aug 26, 2025</span>
                                        <a href="blog-details.html" class="blog-link">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Blog 3 -->

                        <div class="swiper-slide">
                            <div class="blog-card-slider">
                                <div class="blog-img">
                                    <img src="assets/img/blog/blog_6_3.jpg" alt="Sustainable Interior Design">
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta">
                                        <a href="blog.html">By Alex John</a>
                                        <a href="blog.html">Sustainable Living</a>
                                    </div>
                                    <h3 class="blog-title">
                                        <a href="blog-details.html">Sustainable Interior Design: Eco-Friendly Ideas for
                                            Your Home</a>
                                    </h3>
                                    <div class="blog-footer">
                                        <span class="blog-date">Aug 28, 2025</span>
                                        <a href="blog-details.html" class="blog-link">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Blog 4 -->
                        <div class="swiper-slide">
                            <div class="blog-card-slider">
                                <div class="blog-img">
                                    <img src="assets/img/blog/blog_9_3.jpg" alt="Art and Interior Design">
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta">
                                        <a href="blog.html">By Michel Bruis</a>
                                        <a href="blog.html">Interior Styling</a>
                                    </div>
                                    <h3 class="blog-title">
                                        <a href="blog-details.html">The Intersection of Art and Interior Design for
                                            Timeless Spaces</a>
                                    </h3>
                                    <div class="blog-footer">
                                        <span class="blog-date">Aug 27, 2025</span>
                                        <a href="blog-details.html" class="blog-link">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Navigation Buttons -->
                <button class="blog-slider-button prev" id="blog-slider-prev"><i
                        class="fa-solid fa-chevron-left"></i></button>
                <button class="blog-slider-button next" id="blog-slider-next"><i
                        class="fa-solid fa-chevron-right"></i></button>
            </div>

            <!-- Pagination -->
            <div class="blog-slider-pagination">
                <div class="swiper-pagination" id="blog-slider-pagination"></div>
            </div>
        </div>

        <script>
            // Initialize Blog Slider
            document.addEventListener('DOMContentLoaded', function () {
                const blogSlider = new Swiper('.blog-swiper', {
                    slidesPerView: 3,
                    spaceBetween: 24,
                    loop: true,
                    autoplay: {
                        delay: 6000,
                        disableOnInteraction: false
                    },
                    pagination: {
                        el: '#blog-slider-pagination',
                        clickable: true
                    },
                    navigation: {
                        nextEl: '#blog-slider-next',
                        prevEl: '#blog-slider-prev'
                    },
                    breakpoints: {
                        320: {
                            slidesPerView: 1,
                            spaceBetween: 12
                        },
                        380: {
                            slidesPerView: 1,
                            spaceBetween: 14
                        },
                        480: {
                            slidesPerView: 1,
                            spaceBetween: 16
                        },
                        600: {
                            slidesPerView: 1,
                            spaceBetween: 18
                        },
                        768: {
                            slidesPerView: 1,
                            spaceBetween: 20
                        },
                        992: {
                            slidesPerView: 2,
                            spaceBetween: 24
                        },
                        1024: {
                            slidesPerView: 2,
                            spaceBetween: 24
                        },
                        1200: {
                            slidesPerView: 3,
                            spaceBetween: 28
                        },
                        1400: {
                            slidesPerView: 3,
                            spaceBetween: 32
                        }
                    }
                });
            });
        </script>
    </section>
    <!--OUR BRANDS  -->
    <div class="overflow-hidden space-bottom">

        <style>
            /* ============================================================
   ULTRA-PREMIUM BRAND SLIDER DESIGN � UPGRADED VERSION
   ============================================================ */

            .space-bottom {
                padding: 20px;
                /* Removed bottom padding to eliminate space before footer */
                position: relative;
            }

            /* Responsive padding adjustments - only top padding */
            @media (max-width: 1200px) {
                .space-bottom {
                    padding: 80px 0 0 0;
                }
            }

            @media (max-width: 992px) {
                .space-bottom {
                    padding: 70px 0 0 0;
                }
            }

            @media (max-width: 768px) {
                .space-bottom {
                    padding: 60px 0 0 0;
                }
            }

            @media (max-width: 576px) {
                .space-bottom {
                    padding: 50px 0 0 0;
                }
            }

            /* Title styling */
            .space-bottom .sec-title {
                font-size: 42px;
                font-weight: 900;
                letter-spacing: -1px;
            }

            .space-bottom .text-theme {
                color: #9b0500;
            }

            /* ============================================================
   BRAND CARD (3D + GLASS + NEON GLOW)
   ============================================================ */

            .brand-card {
                background: rgba(255, 255, 255, 0.18);
                backdrop-filter: blur(14px);
                border-radius: 20px;
                padding: 32px;
                text-align: center;
                transition: 0.45s cubic-bezier(.25, .46, .45, .94);
                position: relative;
                overflow: hidden;
                border: 1px solid rgba(255, 255, 255, 0.25);

                /* 3D hover tilt */
                transform-style: preserve-3d;
            }

            /* Card lift + neon glow */
            .brand-card:hover {
                transform: translateY(-12px) rotateX(6deg) rotateY(-6deg);
                border-color: transparent;
                background: linear-gradient(#ffffff20, #ffffff20) padding-box,
                    linear-gradient(135deg, #009f6f, #4cf6a5) border-box;
                box-shadow: 0 22px 45px rgba(43, 185, 123, 0.35);
            }

            /* ============================================================
   Floating Glow Halo (Animation)
   ============================================================ */

            .brand-card::after {
                content: "";
                position: absolute;
                width: 180%;
                height: 180%;
                background: radial-gradient(circle, rgba(43, 185, 123, 0.25), transparent 70%);
                top: -40%;
                left: -40%;
                transform: scale(0.8);
                opacity: 0;
                transition: 0.4s ease-out;
            }

            .brand-card:hover::after {
                opacity: 1;
                transform: scale(1);
            }

            /* ============================================================
   LOGO STYLE
   ============================================================ */

            /* Base logo */
            .brand-card img.original {
                width: 120px;
                transition: 0.45s ease;
                transform: translateZ(20px);
                /* 3D effect */
            }

            /* Floating animation */
            .brand-card:hover img.original {
                transform: translateZ(40px) scale(1.14);
            }

            /* Grayscale version */
            .brand-card img.gray {
                width: 120px;
                position: absolute;
                inset: 0;
                margin: auto;
                opacity: 0.35;
                filter: grayscale(100%);
                transition: 0.4s ease;
            }

            /* Fade grayscale on hover */
            .brand-card:hover img.gray {
                opacity: 0;
            }

            /* ============================================================
   BRAND CARD AUTO FLOAT ANIMATION
   ============================================================ */

            @keyframes brandFloat {
                0% {
                    transform: translateY(0px);
                }

                50% {
                    transform: translateY(-8px);
                }

                100% {
                    transform: translateY(0px);
                }
            }

            .brand-card {
                animation: brandFloat 4s ease-in-out infinite;
            }

            /* Staggered delay per card */
            #brandSlider1 .swiper-slide:nth-child(1) .brand-card {
                animation-delay: .1s;
            }

            #brandSlider1 .swiper-slide:nth-child(2) .brand-card {
                animation-delay: .3s;
            }

            #brandSlider1 .swiper-slide:nth-child(3) .brand-card {
                animation-delay: .5s;
            }

            #brandSlider1 .swiper-slide:nth-child(4) .brand-card {
                animation-delay: .7s;
            }

            #brandSlider1 .swiper-slide:nth-child(5) .brand-card {
                animation-delay: .9s;
            }

            /* ============================================================
   RESPONSIVE DESIGN
   ============================================================ */

            @media (max-width: 992px) {
                .brand-card {
                    padding: 26px;
                }

                .brand-card img.original,
                .brand-card img.gray {
                    width: 100px;
                }
            }

            @media (max-width: 576px) {
                .space-bottom {
                    padding: 60px 0;
                }

                .brand-card {
                    padding: 20px;
                    border-radius: 16px;
                    transform: translateY(0) !important;
                    animation: none;
                    /* disable floating on small screens */
                }

                .brand-card img.original,
                .brand-card img.gray {
                    width: 88px;
                }
            }
        </style>



        <div class="container">
            <div class="title-area text-center"><span class="sub-title style2 text-anime">experience with 1,20000+
                    Visitors</span>
                <h2 class="sec-title split-text">[ Our Trusted <span class="text-theme">Brands ]</span></h2>
            </div>
            <div class="slider-area" style="margin-bottom: -140px;">
                <div class="swiper th-slider" id="brandSlider1"
                    data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- footer area -->
    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    
    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg>
    </div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>


    <!-- Scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        // Cart count update
        function updateCartCount() {
            fetch('auth-system/cart-api.php?action=get_count')
                .then(res => res.json())
                .then(data => {
                    document.getElementById('cart-count').textContent = data.count || 0;
                })
                .catch(() => {
                    document.getElementById('cart-count').textContent = 0;
                });
        }
        updateCartCount();
        
        // Update mobile welcome
        const userName = localStorage.getItem('userName');
        if (userName) {
            const welcomeEl = document.getElementById('mobile-welcome');
            if (welcomeEl) {
                welcomeEl.textContent = 'Welcome, ' + userName;
                welcomeEl.style.display = 'block';
            }
        }
    </script>
</body>
</html>
<?php include 'footer-section.html'; ?>