#!/bin/bash
# PHPMailer Installation Script

echo "=================================="
echo "Installing PHPMailer..."
echo "=================================="

cd /d C:\\xampp\\htdocs\\interior

# Check if composer is installed
if ! command -v composer &> /dev/null; then
    echo "Composer not found. Please install Composer first:"
    echo "https://getcomposer.org/download/"
    exit 1
fi

# Install PHPMailer
echo "Running: composer require phpmailer/phpmailer"
composer require phpmailer/phpmailer

echo ""
echo "✓ PHPMailer installed successfully!"
echo "✓ Check vendor/ folder for phpmailer/"
echo ""
echo "Next steps:"
echo "1. Create config/mail.php with Gmail SMTP settings"
echo "2. Follow GMAIL_SMTP_SETUP_GUIDE.md"
echo "3. Test with test-email-setup.php"
