<?php
// Universal navigation header for all pages
if (!isset($page_title)) {
    $page_title = 'Faren Interior Design';
}

$user_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : '';
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : '';
?>
<!DOCTYPE html>
<html class="no-js" lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $page_title; ?> - Faren Interior Design</title>
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
    <style>
        .navbar-brand { height: 50px; }
        .navbar-brand img { max-height: 100%; }
    </style>
</head>
<body id="show-grid">
    <!-- Top Header -->
    <div class="top-header" style="background: #000; color: #fff; padding: 12px 0; position: fixed; top: 0; left: 0; right: 0; z-index: 1029;">
        <div class="container-fluid">
            <div class="row justify-content-between align-items-center">
                <div class="col-auto">
                    <small style="display: flex; gap: 20px;">
                        <a href="tel:+1234567890" style="color: #fff; text-decoration: none;">📞 +1 (234) 567-890</a>
                        <a href="mailto:info@farendesign.com" style="color: #fff; text-decoration: none;">✉️ info@farendesign.com</a>
                    </small>
                </div>
                <div class="col-auto">
                    <small style="display: flex; gap: 15px;">
                        <?php if (!$user_name): ?>
                            <a href="auth-system/login.php" style="color: #fff; text-decoration: none;">Login</a>
                            <a href="auth-system/register.php" style="color: #fff; text-decoration: none;">Register</a>
                        <?php else: ?>
                            <span style="color: #d4a574;">Welcome, <?php echo $user_name; ?></span>
                            <a href="auth-system/logout.php" style="color: #fff; text-decoration: none;">Logout</a>
                        <?php endif; ?>
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light" style="margin-top: 40px;">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">
                <img src="assets/img/logo.svg" alt="Faren" style="height: 40px;">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="about.php">About</a></li>
                    <li class="nav-item"><a class="nav-link" href="service.php">Services</a></li>
                    <li class="nav-item"><a class="nav-link" href="project.php">Projects</a></li>
                    <li class="nav-item"><a class="nav-link" href="gallery.php">Gallery</a></li>
                    <li class="nav-item"><a class="nav-link" href="shop.php">Shop</a></li>
                    <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
                    <li class="nav-item">
                        <a class="nav-link" href="cart.php">
                            🛒 Cart <span id="cart-count-nav" class="badge bg-danger">0</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
</body>
</html>
