<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: auth-system/login.php');
    exit;
}

$host = 'localhost';
$db = 'zemaraim_interior';
$user = 'zemaraim';
$password = '8wwxk]-X3Kx]CJ]5';

$conn = new mysqli($host, $user, $password, $db);
$user_id = $_SESSION['user_id'];
$order_id = $_GET['order_id'] ?? 0;

// Get order details
$order_query = $conn->prepare("SELECT * FROM orders WHERE id = ? AND user_id = ?");
$order_query->bind_param("ii", $order_id, $user_id);
$order_query->execute();
$order_result = $order_query->get_result();
$order = $order_result->fetch_assoc();

if (!$order) {
    die("Order not found");
}

// Get order items
$items_query = $conn->prepare("SELECT * FROM order_items WHERE order_id = ?");
$items_query->bind_param("i", $order_id);
$items_query->execute();
$items_result = $items_query->get_result();

$page_title = 'Order Confirmation';
include 'header-section.html';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmation - Faren</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body { 
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 40px 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
        }
        
        .container-conf { 
            max-width: 900px; 
            margin: 265px auto 50px;
        }
        
        .confirmation-box { 
            background: white; 
            padding: 50px 30px;
            border-radius: 12px; 
            text-align: center; 
            box-shadow: 0 10px 40px rgba(0,0,0,0.15);
            margin-bottom: 30px;
            animation: slideDown 0.6s ease;
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .success-icon {
            font-size: 60px;
            margin-bottom: 20px;
            animation: bounce 0.6s ease;
        }
        
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        
        .confirmation-box h1 { 
            color: #27ae60; 
            font-size: 36px; 
            margin-bottom: 10px;
            font-weight: 700;
        }
        
        .confirmation-box p { 
            color: #666; 
            font-size: 16px; 
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .order-number { 
            background: linear-gradient(135deg, #d4a33a 0%, #c9933d 100%);
            color: white; 
            padding: 15px 30px;
            border-radius: 8px; 
            font-size: 18px; 
            font-weight: bold; 
            margin-bottom: 20px;
            display: inline-block;
            box-shadow: 0 4px 15px rgba(212, 163, 58, 0.3);
        }
        
        .order-details { 
            background: white; 
            padding: 35px; 
            border-radius: 12px; 
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }
        
        .order-details h2 { 
            color: #333;
            font-weight: 700;
            margin-bottom: 30px;
            border-bottom: 3px solid #d4a33a;
            padding-bottom: 15px;
        }
        
        .order-details h3 {
            color: #555;
            font-size: 16px;
            font-weight: 600;
            margin-top: 25px;
            margin-bottom: 15px;
        }
        
        .detail-row { 
            display: grid; 
            grid-template-columns: 1fr 1fr; 
            gap: 20px; 
            margin-bottom: 20px; 
        }
        
        .detail-item { 
            padding: 15px; 
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 8px;
            border-left: 4px solid #d4a33a;
        }
        
        .detail-label { 
            color: #999; 
            font-size: 11px; 
            text-transform: uppercase; 
            margin-bottom: 8px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .detail-value { 
            font-weight: 600; 
            color: #333; 
            font-size: 16px; 
        }
        
        .order-items { 
            background: white; 
            padding: 35px; 
            border-radius: 12px; 
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }
        
        .order-items h2 {
            color: #333;
            font-weight: 700;
            margin-bottom: 25px;
            border-bottom: 3px solid #d4a33a;
            padding-bottom: 15px;
        }
        
        .items-table { 
            width: 100%; 
            border-collapse: collapse; 
        }
        
        .items-table th { 
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 15px; 
            text-align: left; 
            border-bottom: 2px solid #d4a33a;
            font-weight: 700;
            color: #333;
        }
        
        .items-table td { 
            padding: 15px; 
            border-bottom: 1px solid #eee;
        }
        
        .items-table tbody tr:hover { 
            background: #f9f9f9;
        }
        
        .items-table td:last-child {
            text-align: right;
            font-weight: 600;
            color: #d4a33a;
        }
        
        .summary-table { 
            width: 100%; 
            margin-top: 25px;
            border-top: 2px solid #e9ecef;
            padding-top: 20px;
        }
        
        .summary-row { 
            display: flex; 
            justify-content: space-between; 
            padding: 12px 0;
            font-size: 15px;
        }
        
        .summary-row.total { 
            border-top: 2px solid #d4a33a;
            font-weight: 700; 
            font-size: 18px; 
            padding-top: 15px;
            color: #d4a33a;
        }
        
        .buttons { 
            display: flex; 
            gap: 15px; 
            margin-top: 40px;
            justify-content: center;
        }
        
        .btn { 
            padding: 14px 35px; 
            border-radius: 8px; 
            text-decoration: none; 
            font-weight: 600;
            border: none; 
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 15px;
        }
        
        .btn-primary { 
            background: linear-gradient(135deg, #333 0%, #555 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(51, 51, 51, 0.3);
        }
        
        .btn-primary:hover { 
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(51, 51, 51, 0.4);
        }
        
        .btn-secondary { 
            background: linear-gradient(135deg, #d4a33a 0%, #c9933d 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(212, 163, 58, 0.3);
        }
        
        .btn-secondary:hover { 
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(212, 163, 58, 0.4);
        }
        
        .status-badge { 
            display: inline-block; 
            padding: 8px 18px; 
            border-radius: 20px; 
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .status-pending { 
            background: #fff3cd; 
            color: #856404;
        }
        
        .status-processing { 
            background: #d1ecf1; 
            color: #0c5460;
        }
        
        .status-completed { 
            background: #d4edda; 
            color: #155724;
        }
        
        @media (max-width: 768px) {
            .container-conf {
                margin-top: 30px;
            }
            
            .confirmation-box { 
                padding: 30px 20px;
            }
            
            .confirmation-box h1 {
                font-size: 28px;
            }
            
            .success-icon {
                font-size: 50px;
            }
            
            .detail-row { 
                grid-template-columns: 1fr; 
            }
            
            .buttons { 
                flex-direction: column; 
            }
            
            .btn {
                width: 100%;
                text-align: center;
            }
            
            .order-details,
            .order-items {
                padding: 20px;
            }
            
            .items-table th,
            .items-table td {
                padding: 10px 8px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container-conf">
        <div class="confirmation-box">
            <div class="success-icon">✅</div>
            <h1>Thank You for Your Order!</h1>
            <p>Your order has been successfully placed. We'll process it soon and send you tracking information via email.</p>
            <div class="order-number">Order #<?php echo htmlspecialchars($order['id']); ?></div>
        </div>

        <div class="order-details">
            <h2>📋 Order Information</h2>
            
            <h3>👤 Billing Address</h3>
            <div class="detail-row">
                <div class="detail-item">
                    <div class="detail-label">Full Name</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['first_name'] . ' ' . $order['last_name']); ?></div>
                </div>
                <div class="detail-item">
                    <div class="detail-label">Email Address</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['email']); ?></div>
                </div>
            </div>
            <div class="detail-row">
                <div class="detail-item">
                    <div class="detail-label">Phone Number</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['phone']); ?></div>
                </div>
                <div class="detail-item">
                    <div class="detail-label">City</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['billing_city']); ?></div>
                </div>
            </div>
            <div class="detail-row">
                <div class="detail-item">
                    <div class="detail-label">Complete Address</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['billing_address']); ?></div>
                </div>
                <div class="detail-item">
                    <div class="detail-label">Postal Code</div>
                    <div class="detail-value"><?php echo htmlspecialchars($order['billing_postal'] ?? 'N/A'); ?></div>
                </div>
            </div>
            
            <h3>💳 Payment Details</h3>
            <div class="detail-row">
                <div class="detail-item">
                    <div class="detail-label">Payment Method</div>
                    <div class="detail-value"><?php echo ucfirst(str_replace('_', ' ', htmlspecialchars($order['payment_method']))); ?></div>
                </div>
                <div class="detail-item">
                    <div class="detail-label">Order Status</div>
                    <div class="detail-value">
                        <span class="status-badge status-<?php echo htmlspecialchars($order['status']); ?>"><?php echo ucfirst(htmlspecialchars($order['status'])); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="order-items">
            <h2>📦 Order Items</h2>
            <table class="items-table">
                <thead>
                    <tr>
                        <th>Product Name</th>
                        <th>Price</th>
                        <th>Quantity</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($item = $items_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                            <td>Rs. <?php echo number_format($item['price'], 0); ?></td>
                            <td style="text-align: center;"><?php echo $item['quantity']; ?></td>
                            <td>Rs. <?php echo number_format($item['total'], 0); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <div class="summary-table">
                <div class="summary-row">
                    <span>Subtotal:</span>
                    <span>Rs. <?php echo number_format($order['subtotal'], 0); ?></span>
                </div>
                <div class="summary-row">
                    <span>Tax (10%):</span>
                    <span>Rs. <?php echo number_format($order['tax'], 0); ?></span>
                </div>
                <div class="summary-row">
                    <span>Shipping Charges:</span>
                    <span>Rs. <?php echo number_format($order['shipping'], 0); ?></span>
                </div>
                <div class="summary-row total">
                    <span>💰 Total Amount:</span>
                    <span>Rs. <?php echo number_format($order['total'], 0); ?></span>
                </div>
            </div>
        </div>

        <div class="buttons">
            <a href="shop.php" class="btn btn-primary">🛍️ Continue Shopping</a>
            <a href="orders.php" class="btn btn-secondary">📄 View My Orders</a>
        </div>
    </div>

    <?php include 'footer-section.html'; ?>
</body>
</html>
