<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: auth-system/login.php');
    exit;
}

$host = 'localhost';
$db = 'zemaraim_interior';
$user = 'zemaraim';
$password = '8wwxk]-X3Kx]CJ]5';

$conn = new mysqli($host, $user, $password, $db);
$user_id = $_SESSION['user_id'];

// Get all orders for this user
$orders_query = $conn->prepare("
    SELECT id, total, status, created_at FROM orders 
    WHERE user_id = ? 
    ORDER BY created_at DESC
");
$orders_query->bind_param("i", $user_id);
$orders_query->execute();
$orders_result = $orders_query->get_result();
include 'header-section.html';
?>

<!DOCTYPE html>
<html>

<head>
    <title>My Orders</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #f5f5f5;
            padding: 20px;
            font-family: Arial, sans-serif;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .header {
            background: #333;
            color: white;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 30px;
            text-align: center;
            margin-top: 259px;
        }

        .header h1 {
            margin: 0;
            font-size: 28px;
        }

        .orders-table {
            width: 100%;
            background: white;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .orders-table th {
            background: #333;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: bold;
        }

        .orders-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }

        .orders-table tr:hover {
            background: #f9f9f9;
        }

        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .status-pending {
            background: #fff3cd;
            color: #856404;
        }

        .status-processing {
            background: #cfe2ff;
            color: #084298;
        }

        .status-shipped {
            background: #d1e7dd;
            color: #0f5132;
        }

        .status-delivered {
            background: #d4edda;
            color: #155724;
        }

        .status-cancelled {
            background: #f8d7da;
            color: #842029;
        }

        .btn {
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 12px;
            font-weight: bold;
        }

        .btn-view {
            background: #d4a574;
            color: white;
        }

        .btn-view:hover {
            background: #b8905a;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
        }

        .empty-state h2 {
            color: #666;
            margin-bottom: 15px;
        }

        .empty-state p {
            color: #999;
            margin-bottom: 20px;
        }

        .btn-shop {
            background: #333;
            color: white;
            padding: 12px 30px;
            border-radius: 5px;
            text-decoration: none;
        }

        .btn-shop:hover {
            background: #555;
        }

        /* Mobile Responsive - Remove top blank space */
        @media (max-width: 768px) {
            .header {
                margin-top: 100px;
                padding: 15px;
                margin-bottom: 20px;
            }

            .header h1 {
                font-size: 22px;
            }

            .header p {
                font-size: 14px;
                margin: 10px 0 0 0;
            }

            .orders-table th,
            .orders-table td {
                padding: 12px 8px;
                font-size: 14px;
            }

            .btn {
                padding: 6px 12px;
                font-size: 11px;
            }
        }

        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .container {
                max-width: 100%;
            }

            .header {
                margin-top: 0;
                padding: 15px 10px;
                margin-bottom: 15px;
                border-radius: 4px;
            }

            .header h1 {
                font-size: 18px;
            }

            .header p {
                font-size: 12px;
                margin: 8px 0 0 0;
            }

            .orders-table {
                border-radius: 4px;
                font-size: 12px;
            }

            .orders-table th {
                padding: 10px 6px;
                font-size: 12px;
            }

            .orders-table td {
                padding: 10px 6px;
                font-size: 11px;
            }

            .status-badge {
                padding: 4px 8px;
                font-size: 10px;
            }

            .btn {
                padding: 5px 10px;
                font-size: 10px;
            }

            .empty-state {
                padding: 40px 10px;
            }

            .empty-state h2 {
                font-size: 18px;
            }

            .empty-state p {
                font-size: 13px;
            }

            .btn-shop {
                padding: 10px 20px;
                font-size: 13px;
            }

            div[style*="text-align: center; margin-top: 30px"] {
                margin-top: 15px !important;
                margin-bottom: 15px !important;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1>📦 My Orders</h1>
            <p>View and track your orders</p>
        </div>

        <?php if ($orders_result->num_rows === 0): ?>
            <div class="empty-state">
                <h2>No Orders Yet</h2>
                <p>You haven't placed any orders yet. Start shopping now!</p>
                <a href="shop.php" class="btn-shop">Shop Now</a>
            </div>
        <?php else: ?>
            <table class="orders-table">
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>Date</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($order = $orders_result->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo htmlspecialchars($order['id']); ?></td>
                            <td><?php echo date('M d, Y', strtotime($order['created_at'])); ?></td>
                            <td><strong>Rs. <?php echo number_format($order['total'], 0); ?></strong></td>
                            <td>
                                <span class="status-badge status-<?php echo htmlspecialchars($order['status']); ?>">
                                    <?php echo ucfirst(htmlspecialchars($order['status'])); ?>
                                </span>
                            </td>
                            <td>
                                <a href="order-confirmation.php?order_id=<?php echo $order['id']; ?>" class="btn btn-view">View
                                    Details</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php endif; ?>

        <div style="text-align: center; margin-top: 30px; margin-bottom: 30px;">
            <a href="shop.php" class="btn btn-view">Back to Shop</a>
            <a href="cart.php" class="btn btn-view">View Cart</a>
        </div>
    </div>
</body>

</html>

<?php include 'footer-section.html'; ?>