<?php
session_start();
require_once __DIR__ . '/config/db.php';

$page_title = 'Projects - Faren Interior Design';
$user_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- header -->
     <?php include 'header-section.html'; ?>
    
    <!--  -->
    <section class="position-relative space-top overflow-hidden" id="project-sec" style="padding-top: 315px;">
        <!--  -->
        <style>
/* =========================================================
   PROJECT SECTION � LUXURY ARCHITECTURE DESIGN STYLE
========================================================= */

#project-sec {
    position: relative;
    padding-bottom: 80px;
}

/* Number + Line Style */
#project-sec .number {
    font-size: 48px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    color: #000;
    opacity: 0.85;
    position: relative;
    padding-top: 30px;
}

#project-sec .number .line {
    width: 60px;
    height: 2px;
    background: var(--theme-color, #fcb900);
    display: inline-block;
}

/* Title Style */
#project-sec .sec-title {
    font-size: 40px;
    margin: 20px 0 14px;
    line-height: 1.2;
}

/* Description */
#project-sec .sec-text3 {
    font-size: 17px;
    opacity: 0.85;
    margin-bottom: 20px;
}

/* =========================================================
   IMAGE BOX DESIGN � PREMIUM LOOK (2 images overlapping)
========================================================= */

.img-box6 {
    position: relative;
    display: flex;
    gap: 20px;
    align-items: center;
}

.img-box6 .img1,
.img-box6 .img2 {
    flex: 1;
    border-radius: 16px;
    overflow: hidden;
    position: relative;
    transform: translateY(0);
    transition: .5s ease;
}

/* Smooth Zoom Hover */
.img-box6 img {
    width: 100%;
    height: 360px;
    object-fit: cover;
    transition: .6s ease;
    border-radius: 16px;
}

.img-box6:hover img {
    transform: scale(1.05);
}

/* Floating Hover Effect */
.img-box6:hover .img1 {
    transform: translateY(-10px);
}
.img-box6:hover .img2 {
    transform: translateY(10px);
}

/* Shadow */
.img-box6 .img1,
.img-box6 .img2 {
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
}

/* =========================================================
   BUTTON STYLE
========================================================= */

#project-sec .th-btn {
    padding: 12px 28px;
    border-radius: 40px;
    border: 2px solid #000;
    transition: .3s ease;
}

#project-sec .th-btn:hover {
    background: #000;
    color: #fff;
}

/* =========================================================
   RESPONSIVENESS
========================================================= */

/* Laptop */
@media (max-width: 1200px) {
    .img-box6 img {
        height: 300px;
    }
    #project-sec .sec-title {
        font-size: 34px;
    }
}

/* Tablet */
@media (max-width: 992px) {
    .img-box6 {
        flex-direction: column;
    }
    .img-box6 img {
        height: 280px;
    }
    #project-sec .number {
        font-size: 38px;
    }
}

/* Mobile */
@media (max-width: 768px) {
    #project-sec .sec-title {
        font-size: 28px;
    }
    #project-sec .number {
        font-size: 32px;
    }
    .img-box6 img {
        height: 240px;
    }
}

/* Small Mobile */
@media (max-width: 480px) {
    #project-sec .sec-title {
        font-size: 24px;
    }
    .img-box6 img {
        height: 200px;
    }
}

/* =========================================================
   MOBILE TOP BLANK SPACE REMOVAL (≤599px)
   ========================================================= */

@media (max-width: 599px) and (min-width: 480px) {
    #project-sec[style*="padding-top: 315px"] {
        padding-top: 80px !important;
    }
}

@media (max-width: 479px) and (min-width: 380px) {
    #project-sec[style*="padding-top: 315px"] {
        padding-top: 0px !important;
    }
}

@media (max-width: 379px) {
    #project-sec[style*="padding-top: 315px"] {
        padding-top: 60px !important;
    }
}

/* =========================================================
   MOBILE IMAGE GRID LAYOUT (≤768px)
   ========================================================= */

@media (max-width: 768px) {
    .img-box6 {
        display: grid !important;
        grid-template-columns: repeat(2, 1fr) !important;
        gap: 15px !important;
        flex: none !important;
    }

    .img-box6 .img1,
    .img-box6 .img2 {
        flex: none !important;
        width: 100%;
    }

    .img-box6 img {
        width: 100%;
        height: 180px;
        border-radius: 12px;
    }
}

/* =========================================================
   ULTRA-SMALL MOBILE IMAGE GRID (≤480px)
   ========================================================= */

@media (max-width: 480px) {
    .img-box6 {
        grid-template-columns: 1fr !important;
    }

    .img-box6 img {
        height: 160px;
    }
}

</style>

        <div class="container">
            <div class="row gy-4 space-bottom">
                <div class="col-lg-5">
                    <div class="title-area mb-0"><span class="number wow fadeInLeft" data-wow-delay=".2s">01 <span
                                class="line"></span>04</span>
                        <h2 class="sec-title split-text">Excellence Kitchen Interior Design</h2>
                        <p class="sec-text3 wow fadeInUp" data-wow-delay=".3s">Faren architects is�a�team of�young
                            talented experts whose professional activity is�entirely dedicated to�creating unique
                            architectural and design solutions.</p>
                        <div class="wow fadeInUp" data-wow-delay=".4s"><a href="project-details.html"
                                class="th-btn black-border th-icon">View Projects</a></div>
                    </div>
                    <!-- <div class="shape-mockup spin d-none d-xxl-block" data-bottom="8%" data-right="12%"><img
                            src="assets/img/shape/element-5.png" alt=""></div> -->
                </div>
                <div class="col-lg-7">
                    <div class="img-box6">
                        <div class="img1 global-img"><img src="assets/img/project/project_img_1.jpg" alt=""></div>
                        <div class="img2 global-img"><img src="assets/img/project/project_img_2.jpg" alt=""></div>
                    </div>
                </div>
            </div>
            <div class="row gy-4 space-bottom flex-row-reverse justify-content-between" style="padding-top: 20px;">
                <div class="col-lg-5">
                    <div class="title-area mb-0 ps-xl-5 ms-xl-5"><span class="number wow fadeInLeft"
                            data-wow-delay=".2s">02 <span class="line"></span>04</span>
                        <h2 class="sec-title split-text">Top-notch Living Room Interior</h2>
                        <p class="sec-text3 wow fadeInUp" data-wow-delay=".3s">Faren architects is�a�team of�young
                            talented experts whose professional activity is�entirely dedicated to�creating unique
                            architectural and design solutions.</p>
                        <div class="wow fadeInUp" data-wow-delay=".4s"><a href="project-details.html"
                                class="th-btn black-border th-icon">View Projects</a></div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="img-box6">
                        <div class="img1 global-img"><img src="assets/img/project/project_img_3.jpg" alt=""></div>
                        <div class="img2 global-img"><img src="assets/img/project/project_img_4.jpg" alt=""></div>
                    </div>
                </div>
            </div>
            <div class="row gy-4 space-bottom justify-content-between" style="padding-top: 20px;">
                <div class="col-lg-5">
                    <div class="title-area mb-0"><span class="number wow fadeInLeft" data-wow-delay=".2s">03 <span
                                class="line"></span>04</span>
                        <h2 class="sec-title split-text">Excellence Dining Space Interior Design</h2>
                        <p class="sec-text3 wow fadeInUp" data-wow-delay=".3s">Faren architects is�a�team of�young
                            talented experts whose professional activity is�entirely dedicated to�creating unique
                            architectural and design solutions.</p>
                        <div class="wow fadeInUp" data-wow-delay=".4s"><a href="project-details.html"
                                class="th-btn black-border th-icon">View Projects</a></div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="img-box6">
                        <div class="img1 global-img"><img src="assets/img/project/project_img_5.jpg" alt=""></div>
                        <div class="img2 global-img"><img src="assets/img/project/project_img_6.jpg" alt=""></div>
                    </div>
                </div>
            </div>
            <div class="row gy-4 flex-row-reverse justify-content-between" style="padding-top: 20px;">
                <div class="col-lg-5">
                    <div class="title-area mb-0 ps-xl-5 ms-xl-4"><span class="number wow fadeInLeft"
                            data-wow-delay=".2s">04 <span class="line"></span>04</span>
                        <h2 class="sec-title split-text">Architecture Design Nordic Space</h2>
                        <p class="sec-text3 wow fadeInUp" data-wow-delay=".3s">Faren architects is�a�team of�young
                            talented experts whose professional activity is�entirely dedicated to�creating unique
                            architectural and design solutions.</p>
                        <div class="wow fadeInUp" data-wow-delay=".4s"><a href="project-details.html"
                                class="th-btn black-border th-icon">View Projects</a></div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="img-box6">
                        <div class="img1 global-img"><img src="assets/img/project/project_img_7.jpg" alt=""></div>
                        <div class="img2 global-img"><img src="assets/img/project/project_img_8.jpg" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
  
    

    <!-- PROJECTS GRID SECTION (Managed from Admin Dashboard) -->
    <section id="project-grid-sec" style="padding: 80px 15px;">
        <style>
            #project-grid-sec {
                position: relative;
                background: #f9f9f9;
            }

            #project-grid-sec .container {
                max-width: 1200px;
            }

            #project-grid-sec .title-area {
                text-align: center;
                margin-bottom: 60px;
            }

            #project-grid-sec .sub-title {
                display: inline-block;
                font-size: 14px;
                font-weight: 600;
                color: #fcb900;
                margin-bottom: 10px;
            }

            #project-grid-sec .sec-title {
                font-size: 42px;
                font-weight: 700;
                margin-bottom: 15px;
            }

            #project-grid-sec .projects-grid {
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
                gap: 30px;
                margin-top: 50px;
            }

            #project-grid-sec .project-card {
                background: white;
                border-radius: 16px;
                overflow: hidden;
                box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
                transition: all 0.4s ease;
                position: relative;
            }

            #project-grid-sec .project-card:hover {
                transform: translateY(-8px);
                box-shadow: 0 16px 35px rgba(0, 0, 0, 0.15);
            }

            #project-grid-sec .project-card .card-image {
                position: relative;
                overflow: hidden;
                height: 280px;
            }

            #project-grid-sec .project-card .card-image img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.5s ease;
            }

            #project-grid-sec .project-card:hover .card-image img {
                transform: scale(1.08);
            }

            #project-grid-sec .project-card .project-card-footer {
                padding: 24px;
                background: white;
            }

            #project-grid-sec .project-card .category {
                display: inline-block;
                font-size: 12px;
                font-weight: 600;
                color: #fcb900;
                background: #fff3e0;
                padding: 6px 14px;
                border-radius: 20px;
                margin-bottom: 12px;
            }

            #project-grid-sec .project-card .title {
                font-size: 20px;
                font-weight: 700;
                margin: 0;
                line-height: 1.3;
            }

            #project-grid-sec .project-content {
                position: absolute;
                inset: 0;
                background: rgba(0, 0, 0, 0.85);
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                gap: 20px;
                opacity: 0;
                transition: opacity 0.4s ease;
            }

            #project-grid-sec .project-card:hover .project-content {
                opacity: 1;
            }

            #project-grid-sec .project-content .category {
                font-size: 12px;
                font-weight: 600;
                color: #fcb900;
                background: rgba(252, 185, 0, 0.15);
                padding: 8px 16px;
                border-radius: 20px;
                border: 1px solid #fcb900;
            }

            #project-grid-sec .project-content .project-title {
                color: white;
                font-size: 22px;
                font-weight: 700;
                text-align: center;
                margin: 0;
            }

            #project-grid-sec .project-content .project-title a {
                color: white;
                text-decoration: none;
            }

            #project-grid-sec .project-actions {
                display: flex;
                gap: 16px;
                align-items: center;
            }

            #project-grid-sec .project-popup-btn {
                width: 50px;
                height: 50px;
                border-radius: 50%;
                background: #fcb900;
                border: none;
                color: white;
                font-size: 18px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                transition: all 0.3s ease;
            }

            #project-grid-sec .project-popup-btn:hover {
                background: white;
                color: #fcb900;
                transform: scale(1.1);
            }

            #project-grid-sec .project-learn-btn {
                padding: 12px 28px;
                background: white;
                color: black;
                text-decoration: none;
                border-radius: 40px;
                font-weight: 600;
                transition: all 0.3s ease;
                border: 2px solid white;
            }

            #project-grid-sec .project-learn-btn:hover {
                background: transparent;
                color: white;
                border-color: white;
            }

            @media (max-width: 768px) {
                #project-grid-sec .sec-title {
                    font-size: 32px;
                }

                #project-grid-sec .projects-grid {
                    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
                    gap: 20px;
                }

                #project-grid-sec .project-card .card-image {
                    height: 240px;
                }
            }

            @media (max-width: 480px) {
                #project-grid-sec {
                    padding: 60px 12px;
                }

                #project-grid-sec .projects-grid {
                    grid-template-columns: 1fr;
                    gap: 15px;
                }

                #project-grid-sec .sec-title {
                    font-size: 24px;
                }
            }
        </style>
        <div class="container">
            <div class="title-area">
                <span class="sub-title">[ Our Work ]</span>
                <h2 class="sec-title">Projects</h2>
            </div>

            <div class="projects-grid">
                <!-- Project 1 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_1.jpg" alt="Modern Office Space">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Interior</span>
                        <h3 class="title">Modern Office Space</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Interior</span>
                        <h3 class="project-title"><a href="project-details.html">Modern Office Space</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_1.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 2 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_2.jpg" alt="Luxury Residential">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Residential</span>
                        <h3 class="title">Luxury Residential</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Residential</span>
                        <h3 class="project-title"><a href="project-details.html">Luxury Residential</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_2.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>

                <!-- Project 3 -->
                <div class="project-card">
                    <div class="card-image">
                        <img src="assets/img/project/project_1_3.jpg" alt="Retail Design">
                    </div>
                    <div class="project-card-footer">
                        <span class="category">Retail</span>
                        <h3 class="title">Retail Design</h3>
                    </div>
                    <div class="project-content">
                        <span class="category">Retail</span>
                        <h3 class="project-title"><a href="project-details.html">Retail Design</a></h3>
                        <div class="project-actions">
                            <button class="project-popup-btn" onclick="openPopup('assets/img/project/project_1_3.jpg')">
                                <i class="far fa-plus"></i>
                            </button>
                            <a href="project-details.html" class="project-learn-btn">Learn More</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- Testimonial -->
    <section class="overflow-hidden space overflow-hidden" id="testi-sec">
        <style>
/* ============================================================
   TESTIMONIAL SECTION � PREMIUM ARCHITECTURE DESIGN STYLE
============================================================ */

/* SECTION SPACING */
#testi-sec {
    position: relative;
}

/* TITLE AREA */
#testi-sec .sec-title {
    font-weight: 800;
    line-height: 1.2;
}

/* ============================================================
   LEFT SIDE IMAGE STACK - UNIQUE LAYOUT
============================================================ */

.testi-image_wrapp {
    display: flex;
    flex-direction: column;
    gap: 22px;
    position: relative;
}

/* MAIN REVIEW BOX */
.testi-review {
    display: flex;
    align-items: center;
    gap: 18px;
    padding: 20px;
    border-radius: 20px;
    background: #ffffff;
    box-shadow: 0 12px 28px rgba(0,0,0,0.10);
    transition: 0.4s ease;
}

.testi-review:hover {
    transform: translateY(-6px);
    box-shadow: 0 20px 45px rgba(0,0,0,0.18);
}

/* IMAGES */
.testi-img1,
.testi-img2 {
    overflow: hidden;
    border-radius: 20px;
    position: relative;
}

.testi-img1 img,
.testi-img2 img {
    width: 100%;
    height: 260px;
    object-fit: cover;
    transition: .45s ease;
}

/* HOVER ZOOM EFFECT */
.testi-img1:hover img,
.testi-img2:hover img {
    transform: scale(1.12);
    filter: brightness(88%);
}

/* RAISE SHADOW ON HOVER */
.testi-img2:hover {
    transform: translateY(-6px);
    box-shadow: 0 18px 35px rgba(0,0,0,0.15);
}

/* ============================================================
   TESTIMONIAL CARD � GLASS PREMIUM STYLE
============================================================ */

.testi-card {
    background: rgba(255,255,255,0.85);
    backdrop-filter: blur(14px);
    padding: 35px;
    border-radius: 26px;
    border: 1px solid rgba(255,255,255,0.35);
    box-shadow: 0 18px 40px rgba(0,0,0,0.1);
    transition: .4s ease;
}

.testi-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 26px 55px rgba(0,0,0,0.15);
}

/* RATING */
.testi-card .box-rating .rating {
    font-weight: 700;
    font-size: 18px;
}

.testi-card .review i {
    color: #fcb900;
}

/* TEXT */
.testi-card .box-text {
    font-size: 17px;
    line-height: 1.6;
    margin-bottom: 18px;
}

/* AUTHOR */
.box-profile {
    display: flex;
    align-items: center;
    gap: 15px;
}

.box-author img {
    width: 65px;
    height: 65px;
    border-radius: 50%;
    object-fit: cover;
}

/* ============================================================
   SLIDER ARROWS � PREMIUM HOVER EFFECT
============================================================ */

.slider-arrow {
    width: 58px;
    height: 58px;
    border-radius: 50%;
    background: #ffffff;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    box-shadow: 0 8px 15px rgba(0,0,0,0.12);
    transition: 0.3s ease;
}

.slider-arrow:hover {
    background: #000;
    transform: translateY(-3px);
}

.slider-arrow:hover img {
    filter: invert(1);
}

/* ============================================================
   RESPONSIVE DESIGN
============================================================ */

/* Tablet */
@media (max-width: 992px) {
    .testi-img1 img,
    .testi-img2 img {
        height: 220px;
    }
    .testi-card {
        padding: 28px;
    }
}

/* Mobile */
@media (max-width: 768px) {
    .testi-image_wrapp {
        align-items: center;
    }
    .testi-img1 img,
    .testi-img2 img {
        height: 200px;
    }
    .testi-review {
        flex-direction: column;
        text-align: center;
    }
}

/* Small Mobile */
@media (max-width: 480px) {
    .testi-card {
        padding: 22px;
    }
    .box-text {
        font-size: 15px;
    }
}
</style>
        <div class="container">
            <div class="row gy-24 justify-content-center">
                <div class="col-xl-6">
                    <div class="title-area text-center"><span class="sub-title text-anime">TESTIMONIALS</span>
                        <h2 class="sec-title split-text">What Our <span class="text-theme">Client�s </span>Say</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-24 align-items-center">
                <div class="col-xl-5">
                    <div class="testi-image_wrapp">
                        <div class="testi-review">
                            <div class="testi-img1 global-img"><img src="assets/img/testimonial/testi-img1.jpg" alt="">
                            </div>
                            <div class="box-content">
                                <h3 class="box-title">Excellence Residence</h3>
                                <p class="box-text">Interior Decoration</p>
                            </div>
                        </div>
                        <div class="testi-img2 global-img"><img src="assets/img/testimonial/testi-img2.jpg" alt="">
                        </div>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="slider-wrap">
                        <div class="swiper th-slider testiSlide1 has-shadow" id="testiSlide1"
                            data-slider-options='{"effect":"slide","loop":true}'>
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="testi-card style1">
                                        <div class="box-wrapp">
                                            <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                            <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                    class="review"><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i></span></div>
                                        </div>
                                        <p class="box-text">"It was clear from the start that sustainability wasn�t an
                                            afterthought � it was central to every design decision. The passive cooling
                                            and natural materials make our building both eco-friendly and elegant."</p>
                                        <div class="box-profile">
                                            <div class="box-author"><img src="assets/img/testimonial/testi_1_1.png"
                                                    alt="Avater"></div>
                                            <div class="box-info">
                                                <h3 class="box-title">Carlos Mendez</h3><span class="box-desig">Company
                                                    Owner</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="testi-card style1">
                                        <div class="box-wrapp">
                                            <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                            <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                    class="review"><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i></span></div>
                                        </div>
                                        <p class="box-text">Working with Faren transformed our dream into reality. The
                                            design of our home perfectly balances privacy, natural light, and open
                                            space. It�s not just a house � it feels like a sanctuary.</p>
                                        <div class="box-profile">
                                            <div class="box-author"><img src="assets/img/testimonial/testi_1_2.png"
                                                    alt="Avater"></div>
                                            <div class="box-info">
                                                <h3 class="box-title">James Thompson</h3><span class="box-desig">Company
                                                    Owner</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="testi-card style1">
                                        <div class="box-wrapp">
                                            <div class="box-quote"><img src="assets/img/icon/quote2.svg" alt=""></div>
                                            <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                    class="review"><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i><i
                                                        class="fa-solid fa-star"></i></span></div>
                                        </div>
                                        <p class="box-text">We were amazed by the attention to detail and the
                                            understanding of how a home should �feel.� The layout is functional and
                                            beautiful � we love every inch of our new space.</p>
                                        <div class="box-profile">
                                            <div class="box-author"><img src="assets/img/testimonial/testi_1_3.png"
                                                    alt="Avater"></div>
                                            <div class="box-info">
                                                <h3 class="box-title">Aditi Banerjee</h3><span class="box-desig">Company
                                                    Owner</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="icon-box"><button data-slider-prev="#testiSlide1"
                                    class="slider-arrow style4 default slider-prev"><img
                                        src="assets/img/icon/right-arrow4.svg" alt=""></button> <button
                                    data-slider-next="#testiSlide1" class="slider-arrow style4 default slider-next"><img
                                        src="assets/img/icon/left-arrow4.svg" alt=""></button></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-left="0%"><img
                src="assets/img/shape/element-4.png" alt=""></div>
    </section>
    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    <style>
/* ================================================
   MODERN AESTHETIC FOOTER - INTERIOR DESIGN
   ================================================ */

.footer-wrapper.footer-layout1.footer-layout6 {
    background: linear-gradient(135deg, #0a0e27 0%, #1a1f3a 50%, #0f1428 100%);
    padding-top: 80px;
    padding-bottom: 0;
    position: relative;
    overflow: hidden;
}

/* Decorative background elements */
.footer-wrapper::before {
    content: "";
    position: absolute;
    top: -50%;
    right: -10%;
    width: 400px;
    height: 400px;
    background: radial-gradient(circle, rgba(255,180,0,0.08) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

.footer-wrapper::after {
    content: "";
    position: absolute;
    bottom: -20%;
    left: -5%;
    width: 350px;
    height: 350px;
    background: radial-gradient(circle, rgba(62,102,243,0.08) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

.widget-area {
    position: relative;
    z-index: 2;
}

/* ---- SECTION SPACING ---- */
.widget-area > .container:first-child {
    margin-bottom: 60px;
}

/* ---- FOOTER WIDGETS ---- */
.footer-widget {
    padding: 0;
}

.widget_title,
.newsletter-title {
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    margin-bottom: 20px;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    position: relative;
    padding-bottom: 12px;
}

.widget_title::after,
.newsletter-title::after {
    content: "";
    position: absolute;
    bottom: 0;
    left: 0;
    width: 40px;
    height: 3px;
    background: linear-gradient(90deg, #ffb400, #ff8c00);
    border-radius: 2px;
}

/* Newsletter Widget */
.newsletter-widget {
    border-radius: 16px;
    padding: 32px;
    background: rgba(255, 255, 255, 0.04);
    border: 1px solid rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    transition: all 0.4s ease;
}

.newsletter-widget:hover {
    border-color: rgba(255, 180, 0, 0.3);
    background: rgba(255, 255, 255, 0.07);
    transform: translateY(-4px);
}

.newsletter-text {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
    line-height: 1.7;
    margin-bottom: 20px;
}

.newsletter-form {
    display: flex;
    gap: 0;
    margin-bottom: 18px;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 10px;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.3s ease;
}

.newsletter-form:focus-within {
    border-color: rgba(255, 180, 0, 0.4);
    background: rgba(255, 255, 255, 0.12);
}

.newsletter-form input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    padding: 14px 18px;
    font-size: 14px;
}

.newsletter-form input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.newsletter-form input:focus {
    outline: none;
}

.newsletter-form button {
    background: linear-gradient(135deg, #ffb400, #ff8c00);
    border: none;
    color: #000;
    padding: 14px 28px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.newsletter-form button:hover {
    background: linear-gradient(135deg, #ff8c00, #ffb400);
    transform: scale(1.02);
}

.newsletter-widget .form-group {
    display: flex;
    align-items: center;
    gap: 10px;
}

.newsletter-widget input[type="checkbox"] {
    accent-color: #ffb400;
    cursor: pointer;
}

.newsletter-widget label {
    color: rgba(255, 255, 255, 0.7);
    font-size: 13px;
    cursor: pointer;
    margin: 0;
}

/* ---- MENU LINKS ---- */
.menu-all-pages-container ul.menu {
    list-style: none;
    padding: 0;
}

.menu-all-pages-container ul.menu li {
    margin-bottom: 14px;
}

.menu-all-pages-container ul.menu li a {
    color: rgba(255, 255, 255, 0.7);
    font-size: 15px;
    text-decoration: none;
    position: relative;
    transition: all 0.3s ease;
    display: inline-block;
}

.menu-all-pages-container ul.menu li a::before {
    content: "";
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: linear-gradient(90deg, #ffb400, #ff8c00);
    transition: width 0.35s ease;
}

.menu-all-pages-container ul.menu li a:hover {
    color: #ffb400;
    transform: translateX(5px);
}

.menu-all-pages-container ul.menu li a:hover::before {
    width: 100%;
}

/* ---- FOOTER BOTTOM SECTION ---- */
.footer-bottom {
    padding: 40px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    margin-top: 60px;
}

/* Social Links */
.social-links {
    display: flex;
    align-items: center;
    gap: 0;
}

.icon-group {
    display: flex;
    gap: 12px;
    align-items: center;
}

.icon-group a {
    width: 48px;
    height: 48px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.08);
    border: 1.5px solid rgba(255, 255, 255, 0.15);
    border-radius: 12px;
    color: rgba(255, 255, 255, 0.8);
    font-size: 16px;
    transition: all 0.35s cubic-bezier(0.34, 1.56, 0.64, 1);
    position: relative;
    overflow: hidden;
}

.icon-group a::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, #ffb400, #ff8c00);
    border-radius: 12px;
    opacity: 0;
    transition: opacity 0.35s ease;
    z-index: -1;
}

.icon-group a:hover {
    color: #fff;
    border-color: #ffb400;
    transform: translateY(-6px) scale(1.08);
    box-shadow: 0 12px 24px rgba(255, 180, 0, 0.25);
}

.icon-group a:hover::before {
    opacity: 1;
}

.app-download {
    opacity: 0.8;
    transition: all 0.3s ease;
}

.app-download:hover {
    opacity: 1;
    transform: scale(1.05);
}

/* ---- COPYRIGHT SECTION ---- */
.copyright-wrap {
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(10px);
    padding: 28px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.08);
}

.copyright-text {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
    margin: 0;
}

.copyright-text a {
    color: #ffb400;
    text-decoration: none;
    transition: all 0.3s ease;
    font-weight: 600;
}

.copyright-text a:hover {
    color: #fff;
}

.footer-links ul {
    list-style: none;
    padding: 0;
    display: flex;
    gap: 30px;
    justify-content: flex-end;
}

.footer-links ul li a {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
}

.footer-links ul li a::after {
    content: "";
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: #ffb400;
    transition: width 0.3s ease;
}

.footer-links ul li a:hover {
    color: #ffb400;
}

.footer-links ul li a:hover::after {
    width: 100%;
}

/* ---- RESPONSIVE DESIGN ---- */
@media (max-width: 992px) {
    .footer-wrapper {
        padding-top: 60px;
    }

    .widget-area > .container:first-child {
        margin-bottom: 40px;
    }

    .footer-bottom {
        padding: 30px 0;
        margin-top: 40px;
    }

    .footer-links ul {
        gap: 20px;
    }
}

@media (max-width: 768px) {
    .newsletter-widget {
        padding: 24px;
    }

    .icon-group {
        gap: 10px;
    }

    .icon-group a {
        width: 44px;
        height: 44px;
        font-size: 14px;
    }

    .footer-links ul {
        flex-direction: column;
        gap: 12px;
        justify-content: center;
        align-items: center;
        text-align: center;
    }
}

@media (max-width: 576px) {
    .footer-wrapper::before,
    .footer-wrapper::after {
        display: none;
    }

    .footer-wrapper {
        padding-top: 40px;
    }

    .newsletter-widget {
        padding: 20px;
    }

    .widget_title,
    .newsletter-title {
        font-size: 16px;
    }

    .copyright-wrap {
        padding: 20px 0;
    }

    .footer-bottom {
        padding: 20px 0;
        margin-top: 30px;
    }

    .copyright-text {
        font-size: 12px;
        text-align: center;
    }

    .footer-links ul {
        font-size: 12px;
    }
}
</style>

    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    
    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg></div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php include 'footer-section.html'; ?>