<?php
session_start();
require_once __DIR__ . '/config/db.php';

$page_title = 'Services - Faren Interior Design';
$page_description = 'Explore our comprehensive interior design and architecture services';

$user_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">

    <!-- header -->
     <?php include 'header-section.html'; ?>

    
    <!-- OUR SERVICES -->
    <section class="overflow-hidden space overflow-hidden" id="service-sec" style="padding-top: 297px;">
        <style>
/* ============================================================
   PREMIUM SERVICE GRID � UNIQUE + RESPONSIVE
============================================================ */

/* Section spacing */
#service-sec {
    position: relative;
    z-index: 2;
}

/* Service Box */
.service-box {
    background: #ffffff;
    border-radius: 18px;
    overflow: hidden;
    border: 1px solid rgba(0,0,0,0.08);
    transition: all .35s ease;
    box-shadow: 0 8px 22px rgba(0,0,0,0.05);
    position: relative;
}

/* Hover elevation + border glow */
.service-box:hover {
    transform: translateY(-10px);
    border: 1px solid transparent;
    background: linear-gradient(#ffffff, #ffffff) padding-box,
                linear-gradient(135deg, #1b8a67, #46e0ad) border-box;
    box-shadow: 0 18px 45px rgba(43,185,123,0.22);
}

/* Image Box */
.service-box .box-img {
    overflow: hidden;
    height: 260px;
    border-bottom: 1px solid rgba(0,0,0,0.06);
}

/* Image hover zoom */
.service-box .box-img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: .5s ease;
}

.service-box:hover .box-img img {
    transform: scale(1.12);
}

/* Content Area */
.service-box .box-content {
    padding: 25px 22px 30px;
    margin-top: -45px;
}

/* Title */
.service-box .box-title a {
    font-size: 22px;
    font-weight: 700;
    color: #1a1a1a;
    transition: .3s ease;
}

.service-box:hover .box-title a {
    color: #1b8a67;
}

/* Description */
.service-box .box-text {
    font-size: 15px;
    color: #555;
    margin-top: 12px;
    line-height: 1.6;
}

/* CTA Button */
.service-box .line-btn {
    margin-top: 18px;
    position: relative;
    display: inline-block;
    text-decoration: none;
    font-size: 15px;
    letter-spacing: .5px;
    color: #1b8a67;
    transition: .3s ease;
}

/* Underline animation */
.service-box .line-btn::after {
    content: "";
    position: absolute;
    left: 0;
    bottom: -3px;
    width: 0%;
    height: 2px;
    background: #1b8a67;
    transition: .3s ease;
}

.service-box:hover .line-btn::after {
    width: 100%;
}

/* ============ GRID RESPONSIVE FIX ============ */

@media (max-width: 1199px) {
    .service-box .box-img {
        height: 240px;
    }
}

@media (max-width: 992px) {
    .service-box .box-content {
        padding: 20px 18px 25px;
    }
    .service-box .box-img {
        height: 220px;
    }
}

@media (max-width: 768px) {
    .service-box .box-img {
        height: 200px;
    }
}

@media (max-width: 576px) {
    .service-box {
        border-radius: 14px;
    }
    .service-box .box-img {
        height: 190px;
    }
    .service-box .box-content {
        padding: 18px 15px 22px;
    }
    .service-box .box-title a {
        font-size: 19px;
    }
}

/* ============================================
   MOBILE TOP BLANK SPACE REMOVAL (≤599px)
   ============================================ */

@media (max-width: 599px) and (min-width: 480px) {
    #service-sec[style*="padding-top: 297px"] {
        padding-top: 80px !important;
    }
}

@media (max-width: 479px) and (min-width: 380px) {
    #service-sec[style*="padding-top: 297px"] {
        padding-top: 25px !important;
    }
}

@media (max-width: 379px) {
    #service-sec[style*="padding-top: 297px"] {
        padding-top: 60px !important;
    }
}

</style>

        <div class="container">
            <div class="service-sec-title">
                <span class="sub-title">Our services</span>
                <h2 class="sec-title">What We Do</h2>
            </div>
            <div class="row gy-5 justify-content-center">
                                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".1s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_1.jpg" alt="Commercial Interiors"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#">Commercial Interiors</a></h3>
                            <p class="box-text">
                                Designing elegant and functional commercial interiors that elevate brand identity,
                                enhance workflow, and create impactful client experiences.
                            </p>
                            <a href="commercial-page.html" class="line-btn">More Information</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".2s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_2.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="multipurpose.html">Multipurpose Interiors</a></h3>
                                <p class="box-text">
                                    Creating adaptable interior spaces that seamlessly transform to meet diverse
                                    functional, professional, and lifestyle requirements.
                                </p>
                            <a href="multipurpose.html" class="line-btn">More Information</a>

                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".3s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_3.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#residential-interior.html">Residential Interiors</a></h3>
                    <p class="box-text">
                    Crafting refined residential interiors that blend comfort, luxury, and personalization
                    to reflect modern living and timeless elegance.
                    </p>
                    <a href="#residential-interior.html" class="line-btn">More Information</a>

                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".4s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_4.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#interior-consulting.html">Interior Consultation</a></h3>
                            <p class="box-text">
                            Providing expert interior guidance, space planning, material selection, and design
                            direction to achieve cohesive and elegant interiors.
                            </p>
                            <a href="#interior-consulting.html" class="line-btn">More Information</a>

                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".5s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_5.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#space-planning.html">Space Planning</a></h3>
                            <p class="box-text">
                            Optimizing interior layouts through intelligent space planning that improves flow,
                            functionality, and spatial harmony.
                            </p>
                            <a href="#space-planning.html" class="line-btn">More Information</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".6s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_6.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="decor-art-page.html">Décor & Art Styling</a></h3>
                            <p class="box-text">
                            Curating décor elements, artworks, textures, and finishes that enhance interior
                            ambience and express refined aesthetics.
                            </p>
                            <a href="decor-art-page.html" class="line-btn">More Information</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".7s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_7.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#luxury-interior.html">Luxury Interior Styling</a></h3>
                            <p class="box-text">
                            Designing sophisticated luxury interiors with premium materials, custom detailing,
                            and timeless design principles.
                            </p>
                            <a href="#luxury-interior.html" class="line-btn">More Information</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="service-box wow fadeInUp" data-wow-delay=".8s">
                        <div class="box-img global-img"><img src="assets/img/service/service_2_8.jpg" alt="img"></div>
                        <div class="box-content">
                            <h3 class="box-title"><a href="#custom-furniture.html">Custom Furniture Design</a></h3>
                            <p class="box-text">
                            Designing bespoke furniture tailored to interior spaces, ensuring harmony, comfort,
                            and exclusivity in every detail.
                            </p>
                            <a href="#custom-furniture.html" class="line-btn">More Information</a>
                        </div>
                    </div>
                </div>
                
                </div>
            </div>
        </div>
    </section>
    <!--  -->
    
    <!-- CONTACT -->
    <div class="contact-area overflow-hidden space" id="contact-sec">
       <style>
/* =================================
   CONTACT IMAGE – FULL RESPONSIVE FIX
================================= */

/* reset previous behavior */
.contact-image.style2 {
  position: relative;
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: clamp(12px, 2vw, 20px);
  align-items: stretch;
}

/* base image wrapper */
.contact-image.style2 > div {
  position: relative;
  width: 100%;
  overflow: hidden;
  border-radius: 20px;
}

/* image itself */
.contact-image.style2 img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  aspect-ratio: 4 / 3;
  transition: transform .6s ease;
}

/* subtle interaction */
.contact-image.style2 img:hover {
  transform: scale(1.05);
}

/* =================================
   DESKTOP LAYOUT (ASYMMETRIC)
================================= */
.contact-image.style2 .img1 {
  grid-column: span 7;
  aspect-ratio: 4 / 5;
}

.contact-image.style2 .img2 {
  grid-column: span 5;
  aspect-ratio: 1 / 1;
}

.contact-image.style2 .img3 {
  grid-column: span 5;
  aspect-ratio: 3 / 2;
}

.contact-image.style2 .img4 {
  grid-column: span 7;
  aspect-ratio: 16 / 9;
}

/* force aspect control */
.contact-image.style2 .img1 img,
.contact-image.style2 .img2 img,
.contact-image.style2 .img3 img,
.contact-image.style2 .img4 img {
  aspect-ratio: inherit;
}

/* =================================
   TABLET (BALANCED GRID)
================================= */
@media (max-width: 1199px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
  }

  .contact-image.style2 > div {
    grid-column: span 1 !important;
    aspect-ratio: 4 / 3;
  }
}

/* =================================
   MOBILE (2-COLUMN GRID LAYOUT)
================================= */
@media (max-width: 767px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
    gap: clamp(10px, 1.5vw, 15px);
  }

  .contact-image.style2 > div {
    aspect-ratio: 4 / 3;
  }

  .contact-image.style2 .img1,
  .contact-image.style2 .img2,
  .contact-image.style2 .img3,
  .contact-image.style2 .img4 {
    grid-column: span 1 !important;
  }
}

/* =================================
   MOBILE FORM OPTIMIZATION
================================= */
@media (max-width: 767px) {
  .contact-area .row {
    --bs-gutter-y: 1rem;
  }

  .contact-area .title-area {
    margin-bottom: 25px;
  }

  .contact-area .title-area .sub-title {
    font-size: 13px;
  }

  .contact-area .title-area .sec-title {
    font-size: 24px;
    line-height: 1.3;
  }

  .contact-area .form-group {
    margin-bottom: 12px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 15px;
    padding: 12px 14px;
    height: auto;
  }

  .contact-area .form-group input::placeholder,
  .contact-area .form-group textarea::placeholder {
    font-size: 14px;
  }

  .contact-area .form-group textarea {
    min-height: 100px;
  }

  .contact-area .form-btn {
    margin-top: 15px;
  }

  .contact-area .form-messages {
    font-size: 13px;
  }

  .contact-area .col-xl-6 {
    margin-bottom: 30px;
  }
}

/* =================================
   ULTRA-SMALL MOBILE (=380px)
================================= */
@media (max-width: 380px) {
  .contact-area .title-area .sec-title {
    font-size: 20px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 14px;
    padding: 10px 12px;
  }

  .contact-area .form-group textarea {
    min-height: 80px;
    font-size: 14px;
  }

  .contact-area .th-btn {
    font-size: 14px;
    padding: 12px 20px;
  }
}

/* =================================
   ULTRA-WIDE SCREENS
================================= */
@media (min-width: 1600px) {
  .contact-image.style2 img {
    aspect-ratio: 16 / 9;
  }
}
</style>


        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact">
                        <div class="title-area pe-xl-5 me-xl-5"><span class="sub-title style2 text-anime">get in
                                touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into
                                Reality</h2>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6"><input type="text" class="form-control" name="name"
                                    id="name" placeholder="Full Name"> <i class="fa-solid fa-user"></i></div>
                            <div class="form-group col-md-6"><input type="email" class="form-control" name="email"
                                    id="email" placeholder="Email Address"> <i class="fa-solid fa-envelope"></i></div>
                            <div class="form-group col-md-6"><input type="tel" class="form-control" name="number"
                                    id="number" placeholder="Phone Number"> <i class="fa-solid fa-phone"></i></div>
                            <div class="form-group col-md-6"><select name="subject" id="subject"
                                    class="form-select nice-select">
                                    <option value="" disabled="disabled" selected="selected" hidden="">Inquire Services
                                    </option>
                                    <option value="Interior Consultingt">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select></div>
                            <div class="form-group col-12"><textarea name="message" id="message" cols="30" rows="3"
                                    class="form-control" placeholder="Your Message"></textarea> <i
                                    class="fa-solid fa-comment"></i></div>
                            <div class="col-12 form-group"><input type="checkbox" id="html"> <label for="html">I agree
                                    with the privacy policy</label></div>
                            <div class="form-btn mt-20 col-12"><button class="th-btn style4">Send Message</button></div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image style2">
                        <div class="img1 img-anim-left"><img src="assets/img/normal/contact-2-1.jpg" alt=""></div>
                        <div class="img2 img-anim-right"><img src="assets/img/normal/contact-2-2.jpg" alt=""></div>
                        <div class="img3 img-anim-left"><img src="assets/img/normal/contact-2-3.jpg" alt=""></div>
                        <div class="img4 img-anim-right"><img src="assets/img/normal/contact-2-4.jpg" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="shape-mockup spin d-none d-xxl-block" data-top="10%" data-right="13%"><img
                src="assets/img/shape/element-5.png" alt=""></div> -->
    </div>
    <!-- FOOTER -->
    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    <style>
/* ================================================
   MODERN AESTHETIC FOOTER - INTERIOR DESIGN
   ================================================ */

.footer-wrapper.footer-layout1.footer-layout6 {
    background: linear-gradient(135deg, #0a0e27 0%, #1a1f3a 50%, #0f1428 100%);
    padding-top: 80px;
    padding-bottom: 0;
    position: relative;
    overflow: hidden;
}

/* Decorative background elements */
.footer-wrapper::before {
    content: "";
    position: absolute;
    top: -50%;
    right: -10%;
    width: 400px;
    height: 400px;
    background: radial-gradient(circle, rgba(255,180,0,0.08) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

.footer-wrapper::after {
    content: "";
    position: absolute;
    bottom: -20%;
    left: -5%;
    width: 350px;
    height: 350px;
    background: radial-gradient(circle, rgba(62,102,243,0.08) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

.widget-area {
    position: relative;
    z-index: 2;
}

/* ---- SECTION SPACING ---- */
.widget-area > .container:first-child {
    margin-bottom: 60px;
}

/* ---- FOOTER WIDGETS ---- */
.footer-widget {
    padding: 0;
}

.widget_title,
.newsletter-title {
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    margin-bottom: 20px;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    position: relative;
    padding-bottom: 12px;
}

.widget_title::after,
.newsletter-title::after {
    content: "";
    position: absolute;
    bottom: 0;
    left: 0;
    width: 40px;
    height: 3px;
    background: linear-gradient(90deg, #ffb400, #ff8c00);
    border-radius: 2px;
}

/* Newsletter Widget */
.newsletter-widget {
    border-radius: 16px;
    padding: 32px;
    background: rgba(255, 255, 255, 0.04);
    border: 1px solid rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    transition: all 0.4s ease;
}

.newsletter-widget:hover {
    border-color: rgba(255, 180, 0, 0.3);
    background: rgba(255, 255, 255, 0.07);
    transform: translateY(-4px);
}

.newsletter-text {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
    line-height: 1.7;
    margin-bottom: 20px;
}

.newsletter-form {
    display: flex;
    gap: 0;
    margin-bottom: 18px;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 10px;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.3s ease;
}

.newsletter-form:focus-within {
    border-color: rgba(255, 180, 0, 0.4);
    background: rgba(255, 255, 255, 0.12);
}

.newsletter-form input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    padding: 14px 18px;
    font-size: 14px;
}

.newsletter-form input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.newsletter-form input:focus {
    outline: none;
}

.newsletter-form button {
    background: linear-gradient(135deg, #ffb400, #ff8c00);
    border: none;
    color: #000;
    padding: 14px 28px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.newsletter-form button:hover {
    background: linear-gradient(135deg, #ff8c00, #ffb400);
    transform: scale(1.02);
}

.newsletter-widget .form-group {
    display: flex;
    align-items: center;
    gap: 10px;
}

.newsletter-widget input[type="checkbox"] {
    accent-color: #ffb400;
    cursor: pointer;
}

.newsletter-widget label {
    color: rgba(255, 255, 255, 0.7);
    font-size: 13px;
    cursor: pointer;
    margin: 0;
}

/* ---- MENU LINKS ---- */
.menu-all-pages-container ul.menu {
    list-style: none;
    padding: 0;
}

.menu-all-pages-container ul.menu li {
    margin-bottom: 14px;
}

.menu-all-pages-container ul.menu li a {
    color: rgba(255, 255, 255, 0.7);
    font-size: 15px;
    text-decoration: none;
    position: relative;
    transition: all 0.3s ease;
    display: inline-block;
}

.menu-all-pages-container ul.menu li a::before {
    content: "";
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: linear-gradient(90deg, #ffb400, #ff8c00);
    transition: width 0.35s ease;
}

.menu-all-pages-container ul.menu li a:hover {
    color: #ffb400;
    transform: translateX(5px);
}

.menu-all-pages-container ul.menu li a:hover::before {
    width: 100%;
}

/* ---- FOOTER BOTTOM SECTION ---- */
.footer-bottom {
    padding: 40px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    margin-top: 60px;
}

/* Social Links */
.social-links {
    display: flex;
    align-items: center;
    gap: 0;
}

.icon-group {
    display: flex;
    gap: 12px;
    align-items: center;
}

.icon-group a {
    width: 48px;
    height: 48px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.08);
    border: 1.5px solid rgba(255, 255, 255, 0.15);
    border-radius: 12px;
    color: rgba(255, 255, 255, 0.8);
    font-size: 16px;
    transition: all 0.35s cubic-bezier(0.34, 1.56, 0.64, 1);
    position: relative;
    overflow: hidden;
}

.icon-group a::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, #ffb400, #ff8c00);
    border-radius: 12px;
    opacity: 0;
    transition: opacity 0.35s ease;
    z-index: -1;
}

.icon-group a:hover {
    color: #fff;
    border-color: #ffb400;
    transform: translateY(-6px) scale(1.08);
    box-shadow: 0 12px 24px rgba(255, 180, 0, 0.25);
}

.icon-group a:hover::before {
    opacity: 1;
}

.app-download {
    opacity: 0.8;
    transition: all 0.3s ease;
}

.app-download:hover {
    opacity: 1;
    transform: scale(1.05);
}

/* ---- COPYRIGHT SECTION ---- */
.copyright-wrap {
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(10px);
    padding: 28px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.08);
}

.copyright-text {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
    margin: 0;
}

.copyright-text a {
    color: #ffb400;
    text-decoration: none;
    transition: all 0.3s ease;
    font-weight: 600;
}

.copyright-text a:hover {
    color: #fff;
}

.footer-links ul {
    list-style: none;
    padding: 0;
    display: flex;
    gap: 30px;
    justify-content: flex-end;
}

.footer-links ul li a {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
}

.footer-links ul li a::after {
    content: "";
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: #ffb400;
    transition: width 0.3s ease;
}

.footer-links ul li a:hover {
    color: #ffb400;
}

.footer-links ul li a:hover::after {
    width: 100%;
}

/* ---- RESPONSIVE DESIGN ---- */
@media (max-width: 992px) {
    .footer-wrapper {
        padding-top: 60px;
    }

    .widget-area > .container:first-child {
        margin-bottom: 40px;
    }

    .footer-bottom {
        padding: 30px 0;
        margin-top: 40px;
    }

    .footer-links ul {
        gap: 20px;
    }
}

@media (max-width: 768px) {
    .newsletter-widget {
        padding: 24px;
    }

    .icon-group {
        gap: 10px;
    }

    .icon-group a {
        width: 44px;
        height: 44px;
        font-size: 14px;
    }

    .footer-links ul {
        flex-direction: column;
        gap: 12px;
        justify-content: center;
        align-items: center;
        text-align: center;
    }
}

@media (max-width: 576px) {
    .footer-wrapper::before,
    .footer-wrapper::after {
        display: none;
    }

    .footer-wrapper {
        padding-top: 40px;
    }

    .newsletter-widget {
        padding: 20px;
    }

    .widget_title,
    .newsletter-title {
        font-size: 16px;
    }

    .copyright-wrap {
        padding: 20px 0;
    }

    .footer-bottom {
        padding: 20px 0;
        margin-top: 30px;
    }

    .copyright-text {
        font-size: 12px;
        text-align: center;
    }

    .footer-links ul {
        font-size: 12px;
    }
}
</style>

    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    

    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg></div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateCartCount() {
            fetch('auth-system/cart-api.php?action=get_count')
                .then(res => res.json())
                .then(data => {
                    document.getElementById('cart-count').textContent = data.count || 0;
                })
                .catch(() => {
                    document.getElementById('cart-count').textContent = 0;
                });
        }
        updateCartCount();
    </script>
</body>
</html>
<?php include 'footer-section.html'; ?>