<?php
/**
 * Blog Database Setup Script
 * Creates the blogs table if it doesn't exist
 */

require_once __DIR__ . '/config/db.php';

// SQL to create blogs table
$sql = "CREATE TABLE IF NOT EXISTS blogs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(255) NOT NULL,
    category VARCHAR(100) NOT NULL,
    author VARCHAR(100) NOT NULL,
    day VARCHAR(2) NOT NULL,
    month VARCHAR(20) NOT NULL,
    image_path VARCHAR(500) NOT NULL,
    content LONGTEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category (category),
    INDEX idx_author (author),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

// Execute the query
if ($connection->query($sql) === TRUE) {
    echo "✅ Blogs table created successfully or already exists!<br>";
    
    // Check if table is empty and add sample data
    $check = $connection->query("SELECT COUNT(*) as count FROM blogs");
    $result = $check->fetch_assoc();
    
    if ($result['count'] == 0) {
        echo "📝 Adding sample blog posts...<br>";
        
        $sample_blogs = [
            [
                'title' => 'Are custom-made sofas a good choice for premium quality interior design?',
                'category' => 'Interior',
                'author' => 'Johon Smith',
                'day' => '18',
                'month' => 'JUNE',
                'image_path' => 'assets/img/blog/blog-grid-2.jpg',
                'content' => 'Custom-made sofas can be an excellent choice for premium interior design...'
            ],
            [
                'title' => 'What are the latest trends in outdoor living spaces for 2025?',
                'category' => 'Interior',
                'author' => 'Johon Smith',
                'day' => '18',
                'month' => 'JUNE',
                'image_path' => 'assets/img/blog/blog-grid-3.jpg',
                'content' => 'Outdoor living spaces have evolved significantly...'
            ],
            [
                'title' => 'How does proper lighting enhance the ambiance of a room?',
                'category' => 'Design',
                'author' => 'Johon Smith',
                'day' => '18',
                'month' => 'JUNE',
                'image_path' => 'assets/img/blog/blog-grid-5.jpg',
                'content' => 'Proper lighting is crucial in creating the right ambiance...'
            ]
        ];
        
        foreach ($sample_blogs as $blog) {
            $stmt = $connection->prepare("INSERT INTO blogs (title, category, author, day, month, image_path, content) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('sssssss', $blog['title'], $blog['category'], $blog['author'], $blog['day'], $blog['month'], $blog['image_path'], $blog['content']);
            
            if ($stmt->execute()) {
                echo "✅ Added: " . $blog['title'] . "<br>";
            } else {
                echo "❌ Failed to add: " . $blog['title'] . "<br>";
            }
            $stmt->close();
        }
        
        echo "<br>✅ Sample data added successfully!<br>";
    } else {
        echo "ℹ️ Blogs table already contains data (" . $result['count'] . " posts found)<br>";
    }
} else {
    echo "❌ Error creating table: " . $connection->error . "<br>";
}

// Close connection
$connection->close();

echo "<br><a href='admin-dashboard.php'>← Back to Dashboard</a>";
?>
