<?php
// Shop Page Header
?>
<!DOCTYPE html>
<html>
<head>
    <title>Shop - Real Time Cart System</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { background: #f5f5f5; font-family: 'DM Sans', Arial, sans-serif; }
        
        /* Top Header */
        .top-header {
            background: #000000;
            padding: 10px 0;
            color: #ffffff;
        }
        .top-header-inner {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
            font-size: 14px;
        }
        .top-header-inner a {
            color: #ffffff;
            text-decoration: none;
            margin-left: 15px;
            transition: 0.3s;
        }
        .top-header-inner a:hover {
            color: #d4a574;
        }
        
        /* Main Navigation */
        .nav-header {
            background: #ffffff;
            padding: 15px 0;
            border-bottom: 2px solid #d4a574;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .nav-logo {
            font-size: 24px;
            font-weight: 700;
            color: #d4a574;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .nav-menu {
            display: flex;
            gap: 30px;
            align-items: center;
            list-style: none;
        }
        .nav-menu a {
            color: #333;
            text-decoration: none;
            font-weight: 500;
            transition: 0.3s;
        }
        .nav-menu a:hover {
            color: #d4a574;
        }
        .nav-cart-link {
            background: #d4a574;
            color: white;
            padding: 10px 18px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        .nav-cart-link:hover {
            background: #b8905a;
            color: white;
        }
        .nav-logout-btn {
            color: #dc3545;
            font-weight: 600;
            cursor: pointer;
            transition: 0.3s;
        }
        .nav-logout-btn:hover {
            color: #c82333;
        }
        
        /* Main Content */
        .main-content {
            min-height: calc(100vh - 200px);
            padding: 40px 20px;
        }
        .container { max-width: 1200px; margin: 0 auto; }
        
        /* Products Grid */
        .products { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .product-card { background: white; border: 1px solid #ddd; border-radius: 8px; padding: 15px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: transform 0.2s; }
        .product-card:hover { transform: translateY(-5px); box-shadow: 0 5px 15px rgba(0,0,0,0.2); }
        .product-card img { width: 100%; height: 200px; object-fit: cover; border-radius: 5px; margin-bottom: 10px; }
        .product-name { font-size: 18px; font-weight: bold; margin: 10px 0; color: #333; }
        .product-price { font-size: 20px; color: #d4a574; font-weight: bold; margin: 10px 0; }
        .quantity-input { width: 70px; padding: 8px; margin: 10px 0; border: 1px solid #ddd; border-radius: 3px; }
        .btn-add-cart { width: 100%; padding: 12px; background: #333; color: white; border: none; border-radius: 5px; cursor: pointer; font-weight: bold; font-size: 16px; transition: all 0.3s; margin-top: 10px; }
        .btn-add-cart:hover { background: #555; }
        .btn-add-cart:disabled { opacity: 0.6; cursor: not-allowed; }
        
        /* Toast */
        .toast { position: fixed; top: 70px; right: 20px; padding: 15px 25px; color: white; border-radius: 5px; z-index: 9999; display: none; font-weight: bold; animation: slideIn 0.3s; }
        .toast.success { background: #28a745; }
        .toast.error { background: #dc3545; }
        @keyframes slideIn { from { transform: translateX(400px); } to { transform: translateX(0); } }
        
        .login-prompt { background: #fff3cd; border: 2px solid #ffc107; border-radius: 8px; padding: 30px; text-align: center; margin: 30px 0; }
        .login-prompt h2 { color: #856404; margin-bottom: 15px; }
        .login-prompt p { color: #856404; margin-bottom: 20px; }
        .login-prompt a { background: #ffc107; color: #333; padding: 12px 25px; text-decoration: none; border-radius: 5px; font-weight: bold; display: inline-block; margin: 0 10px; transition: 0.3s; }
        .login-prompt a:hover { background: #e0a800; }
        
        .status { margin: 20px 0; padding: 15px; border-radius: 5px; background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .action-bar { text-align: center; margin: 30px 0; }
        
        @media (max-width: 768px) {
            .nav-menu { gap: 15px; font-size: 14px; }
            .products { grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); }
            .top-header-inner { flex-direction: column; gap: 10px; text-align: center; }
        }
    </style>
</head>
<body>
    <!-- Top Header -->
    <div class="top-header">
        <div class="top-header-inner">
            <div>Welcome to Faren Interior Design Store</div>
            <div>
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
        </div>
    </div>

    <!-- Navigation Header -->
    <div class="nav-header">
        <div class="nav-container">
            <a href="index.php" class="nav-logo">
                <i class="fas fa-home"></i> Faren Design
            </a>
            <ul class="nav-menu">
                <li><a href="shop.php">🛍️ Shop</a></li>
                <li><a href="about.php">About</a></li>
                <li><a href="service.php">Services</a></li>
                <li><a href="contact.php">Contact</a></li>
                <?php if (isset($_SESSION['user_id'])): ?>
                    <li><a href="cart.php" class="nav-cart-link"><i class="fas fa-shopping-cart"></i> Cart</a></li>
                    <li><a href="auth-system/logout.php" class="nav-logout-btn">Logout</a></li>
                <?php else: ?>
                    <li><a href="auth-system/login.php" class="nav-cart-link">Login</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Toast Notification -->
    <div class="toast" id="toast"></div>

    <!-- Main Content Begins -->
    <div class="main-content">
