<?php
/**
 * Simple Email Test (No Database Required)
 * Test if PHPMailer and email configuration works
 */

session_start();

if (!isset($_SESSION['user_id'])) {
    die('<h2 style="color:red; padding:20px;">Please login first</h2>');
}

$send_test = isset($_POST['send_test']);
$test_email = $_POST['test_email'] ?? '';

?>
<!DOCTYPE html>
<html>
<head>
    <title>Simple Email Test</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .card { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin: 20px 0; }
        h1 { color: #333; margin-bottom: 30px; }
        h2 { color: #333; border-bottom: 2px solid #d4a574; padding-bottom: 10px; margin-bottom: 20px; }
        .check { padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid; }
        .pass { background: #d4edda; border-left-color: #28a745; }
        .fail { background: #f8d7da; border-left-color: #dc3545; }
        .info { background: #d1ecf1; border-left-color: #17a2b8; }
        .status { font-weight: bold; }
        .pass .status { color: #28a745; }
        .fail .status { color: #dc3545; }
        .info .status { color: #0c5460; }
        form { background: #f9f9f9; padding: 20px; border-radius: 8px; }
        .form-group { margin: 15px 0; }
        label { display: block; font-weight: bold; margin-bottom: 5px; }
        input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; }
        button { padding: 12px 24px; background: #d4a574; color: white; border: none; border-radius: 5px; cursor: pointer; font-weight: bold; margin-top: 10px; font-size: 14px; }
        button:hover { background: #b8905a; }
        .result { padding: 20px; border-radius: 8px; margin-top: 20px; }
        .result.success { background: #d4edda; border-left: 4px solid #28a745; }
        .result.error { background: #f8d7da; border-left: 4px solid #dc3545; }
        .code { background: #f4f4f4; padding: 15px; border-radius: 5px; font-family: monospace; font-size: 12px; overflow-x: auto; margin: 10px 0; }
        .footer { text-align: center; margin-top: 30px; }
        a { color: #d4a574; text-decoration: none; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="container">
        <h1>📧 Email Testing Tool</h1>

        <div class="card">
            <h2>✅ System Check</h2>
            
            <?php
            // Check 1: PHPMailer files
            $phpmailer_ok = file_exists(__DIR__ . '/auth-system/PHPMailer/src/PHPMailer.php') &&
                           file_exists(__DIR__ . '/auth-system/PHPMailer/src/SMTP.php') &&
                           file_exists(__DIR__ . '/auth-system/PHPMailer/src/Exception.php');
            
            echo '<div class="check ' . ($phpmailer_ok ? 'pass' : 'fail') . '">';
            echo '<span class="status">' . ($phpmailer_ok ? '✓ PASS' : '✗ FAIL') . '</span> ';
            echo 'PHPMailer Files: ' . ($phpmailer_ok ? 'Installed' : 'Missing');
            echo '</div>';
            
            // Check 2: EmailService
            $emailservice_ok = file_exists(__DIR__ . '/auth-system/EmailService.php');
            echo '<div class="check ' . ($emailservice_ok ? 'pass' : 'fail') . '">';
            echo '<span class="status">' . ($emailservice_ok ? '✓ PASS' : '✗ FAIL') . '</span> ';
            echo 'EmailService.php: ' . ($emailservice_ok ? 'Found' : 'Missing');
            echo '</div>';
            
            // Check 3: Can load EmailService
            $can_load = false;
            if ($emailservice_ok) {
                try {
                    require_once __DIR__ . '/auth-system/EmailService.php';
                    $can_load = class_exists('EmailService');
                } catch (Exception $e) {
                    $can_load = false;
                }
            }
            
            echo '<div class="check ' . ($can_load ? 'pass' : 'fail') . '">';
            echo '<span class="status">' . ($can_load ? '✓ PASS' : '✗ FAIL') . '</span> ';
            echo 'EmailService Loads: ' . ($can_load ? 'Yes' : 'No');
            echo '</div>';
            ?>
        </div>

        <div class="card">
            <h2>📤 Send Test Email</h2>
            <form method="POST">
                <div class="form-group">
                    <label for="test_email">📧 Enter Your Email Address:</label>
                    <input type="email" id="test_email" name="test_email" placeholder="example@gmail.com" value="<?php echo htmlspecialchars($test_email); ?>" required>
                </div>
                <button type="submit" name="send_test" value="1">Send Test Email</button>
            </form>

            <?php
            if ($send_test && $test_email && $can_load) {
                echo '<div class="result ' . ($phpmailer_ok && $emailservice_ok ? 'info' : 'error') . '">';
                echo '<strong>Sending test email to: ' . htmlspecialchars($test_email) . '</strong><br><br>';
                
                // Generate OTP and send
                $otp = EmailService::generateOTP(6);
                
                try {
                    $result = EmailService::sendEmailVerificationOTP($test_email, 'Test User', $otp);
                    
                    if ($result) {
                        echo '<div class="result success">';
                        echo '<strong>✓ Email Sent Successfully!</strong><br>';
                        echo 'Check your email inbox (or spam folder) for the test message.<br><br>';
                        echo '<strong>Test OTP Code:</strong> <code style="background: #e8f5e9; padding: 5px 10px; border-radius: 3px;">' . $otp . '</code><br>';
                        echo 'This is just for testing purposes.';
                        echo '</div>';
                    } else {
                        echo '<div class="result error">';
                        echo '<strong>✗ Email Failed to Send</strong><br>';
                        echo 'Possible reasons:<br>';
                        echo '<ul style="margin: 10px 0 0 20px;">';
                        echo '<li>Gmail credentials are incorrect</li>';
                        echo '<li>Gmail 2FA not enabled</li>';
                        echo '<li>App password is incorrect or expired</li>';
                        echo '<li>SMTP connection failed</li>';
                        echo '</ul>';
                        echo 'Check <a href="EMAIL_TROUBLESHOOTING.md">troubleshooting guide</a>';
                        echo '</div>';
                    }
                } catch (Exception $e) {
                    echo '<div class="result error">';
                    echo '<strong>✗ Error Sending Email</strong><br>';
                    echo 'Error: ' . htmlspecialchars($e->getMessage());
                    echo '</div>';
                }
            } else if ($send_test && !$can_load) {
                echo '<div class="result error">';
                echo '<strong>✗ Cannot Load EmailService</strong><br>';
                echo 'Please fix the system check issues above first.';
                echo '</div>';
            }
            ?>
        </div>

        <div class="card">
            <h2>⚙️ Email Configuration</h2>
            <div class="code">
SMTP Server: mail.zemaraimgroups.com<br>
Port: 465<br>
Security: SMTPS (SSL)<br>
Username: info@zemaraimgroups.com<br>
From: Interior Design
            </div>
        </div>

        <div class="card">
            <h2>📋 Common Issues</h2>
            <div class="check info">
                <strong>Issue: "Email failed to send"</strong><br>
                <strong>Solution:</strong> Check if Gmail has 2FA enabled and you're using an app password, not your regular password.
            </div>
            <div class="check info">
                <strong>Issue: "PHPMailer files missing"</strong><br>
                <strong>Solution:</strong> Download PHPMailer files and place them in <code>auth-system/PHPMailer/src/</code>
            </div>
            <div class="check info">
                <strong>Issue: Email received but marked as spam</strong><br>
                <strong>Solution:</strong> Check your spam/junk folder. This is normal for automated emails.
            </div>
        </div>

        <div class="footer">
            <p><a href="EMAIL_TROUBLESHOOTING.md">📖 View Full Troubleshooting Guide</a></p>
            <p style="margin-top: 15px;"><a href="admin-dashboard.php">← Back to Dashboard</a></p>
        </div>
    </div>
</body>
</html>
