<?php
/**
 * Simple User Check - No Database Required
 * Shows registered users from the users table
 */

session_start();

if (!isset($_SESSION['user_id'])) {
    die('<h2 style="padding:20px;">Please login first</h2>');
}

// Try to get users data
$users_data = [];
$error = '';

try {
    // Direct connection without relying on config file
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    
    if ($conn->connect_error) {
        // Try alternate database name
        $conn = new mysqli('localhost', 'root', '', 'interior');
    }
    
    if (!$conn->connect_error) {
        // Check if users table exists
        $result = $conn->query("SHOW TABLES LIKE 'users'");
        if ($result && $result->num_rows > 0) {
            // Get users
            $users_result = $conn->query("SELECT id, name, email, phone, created_at FROM users ORDER BY created_at DESC LIMIT 20");
            if ($users_result) {
                while ($row = $users_result->fetch_assoc()) {
                    $users_data[] = $row;
                }
            }
        } else {
            $error = 'Users table not found in database';
        }
    } else {
        $error = 'Could not connect to database: ' . $conn->connect_error;
    }
    $conn->close();
} catch (Exception $e) {
    $error = 'Error: ' . $e->getMessage();
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>User Registration Check</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        .container { max-width: 1000px; margin: 0 auto; }
        .card { background: white; padding: 25px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin: 20px 0; }
        h1 { color: #333; margin-bottom: 30px; }
        h2 { color: #333; border-bottom: 2px solid #d4a574; padding-bottom: 10px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f9f9f9; font-weight: bold; }
        tr:hover { background: #f5f5f5; }
        .check { padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid; }
        .pass { background: #d4edda; border-left-color: #28a745; }
        .fail { background: #f8d7da; border-left-color: #dc3545; }
        .info { background: #d1ecf1; border-left-color: #17a2b8; }
        .empty { color: #999; font-style: italic; }
        .footer { text-align: center; margin-top: 30px; }
        a { color: #d4a574; text-decoration: none; padding: 10px 15px; display: inline-block; margin: 5px; background: #f0e6d8; border-radius: 5px; }
        a:hover { background: #d4a574; color: white; }
        .count { font-size: 28px; font-weight: bold; color: #d4a574; }
    </style>
</head>
<body>
    <div class="container">
        <h1>👥 User Registration Check</h1>

        <?php if ($error): ?>
            <div class="card">
                <div class="check fail">
                    <strong>⚠️ Database Connection Error:</strong><br>
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <p style="margin-top: 15px; color: #666;">
                    This tool requires database access. Make sure:
                    <ul style="margin: 15px 0 0 20px;">
                        <li>MySQL server is running</li>
                        <li>Database "interior_design" or "interior" exists</li>
                        <li>Users table exists in the database</li>
                    </ul>
                </p>
            </div>
        <?php else: ?>
            <div class="card">
                <h2>✅ Registered Users</h2>
                
                <div style="margin-bottom: 20px;">
                    <strong style="font-size: 16px;">Total Users: </strong>
                    <span class="count"><?php echo count($users_data); ?></span>
                </div>

                <?php if (empty($users_data)): ?>
                    <div class="check info">
                        <p class="empty">No users registered yet.</p>
                        <p style="margin-top: 10px;">
                            <a href="auth-system/register.php">Register First User →</a>
                        </p>
                    </div>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Registered</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users_data as $user): ?>
                                <tr>
                                    <td><strong>#<?php echo htmlspecialchars($user['id']); ?></strong></td>
                                    <td><?php echo htmlspecialchars($user['name']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['phone'] ?? 'N/A'); ?></td>
                                    <td><?php echo date('M d, Y H:i', strtotime($user['created_at'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    
                    <div style="margin-top: 20px;">
                        <a href="auth-system/register.php">Register Another User →</a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="card">
            <h2>📋 Next Steps</h2>
            <div class="check info">
                <strong>1. Register a User:</strong>
                <a href="auth-system/register.php">Go to Registration →</a>
            </div>
            <div class="check info">
                <strong>2. Check Admin Dashboard:</strong>
                <a href="admin-dashboard.php">Go to Dashboard →</a>
            </div>
            <div class="check info">
                <strong>3. View Users Section:</strong>
                Click "Users" in the left menu of the admin dashboard
            </div>
        </div>

        <div class="footer">
            <p><a href="admin-dashboard.php">← Back to Dashboard</a></p>
        </div>
    </div>
</body>
</html>
