<?php 
session_start(); 
require_once __DIR__ . '/config/db.php'; 
$page_title = 'Our Team'; 
// Use $connection from config/db.php
$conn = $connection;
// Create team table if it doesn't exist
$create_table_sql = "CREATE TABLE IF NOT EXISTS team_members (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    designation VARCHAR(100) NOT NULL,
    image_path VARCHAR(255),
    twitter_url VARCHAR(255),
    linkedin_url VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)";
$conn->query($create_table_sql);

// Check if table has data, if not insert default data
$count_result = $conn->query("SELECT COUNT(*) as count FROM team_members");
$count_row = $count_result->fetch_assoc();

if ($count_row['count'] == 0) {
    // Insert default team members from HTML
    $default_members = [
        ['Jake Saper', 'CEO & Founder', 'assets/img/team/team_1_1.png'],
        ['Mari Doly', 'Chief Architect', 'assets/img/team/team_1_2.png'],
        ['Michel Smith', 'General Manager', 'assets/img/team/team_1_3.png'],
        ['Elis Mike', 'Assistant Architect', 'assets/img/team/team_1_4.png'],
        ['Johone Smith', 'Johone Smith', 'assets/img/team/team_1_5.png'],
        ['Tony Mari', 'Chief Planner', 'assets/img/team/team_1_6.png']
    ];
    
    foreach ($default_members as $member) {
        $conn->query("INSERT INTO team_members (name, designation, image_path, twitter_url, linkedin_url) 
                     VALUES ('{$member[0]}', '{$member[1]}', '{$member[2]}', 'https://twitter.com/', 'https://linkedin.com/')");
    }
}

// Fetch team members from database
$team_members = [];
$result = $conn->query("SELECT * FROM team_members ORDER BY created_at ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $team_members[] = $row;
    }
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- Compact mobile header fallback: ensures header is visible on small screens -->
    <?php include 'header-section.html'; ?>


    <main>
        <section class="team-sec">
            <div class="container">
                <div class="row gy-30">
                    <?php foreach ($team_members as $member): ?>
                    <div class="col-md-6 col-xl-4">
                        <div class="th-team team-box style2">
                            <div class="box-img">
                                <img src="<?php echo htmlspecialchars($member['image_path']); ?>" alt="<?php echo htmlspecialchars($member['name']); ?>">
                            </div>
                            <h3 class="box-title">
                                <a href="javascript:void(0);"><?php echo htmlspecialchars($member['name']); ?></a>
                            </h3>
                            <span class="team-desig"><?php echo htmlspecialchars($member['designation']); ?></span>
                            <div class="th-social">
                                <a target="_blank" href="<?php echo htmlspecialchars($member['twitter_url']); ?>">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a target="_blank" href="<?php echo htmlspecialchars($member['linkedin_url']); ?>">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    </main>
    <style>
        /* ========================================
           TEAM SECTION - GRID RESPONSIVE DESIGN
           ======================================== */

        .team-sec {
            background: linear-gradient(135deg, #F8F8F8 0%, #FAFAFA 100%);
            padding-top: 310px;
            padding-bottom: 80px;
            position: relative;
        }

        .team-sec .container {
            max-width: 100%;
            padding-left: 20px;
            padding-right: 20px;
        }

        .team-sec .row {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            align-items: stretch;
        }

        .team-sec .col-md-6 {
            width: 100%;
        }

        .team-sec .col-xl-4 {
            width: 100%;
        }

        .th-team {
            display: flex;
            flex-direction: column;
            height: 100%;
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }

        .th-team::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #FF833B, #FFB039);
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 10;
        }

        .th-team:hover {
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.12);
            transform: translateY(-8px);
        }

        .th-team:hover::before {
            opacity: 1;
        }

        .th-team .box-img {
            width: 100%;
            aspect-ratio: 1;
            overflow: hidden;
            background: #f5f5f5;
            flex-shrink: 0;
        }

        .th-team .box-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
            transition: transform 0.4s ease;
        }

        .th-team:hover .box-img img {
            transform: scale(1.08);
        }

        .th-team .box-title {
            margin: 20px 0 8px 0;
            padding: 0 20px;
            font-size: 16px;
            font-weight: 700;
            line-height: 1.4;
        }

        .th-team .box-title a {
            color: #02000F;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .th-team .box-title a:hover {
            color: #FF833B;
        }

        .th-team .team-desig {
            padding: 0 20px;
            color: #6C6D71;
            font-size: 13px;
            margin-bottom: 15px;
            display: block;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .th-team .th-social {
            padding: 15px 20px 20px 20px;
            display: flex;
            gap: 15px;
            margin-top: auto;
            flex-wrap: wrap;
        }

        .th-team .th-social a {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: #F8F8F8;
            color: #02000F;
            border-radius: 50%;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-size: 14px;
            border: 1px solid #E0E0E0;
        }

        .th-team .th-social a:hover {
            background: #FF833B;
            color: white;
            border-color: #FF833B;
            transform: scale(1.15);
        }

        /* ========================================
           MOBILE: 320px to 575px (1 column)
           ======================================== */
        @media (max-width: 575px) {
            .team-sec {
                padding-top: 100px;
                padding-bottom: 40px;
            }

            .team-sec .container {
                padding-left: 12px;
                padding-right: 12px;
            }

            .team-sec .row {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .th-team .box-img {
                aspect-ratio: 1;
            }

            .th-team .box-title {
                margin: 12px 0 4px 0;
                padding: 0 14px;
                font-size: 13px;
            }

            .th-team .team-desig {
                padding: 0 14px;
                font-size: 11px;
                margin-bottom: 10px;
            }

            .th-team .th-social {
                padding: 10px 14px 12px 14px;
                gap: 10px;
            }

            .th-team .th-social a {
                width: 32px;
                height: 32px;
                font-size: 11px;
                min-width: 44px;
                min-height: 44px;
            }

            .th-team:hover {
                transform: translateY(-4px);
            }
        }

        /* ========================================
           MOBILE TABLET: 576px to 768px (2 columns)
           ======================================== */
        @media (min-width: 576px) and (max-width: 768px) {
            .team-sec {
                padding-top: 140px;
                padding-bottom: 50px;
            }

            .team-sec .container {
                padding-left: 15px;
                padding-right: 15px;
            }

            .team-sec .row {
                grid-template-columns: repeat(2, 1fr);
                gap: 18px;
            }

            .th-team .box-title {
                margin: 14px 0 5px 0;
                padding: 0 15px;
                font-size: 14px;
            }

            .th-team .team-desig {
                padding: 0 15px;
                font-size: 12px;
                margin-bottom: 12px;
            }

            .th-team .th-social {
                padding: 12px 15px 14px 15px;
                gap: 10px;
            }

            .th-team .th-social a {
                width: 35px;
                height: 35px;
                font-size: 12px;
            }

            .th-team:hover {
                transform: translateY(-6px);
            }
        }

        /* ========================================
           TABLET: 769px to 1024px (2 columns)
           ======================================== */
        @media (min-width: 769px) and (max-width: 1024px) {
            .team-sec {
                padding-top: 200px;
                padding-bottom: 60px;
            }

            .team-sec .container {
                padding-left: 18px;
                padding-right: 18px;
            }

            .team-sec .row {
                grid-template-columns: repeat(2, 1fr);
                gap: 24px;
            }

            .th-team .box-title {
                margin: 16px 0 6px 0;
                padding: 0 17px;
                font-size: 15px;
            }

            .th-team .team-desig {
                padding: 0 17px;
                font-size: 12px;
                margin-bottom: 12px;
            }

            .th-team .th-social {
                padding: 13px 17px 16px 17px;
                gap: 11px;
            }

            .th-team .th-social a {
                width: 36px;
                height: 36px;
                font-size: 12px;
            }

            .th-team:hover {
                transform: translateY(-8px);
            }
        }

        /* ========================================
           DESKTOP: 1025px and above (3 columns)
           ======================================== */
        @media (min-width: 1025px) {
            .team-sec {
                padding-top: 310px;
                padding-bottom: 80px;
            }

            .team-sec .container {
                padding-left: 20px;
                padding-right: 20px;
            }

            .team-sec .row {
                grid-template-columns: repeat(3, 1fr);
                gap: 30px;
            }

            .th-team .box-title {
                margin: 20px 0 8px 0;
                padding: 0 20px;
                font-size: 16px;
            }

            .th-team .team-desig {
                padding: 0 20px;
                font-size: 13px;
                margin-bottom: 15px;
            }

            .th-team .th-social {
                padding: 15px 20px 20px 20px;
                gap: 15px;
            }

            .th-team .th-social a {
                width: 40px;
                height: 40px;
                font-size: 14px;
            }

            .th-team:hover {
                transform: translateY(-10px);
            }
        }

        /* ========================================
           LARGE DESKTOP: 1440px and above
           ======================================== */
        @media (min-width: 1440px) {
            .team-sec {
                padding-top: 360px;
                padding-bottom: 100px;
            }

            .team-sec .row {
                gap: 36px;
            }

            .th-team .box-title {
                margin: 22px 0 10px 0;
                font-size: 17px;
            }

            .th-team .team-desig {
                font-size: 14px;
                margin-bottom: 16px;
            }

            .th-team .th-social {
                padding: 16px 22px 24px 22px;
                gap: 16px;
            }
        }

        /* ========================================
           ULTRA-WIDE: 1920px and above
           ======================================== */
        @media (min-width: 1920px) {
            .team-sec {
                padding-top: 400px;
                padding-bottom: 120px;
            }

            .team-sec .row {
                gap: 40px;
            }

            .th-team .box-title {
                margin: 24px 0 12px 0;
                padding: 0 24px;
                font-size: 18px;
            }

            .th-team .team-desig {
                padding: 0 24px;
                font-size: 14px;
            }

            .th-team .th-social {
                padding: 18px 24px 26px 24px;
                gap: 18px;
            }
        }

        /* ========================================
           ACCESSIBILITY
           ======================================== */
        @media (prefers-reduced-motion: reduce) {
            .th-team,
            .th-team .box-img img,
            .th-team .th-social a {
                transition: none;
            }
        }

        @media (prefers-color-scheme: dark) {
            .team-sec {
                background: linear-gradient(135deg, #1a1a1a 0%, #222 100%);
            }

            .th-team {
                background: #2d2d2d;
                color: #f0f0f0;
            }

            .th-team .box-title a {
                color: #FFB039;
            }

            .th-team .box-title a:hover {
                color: #FF833B;
            }

            .th-team .team-desig {
                color: #b0b0b0;
            }

            .th-team .box-img {
                background: #333;
            }

            .th-team .th-social a {
                background: #333;
                color: #FFB039;
                border-color: #444;
            }

            .th-team .th-social a:hover {
                background: #FF833B;
            }
        }

        /* ========================================
           HIGH CONTRAST
           ======================================== */
        @media (prefers-contrast: more) {
            .th-team {
                border: 2px solid #02000F;
            }

            .th-team .th-social a {
                border: 2px solid #02000F;
            }
        }
    </style>

    <div class="contact-area overflow-hidden space" id="contact-sec">
       <style>
/* =================================
   CONTACT IMAGE – FULL RESPONSIVE FIX
================================= */

/* reset previous behavior */
.contact-image.style2 {
  position: relative;
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: clamp(12px, 2vw, 20px);
  align-items: stretch;
}

/* base image wrapper */
.contact-image.style2 > div {
  position: relative;
  width: 100%;
  overflow: hidden;
  border-radius: 20px;
}

/* image itself */
.contact-image.style2 img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  aspect-ratio: 4 / 3;
  transition: transform .6s ease;
}

/* subtle interaction */
.contact-image.style2 img:hover {
  transform: scale(1.05);
}

/* =================================
   DESKTOP LAYOUT (ASYMMETRIC)
================================= */
.contact-image.style2 .img1 {
  grid-column: span 7;
  aspect-ratio: 4 / 5;
}

.contact-image.style2 .img2 {
  grid-column: span 5;
  aspect-ratio: 1 / 1;
}

.contact-image.style2 .img3 {
  grid-column: span 5;
  aspect-ratio: 3 / 2;
}

.contact-image.style2 .img4 {
  grid-column: span 7;
  aspect-ratio: 16 / 9;
}

/* force aspect control */
.contact-image.style2 .img1 img,
.contact-image.style2 .img2 img,
.contact-image.style2 .img3 img,
.contact-image.style2 .img4 img {
  aspect-ratio: inherit;
}

/* =================================
   TABLET (BALANCED GRID)
================================= */
@media (max-width: 1199px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
  }

  .contact-image.style2 > div {
    grid-column: span 1 !important;
    aspect-ratio: 4 / 3;
  }
}

/* =================================
   MOBILE (2-COLUMN GRID LAYOUT)
================================= */
@media (max-width: 767px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
    gap: clamp(10px, 1.5vw, 15px);
  }

  .contact-image.style2 > div {
    aspect-ratio: 4 / 3;
  }

  .contact-image.style2 .img1,
  .contact-image.style2 .img2,
  .contact-image.style2 .img3,
  .contact-image.style2 .img4 {
    grid-column: span 1 !important;
  }
}

/* =================================
   MOBILE FORM OPTIMIZATION
================================= */
@media (max-width: 767px) {
  .contact-area .row {
    --bs-gutter-y: 1rem;
  }

  .contact-area .title-area {
    margin-bottom: 25px;
  }

  .contact-area .title-area .sub-title {
    font-size: 13px;
  }

  .contact-area .title-area .sec-title {
    font-size: 24px;
    line-height: 1.3;
  }

  .contact-area .form-group {
    margin-bottom: 12px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 15px;
    padding: 12px 14px;
    height: auto;
  }

  .contact-area .form-group input::placeholder,
  .contact-area .form-group textarea::placeholder {
    font-size: 14px;
  }

  .contact-area .form-group textarea {
    min-height: 100px;
  }

  .contact-area .form-btn {
    margin-top: 15px;
  }

  .contact-area .form-messages {
    font-size: 13px;
  }

  .contact-area .col-xl-6 {
    margin-bottom: 30px;
  }
}

/* =================================
   ULTRA-SMALL MOBILE (=380px)
================================= */
@media (max-width: 380px) {
  .contact-area .title-area .sec-title {
    font-size: 20px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 14px;
    padding: 10px 12px;
  }

  .contact-area .form-group textarea {
    min-height: 80px;
    font-size: 14px;
  }

  .contact-area .th-btn {
    font-size: 14px;
    padding: 12px 20px;
  }
}

/* =================================
   ULTRA-WIDE SCREENS
================================= */
@media (min-width: 1600px) {
  .contact-image.style2 img {
    aspect-ratio: 16 / 9;
  }
}
</style>


        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact">
                        <div class="title-area pe-xl-5 me-xl-5"><span class="sub-title style2 text-anime">get in
                                touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into
                                Reality</h2>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6"><input type="text" class="form-control" name="name"
                                    id="name" placeholder="Full Name"> <i class="fa-solid fa-user"></i></div>
                            <div class="form-group col-md-6"><input type="email" class="form-control" name="email"
                                    id="email" placeholder="Email Address"> <i class="fa-solid fa-envelope"></i></div>
                            <div class="form-group col-md-6"><input type="tel" class="form-control" name="number"
                                    id="number" placeholder="Phone Number"> <i class="fa-solid fa-phone"></i></div>
                            <div class="form-group col-md-6"><select name="subject" id="subject"
                                    class="form-select nice-select">
                                    <option value="" disabled="disabled" selected="selected" hidden="">Inquire Services
                                    </option>
                                    <option value="Interior Consultingt">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select></div>
                            <div class="form-group col-12"><textarea name="message" id="message" cols="30" rows="3"
                                    class="form-control" placeholder="Your Message"></textarea> <i
                                    class="fa-solid fa-comment"></i></div>
                            <div class="col-12 form-group"><input type="checkbox" id="html"> <label for="html">I agree
                                    with the privacy policy</label></div>
                            <div class="form-btn mt-20 col-12"><button class="th-btn style4">Send Message</button></div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image style2">
                        <div class="img1 img-anim-left"><img src="assets/img/normal/contact-2-1.jpg" alt=""></div>
                        <div class="img2 img-anim-right"><img src="assets/img/normal/contact-2-2.jpg" alt=""></div>
                        <div class="img3 img-anim-left"><img src="assets/img/normal/contact-2-3.jpg" alt=""></div>
                        <div class="img4 img-anim-right"><img src="assets/img/normal/contact-2-4.jpg" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="shape-mockup spin d-none d-xxl-block" data-top="10%" data-right="13%"><img
                src="assets/img/shape/element-5.png" alt=""></div> -->
    </div>

    <?php include 'footer-section.html'; ?>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>
</body>

</html>
