<?php
/**
 * Test the actual API endpoint
 */

// Simulate a session with logged-in user
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['email'] = 'test@example.com';

// Simulate the POST request data
$raw_input = json_encode(['amount' => 100.00]);

// Set up the request
$_GET['action'] = 'generate_qr';

// Capture the API response
ob_start();
$url = 'http://localhost/interior/auth-system/upi-payment-api.php?action=generate_qr';
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $raw_input);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_COOKIE, 'PHPSESSID=' . session_id());

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Status: " . $http_code . "\n\n";
echo "Response:\n";
echo $response . "\n";

// Try to parse as JSON
$data = json_decode($response, true);
if ($data) {
    echo "\n\nParsed Response:\n";
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
?>
