<?php
/**
 * Direct API Test
 */
session_start();
$_SESSION['user_id'] = 6; // Use an existing user ID from the database

header('Content-Type: application/json');

// Change to the API directory and include it
chdir(__DIR__ . '/auth-system');
$_GET['action'] = 'generate_qr';

// Simulate POST data
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['CONTENT_TYPE'] = 'application/json';

// Set the input stream
$input = json_encode(['amount' => 100.00]);
$GLOBALS['HTTP_RAW_POST_DATA'] = $input;

// Mock file_get_contents to return our data
if (!function_exists('file_get_contents_original')) {
    $GLOBALS['mock_input'] = $input;
}

// Now include the API
try {
    ob_start();
    include 'upi-payment-api.php';
    $output = ob_get_clean();
    echo $output;
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
?>
