<?php
// Minimal test to debug the checkout API

// Start output buffering to catch any output
ob_start();

session_start();
$_SESSION['user_id'] = 1;

// Set headers
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Log file
$log_file = __DIR__ . '/checkout-test.log';

try {
    // Connect to database
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    
    if ($conn->connect_error) {
        throw new Exception("DB Connection failed: " . $conn->connect_error);
    }
    
    file_put_contents($log_file, "1. Connected to database\n", FILE_APPEND);
    
    // Check if orders table exists
    $result = $conn->query("SHOW TABLES LIKE 'orders'");
    if ($result->num_rows === 0) {
        throw new Exception("Orders table does not exist");
    }
    
    file_put_contents($log_file, "2. Orders table exists\n", FILE_APPEND);
    
    // Get cart items
    $user_id = 1;
    $cart_query = $conn->prepare("SELECT * FROM cart WHERE user_id = ?");
    if (!$cart_query) {
        throw new Exception("Cart prepare failed: " . $conn->error);
    }
    
    $cart_query->bind_param("i", $user_id);
    $cart_query->execute();
    $cart_result = $cart_query->get_result();
    
    file_put_contents($log_file, "3. Cart query executed. Found " . $cart_result->num_rows . " items\n", FILE_APPEND);
    
    if ($cart_result->num_rows === 0) {
        file_put_contents($log_file, "WARNING: Cart is empty for user $user_id\n", FILE_APPEND);
    }
    
    // Test order insertion
    $test_order = [
        'user_id' => 1,
        'first_name' => 'Test',
        'last_name' => 'User',
        'email' => 'test@example.com',
        'phone' => '1234567890',
        'billing_country' => 'Pakistan',
        'billing_address' => '123 Test Street',
        'billing_city' => 'Karachi',
        'billing_postcode' => '75000',
        'shipping_country' => 'Pakistan',
        'shipping_address' => '123 Test Street',
        'shipping_city' => 'Karachi',
        'shipping_postcode' => '75000',
        'company' => '',
        'order_notes' => 'Test',
        'payment_method' => 'credit_card',
        'subtotal' => 5000.00,
        'tax' => 500.00,
        'shipping' => 500.00,
        'total' => 6000.00,
        'status' => 'pending'
    ];
    
    $insert_sql = "INSERT INTO orders (
        user_id, first_name, last_name, email, phone,
        billing_country, billing_address, billing_city, billing_postcode,
        shipping_country, shipping_address, shipping_city, shipping_postcode,
        company, order_notes, payment_method, subtotal, tax, shipping, total, status
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($insert_sql);
    if (!$stmt) {
        throw new Exception("Insert prepare failed: " . $conn->error);
    }
    
    file_put_contents($log_file, "4. Prepared INSERT statement\n", FILE_APPEND);
    
    // Bind parameters
    $bind_result = $stmt->bind_param(
        "isssssssssssssssddds",
        $test_order['user_id'],
        $test_order['first_name'],
        $test_order['last_name'],
        $test_order['email'],
        $test_order['phone'],
        $test_order['billing_country'],
        $test_order['billing_address'],
        $test_order['billing_city'],
        $test_order['billing_postcode'],
        $test_order['shipping_country'],
        $test_order['shipping_address'],
        $test_order['shipping_city'],
        $test_order['shipping_postcode'],
        $test_order['company'],
        $test_order['order_notes'],
        $test_order['payment_method'],
        $test_order['subtotal'],
        $test_order['tax'],
        $test_order['shipping'],
        $test_order['total'],
        $test_order['status']
    );
    
    if (!$bind_result) {
        throw new Exception("Bind failed: " . $stmt->error);
    }
    
    file_put_contents($log_file, "5. Bound all parameters\n", FILE_APPEND);
    
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    file_put_contents($log_file, "6. INSERT executed successfully\n", FILE_APPEND);
    
    $order_id = $conn->insert_id;
    
    // Clear buffer and output success
    ob_end_clean();
    echo json_encode([
        'success' => true,
        'message' => 'Test successful',
        'order_id' => $order_id,
        'log' => file_get_contents($log_file)
    ]);
    
} catch (Exception $e) {
    ob_end_clean();
    file_put_contents($log_file, "ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'log' => file_get_contents($log_file)
    ]);
}

?>

