<?php
// Test complete checkout API flow with proper session

session_start();
$_SESSION['user_id'] = 6;
$_SESSION['user_name'] = 'Test Customer';
$_SESSION['user_role'] = 'customer';

header('Content-Type: application/json');

try {
    // Prepare checkout data (same format as form submission)
    $checkout_data = [
        'first_name' => 'Jane',
        'last_name' => 'Smith',
        'email' => 'jane@example.com',
        'phone' => '03001111111',
        'country' => 'Pakistan',
        'address' => '789 New Street',
        'city' => 'Islamabad',
        'postcode' => '44000',
        'payment_method' => 'debit_card',
        'company' => 'Tech Corp',
        'order_notes' => 'Please deliver before 5 PM'
    ];
    
    // Simulate the API call
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost/interior/auth-system/checkout-api.php?action=place_order');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($checkout_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_COOKIE, 'PHPSESSID=' . session_id());
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        throw new Exception("cURL error: $error");
    }
    
    $api_response = json_decode($response, true);
    
    if (!$api_response) {
        throw new Exception("Invalid JSON response from API: " . substr($response, 0, 200));
    }
    
    echo json_encode([
        'success' => true,
        'http_code' => $http_code,
        'api_response' => $api_response
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
