<?php
session_start();
require_once 'config/db.php';

// Check if consultations table exists
$result = $connection->query("SHOW TABLES LIKE 'consultations'");
if ($result->num_rows === 0) {
    echo "❌ Consultations table does NOT exist!<br>";
} else {
    echo "✓ Consultations table exists<br>";
}

// Check table structure
echo "<h3>Table Structure:</h3>";
$columns = $connection->query("DESCRIBE consultations");
if ($columns) {
    echo "<table border='1'>";
    while ($col = $columns->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($col['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Type']) . "</td>";
        echo "<td>" . ($col['Null'] === 'YES' ? 'NULL' : 'NOT NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Count consultations
$count_result = $connection->query("SELECT COUNT(*) as total FROM consultations");
$count = $count_result->fetch_assoc();
echo "<h3>Total Consultations: " . $count['total'] . "</h3>";

// Show all consultations
echo "<h3>All Consultations:</h3>";
$all = $connection->query("SELECT id, first_name, last_name, email, status FROM consultations LIMIT 20");
if ($all && $all->num_rows > 0) {
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>First Name</th><th>Last Name</th><th>Email</th><th>Status</th></tr>";
    while ($row = $all->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['first_name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['last_name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['email']) . "</td>";
        echo "<td>" . htmlspecialchars($row['status']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No consultations found.</p>";
}

$connection->close();
?>
