<?php
require_once 'classes/DirectSMTPService.php';

echo "<h2>Testing Email Setup</h2>";
echo "<p style='margin: 10px 0;'>This test sends a real email using SMTP or fallback method.</p>";
echo "<hr>";

$emailService = new DirectSMTPService();

// Test SMTP connection
$test = $emailService->testConnection();

if ($test['success']) {
    echo "<p style='color: green;'><strong>✓ SMTP Connection: SUCCESS</strong></p>";
} else {
    echo "<p style='color: orange;'><strong>⚠ SMTP Status: " . $test['message'] . "</strong></p>";
    echo "<p style='font-size: 12px;'>System will use fallback mail() method.</p>";
}

echo "<hr>";
echo "<h3>Sending Test Email...</h3>";

// Test sending approval email
$test_email = 'info@zemaraimgroups.com';  // ← CHANGE THIS
echo "<p>Recipient: <strong>$test_email</strong></p>";

$result = $emailService->sendApprovalEmail(
    $test_email,
    'John Doe',
    'Kitchen Renovation',
    '2026-02-15',
    '$5,000 - $10,000'
);

echo "<hr>";
if ($result['success']) {
    echo "<p style='color: green; font-size: 18px;'><strong>✅ Approval Email: SENT SUCCESSFULLY</strong></p>";
    echo "<p>Check your email inbox (including spam/promotions folder)</p>";
} else {
    echo "<p style='color: orange; font-size: 18px;'><strong>⚠️ Status: " . $result['message'] . "</strong></p>";
    echo "<p>The email may have been queued for retry. Check admin-email-queue.php</p>";
}

echo "<hr>";
echo "<h3>Next Steps:</h3>";
echo "<ol>";
echo "<li>Check your email inbox for the test message</li>";
echo "<li>If received, your email system is working!</li>";
echo "<li>Go back to admin dashboard and test with real consultations</li>";
echo "</ol>";
?>