<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Mail Configuration Test</h2>";

// Check if mail function exists
if (function_exists('mail')) {
    echo "<p style='color: green;'>✓ mail() function is available</p>";
} else {
    echo "<p style='color: red;'>✗ mail() function is NOT available</p>";
    exit;
}

// Check php.ini mail settings
echo "<h3>Mail Configuration (php.ini):</h3>";
echo "<p><strong>SMTP:</strong> " . ini_get('SMTP') . "</p>";
echo "<p><strong>smtp_port:</strong> " . ini_get('smtp_port') . "</p>";
echo "<p><strong>sendmail_path:</strong> " . ini_get('sendmail_path') . "</p>";
echo "<p><strong>sendmail_from:</strong> " . ini_get('sendmail_from') . "</p>";

// Test sending a simple email
echo "<h3>Test Email Sending:</h3>";

$test_email = "info@zemaraimgroups.com";
$test_subject = "Test Email - Interior Design System";
$test_message = "<html><body>";
$test_message .= "<h2>This is a test email</h2>";
$test_message .= "<p>If you receive this, the mail system is working correctly.</p>";
$test_message .= "<p>Sent at: " . date('Y-m-d H:i:s') . "</p>";
$test_message .= "</body></html>";

$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
$headers .= "From: noreply@interiordesign.com\r\n";
$headers .= "To: " . $test_email . "\r\n";

echo "<p><strong>Sending test email to:</strong> " . htmlspecialchars($test_email) . "</p>";

$result = @mail($test_email, $test_subject, $test_message, $headers);

if ($result) {
    echo "<p style='color: green;'>✓ Email sent successfully (queued for delivery)</p>";
    echo "<p><small>Note: The email has been sent to the mail queue. Check spam folder if not received.</small></p>";
} else {
    echo "<p style='color: red;'>✗ Email failed to send</p>";
    echo "<p><strong>This usually means:</strong></p>";
    echo "<ul>";
    echo "<li>SMTP is not configured in php.ini</li>";
    echo "<li>sendmail is not available on the server</li>";
    echo "<li>Mail service is not running</li>";
    echo "</ul>";
    echo "<p><strong>Solution:</strong> Configure a mail server (Sendmail, Postfix, or use a mail relay service)</p>";
}

// Check error log location
echo "<h3>Error Log Location:</h3>";
echo "<p>" . ini_get('error_log') . "</p>";

echo "<hr>";
echo "<p><a href='submit-consultation-test.php'>← Back to test</a></p>";
?>
