<?php
// Simple test to verify order insertion works
session_start();
header('Content-Type: application/json');

try {
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    // Use sprintf to build INSERT  
    $stmt = $conn->prepare(
        "INSERT INTO orders (
            user_id, first_name, last_name, email, phone,
            billing_country, billing_address, billing_city, billing_postcode,
            shipping_country, shipping_address, shipping_city, shipping_postcode,
            company, order_notes, payment_method, subtotal, tax, shipping, total, status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );
    
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    
    // Build parameter array
    $user_id = 6;
    $first_name = "John";
    $last_name = "Doe";
    $email = "john@example.com";
    $phone = "03001234567";
    $billing_country = "Pakistan";
    $billing_address = "123 Main St";
    $billing_city = "Karachi";
    $billing_postcode = "75000";
    $shipping_country = "Pakistan";
    $shipping_address = "456 Oak Ave";
    $shipping_city = "Lahore";
    $shipping_postcode = "54000";
    $company = "Test Co";
    $order_notes = "Special delivery requested";
    $payment_method = "credit_card";
    $subtotal = 15000.00;
    $tax = 1500.00;
    $shipping = 500.00;
    $total = 17000.00;
    $status = "pending";
    
    // Build type string CAREFULLY
    // Parameters in order: user_id(i), first_name(s), last_name(s), email(s), phone(s),
    // billing_country(s), billing_address(s), billing_city(s), billing_postcode(s),
    // shipping_country(s), shipping_address(s), shipping_city(s), shipping_postcode(s),
    // company(s), order_notes(s), payment_method(s),
    // subtotal(d), tax(d), shipping(d), total(d),
    // status(s)
    // = 1i + 15s + 4d + 1s = "issssssssssssssdddds"
    
    $types = "issssssssssssssdddds";
    
    if (!$stmt->bind_param($types, 
        $user_id,
        $first_name,
        $last_name,
        $email,
        $phone,
        $billing_country,
        $billing_address,
        $billing_city,
        $billing_postcode,
        $shipping_country,
        $shipping_address,
        $shipping_city,
        $shipping_postcode,
        $company,
        $order_notes,
        $payment_method,
        $subtotal,
        $tax,
        $shipping,
        $total,
        $status
    )) {
        throw new Exception("Bind failed: " . $stmt->error);
    }
    
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $order_id = $conn->insert_id;
    
    echo json_encode([
        'success' => true,
        'message' => 'Order created successfully',
        'order_id' => $order_id,
        'total' => $total
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
