<?php
// Very simple test with just required fields
header('Content-Type: application/json');

try {
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    if ($conn->connect_error) {
        throw new Exception("Connection failed");
    }
    
    // Test INSERT with exactly counted parameters
    $stmt = $conn->prepare(
        "INSERT INTO orders (
            user_id, first_name, last_name, email, phone,
            billing_country, billing_address, billing_city, billing_postcode,
            shipping_country, shipping_address, shipping_city, shipping_postcode,
            company, order_notes, payment_method, subtotal, tax, shipping, total, status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );
    
    if (!$stmt) {
        throw new Exception("Prepare error");
    }
    
    // Manual verification of types:
    // Position 1: user_id - int - type 'i'
    // Position 2-16: strings (first_name, last_name, email, phone, billing_country, billing_address, billing_city, billing_postcode, shipping_country, shipping_address, shipping_city, shipping_postcode, company, order_notes, payment_method) - type 's' (15 times)
    // Position 17-20: doubles (subtotal, tax, shipping, total) - type 'd' (4 times)
    // Position 21: status - string - type 's'
    
    // Therefore type string: "i" + "sssssssssssssss" + "dddd" + "s" = "issssssssssssssdddds"
    
    // Verify length
    $type_str = "issssssssssssssdddds";
    $type_len = strlen($type_str);
    
    // Count actual parameters
    $params = array(
        1,                          // user_id (i)
        "John",                     // first_name (s)
        "Doe",                      // last_name (s)
        "john@test.com",           // email (s)
        "03001234567",             // phone (s)
        "Pakistan",                // billing_country (s)
        "123 Main",                // billing_address (s)
        "Karachi",                 // billing_city (s)
        "75000",                   // billing_postcode (s)
        "Pakistan",                // shipping_country (s)
        "456 Oak",                 // shipping_address (s)
        "Lahore",                  // shipping_city (s)
        "54000",                   // shipping_postcode (s)
        "Test Co",                 // company (s)
        "Note",                    // order_notes (s)
        "card",                    // payment_method (s)
        5000.00,                   // subtotal (d)
        500.00,                    // tax (d)
        500.00,                    // shipping (d)
        6000.00,                   // total (d)
        "pending"                  // status (s)
    );
    
    $param_count = count($params);
    
    if ($type_len !== $param_count) {
        throw new Exception("Type mismatch: type string has $type_len chars but got $param_count params");
    }
    
    // Now bind them dynamically
    $refs = array_merge(array($type_str), array_map(function(&$v) { return &$v; }, $params));
    
    if (!call_user_func_array(array($stmt, "bind_param"), $refs)) {
        throw new Exception("Bind failed: " . $stmt->error);
    }
    
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    echo json_encode([
        'success' => true,
        'order_id' => $conn->insert_id,
        'type_len' => $type_len,
        'param_count' => $param_count
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
