<?php
// Quick test - run the EXACT query from admin-dashboard

// Get database connection
if (file_exists('config/db.php')) {
    require_once 'config/db.php';
    $conn = $connection;
} else {
    die('Could not find database config');
}

echo "<h1>Users Query Test</h1>";
echo "<p>Testing the exact query from admin-dashboard...</p>";

// Run the exact query
$users_query = "
    SELECT id, name, email, phone, created_at
    FROM users
    ORDER BY created_at DESC
";

echo "<p><strong>Query:</strong></p>";
echo "<pre>" . htmlspecialchars($users_query) . "</pre>";

$users_result = $conn->query($users_query);

echo "<p><strong>Query Status:</strong></p>";
if (!$users_result) {
    echo "<p style='color:red;'><strong>QUERY FAILED</strong></p>";
    echo "<p><strong>Error:</strong> " . $conn->error . "</p>";
    echo "<p>Trying fallback empty query...</p>";
    $users_result = $conn->query("SELECT id, name, email, phone, created_at FROM users WHERE 1=0");
    if ($users_result) {
        echo "<p style='color:orange;'>Fallback query returned: " . $users_result->num_rows . " rows</p>";
    }
} else {
    echo "<p style='color:green;'><strong>QUERY OK</strong></p>";
    echo "<p><strong>Rows Returned:</strong> " . $users_result->num_rows . "</p>";
    
    if ($users_result->num_rows > 0) {
        echo "<h2>Users Found:</h2>";
        echo "<table border='1' cellpadding='10'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Created At</th></tr>";
        
        $users_result->data_seek(0); // Reset pointer
        while ($user = $users_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['phone']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_at']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<p><a href='admin-dashboard.php'>Go to Admin Dashboard</a></p>";
    } else {
        echo "<p style='color:orange;'><strong>Query OK but NO USERS FOUND in database</strong></p>";
        echo "<p>This means either:</p>";
        echo "<ul>";
        echo "<li>No users have been registered yet</li>";
        echo "<li>The registration process is not saving users to the database</li>";
        echo "</ul>";
        echo "<p><a href='debug-users-deep.php'>Run Deep Debug</a> to check table structure</p>";
    }
}

$conn->close();
?>
