<?php
/**
 * Simple Autoloader for PHPMailer
 * This provides basic PHPMailer functionality without full Composer
 */

spl_autoload_register(function ($class) {
    $prefix = 'PHPMailer\\PHPMailer\\';
    $base_dir = __DIR__ . '/phpmailer/phpmailer/src/';
    
    // Check if class uses PHPMailer namespace
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    // Get relative class name
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    // If file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});

// Exception class for PHPMailer
if (!class_exists('PHPMailer\\PHPMailer\\Exception')) {
    // Define exception inline if needed
    eval('
        namespace PHPMailer\\PHPMailer;
        class Exception extends \\Exception {}
    ');
}
?>
