<?php
// Comprehensive test to verify the checkout API fix

session_start();
header('Content-Type: application/json');

$_SESSION['user_id'] = 6;

try {
    // Test 1: Verify type string is correct
    $type_str = "i" . str_repeat("s", 15) . str_repeat("d", 4) . "s";
    
    // Test 2: Connect and verify database
    $conn = new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');
    if ($conn->connect_error) {
        throw new Exception("DB Connection failed");
    }
    
    // Test 3: Check orders table
    $result = $conn->query("SELECT COUNT(*) as cnt FROM orders");
    $row = $result->fetch_assoc();
    $order_count_before = $row['cnt'];
    
    // Test 4: Prepare and execute order insert
    $stmt = $conn->prepare("INSERT INTO orders (
        user_id, first_name, last_name, email, phone,
        billing_country, billing_address, billing_city, billing_postcode,
        shipping_country, shipping_address, shipping_city, shipping_postcode,
        company, order_notes, payment_method, subtotal, tax, shipping, total, status
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    
    $uid = 6;
    $fname = "Test";
    $lname = "Order";
    $em = "test@order.com";
    $ph = "0300555555";
    $bc = "Pakistan";
    $ba = "Test Address";
    $bci = "Test City";
    $bp = "12345";
    $sc = "Pakistan";
    $sa = "Shipping Address";
    $sci = "Shipping City";
    $sp = "54000";
    $co = "";
    $on = "Test order";
    $pm = "credit_card";
    $sub = 10000.00;
    $tx = 1000.00;
    $sh = 500.00;
    $tot = 11500.00;
    $st = "pending";
    
    if (!$stmt->bind_param($type_str,
        $uid, $fname, $lname, $em, $ph, $bc, $ba, $bci, $bp, 
        $sc, $sa, $sci, $sp, $co, $on, $pm, $sub, $tx, $sh, $tot, $st
    )) {
        throw new Exception("Bind failed: " . $stmt->error);
    }
    
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $new_order_id = $conn->insert_id;
    
    // Test 5: Verify order was created
    $verify = $conn->prepare("SELECT id, first_name, total FROM orders WHERE id = ?");
    $verify->bind_param("i", $new_order_id);
    $verify->execute();
    $verify_result = $verify->get_result();
    
    if ($verify_result->num_rows === 0) {
        throw new Exception("Order was not created");
    }
    
    $order_row = $verify_result->fetch_assoc();
    
    // Test 6: Count orders after
    $result = $conn->query("SELECT COUNT(*) as cnt FROM orders");
    $row = $result->fetch_assoc();
    $order_count_after = $row['cnt'];
    
    echo json_encode([
        'success' => true,
        'message' => 'Checkout API is working correctly',
        'tests' => [
            'type_string_length' => strlen($type_str),
            'type_string' => $type_str,
            'new_order_id' => $new_order_id,
            'order_created' => $order_row,
            'orders_before' => $order_count_before,
            'orders_after' => $order_count_after
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
