<?php
require_once 'config/db.php';

$verified = false;
$error = false;
$message = '';
$consultation = null;

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['token']) && isset($_GET['id'])) {
    $token = trim($_GET['token']);
    $consultation_id = intval($_GET['id']);
    
    try {
        // Verify token against database
        $stmt = $connection->prepare("
            SELECT * FROM consultations 
            WHERE id = ? AND verification_token = ? AND token_expiry > NOW()
        ");
        $stmt->bind_param("is", $consultation_id, $token);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $consultation = $result->fetch_assoc();
            
            // Update status to verified
            $update_stmt = $connection->prepare("
                UPDATE consultations 
                SET status = 'verified', verified_at = NOW() 
                WHERE id = ?
            ");
            $update_stmt->bind_param("i", $consultation_id);
            
            if ($update_stmt->execute()) {
                $verified = true;
                $message = 'Your email has been successfully verified! Our team will contact you soon to confirm your consultation appointment.';
            } else {
                $error = true;
                $message = 'Error verifying your email. Please try again.';
            }
        } else {
            $error = true;
            $message = 'This verification link is invalid or has expired. Please submit a new consultation request.';
        }
    } catch (Exception $e) {
        $error = true;
        $message = 'An error occurred: ' . $e->getMessage();
    }
} else {
    $error = true;
    $message = 'Invalid verification link.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification - Interior Design Solutions</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .verification-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 60px 40px;
            text-align: center;
            max-width: 500px;
            width: 100%;
        }

        .icon {
            font-size: 80px;
            margin-bottom: 20px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .success-icon {
            color: #27ae60;
            animation: scaleIn 0.5s ease-out;
        }

        .error-icon {
            color: #e74c3c;
            animation: shake 0.5s ease-out;
        }

        @keyframes scaleIn {
            from {
                transform: scale(0);
                opacity: 0;
            }
            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        @keyframes shake {
            0%, 100% {
                transform: translateX(0);
            }
            25% {
                transform: translateX(-10px);
            }
            75% {
                transform: translateX(10px);
            }
        }

        h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 15px;
        }

        .message {
            color: #666;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .consultation-details {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin: 25px 0;
            text-align: left;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: #333;
        }

        .detail-value {
            color: #666;
        }

        .btn {
            display: inline-block;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            margin: 10px 5px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background-color: #e0e0e0;
            color: #333;
        }

        .btn-secondary:hover {
            background-color: #d0d0d0;
        }

        .note {
            color: #999;
            font-size: 14px;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
        }

        @media (max-width: 600px) {
            .verification-container {
                padding: 40px 20px;
            }

            h1 {
                font-size: 24px;
            }

            .icon {
                font-size: 60px;
                height: 60px;
            }
        }
    </style>
</head>
<body>
    <div class="verification-container">
        <?php if ($verified): ?>
            <div class="icon success-icon">✓</div>
            <h1>Email Verified Successfully!</h1>
            <p class="message"><?php echo htmlspecialchars($message); ?></p>
            
            <?php if ($consultation): ?>
                <div class="consultation-details">
                    <div class="detail-row">
                        <span class="detail-label">Consultation Type:</span>
                        <span class="detail-value"><?php echo ucfirst(str_replace('_', ' ', htmlspecialchars($consultation['consultation_type']))); ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Preferred Date:</span>
                        <span class="detail-value"><?php echo date('M d, Y', strtotime($consultation['preferred_date'])); ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Preferred Time:</span>
                        <span class="detail-value"><?php echo date('h:i A', strtotime($consultation['preferred_time'])); ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Budget Range:</span>
                        <span class="detail-value">₱<?php echo htmlspecialchars($consultation['budget_range']); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <div>
                <a href="customer-dashboard.php" class="btn btn-primary">Go to Dashboard</a>
                <a href="index.php" class="btn btn-secondary">Back to Home</a>
            </div>

            <p class="note">A confirmation email will be sent shortly. Check your inbox and spam folder.</p>

        <?php else: ?>
            <div class="icon error-icon">✕</div>
            <h1>Verification Failed</h1>
            <p class="message"><?php echo htmlspecialchars($message); ?></p>

            <div>
                <a href="consultation.php" class="btn btn-primary">Submit New Request</a>
                <a href="index.php" class="btn btn-secondary">Back to Home</a>
            </div>

            <p class="note">If you continue to experience issues, please contact our support team.</p>
        <?php endif; ?>
    </div>
</body>
</html>
