<?php
/**
 * Verify PHPMailer Setup
 * Check if everything is configured correctly
 */

echo "<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .check { margin: 15px 0; padding: 10px; border-left: 4px solid #999; }
        .check.pass { border-color: #4CAF50; background: #f1f8f4; }
        .check.fail { border-color: #f44336; background: #fef5f5; }
        .status { font-weight: bold; }
        .status.pass { color: #4CAF50; }
        .status.fail { color: #f44336; }
        code { background: #f0f0f0; padding: 2px 6px; border-radius: 3px; }
        .details { margin: 10px 0 0 0; color: #666; font-size: 12px; }
        .button { 
            display: inline-block;
            padding: 10px 20px;
            margin: 10px 5px 0 0;
            background: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
        }
        .button:hover { background: #45a049; }
        .button.secondary { background: #2196F3; }
        .button.secondary:hover { background: #0b7dda; }
        .warning { background: #fff3cd; border: 1px solid #ffc107; padding: 15px; border-radius: 4px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>✅ PHPMailer Setup Verification</h1>
        <p>Check if your system is ready to send emails...</p>";

// Check 1: PHPMailer files exist
$phpmailer_path = __DIR__ . '/auth-system/PHPMailer';
$phpmailer_exists = file_exists($phpmailer_path . '/PHPMailer.php') && 
                   file_exists($phpmailer_path . '/SMTP.php') && 
                   file_exists($phpmailer_path . '/Exception.php');

echo "<div class='check " . ($phpmailer_exists ? 'pass' : 'fail') . "'>
    <span class='status " . ($phpmailer_exists ? 'pass' : 'fail') . "'>
        " . ($phpmailer_exists ? '✓ PASS' : '✗ FAIL') . "
    </span>
    <strong>PHPMailer Files</strong>
    <div class='details'>
        Path: <code>{$phpmailer_path}</code>
        " . ($phpmailer_exists ? 
            "Files found: PHPMailer.php, SMTP.php, Exception.php" : 
            "Missing files. Download from: <a href='PHPMAILER_QUICK_START.md'>PHPMAILER_QUICK_START.md</a>"
        ) . "
    </div>
</div>";

// Check 2: EmailService exists
$email_service_exists = file_exists(__DIR__ . '/auth-system/EmailService.php');

echo "<div class='check " . ($email_service_exists ? 'pass' : 'fail') . "'>
    <span class='status " . ($email_service_exists ? 'pass' : 'fail') . "'>
        " . ($email_service_exists ? '✓ PASS' : '✗ FAIL') . "
    </span>
    <strong>EmailService.php</strong>
    <div class='details'>
        Path: <code>" . __DIR__ . "/auth-system/EmailService.php</code>
        " . ($email_service_exists ? "File exists and ready to use" : "File not found") . "
    </div>
</div>";

// Check 3: Email credentials configured
$email_service_file = file_get_contents(__DIR__ . '/auth-system/EmailService.php');
$has_credentials = (strpos($email_service_file, 'info@zemaraimgroups.com') === false);

echo "<div class='check " . ($has_credentials ? 'pass' : 'fail') . "'>
    <span class='status " . ($has_credentials ? 'pass' : 'fail') . "'>
        " . ($has_credentials ? '✓ PASS' : '⚠ CONFIGURE') . "
    </span>
    <strong>Gmail Credentials</strong>
    <div class='details'>
        Status: " . ($has_credentials ? "Credentials configured" : "Still using defaults - need to update") . "
        <br>Edit: <code>auth-system/EmailService.php</code>
        <br>Find and update:
        <ul style='margin: 5px 0;'>
            <li><code>\$mail->Username = 'info@zemaraimgroups.com';</code></li>
            <li><code>\$mail->Password = 'zemaraimgroups@123';</code></li>
            <li><code>\$mail->setFrom('info@zemaraimgroups.com', 'Interior Design');</code></li>
        </ul>
    </div>
</div>";

// Check 4: PHP Configuration
$mail_func = function_exists('mail');

echo "<div class='check " . ($mail_func ? 'pass' : 'fail') . "'>
    <span class='status " . ($mail_func ? 'pass' : 'fail') . "'>
        " . ($mail_func ? '✓ PASS' : '✗ FAIL') . "
    </span>
    <strong>PHP mail() Function</strong>
    <div class='details'>
        Status: " . ($mail_func ? "Available (fallback will work)" : "Not available") . "
    </div>
</div>";

// Summary
echo "<div class='warning'>
    <strong>📝 Setup Instructions:</strong>
    <ol>
        <li>Run <code>download-phpmailer.bat</code> to download files automatically</li>
        <li>Get Gmail App Password from: <a href='https://myaccount.google.com/apppasswords' target='_blank'>https://myaccount.google.com/apppasswords</a></li>
        <li>Edit <code>auth-system/EmailService.php</code> with your email and password</li>
        <li>Run <code>test-phpmailer.php</code> to verify it works</li>
    </ol>
</div>";

// Quick links
echo "<div style='margin-top: 20px;'>
    <a href='PHPMAILER_QUICK_START.md' class='button secondary'>View Setup Guide</a>
    <a href='test-send-email.php' class='button secondary'>Run Email Test</a>
    <a href='download-phpmailer.bat' class='button secondary'>Download Files</a>
</div>";

echo "</div>
</body>
</html>";
?>
