# Admin Dashboard - Architecture & Flow Diagrams

## 📊 System Architecture

```
┌─────────────────────────────────────────────────────────────────┐
│                        ADMIN DASHBOARD                          │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  ┌──────────────────┐         ┌─────────────────────────────┐  │
│  │    SIDEBAR       │         │    MAIN CONTENT AREA        │  │
│  ├──────────────────┤         ├─────────────────────────────┤  │
│  │ • Overview       │ ────→   │  Statistics Cards           │  │
│  │ • Users          │         │  (Total Users, etc.)        │  │
│  │ • Brokers        │         │                             │  │
│  │ • Staff          │         ├─────────────────────────────┤  │
│  │ • Properties ✨  │ ────→   │  Properties Section ✨      │  │
│  │ • Services ✨    │ ────→   │  ┌───────────────────────┐ │  │
│  │ • Analytics      │         │  │ Properties Grid       │ │  │
│  │ • Settings       │         │  │ ┌─────┬─────┬─────┐  │ │  │
│  │ • Logout         │         │  │ │Card │Card │Card │  │ │  │
│  │                  │         │  │ ├─────┼─────┼─────┤  │ │  │
│  │                  │         │  │ │Card │Card │Card │  │ │  │
│  │                  │         │  │ └─────┴─────┴─────┘  │ │  │
│  │                  │         │  │ Pagination: [1][2][3] │ │  │
│  │                  │         │  └───────────────────────┘ │  │
│  │                  │         │                             │  │
│  │                  │         ├─────────────────────────────┤  │
│  │                  │         │  Services Section ✨        │  │
│  │                  │         │  + Add New Service Button   │  │
│  │                  │         │  ┌───────────────────────┐ │  │
│  │                  │         │  │ Services Grid         │ │  │
│  │                  │         │  │ ┌─────┬─────┬─────┐  │ │  │
│  │                  │         │  │ │Card │Card │Card │  │ │  │
│  │                  │         │  │ ├─────┼─────┼─────┤  │ │  │
│  │                  │         │  │ │Card │Card │Card │  │ │  │
│  │                  │         │  │ └─────┴─────┴─────┘  │ │  │
│  │                  │         │  │ Pagination: [1][2][3] │ │  │
│  │                  │         │  └───────────────────────┘ │  │
│  │                  │         │                             │  │
│  └──────────────────┘         └─────────────────────────────┘  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## 🔄 Data Flow Diagram

```
┌──────────────────────────────────────────────────────────────┐
│                    USER INTERACTIONS                         │
└──────────────────────────────────────────────────────────────┘
                              ↓
                   Click Sidebar Menu Item
                              ↓
┌──────────────────────────────────────────────────────────────┐
│         JAVASCRIPT EVENT HANDLER (admin-dashboard.php)       │
│                                                              │
│  activateSection(section) {                                │
│    1. Hide all panels                                       │
│    2. Show selected panel                                   │
│    3. Call appropriate load function                        │
│  }                                                          │
└──────────────────────────────────────────────────────────────┘
                              ↓
                   loadProperties() or
                   loadServices()
                              ↓
┌──────────────────────────────────────────────────────────────┐
│           AJAX FETCH REQUEST                                │
│                                                              │
│  fetch('/api/get-properties.php?page=1&per_page=10')      │
│         or                                                  │
│  fetch('/api/get-services.php?page=1&per_page=10')       │
└──────────────────────────────────────────────────────────────┘
                              ↓
┌──────────────────────────────────────────────────────────────┐
│                    API ENDPOINTS                            │
│                                                              │
│  /api/get-properties.php ──\                               │
│                              ├→ Check Admin Auth            │
│  /api/get-services.php ────/   Prepare Query                │
│                                Execute Query                │
│                                Fetch Data                    │
│                                Return JSON                  │
└──────────────────────────────────────────────────────────────┘
                              ↓
┌──────────────────────────────────────────────────────────────┐
│                    DATABASE QUERIES                         │
│                                                              │
│  SELECT * FROM properties ORDER BY created_at DESC          │
│  LIMIT 10 OFFSET 0                                          │
│         or                                                  │
│  SELECT * FROM services ORDER BY created_at DESC           │
│  LIMIT 10 OFFSET 0                                          │
└──────────────────────────────────────────────────────────────┘
                              ↓
┌──────────────────────────────────────────────────────────────┐
│                    JSON RESPONSE                            │
│                                                              │
│  {                                                          │
│    "success": true,                                         │
│    "properties": [...],                                     │
│    "total": 50,                                             │
│    "page": 1,                                               │
│    "total_pages": 5                                         │
│  }                                                          │
└──────────────────────────────────────────────────────────────┘
                              ↓
┌──────────────────────────────────────────────────────────────┐
│            RENDER FUNCTION (JavaScript)                     │
│                                                              │
│  renderProperties(data.properties, page, totalPages)       │
│        ↓                                                    │
│  Loop through properties array                              │
│        ↓                                                    │
│  Generate HTML for each property card                       │
│        ↓                                                    │
│  Add pagination if multiple pages                           │
│        ↓                                                    │
│  Insert HTML into DOM (#propertiesContent)                │
└──────────────────────────────────────────────────────────────┘
                              ↓
                    UPDATE UI IN BROWSER
                              ↓
           Property/Service Cards Display in Grid
```

---

## 📱 Responsive Design Flow

```
┌─────────────────────────────────────────────────┐
│            VIEWPORT WIDTH CHECK                 │
└─────────────────────────────────────────────────┘
                    ↓
        ┌───────────┴─────────────┬──────────────┐
        ↓                         ↓              ↓
   < 768px                  768px - 1200px    > 1200px
   (Mobile)                (Tablet)           (Desktop)
        ↓                         ↓              ↓
┌──────────────┐     ┌───────────────────┐  ┌─────────────────┐
│ MOBILE LAYOUT│     │ TABLET LAYOUT     │  │ DESKTOP LAYOUT  │
├──────────────┤     ├───────────────────┤  ├─────────────────┤
│ Sidebar: 60px│     │ Sidebar: collapse │  │ Sidebar: 280px  │
│ (icon only)  │     │ or 100px          │  │ (full sidebar)  │
│              │     │                   │  │                 │
│ Grid: 1 col  │     │ Grid: 2-3 cols    │  │ Grid: 3-4 cols  │
│              │     │                   │  │                 │
│ Full width   │     │ Optimized spacing │  │ Optimized       │
│ cards        │     │                   │  │ layout          │
│              │     │                   │  │                 │
│ Touch        │     │ Touch-friendly    │  │ Mouse-friendly  │
│ optimized    │     │                   │  │                 │
│ buttons      │     │ Large buttons     │  │ Standard size   │
│              │     │ Readable text     │  │ buttons         │
└──────────────┘     └───────────────────┘  └─────────────────┘
```

---

## ⚙️ Component Architecture

```
┌────────────────────────────────────────────────────────────────┐
│                    ADMIN DASHBOARD                             │
│                   (admin-dashboard.php)                        │
└────────────────────────────────────────────────────────────────┘
                              ↓
        ┌─────────────────────┼─────────────────────┐
        ↓                     ↓                     ↓
┌───────────────┐      ┌────────────────┐   ┌─────────────────┐
│  SIDEBAR      │      │  HEADER        │   │  MAIN CONTENT   │
│  COMPONENT    │      │  COMPONENT     │   │  PANELS         │
├───────────────┤      ├────────────────┤   ├─────────────────┤
│ • Menu Items  │      │ • Title        │   │ • Overview      │
│ • Icons       │      │ • User Info    │   │ • Users         │
│ • Logout      │      │ • Logout Btn   │   │ • Properties ✨ │
│ • Navigation  │      │                │   │ • Services ✨   │
│   Handler     │      │                │   │ • Other Panels  │
└───────────────┘      └────────────────┘   └─────────────────┘
                              ↓
                    ┌─────────────────┐
                    │   API LAYER     │
                    ├─────────────────┤
                    │ • Authentication│
                    │ • Data Fetching │
                    │ • Response Fmt  │
                    └─────────────────┘
                              ↓
                    ┌─────────────────────────┐
                    │   DATABASE LAYER        │
                    ├─────────────────────────┤
                    │ • Users Table           │
                    │ • Properties Table      │
                    │ • Services Table (new)  │
                    └─────────────────────────┘
```

---

## 🔄 Real-time Update Cycle

```
Initial Load
    ↓
┌─────────────────────────────────────┐
│  User opens Properties section      │
│  loadProperties(1) called           │
│  Data loaded from API               │
│  Grid rendered                      │
└─────────────────────────────────────┘
    ↓
    ↓ After 30 seconds
    ↓
┌─────────────────────────────────────┐
│  setInterval (30000ms) triggers     │
│  Check currentSection               │
│  If 'properties': loadProperties()  │
│  API fetches latest data            │
│  Grid updates (if data changed)     │
└─────────────────────────────────────┘
    ↓
    ↓ After 30 more seconds
    ↓
┌─────────────────────────────────────┐
│  Cycle repeats                      │
│  Continues until user leaves page   │
└─────────────────────────────────────┘

Other Admin Adds Service
    ↓
Service saved to database
    ↓
    ↓ (wait up to 30 seconds)
    ↓
Current Admin's section auto-refreshes
    ↓
New service appears in grid
    ↓
No manual refresh needed! ✨
```

---

## 🎯 Add Service Flow

```
click "+ Add New Service"
    ↓
┌─────────────────────────────────────┐
│ openAddServiceModal()                │
│ Add active class to modal div        │
│ Modal becomes visible               │
└─────────────────────────────────────┘
    ↓
User fills form:
• Title (required)
• Description
• Icon Class
• Price
    ↓
click "Save Service"
    ↓
┌─────────────────────────────────────┐
│ saveService()                        │
│ Get form values                     │
│ Validate title (required)           │
│ If invalid: show alert              │
│ If valid: continue                  │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ fetch('/api/service-add.php', POST) │
│ Send JSON data                      │
│ Content-Type: application/json      │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ API Endpoint                        │
│ • Verify admin auth                 │
│ • Validate inputs                   │
│ • Insert to database                │
│ • Return success/error              │
└─────────────────────────────────────┘
    ↓
Response received:
{success: true, service_id: 1}
    ↓
┌─────────────────────────────────────┐
│ Show success alert                  │
│ closeAddServiceModal()              │
│ Clear form fields                   │
│ loadServices(1)                     │
│ Reload service grid                 │
│ New service appears!                │
└─────────────────────────────────────┘
```

---

## 🛡️ Security Validation Flow

```
API Request Received
    ↓
┌─────────────────────────────────────┐
│ 1. Check Session                    │
│    if (!isset($_SESSION['user_id'])) │
│      → Return Unauthorized (401)    │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ 2. Check Admin Role                 │
│    if ($_SESSION['role'] !== 'admin')│
│      → Return Unauthorized (401)    │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ 3. Validate Request Method          │
│    if ($_SERVER['REQUEST_METHOD']   │
│        !== 'POST')                  │
│      → Return Invalid Method        │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ 4. Validate Input Data              │
│    • Sanitize strings               │
│    • Cast integers                  │
│    • Check required fields          │
│    if (empty($title))               │
│      → Return error                 │
└─────────────────────────────────────┘
    ↓
┌─────────────────────────────────────┐
│ 5. Use Prepared Statements          │
│    $stmt = $conn->prepare(query)    │
│    $stmt->bind_param('s', $title)  │
│    $stmt->execute()                 │
│    → Prevents SQL injection         │
└─────────────────────────────────────┘
    ↓
✅ All checks passed
    ↓
Process request & return success
```

---

## 📊 Database Schema Relationships

```
┌──────────────────────────────────────────────────────────────┐
│                      DATABASE TABLES                         │
└──────────────────────────────────────────────────────────────┘

USERS Table
├── id (Primary Key)
├── full_name
├── email
├── password
├── phone
├── role (admin, broker, staff, customer)
├── status
└── timestamps


PROPERTIES Table
├── id (Primary Key)
├── title
├── description
├── price
├── type
├── status
├── address
├── city
├── state
├── zip_code
├── bedrooms
├── bathrooms
├── garage
├── area
├── broker_id → FK(users.id)
├── agent_id
├── image_url
├── gallery
├── floor_plan
├── video_url
├── latitude
├── longitude
└── timestamps


SERVICES Table ✨ NEW
├── id (Primary Key)
├── title
├── description
├── icon
├── price
├── status
└── timestamps


RELATIONSHIPS:
│
├─ PROPERTIES.broker_id → USERS.id
│  (One broker can have many properties)
│
└─ SERVICES has no FK
   (Independent management)
```

---

## 🎨 CSS Grid Layout

```
Desktop (auto-fill, minmax(300px, 1fr))
┌─────────────────────────────────────────────────────────┐
│ [Card 300px] [Card 300px] [Card 300px] [Card 300px]    │
│ [Card 300px] [Card 300px] [Card 300px]                 │
└─────────────────────────────────────────────────────────┘

Tablet (auto-fill, minmax(300px, 1fr)) - 768px container
┌──────────────────────────────────────┐
│ [Card 300px] [Card 300px]           │
│ [Card 300px] [Card 300px]           │
└──────────────────────────────────────┘

Mobile (1fr)
┌──────────────────────┐
│ [Card Full Width]    │
│ [Card Full Width]    │
│ [Card Full Width]    │
└──────────────────────┘
```

---

## 🔌 API Contract

```
REQUEST: GET /api/get-properties.php?page=1&per_page=10
┌────────────────────────────────────────────────────┐
│ Query Params:                                      │
│ • page: integer (default: 1)                       │
│ • per_page: integer (default: 10)                  │
│                                                    │
│ Headers:                                           │
│ • Cookie: PHPSESSID=...                            │
│ • Accept: application/json                         │
└────────────────────────────────────────────────────┘
                    ↓
RESPONSE: 200 OK
┌────────────────────────────────────────────────────┐
│ {                                                  │
│   "success": true,                                 │
│   "properties": [                                  │
│     {                                              │
│       "id": 1,                                     │
│       "title": "Luxury Apartment",                 │
│       "type": "Apartment",                         │
│       "price": 500000,                             │
│       "address": "123 Main St",                    │
│       "city": "New York",                          │
│       "bedrooms": 3,                               │
│       "bathrooms": 2,                              │
│       "status": "active",                          │
│       "created_at": "2026-02-13"                   │
│     }                                              │
│   ],                                               │
│   "total": 50,                                     │
│   "page": 1,                                       │
│   "per_page": 10,                                  │
│   "total_pages": 5                                 │
│ }                                                  │
└────────────────────────────────────────────────────┘

ERROR RESPONSE: 401 Unauthorized
┌────────────────────────────────────────────────────┐
│ {                                                  │
│   "success": false,                                │
│   "message": "Unauthorized"                        │
│ }                                                  │
└────────────────────────────────────────────────────┘
```

---

## 📈 Performance Timeline

```
User Interaction Timeline:
│
├─ 0ms:    Click sidebar link
├─ 5ms:    Event listener triggered
├─ 10ms:   URL updated, section activated
├─ 20ms:   API fetch initiated
├─ 100ms:  Network request travels
├─ 200ms:  Server processes query
├─ 300ms:  Response sent back
├─ 350ms:  JavaScript parses JSON
├─ 400ms:  HTML generated for 10 items
├─ 450ms:  DOM updated with new content
├─ 500ms:  Browser renders grid
│
└─ ~500ms Total time from click to seeing data
   (No page reload, all via AJAX!)

Auto-refresh cycle (every 30 seconds):
├─ 30s:    Timer triggers
├─ 30.050s: Check if in properties/services
├─ 30.100s: API called if applicable
├─ 30.200s: Network request
├─ 30.350s: Response received
├─ 30.400s: UI updated (if data changed)
│
└─ ~70ms for auto-refresh (minimal impact)
```

---

**This architecture ensures:**
✅ Responsive, real-time data updates
✅ Seamless user experience
✅ Secure API calls
✅ Mobile-first responsive design
✅ Efficient database queries
✅ Scalable component structure
