# Admin Dashboard - Quick Start Guide

## 🚀 Getting Started

### Access the Admin Dashboard
Navigate to:
```
http://localhost/nexthm/dashboards/admin-dashboard.php
```

You must be logged in as an admin user with `role = 'admin'`.

## 📋 Features Overview

### 1. **Overview (Home)**
- Display key statistics
- Total users, brokers, staff, and properties count
- Quick access to all sections

### 2. **Users Management**
- View all users
- Add new users
- Edit user details
- Suspend users
- Filter by role (Admin, Broker, Staff, Customer)

### 3. **Properties Management** ✨ NEW
- View all properties in a responsive grid
- See property details:
  - Title & Type
  - Price & Location
  - Bedrooms & Bathrooms
  - Current Status
- Edit properties
- Delete properties
- Paginated view (10 per page)

### 4. **Services Management** ✨ NEW
- View all services in an interactive grid
- Add new services with:
  - Service title
  - Description
  - Icon (FontAwesome class)
  - Price (optional)
- Edit existing services
- Delete services
- Paginated view (10 per page)

## 🎨 Responsive Design

### Desktop (1200px+)
```
┌─────────────────────────────────────┐
│ SIDEBAR (280px) │ MAIN CONTENT      │
│ • Overview      │ - Stats Grid      │
│ • Users         │ - Data Grid       │
│ • Brokers       │ - Pagination      │
│ • Staff         │                   │
│ • Properties    │ Multiple columns  │
│ • Services      │ per row           │
│ • Analytics     │                   │
│ • Settings      │                   │
└─────────────────────────────────────┘
```

### Tablet/Mobile (< 768px)
```
┌──────────────────────┐
│ SIDEBAR (60px icons) │
├──────────────────────┤
│ MAIN CONTENT         │
│                      │
│ Single column grid   │
│ Full width cards     │
└──────────────────────┘
```

## 📱 Navigation

### Click Sidebar Items to Switch Sections
- **Overview** → Summary statistics
- **Users** → User management
- **Brokers** → Broker management
- **Staff** → Staff management
- **Properties** → Property CRUD operations
- **Services** → Service CRUD operations
- **Analytics** → Analytics dashboard
- **Settings** → System settings
- **Logout** → Sign out

## 🔄 Real-time Updates

The dashboard checks for new data every **30 seconds** when viewing:
- Properties section
- Services section

**Changes made by other admins appear automatically without page refresh!**

## 📝 Working with Services

### Adding a Service
1. Navigate to **Services** section
2. Click **+ Add New Service** button
3. Fill in the form:
   - **Title** (required): e.g., "Property Management"
   - **Description**: Service details
   - **Icon**: FontAwesome class (e.g., `fas fa-home`)
   - **Price**: Service cost (optional)
4. Click **Save Service**
5. Service appears in the grid immediately!

### Editing a Service
- Click **Edit** button on any service card
- Modify details
- Click **Save** (feature coming soon)

### Deleting a Service
- Click **Delete** button
- Confirm deletion
- Service is removed from list

## 🏠 Working with Properties

### Viewing Properties
1. Navigate to **Properties** section
2. View all property cards with details
3. Use pagination to browse pages

### Property Card Shows
- Property title and type
- Location (address & city)
- Price (formatted with commas)
- Bedroom & bathroom count
- Current status
- Action buttons

### Editing a Property
- Click **Edit** button
- Opens property details page
- Make changes and save

### Deleting a Property
- Click **Delete** button
- Confirm deletion
- Property removed from list

## 🔐 Security Features

✅ **Admin-only access** - Session verification required
✅ **SQL injection protection** - Prepared statements
✅ **CSRF protection** - Session-based validation
✅ **Input sanitization** - Safe data handling
✅ **Password hashing** - Secure storage

## 🎯 Keyboard Shortcuts

| Shortcut | Action |
|----------|--------|
| Click sidebar item | Switch section |
| Pagination number | Jump to page |
| Edit button | Edit item |
| Delete button | Remove item |

## 📊 Pagination

- **Default items per page**: 10
- **Shows page numbers** at bottom
- **Current page highlighted**
- **Click any page** to jump to it

## 🎨 Card Layouts

### Property Card
```
┌─────────────────────┐
│ TITLE     [TYPE]    │
│ 📍 Address, City    │
│ 💰 $Price          │
│ 🛏️ Beds | 🚿 Baths │
│ [STATUS]            │
│ [Edit] [Delete]     │
└─────────────────────┘
```

### Service Card
```
┌─────────────────────┐
│ TITLE      [ICON]   │
│ Description text... │
│ 💰 $Price          │
│ [STATUS]            │
│ [Edit] [Delete]     │
└─────────────────────┘
```

## 🐛 Troubleshooting

### Properties Not Showing
- Check admin session is active
- Verify properties exist in database
- Check browser console for errors
- Refresh the page

### Services Not Loading
- Ensure services table was created
- Check API endpoint responding correctly
- Verify admin authentication
- Try refreshing after 30 seconds

### Buttons Not Working
- Check JavaScript console for errors
- Verify API endpoints are reachable
- Ensure database connection is active
- Try clearing browser cache

### Mobile Layout Issues
- Open in responsive design mode
- Check if viewport meta tag is present
- Verify CSS media queries are active
- Test on actual mobile device

## 💡 Tips & Tricks

- **Auto-refresh**: Leave the page open, it auto-updates every 30s
- **Pagination**: Navigate quickly with page number buttons
- **Icons**: Use standard FontAwesome classes for service icons
- **Pricing**: Enter prices as numbers (decimals accepted)
- **Status**: Badge colors change based on status

## 🔗 API Endpoints

All endpoints require admin authentication.

### Get Properties
```
GET /api/get-properties.php?page=1&per_page=10
Response: JSON with properties array
```

### Get Services
```
GET /api/get-services.php?page=1&per_page=10
Response: JSON with services array
```

### Add Service
```
POST /api/service-add.php
Body: {title, description, icon, price}
Response: {success, message, service_id}
```

## 📞 Support

For issues or questions:
1. Check the [ADMIN_DASHBOARD_UPDATE.md](ADMIN_DASHBOARD_UPDATE.md) file
2. Review database schema in [config.php](../config.php)
3. Check API files in [/api/](../api/) folder
4. Review browser console for errors

---

**Happy managing! 🎉**
