# Admin Dashboard - Testing & Verification Guide

## 🧪 Pre-Testing Checklist

Before running tests, verify:
- [ ] Admin user is logged in
- [ ] Database connection is active
- [ ] `/api/` folder exists
- [ ] `config.php` is properly configured
- [ ] Browser console is open (F12)

---

## 🚀 Quick Test Steps

### Test 1: Access Admin Dashboard
```
1. Open browser: http://localhost/nexthm/dashboards/admin-dashboard.php
2. Expected: Dashboard loads with sidebar menu
3. Verify: All sidebar items visible
4. Status: ✅ PASS / ❌ FAIL
```

### Test 2: Default Overview Section
```
1. Dashboard loads by default
2. Expected: Statistics cards visible
3. Verify: 
   - Total Users count shows
   - Total Brokers count shows
   - Total Staff count shows
   - Total Properties count shows
4. Status: ✅ PASS / ❌ FAIL
```

### Test 3: Properties Section Navigation
```
1. Click "Properties" in sidebar
2. Expected: 
   - URL changes to ?section=properties
   - Properties panel appears
   - Loading spinner shows briefly
   - Properties grid displays
3. Verify: No page reload occurs
4. Status: ✅ PASS / ❌ FAIL
```

### Test 4: Properties Data Loading
```
1. Wait for properties to load
2. Expected:
   - Property cards appear in grid
   - Each card shows: title, type, price, location, beds/baths
   - Cards have Edit & Delete buttons
   - Status badges appear
3. Verify: Data matches database
4. Status: ✅ PASS / ❌ FAIL
```

### Test 5: Properties Pagination
```
1. If more than 10 properties exist
2. Expected:
   - Pagination buttons appear at bottom
   - "1, 2, 3..." buttons visible
   - Current page highlighted
   - Can click to jump to page
3. Verify: Only 10 items per page
4. Status: ✅ PASS / ❌ FAIL
```

### Test 6: Services Section Navigation
```
1. Click "Services" in sidebar
2. Expected:
   - URL changes to ?section=services
   - Services panel appears
   - Loading spinner shows
   - Services grid displays
3. Verify: No page reload occurs
4. Status: ✅ PASS / ❌ FAIL
```

### Test 7: Services Data Loading
```
1. Wait for services to load
2. Expected:
   - Service cards appear in grid
   - Each card shows: title, icon, description, price, status
   - Cards have Edit & Delete buttons
3. Verify: Data matches database
4. Status: ✅ PASS / ❌ FAIL
```

### Test 8: Add Service Modal
```
1. Click "+ Add New Service" button
2. Expected:
   - Modal dialog appears
   - Form fields visible:
     - Service Title (required)
     - Description
     - Icon Class
     - Price
   - Save & Cancel buttons present
3. Status: ✅ PASS / ❌ FAIL
```

### Test 9: Add Service Form Validation
```
1. Click Save without entering title
2. Expected:
   - Alert shows: "Please enter a service title"
   - Modal stays open
3. Status: ✅ PASS / ❌ FAIL
```

### Test 10: Add Service Successfully
```
1. Fill in form:
   - Title: "Test Service"
   - Description: "Test Description"
   - Icon: "fas fa-test"
   - Price: "100"
2. Click Save
3. Expected:
   - Success alert shows
   - Modal closes
   - Service appears in grid immediately
   - Service in database (refresh to verify)
4. Status: ✅ PASS / ❌ FAIL
```

### Test 11: Responsive Design - Mobile
```
1. Open DevTools (F12)
2. Activate responsive design mode
3. Set width to 375px (mobile)
4. Expected:
   - Sidebar collapses to 60px (icons only)
   - Main content full width
   - Grid becomes 1 column
   - Cards are full width
   - Text readable
5. Status: ✅ PASS / ❌ FAIL
```

### Test 12: Responsive Design - Tablet
```
1. Set viewport to 768px (tablet)
2. Expected:
   - Sidebar still visible but narrower
   - Grid shows 2-3 columns
   - Cards properly sized
   - No overflow
3. Status: ✅ PASS / ❌ FAIL
```

### Test 13: Responsive Design - Desktop
```
1. Set viewport to 1920px (desktop)
2. Expected:
   - Sidebar 280px wide
   - Main content flexible
   - Grid shows 3-4 columns
   - Full feature access
3. Status: ✅ PASS / ❌ FAIL
```

### Test 14: Real-time Auto-Refresh
```
1. Open browser console (F12)
2. Stay in Properties section
3. Wait 30 seconds
4. Expected:
   - Network request to /api/get-properties.php
   - No visual disruption
   - Data remains same
5. Add new property from another browser tab
6. Wait 30 seconds
7. Expected:
   - New property appears automatically
   - No manual refresh needed
8. Status: ✅ PASS / ❌ FAIL
```

### Test 15: Section Switching Never Reloads Page
```
1. Note: window.location.href
2. Click between sections multiple times:
   - Overview → Properties → Services → Users
3. Expected:
   - URL changes to ?section=X
   - Page never reloads
   - Same DOM elements persist
   - Content updates via AJAX
4. Status: ✅ PASS / ❌ FAIL
```

### Test 16: Console Errors Check
```
1. Open browser console (F12)
2. Navigate all sections
3. Add services
4. Switch pages
5. Expected:
   - No red error messages
   - No 404 errors
   - No CORS issues
6. Status: ✅ PASS / ❌ FAIL
```

### Test 17: API Authentication
```
1. Open browser console
2. Test direct API call (should fail if not admin):
   fetch('/nexthm/api/get-properties.php')
3. Expected:
   - Request goes to API
   - Response: {"success": false, "message": "Unauthorized"}
   - OR
   - If admin: Full data returns
4. Status: ✅ PASS / ❌ FAIL
```

### Test 18: Edit Property Button
```
1. Click Edit on any property card
2. Expected:
   - Navigates to properties-details.php?id=X
   - Correct property ID in URL
3. Status: ✅ PASS / ❌ FAIL (Navigation check)
```

### Test 19: Delete Service Button
```
1. Click Delete on any service card
2. Expected:
   - Confirmation dialog appears
   - Text: "Are you sure you want to delete this service?"
   - Cancel/Confirm buttons
3. Status: ✅ PASS / ❌ FAIL
```

### Test 20: Pagination Click
```
1. If multiple pages exist:
   - Click page "2"
2. Expected:
   - Data changes to page 2 items
   - Page "2" button is highlighted
   - URL remains same
   - No visual jump/flicker
3. Status: ✅ PASS / ❌ FAIL
```

---

## 🔍 Database Verification

### Check Services Table Created
```sql
SELECT * FROM services;
```
**Expected:** Table exists, columns: id, title, description, icon, price, status, created_at, updated_at

### Check Properties Table Has Data
```sql
SELECT COUNT(*) FROM properties;
```
**Expected:** Returns count greater than 0

### Verify Service Added
```sql
SELECT * FROM services WHERE title = 'Test Service';
```
**Expected:** Returns the service you added

---

## 🐛 Troubleshooting Tests

### If Properties Not Loading
```
1. Check console for errors
2. Verify /api/get-properties.php exists
3. Test API directly: 
   http://localhost/nexthm/api/get-properties.php
4. Expected: JSON response
5. If error 401: Check admin auth
```

### If Services Not Loading
```
1. Check console for errors
2. Verify /api/get-services.php exists
3. Test API directly:
   http://localhost/nexthm/api/get-services.php
4. Expected: JSON response with services array
```

### If Modal Won't Open
```
1. Check console for JS errors
2. Verify onclick="openAddServiceModal()" works
3. Check modal div exists: id="addServiceForm"
4. Verify CSS .modal { display: none; }
```

### If Real-time Not Working
```
1. Check console Network tab
2. Look for periodic /api/get-*.php requests
3. Should appear every 30 seconds
4. If not: Check setInterval in script
5. Verify currentSection value changes correctly
```

---

## 📊 Test Results Template

```markdown
## Test Results - [Date]

### Functionality Tests
- Test 1 (Access Dashboard): ✅ PASS / ❌ FAIL
- Test 2 (Overview Section): ✅ PASS / ❌ FAIL
- Test 3 (Nav Properties): ✅ PASS / ❌ FAIL
- Test 4 (Load Properties): ✅ PASS / ❌ FAIL
- Test 5 (Pagination): ✅ PASS / ❌ FAIL
- Test 6 (Nav Services): ✅ PASS / ❌ FAIL
- Test 7 (Load Services): ✅ PASS / ❌ FAIL
- Test 8 (Add Modal): ✅ PASS / ❌ FAIL
- Test 9 (Form Validation): ✅ PASS / ❌ FAIL
- Test 10 (Add Service): ✅ PASS / ❌ FAIL

### Responsive Tests
- Test 11 (Mobile 375px): ✅ PASS / ❌ FAIL
- Test 12 (Tablet 768px): ✅ PASS / ❌ FAIL
- Test 13 (Desktop 1920px): ✅ PASS / ❌ FAIL

### Real-time Tests
- Test 14 (Auto-Refresh): ✅ PASS / ❌ FAIL
- Test 15 (No Page Reload): ✅ PASS / ❌ FAIL
- Test 16 (No Console Errors): ✅ PASS / ❌ FAIL

### Security Tests
- Test 17 (API Auth): ✅ PASS / ❌ FAIL
- Test 18 (Edit Navigation): ✅ PASS / ❌ FAIL
- Test 19 (Delete Confirm): ✅ PASS / ❌ FAIL
- Test 20 (Pagination): ✅ PASS / ❌ FAIL

### Overall Status: ✅ ALL PASS / ⚠️ SOME ISSUES / ❌ CRITICAL ERRORS

### Issues Found
[List any issues here]

### Notes
[Additional notes here]
```

---

## ✅ Final Verification

Once all tests pass:
```
✅ Admin dashboard fully functional
✅ Properties section working
✅ Services section working
✅ Real-time updates active
✅ Responsive on all devices
✅ No console errors
✅ API endpoints secured
✅ Ready for production
```

---

## 🎯 Success Criteria

- [ ] All 20 tests pass
- [ ] No console errors
- [ ] Real-time refresh works
- [ ] Responsive on mobile/tablet/desktop
- [ ] Add service functionality works
- [ ] Pagination works correctly
- [ ] No page reloads on section switch
- [ ] Database updates reflected in UI

**🎉 If all passed: Implementation is complete and working!**
