# NextHM System Architecture & Data Flow

## System Architecture Overview

```
┌─────────────────────────────────────────────────────────────────────┐
│                     NextHM Real Estate Platform                     │
├─────────────────────────────────────────────────────────────────────┤
│
│  ┌──────────────────────────────────────────────────────────────┐
│  │              Frontend (User Interface Layer)                  │
│  ├──────────────┬───────────────────┬──────────────┬────────────┤
│  │   Login.php  │  Register.php     │  Logout.php  │ Dashboards │
│  └──────────────┼───────────────────┼──────────────┼────────────┘
│                 │                   │              │
│  ┌──────────────v───────────────────v──────────────v────────────┐
│  │         Backend Processing Layer (PHP Logic)                 │
│  ├──────────────┬───────────────────┬──────────────┬────────────┤
│  │ Process-     │ Process-Register  │ Session      │ Access     │
│  │ Login        │                   │ Management   │ Control    │
│  └──────────────┼───────────────────┼──────────────┼────────────┘
│                 │                   │              │
│  ┌──────────────v───────────────────v──────────────v────────────┐
│  │              Database Abstraction Layer                       │
│  │                   (Config.php)                               │
│  └──────────────────────────────┬───────────────────────────────┘
│                                  │
│  ┌──────────────────────────────v───────────────────────────────┐
│  │            MySQL Database (nexthm)                           │
│  ├──────────────────────────────────────────────────────────────┤
│  │                    users Table                               │
│  │  id | name | email | password | role | status | ...         │
│  └──────────────────────────────────────────────────────────────┘
│
└─────────────────────────────────────────────────────────────────────┘
```

## Authentication Flow Diagram

```
                        USER JOURNEY
                            │
        ┌───────────────────┴───────────────────┐
        │                                       │
        ▼                                       ▼
    ┌─────────┐                           ┌─────────────┐
    │ Login   │                           │ Register    │
    │ Page    │                           │ Page        │
    └────┬────┘                           └────┬────────┘
         │                                     │
         ▼                                     ▼
    ┌─────────────────────┐         ┌──────────────────────┐
    │ process-login.php   │         │ process-register.php │
    │                     │         │                      │
    │ • Validate input    │         │ • Validate form      │
    │ • Query users DB    │         │ • Check duplicate    │
    │ • Hash password     │         │ • Hash password      │
    │ • Create session    │         │ • Insert new user    │
    └────────┬────────────┘         └───────────┬──────────┘
             │                                  │
      ┌──────┴─────┐                    ┌──────┴──────┐
      │ Valid?      │                    │ Success?    │
      ▼             ▼                    ▼             ▼
    ┌────┐      ┌───────┐            ┌────────┐  ┌────────┐
    │YES │      │ NO    │            │   YES  │  │  NO    │
    └─┬──┘      └───┬───┘            └──┬─────┘  └───┬────┘
      │             │                   │            │
      ▼             ▼                   ▼            ▼
    ┌──────────┐ ┌─────────┐      ┌──────────┐  ┌───────────┐
    │ Role     │ │ Redirect│      │ Redirect │  │ Show      │
    │ Check    │ │ to      │      │ to       │  │ Error &   │
    └─┬────────┘ │ Login   │      │ Login    │  │ Reload    │
      │          └─────────┘      └──────────┘  └───────────┘
      │
      ├─► role = 'customer'  → customer-dashboard.php
      ├─► role = 'agent'     → agent-dashboard.php
      ├─► role = 'staff'     → staff-dashboard.php
      ├─► role = 'broker'    → broker-dashboard.php
      └─► role = 'admin'     → admin-dashboard.php
           │
           ▼
        ┌─────────────────┐
        │ Dashboard       │
        │ (Session Valid) │
        │                 │
        │ • Check role    │
        │ • Verify session│
        │                 │
        │ [Logout Button] │
        └────────┬────────┘
                 │
          ┌──────┴──────┐
          ▼             ▼
      ┌────────┐   ┌──────────────┐
      │Logout  │   │ Access Denied│
      │Page    │   │ Redirect to  │
      │        │   │ Login        │
      └───┬────┘   └──────────────┘
          │
          ▼
    ┌──────────────┐
    │ Session      │
    │ Destroyed    │
    │              │
    │ Redirect to  │
    │ Home Page    │
    └──────────────┘
```

## Role-Based Access Control System

```
┌─────────────────────────────────────────────────────────────────┐
│                Role-Based Access Control (RBAC)                │
├─────────────────────────────────────────────────────────────────┤
│
│  ROLE HIERARCHY
│  ═════════════════
│
│         ┌──────────┐
│         │  ADMIN   │ ◄──── Full System Access
│         └────┬─────┘
│              │
│         ┌────▼─────┐
│         │ BROKER   │ ◄──── Team Management
│         └────┬─────┘
│              │
│      ┌──────┴─────┬──────────┐
│      │            │          │
│      ▼            ▼          ▼
│   STAFF        AGENT     CUSTOMER
│   Operations   Properties  Shopping
│   Management   & Sales     & Booking
│
│  ACCESS RULES
│  ════════════════
│
│  ┌─────────────┬──────────┬─────────┬────────┬──────────┐
│  │ Resource    │ Customer │ Agent   │ Staff  │ Broker   │
│  ├─────────────┼──────────┼─────────┼────────┼──────────┤
│  │ Browse Props│    ✓     │    ✓    │   ✓    │    ✓     │
│  │ List Props  │    ✗     │    ✓    │   ✗    │    ✗     │
│  │ View Offers │    ✓     │    ✓    │   ✓    │    ✓     │
│  │ Manage Inq  │    ✓     │    ✓    │   ✓    │    ✓     │
│  │ Manage Team │    ✗     │    ✗    │   ✓    │    ✓     │
│  │ System Cfg  │    ✗     │    ✗    │   ✗    │    ✗     │
│  │ View Reports│    ✗     │    ✓    │   ✓    │    ✓     │
│  └─────────────┴──────────┴─────────┴────────┴──────────┘
│
└─────────────────────────────────────────────────────────────────┘
```

## Database Schema Diagram

```
┌──────────────────────────────────────────┐
│              users Table                 │
├──────────────────────────────────────────┤
│                                          │
│  PK │ id (INT)                           │
│     │ ├─ Auto Increment                  │
│     │ └─ Unique Identifier               │
│                                          │
│  UQ │ email (VARCHAR 100)                │
│     │ ├─ Unique Constraint               │
│     │ └─ Login Identifier                │
│                                          │
│     │ name (VARCHAR 100)                 │
│     │ ├─ User Full Name                  │
│     │ └─ Display in Dashboard            │
│                                          │
│     │ password (VARCHAR 255)             │
│     │ ├─ BCRYPT Hashed                   │
│     │ └─ Never Plain Text                │
│                                          │
│     │ phone (VARCHAR 20)                 │
│     │ └─ Optional Contact                │
│                                          │
│  FK │ role (ENUM)                        │
│     │ ├─ 'customer'                      │
│     │ ├─ 'agent'                         │
│     │ ├─ 'broker'                        │
│     │ ├─ 'staff'                         │
│     │ └─ 'admin'                         │
│                                          │
│     │ status (ENUM)                      │
│     │ ├─ 'active'                        │
│     │ └─ 'inactive'                      │
│                                          │
│     │ created_at (TIMESTAMP)             │
│     │ └─ Account Creation Time           │
│                                          │
│     │ updated_at (TIMESTAMP)             │
│     │ └─ Last Profile Update             │
│                                          │
└──────────────────────────────────────────┘
```

## Session Management Flow

```
┌──────────────────────────────────────────────────────┐
│           SESSION LIFECYCLE                         │
├──────────────────────────────────────────────────────┤
│
│  INITIALIZATION
│  ═════════════════════════════════════════════════════
│
│  LOGIN                                LOGOUT
│  ─────                                ──────
│  ▼                                      ▼
│  ┌──────────────┐             ┌──────────────────┐
│  │ session_start│             │ session_destroy()│
│  └──────┬───────┘             └────────┬─────────┘
│         │                              │
│         ▼                              ▼
│  ┌──────────────────────┐   ┌──────────────────────┐
│  │ $_SESSION           │   │ $_SESSION = array()  │
│  │ [                   │   │                      │
│  │  'user_id'     ► 1  │   │ (All data cleared)   │
│  │  'user_name'   ► ..  │   │                      │
│  │  'email'       ► ..  │   │ setcookie() removes │
│  │  'role'        ► ..  │   │ PHPSESSID           │
│  │ ]                   │   │                      │
│  └──────┬───────────────┘   └──────────┬──────────┘
│         │                              │
│         ▼                              ▼
│  ┌──────────────────────┐   ┌──────────────────────┐
│  │ PHPSESSID Cookie     │   │ Redirect to Index    │
│  │ Set (HTTP Header)    │   │ User Logged Out      │
│  └──────┬───────────────┘   └──────┬───────────────┘
│         │                          │
│         ▼                          ▼
│  ┌──────────────────────┐   Next Request
│  │ Session File Created │   ├─ No PHPSESSID
│  │ /tmp/sess_XXXXX      │   ├─ No $_SESSION
│  │ ~/php/sessions/      │   └─ Must login again
│  └──────┬───────────────┘
│         │
│         ▼
│  ┌──────────────────────┐
│  │ User Authenticated   │
│  │ Access Dashboard     │
│  └──────────────────────┘
│
└──────────────────────────────────────────────────────┘
```

## Security Implementation Layer

```
┌────────────────────────────────────────────────────────┐
│          SECURITY MEASURES & IMPLEMENTATION            │
├────────────────────────────────────────────────────────┤
│
│  1. PASSWORD SECURITY
│     ═══════════════════════════════════════════════════
│     User Input    ─►  password_hash()  ─►  Database
│     (myPassword)      (BCRYPT)             (encrypted)
│
│     Database      ─►  password_verify()  ─►  Validation
│     (encrypted)       (BCRYPT check)        Result
│
│
│  2. SQL INJECTION PREVENTION
│     ═══════════════════════════════════════════════════
│     User Input ($email, $password)
│          │
│          ▼
│     Prepared Statement
│     ├─ $stmt = $conn->prepare()
│     ├─ $stmt->bind_param("ss", $email, $password)
│     └─ Query never concatenates user input
│          │
│          ▼
│     Safe Database Query
│
│
│  3. XSS PREVENTION
│     ═══════════════════════════════════════════════════
│     Database Value  ─►  htmlspecialchars()  ─►  Display
│     (user_name)         (encode entities)       (safe)
│
│     Example:
│     <input value="<?php echo htmlspecialchars($name); ?>">
│
│
│  4. SESSION SECURITY
│     ═══════════════════════════════════════════════════
│     ✓ Session ID in cookie (HTTP only if configured)
│     ✓ Session files stored server-side
│     ✓ User cannot directly modify session data
│     ✓ Timeout support (configurable)
│     ✓ Regeneration on login (recommended)
│
│
│  5. ROLE-BASED ACCESS CONTROL
│     ═══════════════════════════════════════════════════
│     Request to Dashboard
│          │
│          ▼
│     Check session_start()
│          │
│          ├─ Session Active? ──NO──►  Redirect Login
│          │
│          ▼ YES
│     Check Role
│          │
│          ├─ role == 'customer'?  ─YES──►  Allow Access
│          │
│          ├─ Other roles?  ──NO──►  Redirect Login
│          │
│          ▼ YES
│     Grant Dashboard Access
│
│
│  6. ERROR HANDLING
│     ═══════════════════════════════════════════════════
│     ✓ Database errors logged (not displayed)
│     ✓ User-friendly error messages
│     ✓ No sensitive information exposed
│     ✓ Secure headers configured
│
└────────────────────────────────────────────────────────┘
```

## File & Folder Structure

```
nexthm/
│
├─ 📄 login.php                           ◄─── User Login Interface
├─ 📄 process-login.php                   ◄─── Login Processing Logic
├─ 📄 logout.php                          ◄─── Logout Handler
├─ 📄 register.php                        ◄─── Registration Interface
├─ 📄 process-register.php                ◄─── Registration Logic
├─ 📄 config.php                          ◄─── Database Configuration
├─ 📄 test-auth-system.php                ◄─── System Test Tool
├─ 📄 index.php                           ◄─── Home Page
│
├─ 📁 dashboards/                         ◄─── User Dashboards
│  ├─ 📄 customer-dashboard.php           ◄─── Customer Dashboard
│  ├─ 📄 agent-dashboard.php              ◄─── Agent Dashboard
│  ├─ 📄 staff-dashboard.php              ◄─── Staff Dashboard
│  ├─ 📄 broker-dashboard.php             ◄─── Broker Dashboard
│  └─ 📄 admin-dashboard.php              ◄─── Admin Dashboard
│
├─ 📁 assets/                             ◄─── Frontend Resources
│  ├─ 📁 css/
│  │  ├─ bootstrap.min.css
│  │  ├─ fontawesome.min.css
│  │  ├─ style.css
│  │  └─ ...
│  │
│  ├─ 📁 js/
│  │  ├─ bootstrap.min.js
│  │  ├─ jquery.min.js
│  │  ├─ main.js
│  │  └─ ...
│  │
│  └─ 📁 img/
│     ├─ 📁 properties/
│     ├─ 📁 team/
│     ├─ 📁 hero/
│     └─ ...
│
├─ 📁 api/                                ◄─── API Endpoints
│  └─ 📄 get-property.php
│
└─ 📄 Documentation
   ├─ AUTHENTICATION_SYSTEM.md            ◄─── Full Documentation
   ├─ QUICK_START_AUTH.md                 ◄─── Setup Guide
   ├─ IMPLEMENTATION_COMPLETE.md          ◄─── Completion Summary
   └─ ARCHITECTURE_OVERVIEW.md            ◄─── This File
```

## Integration Points

```
┌──────────────────────────────────────────────────────────┐
│          System Integration Architecture                │
├──────────────────────────────────────────────────────────┤
│
│  FRONTEND LAYER
│  ═════════════════════════════════════════════════════════
│  ┌────────────────────────────────────────────────────┐
│  │ HTML Forms & Templates                             │
│  │  • login.php          (HTML + Form)                 │
│  │  • register.php       (HTML + Form)                 │
│  │  • Dashboards         (HTML + Display Logic)        │
│  └────────────────────────────────────────────────────┘
│
│  ▼ HTTP POST/GET ▼
│
│  APPLICATION LAYER
│  ═════════════════════════════════════════════════════════
│  ┌────────────────────────────────────────────────────┐
│  │ PHP Business Logic                                 │
│  │  • process-login.php  (Authentication)              │
│  │  • process-register.php (User Creation)             │
│  │  • logout.php         (Session Cleanup)             │
│  │  • Dashboards         (Authorization & Display)     │
│  └────────────────────────────────────────────────────┘
│
│  ▼ SQL Queries ▼
│
│  DATA ACCESS LAYER
│  ═════════════════════════════════════════════════════════
│  ┌────────────────────────────────────────────────────┐
│  │ Database Abstraction                               │
│  │  • config.php         (Connection & Interface)      │
│  │  • Prepared Statements (Safe Query Execution)       │
│  │  • Error Handling     (Graceful Failures)           │
│  └────────────────────────────────────────────────────┘
│
│  ▼ CRUD Operations ▼
│
│  DATABASE LAYER
│  ═════════════════════════════════════════════════════════
│  ┌────────────────────────────────────────────────────┐
│  │ MySQL Database (nexthm)                            │
│  │  • users table        (5 roles, ~7 attributes)      │
│  │  • Indexes            (email, role for performance) │
│  │  • Constraints        (PK, UQ, FK)                  │
│  └────────────────────────────────────────────────────┘
│
└──────────────────────────────────────────────────────────┘
```

## Key Technologies Used

```
┌─────────────────────────────────────────────────────────────┐
│              TECHNOLOGY STACK                              │
├─────────────────────────────────────────────────────────────┤
│
│  Backend Framework  │  PHP 7.x / 8.x
│                     │  • Session Management
│                     │  • Database Connectivity
│                     │  • Security Functions
│
│  Web Server         │  Apache 2.4 (via XAMPP)
│                     │  • HTTP Request Handler
│                     │  • URL Routing
│                     │  • Performance Optimization
│
│  Database           │  MySQL 5.7+ / MariaDB
│                     │  • User Data Storage
│                     │  • Prepared Statements
│                     │  • Indexes & Constraints
│
│  Frontend           │  HTML5 + CSS3
│                     │  • Bootstrap Framework
│                     │  • Font Awesome Icons
│                     │  • Responsive Design
│
│  Client-Side        │  JavaScript (Vanilla)
│                     │  • Form Validation
│                     │  • User Interactions
│                     │  • Dynamic Content
│
│  Security           │  PHP Built-in Functions
│                     │  • password_hash()
│                     │  • password_verify()
│                     │  • mysqli Prepared Statements
│                     │  • htmlspecialchars()
│
└─────────────────────────────────────────────────────────────┘
```

## Request/Response Lifecycle

```
┌─────────────────────────────────────────────────────────────┐
│          HTTP REQUEST/RESPONSE CYCLE                       │
├─────────────────────────────────────────────────────────────┤
│
│  1. CLIENT REQUEST
│     ═════════════════════════════════════════════════════════
│     Browser sends:
│     POST /process-login.php HTTP/1.1
│     Host: localhost/nexthm
│     Cookie: PHPSESSID=abc123...
│
│     Data:
│     {
│       email: "customer@test.com",
│       password: "CustomerPass123"
│     }
│
│  2. SERVER PROCESSING
│     ═════════════════════════════════════════════════════════
│     a) Accept request
│     b) Start session (retrieve or create)
│     c) Process login logic
│        ├─ Validate input
│        ├─ Query database
│        ├─ Check credentials
│        └─ Create session variables
│     d) Prepare response
│
│  3. SERVER RESPONSE
│     ═════════════════════════════════════════════════════════
│     HTTP/1.1 302 Found
│     Location: /dashboards/customer-dashboard.php
│     Set-Cookie: PHPSESSID=abc123; Path=/
│
│  4. BROWSER ACTION
│     ═════════════════════════════════════════════════════════
│     a) Store PHPSESSID cookie
│     b) Follow redirect to dashboard
│     c) Send GET request with cookie
│
│  5. DASHBOARD RESPONSE
│     ═════════────────────────────────────────────────────────
│     a) Retrieve session using PHPSESSID
│     b) Validate user role
│     c) Generate HTML dashboard
│     d) Send to browser
│
│  6. USER VIEWS DASHBOARD
│     ═════════════════════════════════════════════════════════
│     ✓ Dashboard displayed
│     ✓ Logged in status shown
│     ✓ User menu available
│     ✓ Logout button accessible
│
└─────────────────────────────────────────────────────────────┘
```

---

**Status**: ✅ Complete  
**Version**: 1.0  
**Last Updated**: February 2026
