# Real-Time Broker Dashboard - Testing & Verification Guide

## ✅ Pre-Launch Checklist

Use this guide to verify everything is working correctly before brokers start using the dashboard.

---

## Phase 1: Environment Setup Verification

### ✓ Check 1: Database Tables Exist

```sql
-- Verify these tables exist:
SHOW TABLES LIKE 'properties';
SHOW TABLES LIKE 'inquiries';
SHOW TABLES LIKE 'appointments';
SHOW TABLES LIKE 'broker_documents';
SHOW TABLES LIKE 'users';
```

**Expected Result**: All 5 tables exist and have data

### ✓ Check 2: Database Columns

```sql
-- properties table should have:
SELECT * FROM properties LIMIT 1;
-- Should include: id, title, price, city, status, broker_id, created_at
```

### ✓ Check 3: PHP Configuration

In browser console (F12), check:
```
- No critical errors
- API endpoints responding
- Session active
```

### ✓ Check 4: File Permissions

Verify files are readable:
```
- dashboards/broker-dashboard.php
- api/broker/get-stats.php
- api/broker/get-properties.php
- api/broker/get-leads.php
- api/broker/get-visits.php
- api/broker/get-documents.php
```

---

## Phase 2: API Endpoint Verification

### ✓ Test 1: Statistics API

**URL**: `http://localhost/nexthm/api/broker/get-stats.php`

**Test Steps**:
1. Login as broker first (creates session)
2. Visit the API URL
3. Should see JSON response

**Expected Response**:
```json
{
    "success": true,
    "stats": {
        "assigned_properties": [number],
        "active_leads": [number],
        "scheduled_visits": [number],
        "pending_documents": [number]
    }
}
```

### ✓ Test 2: Properties API

**URL**: `http://localhost/nexthm/api/broker/get-properties.php`

**Expected Response**:
```json
{
    "success": true,
    "properties": [
        {
            "id": 1,
            "title": "Property Name",
            "city": "City",
            "price": 500000,
            "status": "active",
            "inquiry_count": 2
        }
    ],
    "count": 1
}
```

### ✓ Test 3: Leads API

**URL**: `http://localhost/nexthm/api/broker/get-leads.php`

**Expected Response**:
```json
{
    "success": true,
    "leads": [
        {
            "id": 1,
            "customer_name": "John Doe",
            "email": "john@example.com",
            "property_title": "Property Name",
            "message": "Inquiry message",
            "status": "pending"
        }
    ],
    "count": 1
}
```

### ✓ Test 4: Site Visits API

**URL**: `http://localhost/nexthm/api/broker/get-visits.php`

**Expected Response**:
```json
{
    "success": true,
    "appointments": [
        {
            "id": 1,
            "customer_name": "Jane Smith",
            "phone": "+1-555-0123",
            "property_title": "Property Name",
            "appointment_date": "2024-02-15",
            "appointment_time": "14:00",
            "status": "pending"
        }
    ],
    "count": 1
}
```

### ✓ Test 5: Documents API

**URL**: `http://localhost/nexthm/api/broker/get-documents.php`

**Expected Response**:
```json
{
    "success": true,
    "documents": [
        {
            "id": 1,
            "document_name": "Certificate",
            "document_type": "certificate",
            "file_size": 2048,
            "approval_status": "pending",
            "uploaded_at": "2024-01-20"
        }
    ],
    "count": 1
}
```

---

## Phase 3: Frontend Functionality Testing

### ✓ Test 1: Dashboard Loading

**Test Steps**:
1. Clear browser cache (Ctrl+Shift+Delete)
2. Go to `/broker-login.php`
3. Login with broker credentials
4. Should be redirected to `/dashboards/broker-dashboard.php`

**Verify**:
- ✅ Dashboard loads without errors
- ✅ Header shows broker name and email
- ✅ Statistics cards visible
- ✅ Sidebar navigation shows all tabs
- ✅ Browser console shows no red errors

### ✓ Test 2: Real-Time Statistics

**Test Steps**:
1. Open dashboard
2. Note the stats numbers
3. Wait 5 seconds
4. Stats should remain same (no changes on backend)

**If You Have Test Data**:
1. Add a new property in admin panel
2. Wait 5 seconds
3. Property count should increase in broker dashboard

**Verify**:
- ✅ Stats update automatically
- ✅ No page refresh needed
- ✅ Browser console shows API calls
- ✅ Updates happen every 5 seconds

### ✓ Test 3: Tab Navigation

**Test Steps**:
1. Click each sidebar tab:
   - Dashboard
   - Properties
   - Leads
   - Site Visits
   - Documents

**Verify**:
- ✅ Tab content switches correctly
- ✅ No console errors
- ✅ Content loads within 1 second
- ✅ Responsive on mobile devices

### ✓ Test 4: Properties Tab

**Test Steps**:
1. Click "Properties" tab
2. Should see table with all assigned properties
3. Wait 5 seconds to see auto-update

**Verify**:
- ✅ All properties display
- ✅ Columns show: Name, Location, Price, Status, Inquiries, Date, Actions
- ✅ "View" and "Edit" buttons visible
- ✅ Inquiry count shows correctly

**If No Data**:
1. Check admin has assigned properties to broker
2. Reload page
3. Try again

### ✓ Test 5: Leads Tab

**Test Steps**:
1. Click "Leads" tab
2. Should see table with inquiries (if any exist)
3. For each lead:
   - Click "Respond" button
   - Enter test message
   - Click "Send Response"
   - Verify success notification

**Verify**:
- ✅ Leads display correctly
- ✅ Lead status shows properly
- ✅ Respond button opens modal
- ✅ Response message sends successfully
- ✅ Status changes to "Responded"
- ✅ Decline button works

### ✓ Test 6: Site Visits Tab

**Test Steps**:
1. Click "Site Visits" tab
2. Should see appointments (if any exist)
3. For each visit:
   - Click "Confirm" button
   - Verify success notification
   - Status should change to "Confirmed"

**Verify**:
- ✅ Visits display with all details
- ✅ Customer info shows correctly
- ✅ Date/time format correct
- ✅ Confirm button works
- ✅ Status updates immediately

### ✓ Test 7: Documents Tab

**Test Steps**:
1. Click "Documents" tab
2. View any uploaded documents
3. Check approval status shown correctly

**Verify**:
- ✅ Document list displays
- ✅ Status badges show correct colors:
   - Yellow for "Pending"
   - Green for "Approved"
   - Red for "Rejected"
- ✅ File sizes display correctly
- ✅ Download links work

---

## Phase 4: Real-Time Action Testing

### ✓ Test 1: Lead Response Flow

**Prerequisites**: 
- Broker must have at least 1 pending lead
- Create test lead via admin or customer inquiry

**Test Steps**:

```
1. Broker sees lead in "Leads" tab
2. Click "Respond" button
3. Modal opens
4. Enter response message: "Thank you for your inquiry..."
5. Click "Send Response"
6. Success notification appears: "Response sent successfully! ✅"
7. Modal closes automatically
8. Lead status changes to "Responded"
9. Lead disappears from pending list (if filtered)
```

**Verify Each Step**:
- ✅ Modal opens correctly
- ✅ Message sends without errors
- ✅ Success notification appears
- ✅ Status updates in real-time
- ✅ No page refresh needed

### ✓ Test 2: Lead Decline Flow

**Test Steps**:

```
1. Click "Decline" button on any lead
2. Confirmation dialog appears
3. Click "OK" to confirm
4. Success notification appears: "Lead declined ✅"
5. Lead status changes to "Declined"
6. Lead removed from active list
```

**Verify**:
- ✅ Confirmation dialog shows
- ✅ Decline processes without errors
- ✅ Notification shows success
- ✅ Lead disappears from dashboard

### ✓ Test 3: Visit Confirmation Flow

**Prerequisites**:
- Must have pending site visits

**Test Steps**:

```
1. Go to "Site Visits" tab
2. Click "Confirm" button on a visit
3. Status changes to "Confirmed"
4. Success notification appears
5. Visit updates immediately
```

**Verify**:
- ✅ Button click processes instantly
- ✅ Status updates without page refresh
- ✅ Notification shows
- ✅ No console errors

---

## Phase 5: Real-Time Updates Testing

### ✓ Test 1: 5-Second Polling

**Test Steps**:

```
1. Open browser Network tab (F12)
2. Go to dashboard
3. Watch for API calls:
   - Should see calls to get-stats.php
   - Should see calls to properties/leads/visits APIs
4. Wait 5 seconds
5. Should see same API calls repeat
6. Pattern repeats every 5 seconds
```

**Verify in Network Tab**:
- ✅ API calls every 5 seconds
- ✅ Response status 200 (OK)
- ✅ Response time < 500ms
- ✅ Response size < 100KB
- ✅ No errors in Network tab

### ✓ Test 2: Smart Tab Polling

**Test Steps**:

```
1. Open Network tab
2. Go to "Properties" tab
3. Watch: Should see properties API call
4. Switch to "Leads" tab
5. Watch: Should see leads API call, NOT properties
6. Properties tab data is NOT updated
7. Switch back to Properties
8. Properties data updates (was 5 seconds old)
```

**Verify**:
- ✅ Only visible tab API detected
- ✅ Invisible tabs skipped
- ✅ Reduces API calls significantly
- ✅ Improves browser performance

### ✓ Test 3: Real-Time Data Sync

**Test Steps** (Need 2 Browsers or 2 Windows):

```
Window 1 (Browser A):
1. Open dashboard as Broker A
2. Go to "Leads" tab
3. See 5 pending leads

Window 2 (Admin):
1. Create new inquiry as another customer
2. Assign to Broker A

Back to Window 1 (Browser A):
1. Wait 5 seconds
2. Leads count increases to 6
3. New lead appears in tab
```

**Verify**:
- ✅ New data appears within 5 seconds
- ✅ Multiple users see same data
- ✅ Real-time sync working

---

## Phase 6: Error Handling Testing

### ✓ Test 1: Session Timeout

**Test Steps**:

```
1. Login to dashboard
2. Leave idle for session timeout (usually 30 min)
3. Try any action (respond to lead, etc.)
4. Should see error or redirect to login
```

**Verify**:
- ✅ Handles timeout gracefully
- ✅ Shows appropriate error
- ✅ Redirects to login if needed

### ✓ Test 2: Network Error Handling

**Test Steps**:

```
1. Open dashboard
2. Disconnect internet
3. Wait for next polling cycle
4. Should show error notification
5. Reconnect internet
6. Should resume normal operation
```

**Verify**:
- ✅ Handles network errors
- ✅ Shows error notification
- ✅ Retries automatically
- ✅ Resumes when connection restored

### ✓ Test 3: Missing Data Handling

**Test Steps**:

```
1. Go to "Properties" tab with no properties
2. Should show "no data" message
3. Go to "Leads" with no leads
4. Should show "no data" message
```

**Verify**:
- ✅ Shows friendly "no data" message
- ✅ No console errors
- ✅ UI doesn't break

---

## Phase 7: Performance Testing

### ✓ Test 1: Load Time

**Using Browser DevTools**:

```
1. F12 > Performance tab
2. Click Record
3. Reload dashboard page
4. Click Stop
5. Check metrics:
   - First Contentful Paint (FCP): < 2 seconds
   - Largest Contentful Paint (LCP): < 3 seconds
   - Cumulative Layout Shift (CLS): < 0.1
```

**Verify**:
- ✅ Dashboard loads in < 3 seconds
- ✅ Content visible quickly
- ✅ API calls start immediately

### ✓ Test 2: Data Update Speed

**Test Steps**:

```
1. Use Network tab
2. Track API response times
3. Most requests: 100-500ms
4. Average: < 300ms
5. Max: < 1 second
```

**Verify**:
- ✅ API responses fast
- ✅ UI updates within 1 second
- ✅ Smooth experience

### ✓ Test 3: Memory Usage

**Using DevTools**:

```
1. F12 > Memory tab
2. Take heap snapshot
3. Dashboard memory: 2-5 MB
4. Stay on page 10+ minutes
5. Memory doesn't grow indefinitely
```

**Verify**:
- ✅ Low memory footprint
- ✅ No memory leaks
- ✅ Stable over time

---

## Phase 8: Mobile Responsiveness Testing

### ✓ Test 1: Responsive Design

**Test on Devices/Screen Sizes**:
- 📱 Mobile (375px - iPhone SE)
- 📱 Tablet (768px - iPad)
- 💻 Desktop (1920px - Full HD)

**Test Steps**:
```
1. Open dashboard on each device
2. Test navigation on all screen sizes
3. Click all buttons/links
4. Verify tables are readable
5. Test on orientation changes
```

**Verify**:
- ✅ Sidebar collapses on mobile
- ✅ Content readable on all sizes
- ✅ Buttons clickable on touch
- ✅ No overflow issues
- ✅ Orientation changes handled

### ✓ Test 2: Mobile Interactions

**Test Steps**:
```
1. On mobile device, open dashboard
2. Try responding to lead (modal opens)
3. Try declining lead
4. Try confirming visit
5. All should work smoothly
```

**Verify**:
- ✅ Modals visible on mobile
- ✅ Buttons easy to tap
- ✅ Text readable
- ✅ No layout breaks

---

## Phase 9: Security Testing

### ✓ Test 1: Authorization

**Test Steps**:

```
1. Logout from broker dashboard
2. Try accessing /dashboards/broker-dashboard.php directly
3. Should redirect to login
4. Login as different role (admin, staff)
5. Should NOT see broker dashboard
```

**Verify**:
- ✅ Non-authenticated users redirected
- ✅ Wrong role can't access
- ✅ Can only see own data

### ✓ Test 2: XSS Prevention

**Test Steps**:

```
1. Try to submit lead response with XSS payload:
   "<script>alert('xss')</script>"
2. Message should be escaped/sanitized
3. No alert should appear
4. Message stored safely in database
```

**Verify**:
- ✅ XSS attacks prevented
- ✅ Input properly escaped
- ✅ Data stored safely

### ✓ Test 3: CSRF Protection

**Test Steps**:

```
1. Form submissions should include CSRF tokens
2. All API calls verified as coming from browser
3. No cross-site requests possible
```

**Verify**:
- ✅ Session tokens valid
- ✅ No CSRF vulnerabilities
- ✅ Secure form submissions

---

## Phase 10: Browser Compatibility Testing

### ✓ Test on Browsers

Test on:
- ✅ Chrome 90+
- ✅ Firefox 88+
- ✅ Safari 14+
- ✅ Edge 90+
- ⚠️ Internet Explorer (not supported - show message)

**Test Each**:
```
1. Dashboard loads
2. All tabs work
3. Actions work
4. No console errors
5. Styling looks correct
```

---

## Final Pre-Launch Checklist

Before going to production:

- [ ] All 10 phases testing complete
- [ ] No console errors
- [ ] All buttons clickable
- [ ] All modals working
- [ ] Real-time updates working
- [ ] Error handling functional
- [ ] Mobile responsive
- [ ] Performance acceptable
- [ ] Security checks passed
- [ ] Browser compatibility verified

---

## Launch Checklist

**Before brokers use**:

1. **Database**
   - [ ] Backup database
   - [ ] Verify tables exist
   - [ ] Verify sample data

2. **API**
   - [ ] All endpoints accessible
   - [ ] Response times acceptable
   - [ ] Error handling working

3. **Dashboard**
   - [ ] Loads without errors
   - [ ] Real-time updates working
   - [ ] All features functional

4. **Security**
   - [ ] HTTPS enabled
   - [ ] Session timeout set
   - [ ] Admin can manage brokers

5. **Documentation**
   - [ ] BROKER_REALTIME_IMPLEMENTATION.md ready
   - [ ] BROKER_REALTIME_QUICKSTART.md ready
   - [ ] Training materials prepared
   - [ ] Support plan in place

6. **Monitoring**
   - [ ] Error logs set up
   - [ ] Performance monitoring active
   - [ ] User activity tracking enabled
   - [ ] Support contact information available

---

## Troubleshooting Checklist

If something doesn't work:

| Issue | Solution |
|-------|----------|
| Dashboard won't load | Clear cache, check PHP errors, verify session |
| No data appearing | Check database tables, verify broker assigned properties |
| Real-time not updating | Check Network tab, verify API calls, wait 5 seconds |
| Buttons not working | Check console errors, verify API permissions |
| Styling looks wrong | Clear cache, F5 refresh, check if CSS files loading |
| Mobile not responsive | Test on actual device, clear cache |

---

## Success Criteria

Dashboard is ready when:

✅ All 10 test phases complete  
✅ No critical errors found  
✅ Performance acceptable (<3s load)  
✅ Real-time updates work (every 5s)  
✅ Mobile responsive on all devices  
✅ Security checks passed  
✅ Cross-browser compatible  
✅ Documentation complete  
✅ Support team trained  
✅ Monitoring active  

---

**Testing Version**: 1.0  
**Last Updated**: February 2024  
**Status**: Ready for Launch  

