# Customer Reviews System - Quick Start Guide

## System Overview

A complete customer reviews management system has been implemented with the following features:
- ✅ Customer review submission via dashboard
- ✅ Admin approval/rejection workflow
- ✅ Dynamic review carousel on about page
- ✅ Fully responsive design (mobile, tablet, desktop)
- ✅ Real-time updates and status tracking

## How to Use

### For Customers

1. **Log into Customer Dashboard**
   - Go to `/dashboards/customer-dashboard.php`
   - Navigate to "Feedback" section in sidebar

2. **Submit a Review**
   - Select rating (1-5 stars)
   - Write your feedback message (minimum 10 characters)
   - Click "Submit Feedback"
   - See success message: "Review submitted successfully and pending admin approval"

3. **Track Your Reviews**
   - View all your submitted reviews in "Your Feedback History"
   - See the approval status: Pending → Approved or Rejected
   - Once approved, review will appear on the about page

### For Admins

1. **Log into Admin Dashboard**
   - Go to `/dashboards/admin-dashboard.php`
   - Click "Customer Feedback" in sidebar

2. **Review Submissions**
   - Default view shows "Pending" reviews
   - Each review card shows:
     - Customer name
     - Submission date/time
     - Star rating
     - Full review text

3. **Take Action**
   - **Approve**: Click green "Approve" button
     - Review goes live on about.php
     - Customer sees "Approved" status
     - Review appears in slider carousel
   
   - **Reject**: Click red "Reject" button
     - Review hidden from public
     - Customer sees "Rejected" status
     - Review appears in "Rejected" tab for records

4. **Filter Reviews**
   - **Pending** tab: Reviews awaiting decision
   - **Approved** tab: Live reviews (shown on about page)
   - **Rejected** tab: Hidden reviews
   - **All Reviews** tab: Complete history

5. **Real-time Updates**
   - Review counts update instantly
   - Counts shown in tab headers
   - Refresh button available anytime

### For Visitors

1. **View Reviews on About Page**
   - Go to `/about.php`
   - Scroll to "Trusted By Our Happy Clients" section
   - Slider automatically plays through reviews (5-second intervals)

2. **Navigate Reviews**
   - Click left arrow (◀) for previous review
   - Click right arrow (▶) for next review
   - Click dot indicator to jump to specific review

3. **Responsive Experience**
   - Desktop: See 3 reviews at once
   - Tablet: See 2 reviews at once
   - Mobile: See 1 review at a time
   - Auto-adjusts for screen size

## Technical Integration Details

### Database Changes
The `reviews` table now includes approval workflow:
```sql
-- Status values
'pending'   - Awaiting admin approval
'approved'  - Visible on about page
'rejected'  - Hidden from public

-- Default: status = 'pending'
-- Indexes: status column (for fast filtering)
```

### File Structure
```
/about.php                           - Review carousel display
/dashboards/customer-dashboard.php   - Customer feedback form
/dashboards/admin-dashboard.php      - Admin approval interface
/api/feedback-submit.php             - Customer submittal endpoint
/api/reviews-manage.php              - Admin action endpoint
/api/get-customer-feedback.php       - Customer history endpoint
/config.php                          - Database schema
```

### API Endpoints

#### POST /api/feedback-submit.php
Customer submits review
```json
{
  "message": "Review text here...",
  "rating": 5
}
```

#### GET /api/reviews-manage.php?action=get-pending&status=pending
Admin fetches pending reviews
```json
{
  "success": true,
  "reviews": [{...}],
  "counts": {"pending": 5, "approved": 12, "rejected": 2}
}
```

#### POST /api/reviews-manage.php
Admin approves/rejects
```
action=approve&id=123
action=reject&id=123
```

#### GET /api/get-customer-feedback.php
Customer fetches their reviews
```json
{
  "success": true,
  "feedback": [{...}]
}
```

## Display Features

### About Page Slider
- **Auto-play**: 5-second interval
- **Navigation**: Previous/Next buttons
- **Indicators**: Dot indicators (clickable)
- **Responsive**: 3 → 2 → 1 slides based on screen
- **Star Display**: ★★★★★ format
- **Avatar**: Customer initials in gradient circle
- **Status**: Only "approved" reviews show

### Admin Dashboard
- **Real-time counts**: Pending/Approved/Rejected
- **Status badges**: Color-coded in cards
- **Action buttons**: Approve (green) / Reject (red)
- **Confirmation**: Dialog confirmation before action
- **Feedback**: Success/Error messages

### Customer Dashboard
- **Status tracking**: See review approval status
- **History**: All submitted reviews listed
- **Dates**: Formatted submission dates
- **Ratings**: Star display for each review

## Customization

### Change Auto-play Speed
In `/about.php`, find the Slick initialization:
```javascript
autoplaySpeed: 5000,  // Change 5000 to desired milliseconds
```

### Change Responsive Breakpoints
Find the responsive settings in the Slick slider config:
```javascript
{
  breakpoint: 1200,  // Change to your breakpoint
  settings: {
    slidesToShow: 2   // Adjust slides visible
  }
}
```

### Change Colors
Admin dashboard action buttons in `/dashboards/admin-dashboard.php`:
- Approve button: `background: #10b981` (change hex color)
- Reject button: `background: #ef4444` (change hex color)

### Change Success Message
In `/api/feedback-submit.php`:
```php
'message' => 'Review submitted successfully and pending admin approval'
// Change to custom message
```

## Troubleshooting

### Reviews not showing on about.php
1. Check reviews table in database
2. Verify review status = 'approved'
3. Clear browser cache
4. Check console for JavaScript errors

### Admin can't see reviews
1. Verify user role is 'admin'
2. Check session is active
3. Verify reviews table exists with status column
4. Check API endpoint: `/api/reviews-manage.php`

### Customer feedback form not submitting
1. Fill all required fields (rating, message 10+ characters)
2. Check browser console for errors
3. Verify `/api/feedback-submit.php` is accessible
4. Check customer is logged in (session valid)

### Slider not working
1. Verify Slick Slider library loaded: Check `/assets/js/slick.min.js`
2. Check console for JavaScript errors
3. Verify reviews exist (fallback static reviews should show if empty)
4. Clear cache and reload

## Security Features

- ✅ Session validation on all endpoints
- ✅ Role-based access control (customer/admin)
- ✅ Prepared statements (SQL injection prevention)
- ✅ Input validation and sanitization
- ✅ HTML escaping for display
- ✅ Confirmation dialogs for destructive actions
- ✅ Error handling without exposing system details

## Performance Optimizations

- ✅ Database indexes on status and created_at columns
- ✅ LIMIT clauses to reduce query results
- ✅ Lazy loading with pagination
- ✅ Slick Slider: Minimal DOM manipulation
- ✅ CSS on-demand with responsive design
- ✅ Efficient JavaScript with event delegation

## Mobile Optimizations

- ✅ Touch-friendly button sizes (50px minimum)
- ✅ Responsive font sizes
- ✅ Optimized spacing for small screens
- ✅ Single column layout on mobile
- ✅ Fast-loading slider images
- ✅ Accessible color contrast

---

## Support

For issues or questions:
1. Check the CUSTOMER_REVIEWS_IMPLEMENTATION.md file for detailed technical docs
2. Review API error responses in browser console
3. Check database connectivity in config.php
4. Verify file permissions on `/api/` directory
