# Forgot Password System - Quick Setup Guide

## 🚀 Quick Start (5 Minutes)

### Step 1: Configure Email Settings
Edit `auth-helpers.php` (Line 19-23):

```php
$mail->Host       = 'smtp.gmail.com';          // SMTP Server
$mail->Username   = 'your-email@gmail.com';    // Your Email
$mail->Password   = 'your-app-password';       // App Password
```

### Step 2: Database Ready
✅ `password_resets` table is auto-created in `config.php`

### Step 3: Test the System
1. Go to `http://your-domain.com/forgot-password.php`
2. Enter registered email
3. Enter OTP from email
4. Set new password (minimum requirements shown)
5. Login with new password

## 📋 Email Configuration Guide

### Gmail
1. Settings → Account → Security
2. Enable 2-Step Verification
3. Generate App Password
4. Copy 16-character password
5. Paste in `auth-helpers.php`

### Outlook/Office 365
```php
$mail->Host = 'smtp-mail.outlook.com';
$mail->Port = 587;
```

### Custom SMTP
```php
$mail->Host = 'mail.yourdomain.com';
$mail->Port = 587; // or 465 for SSL
$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // or TLS
```

## 🔒 Security Features Included

✅ 6-digit OTP with 15-minute expiry  
✅ One-time use verification  
✅ Strong password validation  
✅ Email confirmation required  
✅ Session-based verification  
✅ CSRF protection  
✅ Rate limiting (60s resend cooldown)  

## 📱 Responsive Features

✅ Desktop optimized layouts  
✅ Tablet-friendly grid  
✅ Mobile-first design  
✅ Touch-friendly inputs  
✅ Auto-focus OTP fields  
✅ Countdown timers  

## 🔧 Password Requirements Display

Real-time validation shows:
- ✅/❌ At least 8 characters
- ✅/❌ One uppercase letter
- ✅/❌ One lowercase letter
- ✅/❌ One number
- ✅/❌ Passwords match

## 📞 Key Pages

```
forgot-password.php
    ↓ (Enter email)
process-forgot-password.php (Generate OTP)
    ↓ (Check email)
verify-otp.php
    ↓ (Enter 6-digit code)
process-verify-otp.php (Verify OTP)
    ↓ (Code valid)
reset-password.php
    ↓ (Set new password)
process-reset-password.php (Update database)
    ↓ (Success!)
login.php (Login with new password)
```

## 🆘 Troubleshooting

**OTP not received?**
- Check email configuration
- Check spam folder
- Verify SMTP settings
- Review server logs

**Password too weak?**
- Add more characters
- Include uppercase letter
- Include number
- Check requirements below input

**"Invalid OTP" error?**
- Check OTP hasn't expired (15 min)
- Verify you entered correct code
- Try resend (60s cooldown)

## ✅ Testing Checklist

- [ ] Email configuration updated
- [ ] Can access forgot-password.php
- [ ] OTP received in email
- [ ] Can verify OTP code
- [ ] Password validation works
- [ ] Password successfully resets
- [ ] Can login with new password
- [ ] Mobile responsive works
- [ ] Error messages display correctly

## 📊 Database Query (Optional)

Check OTP table:
```sql
SELECT * FROM password_resets WHERE email = 'user@example.com';
```

View reset history:
```sql
SELECT email, created_at, is_used, verified_at 
FROM password_resets 
ORDER BY created_at DESC 
LIMIT 10;
```

## 🎨 Customization

### Change OTP Expiry Time
In `auth-helpers.php` > `storeOTP()`:
```php
DATE_ADD(NOW(), INTERVAL 15 MINUTE)  // Change 15 to your preferred minutes
```

### Change Colors
Edit CSS in respective `.php` files:
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
/* Change to your brand colors */
```

### Change Email Template
Edit HTML email in `sendOTPEmail()` function in `auth-helpers.php`

## 📚 Related Files

- `config.php` - Database configuration
- `auth-helpers.php` - All helper functions
- `login.php` - Updated with success messages
- `forgot-password.php` - Entry page
- `verify-otp.php` - OTP verification
- `reset-password.php` - New password setup
- `process-*.php` - Backend handlers (5 files)

## 🎯 Best Practices

1. **Always use HTTPS** in production
2. **Test email configuration** before going live
3. **Monitor OTP table** for cleanup of old records
4. **Log password reset attempts** for security
5. **Use strong SMTP credentials** never in comments
6. **Regularly update** PHPMailer library
7. **Test on multiple devices** before launching

## 💡 Pro Tips

- OTP uses secure random generation
- Passwords hashed with PASSWORD_BCRYPT
- Session tokens prevent direct URL access
- Email verification prevents account enumeration
- All timestamps in UTC format

---

**Need Help?** Check FORGOT_PASSWORD_SYSTEM.md for detailed documentation.
