# Hero Slider Management System - Admin Dashboard Integration

## Overview
The Hero Slider Management System has been successfully integrated into your Admin Dashboard, allowing real-time management of hero slider content with full CRUD operations (Create, Read, Update, Delete).

## Features

### ✨ Real-Time Management
- **Add New Slides**: Create new hero sliders with custom content
- **Edit Slides**: Modify existing slider content instantly
- **Delete Slides**: Remove unwanted slides with confirmation
- **Real-Time Updates**: Changes appear immediately without page refresh
- **Status Control**: Activate or deactivate slides on demand

### 📊 Content Management
Each hero slider supports:
- **Tag/Category**: Categorize your sliders
- **Title**: Main heading text
- **Subtitle**: Detailed description
- **Action Buttons**: Two customizable CTA buttons with URLs
- **Background Image**: Custom hero image
- **Statistics**: Two stat blocks with icons and text
- **Display Order**: Control slide sequence
- **Status**: Active/Inactive toggle

## Access the Hero Slider Management

### Method 1: From Admin Dashboard
1. Navigate to Admin Dashboard: `http://localhost/nexthm/dashboards/admin-dashboard.php`
2. Click on **"Hero Slider"** in the left sidebar
3. The Hero Slider Management panel will load

### Method 2: Direct Access
Open in your browser: `http://localhost/nexthm/dashboards/admin-dashboard.php?section=heroSliderPanel`

## How to Use

### Adding a New Hero Slider

1. Click the **"+ Add New Slider"** button in the Hero Slider panel
2. Fill in all the fields:
   - **Tag/Category**: e.g., "Premium Properties"
   - **Main Title**: e.g., "Find Your Dream Apartment"
   - **Subtitle**: Detailed description text
   - **Button 1 Text & URL**: Primary CTA
   - **Button 2 Text & URL**: Secondary CTA
   - **Background Image URL**: Path to hero image
   - **Stat 1 & 2**: Icon classes and text
   - **Display Order**: Position in slider sequence
   - **Status**: Select Active or Inactive

3. Click **"Save Slider"**
4. Success message appears, slider added to list
5. Changes appear immediately on the homepage

### Editing an Existing Slider

1. Find the slider you want to edit in the Heroes Slider list
2. Click the **"Edit"** button on the slider card
3. The modal opens with current values pre-filled
4. Make your changes
5. Click **"Save Slider"**
6. Changes are instantly updated

### Deleting a Slider

1. Click the **"Delete"** button on the slider card
2. Confirm the deletion
3. Slider is immediately removed from the database and homepage

## Database Schema

The system automatically creates the `hero_sliders` table with the following structure:

```sql
CREATE TABLE hero_sliders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tag VARCHAR(100),
    title VARCHAR(255) NOT NULL,
    subtitle TEXT NOT NULL,
    button1_text VARCHAR(100),
    button1_url VARCHAR(255),
    button2_text VARCHAR(100),
    button2_url VARCHAR(255),
    image_url VARCHAR(255),
    stat1_icon VARCHAR(100),
    stat1_text VARCHAR(255),
    stat2_icon VARCHAR(100),
    stat2_text VARCHAR(255),
    display_order INT DEFAULT 0,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)
```

## File Structure

```
dashboards/
├── admin-dashboard.php       # Main dashboard with hero slider panel
api/
├── hero-slider.php           # Backend API for CRUD operations
```

### API Endpoints

All requests use POST/GET to `api/hero-slider.php`:

#### Get All Sliders
```
GET: api/hero-slider.php?action=get_all
```

#### Add New Slider
```
POST: api/hero-slider.php
FormData:
  - action: "add"
  - tag, title, subtitle, button1_text, button1_url
  - button2_text, button2_url, image_url
  - stat1_icon, stat1_text, stat2_icon, stat2_text
  - display_order, status
```

#### Update Slider
```
POST: api/hero-slider.php
FormData:
  - action: "update"
  - id: [slider_id]
  - [same fields as add]
```

#### Delete Slider
```
POST: api/hero-slider.php
FormData:
  - action: "delete"
  - id: [slider_id]
```

## Frontend Integration

The hero slider on your homepage (`index.php`) automatically fetches data from the database:

```php
// Fetches active sliders in display order
$query_hero = "SELECT * FROM hero_sliders WHERE status = 'active' ORDER BY display_order ASC";
```

Changes made in the admin panel are instantly reflected on the homepage.

## Example Data

When you first create sliders in the admin panel, here's an example:

**Slide 1 - Premium Properties**
- Tag: Premium Properties
- Title: Find Your Dream Apartment Today
- Subtitle: Discover luxury apartments in prime locations...
- Button 1: Explore Properties → properties.html
- Button 2: Contact Us → contact.php
- Image: assets/img/hero/hero1.png
- Stats: 22K+ Properties Listed | 140K+ Happy Customers

## Security Features

✅ **XSS Protection**: htmlspecialchars() prevents injection attacks
✅ **SQL Escaping**: real_escape_string() for safe database queries
✅ **Authentication**: Only logged-in admins can access
✅ **Authorization**: Role-based access control (admin only)

## Troubleshooting

### Hero sliders not showing on homepage?
1. Check if `hero_sliders` table exists in database
2. Verify sliders have `status = 'active'`
3. Clear browser cache (Ctrl+F5)
4. Refresh the homepage

### Changes not appearing immediately?
1. Hard refresh page (Ctrl+Shift+R)
2. Check browser console for JS errors
3. Verify database connection in config.php

### Images not loading?
1. Check image path is correct
2. Verify image file exists at specified location
3. Ensure file permissions allow reading

## Best Practices

1. **Use Relative Paths**: Use paths like `assets/img/hero/image.png` not full URLs
2. **Font Awesome Icons**: Use valid FA classes like `fas fa-check-circle`
3. **Descriptive Content**: Write compelling titles and subtitles
4. **Image Optimization**: Use compressed images for faster loading
5. **Order Properly**: Set display_order to control slide sequence
6. **Test Links**: Verify all button URLs work before publishing

## Performance Tips

- Database table is indexed with auto-increment primary key
- Active/Inactive status filters reduce query load
- Limit sliders to 5-10 for optimal carousel performance
- Use optimized images (JPG/WebP, < 500KB recommended)

## Support & Maintenance

The system is fully self-contained and requires no external dependencies beyond what's already in your project:
- PHP with MySQLi
- Bootstrap 5 (for styling)
- Font Awesome (for icons)
- jQuery & Slick Carousel (for animations)

## Next Steps

1. ✅ Access the Admin Dashboard Hero Slider section
2. ✅ Add your first hero slider
3. ✅ Verify it appears on the homepage
4. ✅ Edit and customize as needed
5. ✅ Manage your hero content without touching code!

---

**Created**: February 19, 2026  
**Status**: Production Ready  
**Version**: 1.0
