# Hero Slider Admin - Quick Start Guide

## 🚀 Get Started in 5 Minutes

### Step 1: Open Admin Dashboard
```
http://localhost/nexthm/dashboards/admin-dashboard.php
```

### Step 2: Navigate to Hero Slider
Click **"Hero Slider"** in the left sidebar menu

### Step 3: Create Your First Slider
Click **[+ Add New Slider]** button

### Step 4: Fill the Form
```
Tag:                    Premium Properties
Title:                  Find Your Dream Apartment
Subtitle:               Discover luxury apartments in prime locations...
Button 1 Text:          Explore Properties
Button 1 URL:           properties.html
Button 2 Text:          Contact Us
Button 2 URL:           contact.php
Image URL:              assets/img/hero/image.png
Stat 1 Icon:            fas fa-check-circle
Stat 1 Text:            22K+ Properties Listed
Stat 2 Icon:            fas fa-users
Stat 2 Text:            140K+ Happy Customers
Display Order:          1
Status:                 Active
```

### Step 5: Save & Verify
1. Click **[Save Slider]**
2. See success message
3. Go to homepage: `http://localhost/nexthm/index.php`
4. Hero slider now displays your content!

---

## 🎯 Common Tasks

### Edit a Slider
1. Find the slider in the grid
2. Click **[Edit]**
3. Modify fields
4. Click **[Save Slider]**
✅ Changes appear immediately!

### Delete a Slider
1. Find the slider in the grid
2. Click **[Delete]**
3. Confirm deletion
✅ Removed instantly!

### Reorder Sliders
1. Edit each slider
2. Change **Display Order** (1, 2, 3, ...)
3. Save
✅ They appear in order on homepage!

### Deactivate a Slider
1. Edit the slider
2. Change **Status** to **Inactive**
3. Save
✅ Won't display on homepage anymore!

---

## 📋 Field Reference

| Field | Purpose | Example |
|-------|---------|---------|
| **Tag** | Category/Label | Premium Properties |
| **Title** | Main heading | Find Your Dream Apartment |
| **Subtitle** | Description text | Discover luxury apartments... |
| **Button 1-2** | CTA links | Explore / Contact |
| **Image URL** | Background image | assets/img/hero/hero1.png |
| **Stats** | Key metrics | 22K+ Properties Listed |
| **Display Order** | Position in slider | 1, 2, 3... |
| **Status** | Publish state | Active/Inactive |

---

## 🖼️ Image Setup

### Where to Put Images
```
nexthm/
├── assets/
│   └── img/
│       └── hero/
│           ├── hero1.png
│           ├── hero2.png
│           └── hero3.png
```

### Image URL Format
```
In Admin Panel, use:
assets/img/hero/hero1.png

Do NOT use full URLs:
❌ http://localhost/nexthm/assets/img/hero/hero1.png
✅ assets/img/hero/hero1.png
```

### Image Requirements
- Format: JPG, PNG, WebP
- Size: 1920x600px recommended
- File Size: < 500KB
- Quality: High resolution

---

## 🎨 Icon Reference

### Common Font Awesome Icons

```
fas fa-check-circle      ✓ (Checkmark)
fas fa-users             👥 (People)
fas fa-home              🏠 (House)
fas fa-building          🏢 (Building)
fas fa-chart-line        📈 (Graph)
fas fa-shield-alt        🛡️ (Shield)
fas fa-map-marker-alt    📍 (Location)
fas fa-handshake         🤝 (Handshake)
fas fa-star              ⭐ (Star)
fas fa-heart             ❤️ (Heart)
fas fa-phone             📞 (Phone)
fas fa-envelope          ✉️ (Email)
```

**Find More**: fontawesome.com/icons

---

## 💾 Example Data

### Slide 1 - Luxury Apartments
```
Tag:          Premium Properties
Title:        Find Your Dream Apartment Today
Subtitle:     Discover luxury apartments in prime locations with 
              verified documents and expert guidance
Button 1:     Explore Properties → properties.html
Button 2:     Contact Us → contact.php
Image:        assets/img/hero/Copilot_20260219_135217.png
Stat 1:       fas fa-check-circle → 22K+ Properties Listed
Stat 2:       fas fa-users → 140K+ Happy Customers
Order:        1
Status:       Active
```

### Slide 2 - Smart Investments
```
Tag:          Business Opportunities
Title:        Real Estate Investment Made Easy
Subtitle:     Access verified properties with legal documentation,
              loan assistance, and expert investment consultation
Button 1:     Start Investing → properties.html
Button 2:     Consult Expert → contact.php
Image:        assets/img/hero/hero2.png
Stat 1:       fas fa-shield-alt → 100% Legal Verified
Stat 2:       fas fa-map-marker-alt → Prime Locations Only
Order:        2
Status:       Active
```

---

## 🔗 Button URLs

### Internal Pages
```
properties.html
services.html
blog.html
contact.php
about.php
```

### External Links
```
https://facebook.com/yourpage
https://whatsapp.me/yourphone
https://instagram.com/yourprofile
```

### Email Link
```
mailto:info@yourdomain.com
```

---

## ✨ Real-Time Features

✅ **No Page Reload** - Changes appear instantly
✅ **No Coding** - Pure form-based management
✅ **Live Preview** - See changes immediately on homepage
✅ **Status Control** - Activate/deactivate without deleting
✅ **Reordering** - Change display order anytime
✅ **Safe Deletion** - Confirmation prevents accidents
✅ **Error Messages** - Clear feedback if something fails

---

## 🆘 Troubleshooting

### Slider not showing on homepage?
```
1. Go to admin panel
2. Check Status = "Active"
3. Check display_order is set
4. Go to homepage
5. Refresh (Ctrl+F5)
```

### Images not loading?
```
1. Verify image file exists
2. Check image path is correct
3. Use relative path (not full URL)
4. Try JPG instead of PNG
5. Check file size < 500KB
```

### Changes not saving?
```
1. Check all required fields filled (marked in form)
2. Check browser console (F12)
3. Verify database connection
4. Try different browser
5. Clear cache (Ctrl+Shift+Delete)
```

### Admin menu not showing?
```
1. Check you're logged in as ADMIN
2. Check user role in database
3. Refresh page
4. Log out and back in
```

---

## 📞 Support Files

Need help? Check these files:

- **`HERO_SLIDER_ADMIN_GUIDE.md`** - Complete user guide
- **`HERO_SLIDER_FILE_CHANGES.md`** - Technical details
- **`HERO_SLIDER_ADMIN_IMPLEMENTATION.md`** - Implementation info

---

## 🎓 Video Tutorial (DIY)

### Record these steps:
1. Open admin dashboard
2. Click Hero Slider menu
3. Click Add New Slider
4. Fill in example data
5. Click Save
6. Show success message
7. Go to homepage
8. Show slider displaying

### Share with team!

---

## ⚡ Pro Tips

### 💡 Tip 1: Use Numbered Order
```
Order: 1, 2, 3, 4, 5
(If you skip numbers, carousel still works fine)
```

### 💡 Tip 2: Test Before Publishing
```
Set Status to "Inactive"
Submit content for review
Activate when approved
```

### 💡 Tip 3: Keywords for SEO
```
Use keywords in:
- Title
- Subtitle
- Button text
(Helps search engines find your content)
```

### 💡 Tip 4: Image Compression
```
Online tools:
- tinypng.com
- compressor.io
- kraken.io
Reduces file size by 50-80%!
```

### 💡 Tip 5: Mobile Preview
```
Desktop: 1920x600px
Tablet: 768x400px
Mobile: 375x280px
(Homepage handles responsive automatically)
```

---

## 🔐 Security Notes

✅ All input is validated
✅ XSS attacks prevented
✅ SQL injection prevented
✅ Admin-only access
✅ No sensitive data exposed

**Safe to use with confidence!**

---

## 📊 Dashboard Analytics

### Coming Soon Features:
- [ ] View count statistics
- [ ] Click-through tracking
- [ ] Performance metrics
- [ ] A/B testing

---

## 🎉 You're All Set!

**Now Go Manage Your Hero Sliders!**

```
1. ✅ Admin Dashboard open
2. ✅ Hero Slider menu accessed
3. ✅ Add first slider
4. ✅ See results on homepage
5. ✅ Start managing content!
```

**Questions?** Check the full guides in your project root folder.

---

**Status**: Ready to Use ✨
**Last Updated**: February 19, 2026
**Version**: 1.0

