# Real-Time Dashboard - Troubleshooting Guide

## 🔧 Common Issues & Solutions

---

## ❌ Favorites not showing in Dashboard

### Symptoms:
- Added favorite on properties page
- Heart turns red
- Doesn't appear in Dashboard → Favorites

### Solutions:

**Step 1: Verify Login**
- Are you logged in as CUSTOMER?
- Check sidebar - should show your name
- Not logged in? → Go to [login.php](login.php)

**Step 2: Wait for Polling**
- Real-time updates happen every 5 seconds
- Wait 5-10 seconds after adding favorite
- Don't refresh page immediately!

**Step 3: Manual Refresh**
- If still not showing, refresh page (F5)
- Or use hard refresh (Ctrl+F5)
- Clear cache if needed

**Step 4: Check Browser Console**
- Press F12 to open Developer Tools
- Go to Console tab
- Look for error messages
- Take screenshot of errors

**Step 5: Verify Database**
- Check if `favorites` table exists
- Go to [verify-realtime-setup.php](verify-realtime-setup.php)
- Look for Database Table section
- All items should show ✅

---

## ❌ Appointments not saving

### Symptoms:
- Fill appointment form
- Click "Schedule Visit"
- Form doesn't submit or no change

### Solutions:

**Step 1: Check Required Fields**
```
Must have:
✅ Property selected (not "-- Choose Property --")
✅ Date selected (must be today or future date)
✅ Time selected (format: HH:MM)
✅ All three filled!
```

**Step 2: Verify Date Format**
- Date must be today or in future
- Can't schedule in past
- Format should be: YYYY-MM-DD
- Try a date 1 week from today

**Step 3: Try Different Property**
- Try another property from dropdown
- Some properties might have issues
- Try 2-3 different properties

**Step 4: Check Console Errors**
- Press F12 → Console tab
- Try scheduling again
- Look for error messages
- Get error text and check documentation

**Step 5: Reload Page**
- Hard refresh page (Ctrl+F5)
- Try again from fresh state
- Might be temporary issue

---

## ❌ Inquiries not submitting

### Symptoms:
- Fill inquiry form
- Click "Send Inquiry"
- Nothing happens or error appears

### Solutions:

**Step 1: Check Required Fields**
```
Must have:
✅ Property selected
✅ Message entered (not empty)
✅ Both required!
```

**Step 2: Verify Message Length**
- Message should be at least 10 characters
- Try typing a longer message
- Avoid single words

**Step 3: Check Login Status**
- Log out completely
- Log back in
- Try again
- Might be session issue

**Step 4: Try Different Property**
- Select different property
- Try sending inquiry
- See if it works with different property

**Step 5: Check Network Tab**
- Press F12 → Network tab
- Send inquiry
- Look for API call to `inquiry-add.php`
- Check Response tab
- Should show `"success": true`

---

## ❌ Dashboard not updating in real-time

### Symptoms:
- Changes not appearing automatically
- Must manually refresh
- No real-time sync

### Solutions:

**Step 1: Wait for Next Poll**
- Real-time updates every 5 seconds
- Wait 10 seconds maximum
- Don't assume it's broken immediately

**Step 2: Check JavaScript Console**
- Press F12 → Console
- Should see info messages (not errors)
- If JavaScript errors: document them

**Step 3: Restart Browser**
- Close all browser windows
- Reopen browser
- Go to dashboard clean
- Try again from fresh start

**Step 4: Try Different Browser**
- Try Chrome, Firefox, Safari, or Edge
- See if issue is browser-specific
- Use different browser to isolate problem

**Step 5: Clear Browser Cache**
- Press Ctrl+Shift+Delete
- Choose "All time"
- Check: Cookies and cached files
- Click Clear Data
- Refresh dashboard

---

## ❌ Sidebar stats not updating

### Symptoms:
- Add favorite, count doesn't change
- Schedule appointment, count stays same
- Stats frozen

### Solutions:

**Step 1: Check Sidebar Display**
- Look at right side of dashboard
- Should show:
  - ❤️ Favorites (number)
  - 📅 Appointments (number)
  - 💬 Inquiries (number)

**Step 2: Wait for Update**
- Click favorite
- Wait 5 seconds
- Check if count increases
- Try again if not

**Step 3: Refresh Sidebar**
- Scroll down then up
- Or switch sections and back
- Might help refresh display

**Step 4: Hard Refresh Page**
- Ctrl+F5 (Windows/Linux)
- Cmd+Shift+R (Mac)
- Wait for page to load completely

---

## ❌ Profile changes not saving

### Symptoms:
- Update name/email/phone
- Click "Save Changes"
- Changes don't save

### Solutions:

**Step 1: Verify Form Fields**
- Make sure you actually changed something
- Don't try to save empty changes
- Fill at least one field

**Step 2: Check Email Format**
- If updating email, must be valid format
- Example: name@example.com
- Not: name@, @example, or name

**Step 3: Check Phone Format**
- Phone should be numbers and symbols only
- Example: +1-555-123-4567 ✅
- Example: 555-123-4567 ✅
- Example: Call me sometime ❌

**Step 4: Wait for Confirmation**
- After clicking Save
- Should see success message
- Wait a few seconds
- Then verify change persisted

**Step 5: Reload Page**
- Refresh page to verify changes
- Go to Profile section
- Check if your changes still there
- If not, try again

---

## ❌ API returning errors

### Symptoms:
- See error messages in console
- API calls showing red in Network tab
- Response shows "success": false

### Solutions:

**Step 1: Check Error Message**
- Open F12 → Network tab
- Perform action (add favorite, etc.)
- Click on API call (e.g., favorites-toggle.php)
- Look at Response tab
- Read error message carefully

**Step 2: Verify Session Active**
- Session expires after inactivity
- Log out completely
- Log back in
- Try action again

**Step 3: Check File Exists**
- Go to [verify-realtime-setup.php](verify-realtime-setup.php)
- Check API section
- All should show ✅ exists
- If not, files need to be created

**Step 4: Check Database Connection**
- On [verify-realtime-setup.php](verify-realtime-setup.php)
- Check Database Tables section
- All tables should exist
- Check Required Columns section
- All columns should exist

**Step 5: Contact Support**
- Screenshot error message
- Note steps to reproduce
- Send to support team
- Include any console errors

---

## ⚡ Performance Issues

### Symptoms:
- Dashboard loads slow
- Updates take forever
- Lots of lag/delay

### Solutions:

**Step 1: Check Internet Speed**
- Run speed test at speedtest.net
- Should have at least 1 Mbps
- Slow connection = slow updates

**Step 2: Reduce Browser Extensions**
- Disable all extensions
- Retry dashboard
- Re-enable extensions one by one
- Identify problematic extension

**Step 3: Close Other Tabs**
- Close unnecessary tabs
- Close other applications
- Free up system resources
- Try dashboard again

**Step 4: Check Server Load**
- Try at different time of day
- Might be server overloaded
- Try early morning vs peak hours
- See if performance improves

**Step 5: Use Different Device**
- Try on different computer
- Try on mobile device
- See if issue is device-specific
- Helps identify problem

---

## 🔍 Debug Mode

### Enabling Console Logging

Open Developer Tools and run:
```javascript
// Force refresh all data
loadFavorites();
loadAppointments();
loadInquiries();
updateStats();

// Check these values in console:
console.log('Check polling active');
console.log(localStorage.getItem('favorites-updated'));
```

### Network Monitoring

1. Press F12
2. Go to Network tab
3. Perform action
4. Watch for API calls:
   - `favorites-toggle.php`
   - `appointment-add.php`
   - `inquiry-add.php`
   - etc.

### Console Messages

Look for normal messages:
- `"Loading favorites..."`
- `"API response success"`
- etc.

Red errors indicate problems!

---

## 📋 When Contacting Support

Have ready:
1. **Browser**: Chrome, Firefox, Safari, Edge?
2. **OS**: Windows, Mac, Linux, Mobile?
3. **Error**: Screenshot of error message
4. **Steps**: How to reproduce issue
5. **Attempts**: What you already tried
6. **Time**: When issue started
7. **Frequency**: Always or sometimes?

---

## 🎯 Quick Fixes Checklist

- [ ] Verified you're logged in as CUSTOMER
- [ ] Waited 5+ seconds for real-time update
- [ ] Hard refreshed page (Ctrl+F5)
- [ ] Checked browser console (F12)
- [ ] Cleared browser cache
- [ ] Tried different browser
- [ ] Verified [verify-realtime-setup.php](verify-realtime-setup.php) shows all ✅
- [ ] Checked internet connection
- [ ] Restarted browser completely
- [ ] Tried on different device/network

---

## 🚨 Critical Issues

### Database Connection Failed
- **Symptom**: All features show errors
- **Fix**: Check MySQL is running (XAMPP panel)
- **Contact support** if can't start

### API Files Missing
- **Symptom**: 404 errors for API calls
- **Fix**: Verify files in `/api/` folder
- **Contact support** to re-install

### JavaScript Errors
- **Symptom**: Console shows red errors
- **Fix**: Hard refresh (Ctrl+F5)
- **Contact support** with error details

---

## ✅ Verification Checklist

Visit [verify-realtime-setup.php](verify-realtime-setup.php) and check:

- [ ] favorites table exists
- [ ] appointments table exists
- [ ] inquiries table exists
- [ ] All required columns exist
- [ ] All API files exist
- [ ] Data can be read properly

---

## 📞 Getting Help

1. **Read this guide** - Most issues are covered
2. **Check [verify-realtime-setup.php](verify-realtime-setup.php)** - Diagnose system
3. **Check browser console** - See actual errors
4. **Clear cache and retry** - Fixes many issues
5. **Contact support** - If still stuck

---

## 💡 Pro Tips

- **Keep dev tools open** (F12) while testing
- **Monitor Network tab** to see API calls
- **Wait 5 seconds** between actions
- **Hard refresh** (Ctrl+F5) not lazy refresh (F5)
- **Use different browser** to isolate issues
- **Close extension popups** blocking dashboard
- **Keep browser updated** for compatibility
- **Check internet speed** if everything slow

---

**Don't worry! Most issues are simple to fix.** 

If you get stuck, this guide covers 99% of common problems. 🎉
