<?php
require_once 'config.php';

// Fetch approved reviews from database
$reviews = [];
$query = "SELECT r.id, r.rating, r.comment, r.customer_name, r.created_at 
          FROM reviews r 
          WHERE r.status = 'approved' 
          ORDER BY r.created_at DESC 
          LIMIT 12";
$result = $conn->query($query);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $reviews[] = $row;
    }
}

// Fallback to static reviews if no reviews in database
if (empty($reviews)) {
    $reviews = [
        [
            'customer_name' => 'Rahul Sharma',
            'rating' => 5,
            'comment' => 'Buying my apartment through Zemaraim was an incredible experience. The team guided me through every step, verified all documentation, and made the process transparent and stress-free. Highly recommended!',
            'created_at' => date('Y-m-d H:i:s')
        ],
        [
            'customer_name' => 'Priya Nair',
            'rating' => 5,
            'comment' => 'As a first-time property investor, Zemaraim provided excellent consultation. They helped me choose a commercial property in a prime location, and I\'ve already seen great rental returns!',
            'created_at' => date('Y-m-d H:i:s')
        ],
        [
            'customer_name' => 'Arjun Mehta',
            'rating' => 5,
            'comment' => 'Professional team, verified listings, and secure transactions. Zemaraim made buying my villa a seamless experience. The after-purchase support is excellent!',
            'created_at' => date('Y-m-d H:i:s')
        ]
    ];
}

// Generate avatar from name
function getAvatar($name) {
    $parts = explode(' ', trim($name));
    $initials = '';
    foreach ($parts as $part) {
        $initials .= strtoupper(substr($part, 0, 1));
    }
    return substr($initials, 0, 2);
}
?>

<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Zemaraim HTML Template Home One</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <!-- Mobile Specific Metas -->
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <!-- Favicons - Place favicon.ico in the root directory -->
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <!--==============================
	  Google Fonts
	============================== -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!--==============================
	    All CSS File
	============================== -->
  <!-- Bootstrap -->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <!-- Fontawesome Icon -->
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <!-- Magnific Popup -->
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <!-- Slick Slider -->
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <!-- Theme Custom CSS -->
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    /* About Section Styles */
    .about-intro-section { padding: 20px 0; background: white; }
    .about-intro-wrapper { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
    .about-intro-img { width: 100%; border-radius: 15px; overflow: hidden; box-shadow: 0 10px 40px rgba(0,0,0,0.1); }
    .about-intro-img img { width: 100%; height: auto; display: block; }
    .about-intro-content h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 20px; font-family: 'Playfair Display', serif; }
    .about-intro-tag { display: inline-block; background: rgba(102, 126, 234, 0.1); color: #667eea; padding: 8px 20px; border-radius: 25px; font-size: 12px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 20px; }
    .about-intro-content p { font-size: 16px; color: #666; line-height: 1.7; margin-bottom: 20px; }
    .about-features-list { list-style: none; padding: 0; margin: 30px 0; }
    .about-features-list li { font-size: 15px; color: #666; padding: 12px 0; display: flex; align-items: center; gap: 12px; }
    .about-features-list li:before { content: '✓'; width: 24px; height: 24px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 14px; flex-shrink: 0; }

    /* Timeline Section */
    .timeline-section { padding: 20px 0; background: #f8f9fa; }
    .timeline-section-header { text-align: center; margin-bottom: 70px; }
    .timeline-section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; font-family: 'Playfair Display', serif; }
    .timeline-section-header p { font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; }
    .timeline-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 40px; }
    .timeline-card { background: white; padding: 40px 30px; border-radius: 12px; box-shadow: 0 2px 15px rgba(0,0,0,0.08); text-align: center; position: relative; transition: all 0.3s ease; border-top: 4px solid #667eea; }
    .timeline-card:hover { transform: translateY(-8px); box-shadow: 0 10px 35px rgba(0,0,0,0.15); }
    .timeline-card-year { font-size: 32px; font-weight: 700; color: #667eea; margin-bottom: 10px; }
    .timeline-card-title { font-size: 20px; font-weight: 700; color: #1a1a1a; margin-bottom: 12px; }
    .timeline-card-desc { font-size: 14px; color: #666; margin-bottom: 25px; line-height: 1.6; }
    .timeline-card-stat { font-size: 28px; font-weight: 700; color: #667eea; margin-bottom: 8px; }
    .timeline-card-label { font-size: 13px; color: #999; }

    /* Reviews Section */
    .reviews-section { padding: 20px 0; background: white; }
    .reviews-section-header { text-align: center; margin-bottom: 70px; }
    .reviews-section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; font-family: 'Playfair Display', serif; }
    .reviews-section-header p { font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; }
    .reviews-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; }
    .review-card { background: #f8f9fa; padding: 30px; border-radius: 12px; position: relative; transition: all 0.3s ease; border: 1px solid #e0e0e0; }
    .review-card:hover { transform: translateY(-5px); box-shadow: 0 10px 30px rgba(0,0,0,0.1); border-color: #667eea; }
    .review-stars { font-size: 14px; color: #f39c12; margin-bottom: 15px; letter-spacing: 2px; }
    .review-text { font-size: 15px; color: #666; line-height: 1.7; margin-bottom: 20px; font-style: italic; }
    .review-author { display: flex; align-items: center; gap: 15px; }
    .review-avatar { width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px; flex-shrink: 0; }
    .review-author-info h4 { font-size: 14px; font-weight: 700; color: #1a1a1a; margin: 0; margin-bottom: 2px; }
    .review-author-info span { font-size: 12px; color: #999; }

    /* Responsive Design */
    @media (max-width: 1200px) {
      .about-intro-section { padding: 70px 0; }
      .about-intro-wrapper { gap: 40px; }
      .about-intro-content h2 { font-size: 36px; }
      .timeline-section, .reviews-section { padding: 70px 0; }
      .timeline-section-header h2, .reviews-section-header h2 { font-size: 36px; }
    }

    @media (max-width: 992px) {
      .about-intro-section { padding: 60px 0; }
      .about-intro-wrapper { grid-template-columns: 1fr; gap: 40px; }
      .about-intro-content h2 { font-size: 32px; }
      .about-intro-content p { font-size: 15px; }
      .about-features-list li { font-size: 14px; }
      .timeline-section, .reviews-section { padding: 60px 0; }
      .timeline-section-header, .reviews-section-header { margin-bottom: 50px; }
      .timeline-section-header h2, .reviews-section-header h2 { font-size: 32px; }
      .timeline-grid { gap: 30px; }
      .timeline-card { padding: 30px 20px; }
      .reviews-grid { gap: 20px; }
    }

    @media (max-width: 768px) {
      .about-intro-section { padding: 50px 0; }
      .about-intro-content h2 { font-size: 28px; margin-bottom: 15px; }
      .about-intro-tag { margin-bottom: 15px; }
      .about-intro-content p { font-size: 14px; margin-bottom: 15px; }
      .about-features-list li { font-size: 13px; padding: 10px 0; }
      .timeline-section, .reviews-section { padding: 50px 0; }
      .timeline-section-header, .reviews-section-header { margin-bottom: 40px; }
      .timeline-section-header h2, .reviews-section-header h2 { font-size: 28px; margin-bottom: 12px; }
      .timeline-section-header p, .reviews-section-header p { font-size: 14px; }
      .timeline-grid { grid-template-columns: 1fr; gap: 20px; }
      .timeline-card { padding: 25px 20px; }
      .timeline-card-year { font-size: 28px; }
      .timeline-card-title { font-size: 18px; }
      .review-card { padding: 20px; }
      .review-text { font-size: 14px; margin-bottom: 15px; }
    }

    @media (max-width: 576px) {
      .about-intro-section { padding: 40px 0; }
      .about-intro-content h2 { font-size: 24px; }
      .about-intro-tag { font-size: 10px; padding: 6px 15px; }
      .about-intro-content p { font-size: 13px; }
      .about-features-list li { font-size: 12px; padding: 8px 0; }
      .timeline-section, .reviews-section { padding: 40px 0; }
      .timeline-section-header, .reviews-section-header { margin-bottom: 30px; }
      .timeline-section-header h2, .reviews-section-header h2 { font-size: 24px; margin-bottom: 10px; }
      .timeline-section-header p, .reviews-section-header p { font-size: 12px; }
      .timeline-grid { grid-template-columns: 1fr; gap: 15px; }
      .timeline-card { padding: 20px 15px; border-top-width: 3px; }
      .timeline-card-year { font-size: 24px; }
      .timeline-card-title { font-size: 16px; }
      .timeline-card-stat { font-size: 24px; }
      .timeline-card-label { font-size: 12px; }
      .reviews-grid { grid-template-columns: 1fr; gap: 15px; }
      .review-card { padding: 15px; }
      .review-text { font-size: 13px; margin-bottom: 12px; }
    }

    /* Reviews Slider Styles */
    .reviews-slider {
      position: relative;
    }

    .review-slide {
      padding: 20px;
    }

    .review-card {
      background: #f8f9fa;
      padding: 30px;
      border-radius: 12px;
      position: relative;
      transition: all 0.3s ease;
      border: 1px solid #e0e0e0;
      height: 100%;
      display: flex;
      flex-direction: column;
    }

    .review-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      border-color: #667eea;
    }

    .review-stars {
      font-size: 18px;
      color: #f39c12;
      margin-bottom: 15px;
      letter-spacing: 3px;
    }

    .review-text {
      font-size: 15px;
      color: #666;
      line-height: 1.7;
      margin-bottom: 20px;
      font-style: italic;
      flex-grow: 1;
    }

    .review-author {
      display: flex;
      align-items: center;
      gap: 15px;
      margin-top: auto;
      padding-top: 20px;
      border-top: 1px solid #e0e0e0;
    }

    .review-avatar {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-weight: bold;
      font-size: 20px;
      flex-shrink: 0;
    }

    .review-author-info h4 {
      font-size: 14px;
      font-weight: 700;
      color: #1a1a1a;
      margin: 0;
      margin-bottom: 2px;
    }

    .review-author-info span {
      font-size: 12px;
      color: #999;
    }

    .reviews-slider-controls {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 30px;
      margin-top: 40px;
    }

    .review-nav-btn {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 16px;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .review-nav-btn:hover {
      transform: scale(1.1);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
    }

    .review-nav-btn:active {
      transform: scale(0.95);
    }

    .reviews-dots {
      display: flex;
      gap: 10px;
      align-items: center;
    }

    /* Responsive Slider Styles */
    @media (max-width: 1200px) {
      .review-slide {
        padding: 15px;
      }

      .review-card {
        padding: 25px;
      }

      .review-nav-btn {
        width: 45px;
        height: 45px;
        font-size: 14px;
      }

      .review-text {
        font-size: 14px;
      }
    }

    @media (max-width: 992px) {
      .review-slide {
        padding: 12px;
      }

      .review-card {
        padding: 20px;
      }

      .review-stars {
        font-size: 16px;
      }

      .review-nav-btn {
        width: 42px;
        height: 42px;
        font-size: 13px;
      }
    }

    @media (max-width: 768px) {
      .reviews-slider-controls {
        gap: 20px;
        margin-top: 30px;
      }

      .review-slide {
        padding: 10px;
      }

      .review-card {
        padding: 18px;
      }

      .review-text {
        font-size: 13px;
        margin-bottom: 15px;
      }

      .review-author {
        gap: 12px;
        padding-top: 15px;
      }

      .review-avatar {
        width: 45px;
        height: 45px;
        font-size: 18px;
      }

      .review-author-info h4 {
        font-size: 13px;
      }

      .review-nav-btn {
        width: 40px;
        height: 40px;
        font-size: 12px;
      }
    }

    @media (max-width: 576px) {
      .reviews-slider-controls {
        gap: 15px;
        margin-top: 25px;
      }

      .review-slide {
        padding: 8px;
      }

      .review-card {
        padding: 15px;
      }

      .review-stars {
        font-size: 14px;
        margin-bottom: 12px;
      }

      .review-text {
        font-size: 12px;
        line-height: 1.6;
        margin-bottom: 12px;
      }

      .review-author {
        gap: 10px;
        padding-top: 12px;
      }

      .review-avatar {
        width: 40px;
        height: 40px;
        font-size: 16px;
      }

      .review-author-info h4 {
        font-size: 12px;
      }

      .review-author-info span {
        font-size: 10px;
      }

      .review-nav-btn {
        width: 36px;
        height: 36px;
        font-size: 11px;
      }
    }
  </style>
</head>

<body>
  <!--[if lte IE 9]>
    	<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->
  <!--================================
     Preloader
    ==============================-->
  <div class="preloader">
    <button class="vs-btn preloaderCls">Cancel Preloader </button>
    <div class="preloader-inner">
      <img src="assets/img/logo.png" alt="Zemaraim">
      <span class="loader"></span>
    </div>
  </div>

  <?php include 'header.php'; ?>
  
  <!--==============================
    Breadcumb
    ============================== -->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">About Us</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current">About Us</span>
      </div>
    </div>
  </div>

  <!--==============================
  About Introduction Section
  ==============================-->
  <section class="about-intro-section">
    <div class="container">
      <div class="about-intro-wrapper">
        <!-- Image -->
        <div class="about-intro-img">
          <img src="assets/img/hero/hero2.png" alt="Zemaraim About">
        </div>

        <!-- Content -->
        <div class="about-intro-content">
          <span class="about-intro-tag">About Zemaraim</span>
          <h2>Delivering Trusted Property Solutions Since 2000</h2>
          <p>
            Zemaraim is a leading real estate company committed to providing transparent, reliable property solutions for buyers, sellers, and investors. For over two decades, we've helped thousands of customers find their dream properties and make profitable investments.
          </p>
          <p>
            Our mission is to revolutionize the real estate experience by combining expert guidance, verified legal documentation, and cutting-edge technology. We believe in building long-term relationships based on trust, transparency, and exceptional service.
          </p>
          <ul class="about-features-list">
            <li>100% Verified Legal Property Documentation & Clear Titles</li>
            <li>Expert Real Estate Consultants with Market Expertise</li>
            <li>Prime Location Premium Projects with High ROI</li>
            <li>Transparent Pricing and Secure Transaction Processing</li>
            <li>24/7 Customer Support & Post-Purchase Assistance</li>
          </ul>
        </div>
      </div>
    </div>
  </section>

  <!--==============================
  Timeline Section - Our Journey
  ==============================-->
  <section class="timeline-section">
    <div class="container">
      <div class="timeline-section-header">
        <h2>Our Growth Journey</h2>
        <p>Milestones in our real estate success story</p>
      </div>

      <div class="timeline-grid">
        <!-- 2000 -->
        <div class="timeline-card">
          <div class="timeline-card-year">2000</div>
          <h3 class="timeline-card-title">Company Founded</h3>
          <p class="timeline-card-desc">Started as a local real estate consulting firm with vision to transform property transactions in India.</p>
          <div class="timeline-card-stat">50+</div>
          <div class="timeline-card-label">Projects Completed</div>
        </div>

        <!-- 2008 -->
        <div class="timeline-card">
          <div class="timeline-card-year">2008</div>
          <h3 class="timeline-card-title">Commercial Expansion</h3>
          <p class="timeline-card-desc">Expanded into commercial and office real estate solutions, serving corporate clients nationwide.</p>
          <div class="timeline-card-stat">200+</div>
          <div class="timeline-card-label">Commercial Deals</div>
        </div>

        <!-- 2016 -->
        <div class="timeline-card">
          <div class="timeline-card-year">2016</div>
          <h3 class="timeline-card-title">Global Partnerships</h3>
          <p class="timeline-card-desc">Partnered with leading international real estate developers for premium property offerings.</p>
          <div class="timeline-card-stat">15+</div>
          <div class="timeline-card-label">Global Partnerships</div>
        </div>

        <!-- 2024 -->
        <div class="timeline-card">
          <div class="timeline-card-year">2024</div>
          <h3 class="timeline-card-title">Digital Innovation</h3>
          <p class="timeline-card-desc">Launched AI-powered property platform for seamless online property search and transactions.</p>
          <div class="timeline-card-stat">120K+</div>
          <div class="timeline-card-label">Happy Customers</div>
        </div>
      </div>
    </div>
  </section>

  <!--==============================
  Client Reviews Section
  ==============================-->
  <section class="reviews-section">
    <div class="container">
      <div class="reviews-section-header">
        <h2>Trusted By Our Happy Clients</h2>
        <p>Real experiences from satisfied property buyers and investors</p>
      </div>

      <div class="reviews-slider" id="reviewsSlider">
        <?php foreach ($reviews as $review): ?>
        <div class="review-slide">
          <div class="review-card">
            <div class="review-stars">
              <?php for ($i = 0; $i < $review['rating']; $i++): ?>
                <span class="star">★</span>
              <?php endfor; ?>
            </div>
            <p class="review-text">
              "<?php echo htmlspecialchars($review['comment']); ?>"
            </p>
            <div class="review-author">
              <div class="review-avatar"><?php echo getAvatar($review['customer_name']); ?></div>
              <div class="review-author-info">
                <h4><?php echo htmlspecialchars($review['customer_name']); ?></h4>
                <span>Verified Customer</span>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>

      <div class="reviews-slider-controls">
        <button class="review-nav-btn review-prev" id="reviewPrev">
          <i class="fas fa-chevron-left"></i>
        </button>
        <div class="reviews-dots"></div>
        <button class="review-nav-btn review-next" id="reviewNext">
          <i class="fas fa-chevron-right"></i>
        </button>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  <!--==============================
        All Js File
    ============================== -->
  <!-- Jquery -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <!-- Bootstrap -->
  <script src="assets/js/bootstrap.min.js"></script>
  <!-- Slick Slider -->
  <script src="assets/js/slick.min.js"></script>
  <!-- Magnific Popup -->
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <!-- Imagesloaded -->
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <!-- Isotope -->
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <!-- Main Js File -->
  <script src="assets/js/main.js"></script>

  <!-- Reviews Slider Initialization -->
  <script>
    $(document).ready(function() {
      // Initialize reviews slider
      var reviewCount = $('#reviewsSlider .review-slide').length;
      
      if (reviewCount > 0) {
        // Build dots HTML
        var dotsHtml = '';
        for (var i = 0; i < reviewCount; i++) {
          dotsHtml += '<div class="review-dot" data-index="' + i + '"></div>';
        }
        $('.reviews-dots').html(dotsHtml);
      }

      // Initialize Slick Slider with responsive settings
      $('#reviewsSlider').slick({
        infinite: true,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 5000,
        dots: false,
        arrows: false,
        speed: 500,
        responsive: [
          {
            breakpoint: 1200,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1,
              infinite: true
            }
          },
          {
            breakpoint: 992,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 576,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });

      // Custom navigation buttons
      $('#reviewNext').click(function(e) {
        e.preventDefault();
        $('#reviewsSlider').slick('slickNext');
      });

      $('#reviewPrev').click(function(e) {
        e.preventDefault();
        $('#reviewsSlider').slick('slickPrev');
      });

      // Update active dot on slide change
      $('#reviewsSlider').on('afterChange', function(event, slick, currentSlide) {
        $('.review-dot').removeClass('active');
        $('.review-dot[data-index="' + currentSlide + '"]').addClass('active');
        
        // Set first dot as active initially
        if (currentSlide === 0) {
          $('.review-dot').first().addClass('active');
        }
      });

      // Handle dot click
      $(document).on('click', '.review-dot', function() {
        var index = $(this).data('index');
        $('#reviewsSlider').slick('slickGoTo', index);
        $('.review-dot').removeClass('active');
        $(this).addClass('active');
      });

      // Set first dot as active on page load
      $('.review-dot').first().addClass('active');
    });
  </script>

  <style>
    /* Slider indicator dots styling */
    .review-dot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
      background: #ddd;
      cursor: pointer;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }

    .review-dot:hover {
      background: #667eea;
    }

    .review-dot.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      box-shadow: 0 0 10px rgba(102, 126, 234, 0.5);
    }

    /* Slick slider customization */
    .slick-slide {
      outline: none;
    }

    .slick-list {
      margin: 0 -20px;
    }

    .slick-track {
      display: flex;
    }

    @media (max-width: 768px) {
      .slick-list {
        margin: 0 -12px;
      }
    }

    @media (max-width: 576px) {
      .slick-list {
        margin: 0 -8px;
      }
    }
  </style>

</body>

</html>
