<?php
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['user_role'] = 'admin';

require_once 'config.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard Debug</title>
    <style>
        body { font-family: monospace; background: #f5f5f5; padding: 20px; }
        .section { background: white; margin: 20px 0; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .section h2 { color: #667eea; margin-top: 0; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        pre { background: #f8f8f8; padding: 10px; overflow-x: auto; border-left: 3px solid #667eea; }
        button { background: #667eea; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; margin: 5px; }
        button:hover { background: #764ba2; }
    </style>
</head>
<body>
    <h1>✅ Admin Dashboard Debug Panel</h1>
    
    <div class="section">
        <h2>🔍 System Status</h2>
        <p><strong>Session Status:</strong> <span class="success">Active</span></p>
        <p><strong>User Role:</strong> <?php echo $_SESSION['user_role']; ?></p>
        <p><strong>User ID:</strong> <?php echo $_SESSION['user_id']; ?></p>
        <p><strong>Database Connection:</strong> <span class="success">Connected</span></p>
        <p><strong>mysqli Alias:</strong> <span class="success">✓ Defined</span></p>
    </div>
    
    <div class="section">
        <h2>📊 Database Statistics</h2>
        <?php
        $props_count = $mysqli->query("SELECT COUNT(*) as c FROM properties")->fetch_assoc()['c'];
        $props_with_images = $mysqli->query("SELECT COUNT(*) as c FROM properties WHERE image_url IS NOT NULL AND image_url != ''")->fetch_assoc()['c'];
        $services_count = $mysqli->query("SELECT COUNT(*) as c FROM services")->fetch_assoc()['c'];
        $active_props = $mysqli->query("SELECT COUNT(*) as c FROM properties WHERE status = 'active'")->fetch_assoc()['c'];
        ?>
        <p><strong>Total Properties:</strong> <span class="success"><?php echo $props_count; ?></span></p>
        <p><strong>Properties with Images:</strong> <span class="success"><?php echo $props_with_images; ?></span></p>
        <p><strong>Active Properties:</strong> <span class="success"><?php echo $active_props; ?></span></p>
        <p><strong>Total Services:</strong> <span class="success"><?php echo $services_count; ?></span></p>
    </div>
    
    <div class="section">
        <h2>🧪 API Tests</h2>
        <p>
            <button onclick="testPropertiesAPI()">Test Properties API</button>
            <button onclick="testServicesAPI()">Test Services API</button>
            <button onclick="testBothAPIs()">Test Both APIs</button>
        </p>
        <div id="api-results"></div>
    </div>
    
    <div class="section">
        <h2>📝 Sample Data</h2>
        <h3>First 3 Properties:</h3>
        <pre id="properties-sample"></pre>
        <h3>First 3 Services:</h3>
        <pre id="services-sample"></pre>
    </div>
    
    <script>
        async function testPropertiesAPI() {
            const results = document.getElementById('api-results');
            results.innerHTML = '<p>🔄 Loading...</p>';
            
            try {
                const response = await fetch('api/get-properties.php?page=1&per_page=3');
                const data = await response.json();
                
                if (data.success) {
                    results.innerHTML = `<p class="success">✓ Success</p><p>Found ${data.properties.length} properties</p><pre>${JSON.stringify(data, null, 2)}</pre>`;
                    document.getElementById('properties-sample').textContent = JSON.stringify(data.properties, null, 2);
                } else {
                    results.innerHTML = `<p class="error">✗ API Error: ${data.message}</p>`;
                }
            } catch (error) {
                results.innerHTML = `<p class="error">✗ Fetch Error: ${error.message}</p>`;
            }
        }
        
        async function testServicesAPI() {
            const results = document.getElementById('api-results');
            results.innerHTML = '<p>🔄 Loading...</p>';
            
            try {
                const response = await fetch('api/get-services.php?page=1&per_page=3');
                const data = await response.json();
                
                if (data.success) {
                    results.innerHTML = `<p class="success">✓ Success</p><p>Found ${data.services.length} services</p><pre>${JSON.stringify(data, null, 2)}</pre>`;
                    document.getElementById('services-sample').textContent = JSON.stringify(data.services, null, 2);
                } else {
                    results.innerHTML = `<p class="error">✗ API Error: ${data.message}</p>`;
                }
            } catch (error) {
                results.innerHTML = `<p class="error">✗ Fetch Error: ${error.message}</p>`;
            }
        }
        
        async function testBothAPIs() {
            const results = document.getElementById('api-results');
            results.innerHTML = '<p>🔄 Testing both APIs...</p>';
            
            try {
                const propsRes = await fetch('api/get-properties.php?page=1&per_page=3');
                const propsData = await propsRes.json();
                
                const servRes = await fetch('api/get-services.php?page=1&per_page=3');
                const servData = await servRes.json();
                
                const passed = (propsData.success && servData.success) ? 'PASSED ✓' : 'FAILED ✗';
                results.innerHTML = `
                    <p><strong>Properties API: ${propsData.success ? '✓ Success' : '✗ Failed'}</strong></p>
                    <p><strong>Services API: ${servData.success ? '✓ Success' : '✗ Failed'}</strong></p>
                    <p style="font-size: 18px; font-weight: bold; color: ${propsData.success && servData.success ? 'green' : 'red'};">Overall: ${passed}</p>
                `;
                
                document.getElementById('properties-sample').textContent = JSON.stringify(propsData.properties || [], null, 2);
                document.getElementById('services-sample').textContent = JSON.stringify(servData.services || [], null, 2);
            } catch (error) {
                results.innerHTML = `<p class="error">✗ Error: ${error.message}</p>`;
            }
        }
        
        // Run both tests on page load
        window.addEventListener('load', testBothAPIs);
    </script>
</body>
</html>
