<?php
require_once 'config.php';

// Check if table exists, if not create it
$check_table = $conn->query("SHOW TABLES LIKE 'hero_sliders'");
if ($check_table->num_rows == 0) {
    $create_sql = "CREATE TABLE IF NOT EXISTS `hero_sliders` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `tag` VARCHAR(100) NOT NULL,
      `title` VARCHAR(255) NOT NULL,
      `subtitle` TEXT NOT NULL,
      `button1_text` VARCHAR(100),
      `button1_url` VARCHAR(255),
      `button2_text` VARCHAR(100),
      `button2_url` VARCHAR(255),
      `image_url` VARCHAR(255),
      `stat1_icon` VARCHAR(100),
      `stat1_text` VARCHAR(255),
      `stat2_icon` VARCHAR(100),
      `stat2_text` VARCHAR(255),
      `display_order` INT DEFAULT 0,
      `status` ENUM('active', 'inactive') DEFAULT 'active',
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($create_sql);
}

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'add') {
            // Add new hero slider
            $tag = $conn->real_escape_string($_POST['tag']);
            $title = $conn->real_escape_string($_POST['title']);
            $subtitle = $conn->real_escape_string($_POST['subtitle']);
            $button1_text = $conn->real_escape_string($_POST['button1_text']);
            $button1_url = $conn->real_escape_string($_POST['button1_url']);
            $button2_text = $conn->real_escape_string($_POST['button2_text']);
            $button2_url = $conn->real_escape_string($_POST['button2_url']);
            $image_url = $conn->real_escape_string($_POST['image_url']);
            $stat1_icon = $conn->real_escape_string($_POST['stat1_icon']);
            $stat1_text = $conn->real_escape_string($_POST['stat1_text']);
            $stat2_icon = $conn->real_escape_string($_POST['stat2_icon']);
            $stat2_text = $conn->real_escape_string($_POST['stat2_text']);
            $display_order = (int)$_POST['display_order'];
            $status = $_POST['status'];

            $insert_sql = "INSERT INTO hero_sliders 
            (tag, title, subtitle, button1_text, button1_url, button2_text, button2_url, image_url, stat1_icon, stat1_text, stat2_icon, stat2_text, display_order, status) 
            VALUES ('$tag', '$title', '$subtitle', '$button1_text', '$button1_url', '$button2_text', '$button2_url', '$image_url', '$stat1_icon', '$stat1_text', '$stat2_icon', '$stat2_text', $display_order, '$status')";

            if ($conn->query($insert_sql) === TRUE) {
                $message = "✓ Hero slider added successfully!";
                $message_type = "success";
            } else {
                $message = "✗ Error: " . $conn->error;
                $message_type = "error";
            }
        } elseif ($_POST['action'] == 'edit') {
            // Update existing hero slider
            $id = (int)$_POST['id'];
            $tag = $conn->real_escape_string($_POST['tag']);
            $title = $conn->real_escape_string($_POST['title']);
            $subtitle = $conn->real_escape_string($_POST['subtitle']);
            $button1_text = $conn->real_escape_string($_POST['button1_text']);
            $button1_url = $conn->real_escape_string($_POST['button1_url']);
            $button2_text = $conn->real_escape_string($_POST['button2_text']);
            $button2_url = $conn->real_escape_string($_POST['button2_url']);
            $image_url = $conn->real_escape_string($_POST['image_url']);
            $stat1_icon = $conn->real_escape_string($_POST['stat1_icon']);
            $stat1_text = $conn->real_escape_string($_POST['stat1_text']);
            $stat2_icon = $conn->real_escape_string($_POST['stat2_icon']);
            $stat2_text = $conn->real_escape_string($_POST['stat2_text']);
            $display_order = (int)$_POST['display_order'];
            $status = $_POST['status'];

            $update_sql = "UPDATE hero_sliders SET 
            tag='$tag', title='$title', subtitle='$subtitle', button1_text='$button1_text', button1_url='$button1_url', 
            button2_text='$button2_text', button2_url='$button2_url', image_url='$image_url', stat1_icon='$stat1_icon', 
            stat1_text='$stat1_text', stat2_icon='$stat2_icon', stat2_text='$stat2_text', display_order=$display_order, 
            status='$status' WHERE id=$id";

            if ($conn->query($update_sql) === TRUE) {
                $message = "✓ Hero slider updated successfully!";
                $message_type = "success";
            } else {
                $message = "✗ Error: " . $conn->error;
                $message_type = "error";
            }
        } elseif ($_POST['action'] == 'delete') {
            // Delete hero slider
            $id = (int)$_POST['id'];
            $delete_sql = "DELETE FROM hero_sliders WHERE id=$id";

            if ($conn->query($delete_sql) === TRUE) {
                $message = "✓ Hero slider deleted successfully!";
                $message_type = "success";
            } else {
                $message = "✗ Error: " . $conn->error;
                $message_type = "error";
            }
        }
    }
}

// Get all hero sliders
$result = $conn->query("SELECT * FROM hero_sliders ORDER BY display_order ASC");
$hero_sliders = [];
if ($result) {
    while($row = $result->fetch_assoc()) {
        $hero_sliders[] = $row;
    }
}

// Get slider to edit (if editing)
$edit_slider = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $result = $conn->query("SELECT * FROM hero_sliders WHERE id=$id");
    if ($result && $result->num_rows > 0) {
        $edit_slider = $result->fetch_assoc();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hero Slider Admin Panel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        .admin-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .admin-header {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 30px;
        }
        .admin-header h1 {
            color: #667eea;
            margin: 0;
        }
        .admin-header p {
            color: #666;
            margin: 10px 0 0 0;
        }
        .form-section {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 30px;
        }
        .form-section h2 {
            color: #667eea;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .slider-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .slider-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        .slider-card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 20px;
        }
        .slider-card-body {
            padding: 20px;
        }
        .slider-card-body p {
            margin: 10px 0;
            color: #333;
        }
        .slider-card-body strong {
            color: #667eea;
        }
        .slider-card-footer {
            background: #f8f9fa;
            padding: 15px 20px;
            display: flex;
            gap: 10px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .btn-danger {
            background: #dc3545;
            border: none;
        }
        .btn-secondary {
            background: #6c757d;
            border: none;
        }
        .message {
            padding: 15px 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .form-group label {
            color: #667eea;
            font-weight: 600;
        }
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-badge.active {
            background: #d4edda;
            color: #155724;
        }
        .status-badge.inactive {
            background: #f8d7da;
            color: #721c24;
        }
        .btn-sm {
            padding: 5px 10px;
            font-size: 12px;
        }
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #999;
        }
        .empty-state i {
            font-size: 48px;
            color: #ddd;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- Header -->
        <div class="admin-header">
            <h1><i class="fas fa-sliders-h"></i> Hero Slider Admin Panel</h1>
            <p>Manage your website's hero sliders - add, edit, and delete slides to keep your website fresh!</p>
        </div>

        <!-- Message -->
        <?php if ($message): ?>
            <div class="message <?php echo $message_type; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- Add/Edit Form -->
        <div class="form-section">
            <h2><?php echo $edit_slider ? '✏️ Edit Hero Slider' : '➕ Add New Hero Slider'; ?></h2>
            
            <form method="POST">
                <input type="hidden" name="action" value="<?php echo $edit_slider ? 'edit' : 'add'; ?>">
                <?php if ($edit_slider): ?>
                    <input type="hidden" name="id" value="<?php echo $edit_slider['id']; ?>">
                <?php endif; ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="tag">Tag / Category</label>
                            <input type="text" class="form-control" name="tag" id="tag" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['tag']) : ''; ?>" required 
                                   placeholder="e.g., Premium Properties">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="display_order">Display Order</label>
                            <input type="number" class="form-control" name="display_order" id="display_order" 
                                   value="<?php echo $edit_slider ? $edit_slider['display_order'] : '1'; ?>" required>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="title">Main Title</label>
                    <input type="text" class="form-control" name="title" id="title" 
                           value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['title']) : ''; ?>" required 
                           placeholder="e.g., Find Your Dream Apartment">
                </div>

                <div class="form-group mb-3">
                    <label for="subtitle">Subtitle / Description</label>
                    <textarea class="form-control" name="subtitle" id="subtitle" rows="3" required 
                              placeholder="Detailed description for the slider..."><?php echo $edit_slider ? htmlspecialchars($edit_slider['subtitle']) : ''; ?></textarea>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="button1_text">Button 1 Text</label>
                            <input type="text" class="form-control" name="button1_text" id="button1_text" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['button1_text']) : ''; ?>" 
                                   placeholder="e.g., Explore Properties">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="button1_url">Button 1 URL</label>
                            <input type="text" class="form-control" name="button1_url" id="button1_url" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['button1_url']) : ''; ?>" 
                                   placeholder="e.g., properties.html">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="button2_text">Button 2 Text</label>
                            <input type="text" class="form-control" name="button2_text" id="button2_text" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['button2_text']) : ''; ?>" 
                                   placeholder="e.g., Contact Us">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="button2_url">Button 2 URL</label>
                            <input type="text" class="form-control" name="button2_url" id="button2_url" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['button2_url']) : ''; ?>" 
                                   placeholder="e.g., contact.php">
                        </div>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="image_url">Background Image URL</label>
                    <input type="text" class="form-control" name="image_url" id="image_url" 
                           value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['image_url']) : ''; ?>" 
                           placeholder="e.g., assets/img/hero/image.png">
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="stat1_icon">Stat 1 Icon</label>
                            <input type="text" class="form-control" name="stat1_icon" id="stat1_icon" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['stat1_icon']) : ''; ?>" 
                                   placeholder="e.g., fas fa-check-circle">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="stat1_text">Stat 1 Text</label>
                            <input type="text" class="form-control" name="stat1_text" id="stat1_text" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['stat1_text']) : ''; ?>" 
                                   placeholder="e.g., 22K+ Properties Listed">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="stat2_icon">Stat 2 Icon</label>
                            <input type="text" class="form-control" name="stat2_icon" id="stat2_icon" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['stat2_icon']) : ''; ?>" 
                                   placeholder="e.g., fas fa-users">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="stat2_text">Stat 2 Text</label>
                            <input type="text" class="form-control" name="stat2_text" id="stat2_text" 
                                   value="<?php echo $edit_slider ? htmlspecialchars($edit_slider['stat2_text']) : ''; ?>" 
                                   placeholder="e.g., 140K+ Happy Customers">
                        </div>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="status">Status</label>
                    <select class="form-control" name="status" id="status" required>
                        <option value="active" <?php echo $edit_slider && $edit_slider['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                        <option value="inactive" <?php echo $edit_slider && $edit_slider['status'] == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                    </select>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> <?php echo $edit_slider ? 'Update Slider' : 'Add Slider'; ?>
                    </button>
                    <?php if ($edit_slider): ?>
                        <a href="admin-hero-sliders.php" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    <?php endif; ?>
                </div>
            </form>
        </div>

        <!-- Hero Sliders List -->
        <div class="form-section">
            <h2>📋 Current Hero Sliders</h2>
            
            <?php if (empty($hero_sliders)): ?>
                <div class="empty-state">
                    <i class="fas fa-image"></i>
                    <p>No hero sliders found. Create your first slider above!</p>
                </div>
            <?php else: ?>
                <?php foreach ($hero_sliders as $slider): ?>
                    <div class="slider-card">
                        <div class="slider-card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-0"><?php echo htmlspecialchars($slider['title']); ?></h5>
                                    <small><?php echo htmlspecialchars($slider['tag']); ?></small>
                                </div>
                                <span class="status-badge <?php echo $slider['status']; ?>">
                                    <?php echo ucfirst($slider['status']); ?>
                                </span>
                            </div>
                        </div>
                        <div class="slider-card-body">
                            <p><strong>Subtitle:</strong> <?php echo htmlspecialchars(substr($slider['subtitle'], 0, 100)) . (strlen($slider['subtitle']) > 100 ? '...' : ''); ?></p>
                            <p><strong>Button 1:</strong> <?php echo htmlspecialchars($slider['button1_text'] ?? 'N/A'); ?> → <?php echo htmlspecialchars($slider['button1_url'] ?? 'N/A'); ?></p>
                            <p><strong>Button 2:</strong> <?php echo htmlspecialchars($slider['button2_text'] ?? 'N/A'); ?> → <?php echo htmlspecialchars($slider['button2_url'] ?? 'N/A'); ?></p>
                            <p><strong>Image URL:</strong> <small><?php echo htmlspecialchars($slider['image_url'] ?? 'N/A'); ?></small></p>
                            <p><strong>Stats:</strong> <?php echo htmlspecialchars($slider['stat1_text'] ?? 'N/A'); ?> | <?php echo htmlspecialchars($slider['stat2_text'] ?? 'N/A'); ?></p>
                            <p><strong>Order:</strong> #<?php echo $slider['display_order']; ?> | <strong>Created:</strong> <?php echo date('M d, Y', strtotime($slider['created_at'])); ?></p>
                        </div>
                        <div class="slider-card-footer">
                            <a href="?edit=<?php echo $slider['id']; ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this slider?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $slider['id']; ?>">
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
