<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Zemaraim Real Estate</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .login-container { background: white; border-radius: 10px; box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2); width: 100%; max-width: 400px; padding: 40px; }
        .logo { text-align: center; margin-bottom: 30px; }
        .logo h1 { color: #667eea; font-size: 28px; margin-bottom: 5px; }
        .logo p { color: #999; font-size: 14px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; color: #333; font-weight: 600; margin-bottom: 8px; font-size: 14px; }
        .form-group input { width: 100%; padding: 12px 15px; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; transition: all 0.3s ease; }
        .form-group input:focus { outline: none; border-color: #667eea; box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1); }
        .btn-login { width: 100%; padding: 12px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; border-radius: 5px; font-weight: 600; cursor: pointer; transition: all 0.3s ease; margin-top: 10px; }
        .btn-login:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3); }
        .error-message { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 5px; margin-bottom: 20px; border: 1px solid #f5c6cb; font-size: 14px; }
        .forgot-password { text-align: center; margin-top: 15px; }
        .forgot-password a { color: #667eea; text-decoration: none; font-size: 13px; }
        .forgot-password a:hover { text-decoration: underline; }
        .back-home { text-align: center; margin-top: 20px; }
        .back-home a { color: #999; text-decoration: none; font-size: 13px; }
        .info-box { background: #f0f4ff; border-left: 3px solid #667eea; padding: 15px; border-radius: 5px; margin-bottom: 20px; font-size: 13px; color: #333; }
        .info-box strong { color: #667eea; }
        @media (max-width: 480px) {
            .login-container { margin: 20px; }
        }
    </style>
</head>
<body>

<?php
// Session and config are loaded together to avoid session_start() conflicts
require_once 'config.php';

// Redirect if already logged in
if (isset($_SESSION['user_id']) && isset($_SESSION['user_role'])) {
    header('Location: dashboards/admin-dashboard.php');
    exit;
}

$error = '';
$showInfo = !isset($_POST['email']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    // Validate
    if (empty($email) || empty($password)) {
        $error = 'Please enter email and password';
    } else {
        // Query user from users table - Only admin role
        $stmt = $mysqli->prepare("SELECT id, full_name, password, role, status FROM users WHERE email = ? AND role = 'admin'");
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            $error = 'Invalid email or this user does not have admin access';
        } else {
            $user = $result->fetch_assoc();
            
            if ($user['status'] !== 'active') {
                $error = 'Your account is suspended or inactive';
            } elseif (!password_verify($password, $user['password'])) {
                $error = 'Invalid password';
            } else {
                // Login successful
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['full_name'];
                $_SESSION['email'] = $email;
                $_SESSION['user_role'] = $user['role'];

                // Redirect to admin dashboard
                header('Location: dashboards/admin-dashboard.php');
                exit;
            }
        }
        $stmt->close();
    }
}

?>

    <div class="login-container">
        <div class="logo">
            <h1>🔐 Admin Login</h1>
            <p>Administrator Dashboard</p>
        </div>

        <?php if ($showInfo): ?>
            <div class="info-box">
                <strong>📊 Admin Test Credentials:</strong><br>
                Email: <code style="background: white; padding: 2px 5px; border-radius: 3px;">admin@test.com</code><br>
                Password: <code style="background: white; padding: 2px 5px; border-radius: 3px;">AdminPass123</code>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error-message">
                <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" placeholder="admin@Zemaraim.com" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required autofocus>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" placeholder="Enter your password" required>
            </div>

            <button type="submit" class="btn-login">
                <i class="fas fa-sign-in-alt"></i> Sign In
            </button>
        </form>

        <div class="forgot-password">
            <a href="forgot-password.php">Forgot password?</a>
        </div>

        <div class="back-home">
            <a href="index.php">← Back to Home</a>
        </div>
    </div>

</body>
</html>
