<?php
require_once 'config.php';

// Get agent ID from URL
$agent_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Get agent details from database
$agent = null;
if ($agent_id > 0) {
    $result = $conn->query("SELECT * FROM agents WHERE id = " . $agent_id);
    if ($result && $result->num_rows > 0) {
        $agent = $result->fetch_assoc();
    }
}

// If agent not found, redirect to agents list
if (!$agent) {
    header('Location: agents.php');
    exit;
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title><?php echo htmlspecialchars($agent['name']); ?> - Agent Profile - Zemaraim</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="<?php echo htmlspecialchars($agent['position']); ?> - <?php echo htmlspecialchars($agent['specialization']); ?>">
  <meta name="keywords" content="agent, real estate, property">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="../../css2-4?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    /* Agent Detail Styles */
    .agent-detail-section {
      padding: 60px 0;
      background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    }

    .agent-detail-container {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 40px;
      align-items: start;
      margin-bottom: 50px;
    }

    .agent-detail-image {
      position: relative;
      border-radius: 15px;
      overflow: hidden;
      box-shadow: 0 15px 50px rgba(102, 126, 234, 0.2);
      aspect-ratio: 3/4;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .agent-detail-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.3s ease;
    }

    .agent-detail-image:hover img {
      transform: scale(1.05);
    }

    /* Floating Badges */
    .detail-badge {
      position: absolute;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 12px 20px;
      border-radius: 30px;
      font-weight: 600;
      box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
      display: flex;
      align-items: center;
      gap: 8px;
      font-size: 14px;
    }

    .badge-rating {
      top: 20px;
      right: 20px;
    }

    .badge-experience {
      bottom: 20px;
      left: 20px;
    }

    .agent-detail-info {
      display: flex;
      flex-direction: column;
    }

    .agent-detail-name {
      font-size: clamp(28px, 4vw, 42px);
      font-weight: 700;
      color: #222;
      margin-bottom: 8px;
    }

    .agent-detail-position {
      font-size: clamp(16px, 2vw, 20px);
      color: #667eea;
      font-weight: 600;
      margin-bottom: 20px;
    }

    .agent-detail-divider {
      width: 50px;
      height: 4px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      margin-bottom: 25px;
    }

    .agent-detail-bio {
      font-size: 16px;
      line-height: 1.8;
      color: #555;
      margin-bottom: 30px;
      text-align: justify;
    }

    /* Info Grid */
    .agent-info-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 20px;
      margin-bottom: 30px;
      padding: 25px;
      background: white;
      border-radius: 12px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
    }

    .info-item {
      display: flex;
      flex-direction: column;
    }

    .info-label {
      font-size: 12px;
      color: #999;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      margin-bottom: 5px;
    }

    .info-value {
      font-size: 18px;
      font-weight: 600;
      color: #667eea;
    }

    /* Contact Section */
    .agent-contact-section {
      background: white;
      padding: 30px;
      border-radius: 12px;
      margin-bottom: 30px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
    }

    .contact-title {
      font-size: 18px;
      font-weight: 700;
      color: #222;
      margin-bottom: 20px;
    }

    .contact-method {
      display: flex;
      align-items: center;
      gap: 15px;
      padding: 15px 0;
      border-bottom: 1px solid #eee;
    }

    .contact-method:last-child {
      border-bottom: none;
    }

    .contact-icon {
      width: 45px;
      height: 45px;
      border-radius: 50%;
      background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      color: #667eea;
      font-size: 18px;
    }

    .contact-details {
      flex: 1;
    }

    .contact-label {
      font-size: 12px;
      color: #999;
      text-transform: uppercase;
    }

    .contact-value {
      font-size: 16px;
      font-weight: 600;
      color: #222;
      text-decoration: none;
    }

    .contact-value:hover {
      color: #667eea;
    }

    /* Social Links Section */
    .agent-social-section {
      background: white;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
    }

    .social-title {
      font-size: 18px;
      font-weight: 700;
      color: #222;
      margin-bottom: 20px;
    }

    .agent-social-links {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
      gap: 15px;
    }

    .social-link-btn {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 20px;
      background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
      border-radius: 12px;
      text-decoration: none;
      transition: all 0.3s ease;
      color: #667eea;
      font-weight: 600;
      gap: 8px;
    }

    .social-link-btn:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
    }

    .social-link-btn i {
      font-size: 24px;
    }

    /* Call to Action */
    .agent-cta-section {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 40px;
      border-radius: 12px;
      text-align: center;
      margin-top: 50px;
    }

    .cta-title {
      font-size: 24px;
      font-weight: 700;
      margin-bottom: 15px;
    }

    .cta-description {
      font-size: 16px;
      opacity: 0.9;
      margin-bottom: 25px;
    }

    .cta-button {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      background: white;
      color: #667eea;
      padding: 12px 30px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 700;
      transition: all 0.3s ease;
    }

    .cta-button:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
      color: #764ba2;
      text-decoration: none;
    }

    /* Back Button */
    .back-button {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      background: white;
      color: #667eea;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      margin-bottom: 30px;
      transition: all 0.3s ease;
    }

    .back-button:hover {
      box-shadow: 0 5px 15px rgba(102, 126, 234, 0.2);
      transform: translateX(-5px);
      color: #667eea;
      text-decoration: none;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .agent-detail-section {
        padding: 40px 0;
      }

      .agent-detail-container {
        grid-template-columns: 1fr;
        gap: 30px;
      }

      .agent-info-grid {
        grid-template-columns: 1fr;
      }

      .agent-detail-name {
        font-size: 28px;
      }

      .agent-detail-position {
        font-size: 16px;
      }

      .agent-cta-section {
        padding: 30px;
      }

      .cta-title {
        font-size: 20px;
      }
    }

    @media (max-width: 480px) {
      .agent-detail-section {
        padding: 30px 0;
      }

      .agent-detail-name {
        font-size: 22px;
      }

      .agent-detail-position {
        font-size: 14px;
      }

      .agent-detail-bio {
        font-size: 14px;
      }

      .agent-social-links {
        grid-template-columns: repeat(2, 1fr);
      }

      .social-link-btn {
        padding: 15px;
      }

      .agent-cta-section {
        padding: 20px;
      }

      .cta-button {
        width: 100%;
        justify-content: center;
      }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">Agent Profile</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <a href="agents.php">Agents</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current"><?php echo htmlspecialchars($agent['name']); ?></span>
      </div>
    </div>
  </div>

  <!-- Agent Detail Section -->
  <section class="agent-detail-section">
    <div class="container">
      <!-- Back Button -->
      <a href="agents.php" class="back-button">
        <i class="fas fa-arrow-left"></i> Back to Agents
      </a>

      <!-- Main Agent Detail -->
      <div class="agent-detail-container">
        <!-- Left: Agent Image -->
        <div class="agent-detail-image">
          <img src="<?php echo htmlspecialchars($agent['image_url']); ?>" alt="<?php echo htmlspecialchars($agent['name']); ?>">
          
          <div class="detail-badge badge-rating">
            ⭐ <?php echo number_format($agent['rating'], 1); ?>/5.0 Rating
          </div>
          
          <div class="detail-badge badge-experience">
            🏆 <?php echo $agent['experience']; ?> Years Exp.
          </div>
        </div>

        <!-- Right: Agent Info -->
        <div class="agent-detail-info">
          <h1 class="agent-detail-name"><?php echo htmlspecialchars($agent['name']); ?></h1>
          <p class="agent-detail-position"><?php echo htmlspecialchars($agent['position']); ?></p>
          <div class="agent-detail-divider"></div>

          <!-- Bio -->
          <p class="agent-detail-bio">
            <?php echo htmlspecialchars($agent['bio']); ?>
          </p>

          <!-- Info Grid -->
          <div class="agent-info-grid">
            <div class="info-item">
              <span class="info-label">Specialization</span>
              <span class="info-value"><?php echo htmlspecialchars($agent['specialization']); ?></span>
            </div>
            <div class="info-item">
              <span class="info-label">Experience</span>
              <span class="info-value"><?php echo $agent['experience']; ?> Years</span>
            </div>
            <div class="info-item">
              <span class="info-label">Properties Sold</span>
              <span class="info-value"><?php echo $agent['properties_sold']; ?> +</span>
            </div>
            <div class="info-item">
              <span class="info-label">Client Rating</span>
              <span class="info-value">★ <?php echo number_format($agent['rating'], 1); ?></span>
            </div>
          </div>
        </div>
      </div>

      <!-- Contact & Social Section -->
      <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin-top: 50px;">
        <!-- Contact Section -->
        <div class="agent-contact-section">
          <h3 class="contact-title">📞 Get in Touch</h3>

          <?php if (!empty($agent['phone'])): ?>
            <div class="contact-method">
              <div class="contact-icon">
                <i class="fas fa-phone"></i>
              </div>
              <div class="contact-details">
                <div class="contact-label">Phone</div>
                <a href="tel:<?php echo htmlspecialchars($agent['phone']); ?>" class="contact-value">
                  <?php echo htmlspecialchars($agent['phone']); ?>
                </a>
              </div>
            </div>
          <?php endif; ?>

          <?php if (!empty($agent['email'])): ?>
            <div class="contact-method">
              <div class="contact-icon">
                <i class="fas fa-envelope"></i>
              </div>
              <div class="contact-details">
                <div class="contact-label">Email</div>
                <a href="mailto:<?php echo htmlspecialchars($agent['email']); ?>" class="contact-value">
                  <?php echo htmlspecialchars($agent['email']); ?>
                </a>
              </div>
            </div>
          <?php endif; ?>

          <div class="contact-method">
            <div class="contact-icon">
              <i class="fas fa-briefcase"></i>
            </div>
            <div class="contact-details">
              <div class="contact-label">Position</div>
              <span class="contact-value"><?php echo htmlspecialchars($agent['position']); ?></span>
            </div>
          </div>
        </div>

        <!-- Social Links Section -->
        <div class="agent-social-section">
          <h3 class="social-title">🌐 Connect on Social</h3>

          <div class="agent-social-links">
            <?php if (!empty($agent['facebook_url'])): ?>
              <a href="<?php echo htmlspecialchars($agent['facebook_url']); ?>" target="_blank" class="social-link-btn" title="Facebook">
                <i class="fab fa-facebook-f"></i>
                <span>Facebook</span>
              </a>
            <?php endif; ?>

            <?php if (!empty($agent['twitter_url'])): ?>
              <a href="<?php echo htmlspecialchars($agent['twitter_url']); ?>" target="_blank" class="social-link-btn" title="Twitter">
                <i class="fab fa-twitter"></i>
                <span>Twitter</span>
              </a>
            <?php endif; ?>

            <?php if (!empty($agent['linkedin_url'])): ?>
              <a href="<?php echo htmlspecialchars($agent['linkedin_url']); ?>" target="_blank" class="social-link-btn" title="LinkedIn">
                <i class="fab fa-linkedin-in"></i>
                <span>LinkedIn</span>
              </a>
            <?php endif; ?>

            <?php if (!empty($agent['instagram_url'])): ?>
              <a href="<?php echo htmlspecialchars($agent['instagram_url']); ?>" target="_blank" class="social-link-btn" title="Instagram">
                <i class="fab fa-instagram"></i>
                <span>Instagram</span>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- CTA Section -->
      <div class="agent-cta-section">
        <h2 class="cta-title">Ready to Find Your Perfect Property?</h2>
        <p class="cta-description">
          Contact <?php echo htmlspecialchars($agent['name']); ?> today to discuss your real estate needs
        </p>
        <a href="contact.php" class="cta-button">
          Schedule a Meeting →
        </a>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>

  <!-- Scripts -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
