<?php
require_once 'config.php';

// Get all agents from database
$agents_result = $conn->query("SELECT * FROM agents ORDER BY created_at DESC");
$agents = [];
if ($agents_result) {
    while ($row = $agents_result->fetch_assoc()) {
        $agents[] = $row;
    }
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Our Professional Agents - Zemaraim</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="Meet our professional real estate agents with extensive market experience">
  <meta name="keywords" content="real estate agents, property consultants, brokers">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    /* Responsive Agent Styles */
    .agents-section {
      padding: 60px 0;
      background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    }

    .agents-title {
      text-align: center;
      margin-bottom: 50px;
      animation: fadeInDown 0.6s ease-out;
    }

    .agents-title h2 {
      font-size: clamp(28px, 5vw, 48px);
      font-weight: 700;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      margin-bottom: 15px;
    }

    .agents-title p {
      font-size: clamp(14px, 3vw, 18px);
      color: #666;
      max-width: 600px;
      margin: 0 auto;
    }

    /* Responsive Agent Grid */
    .agents-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 30px;
      margin-bottom: 40px;
    }

    /* Agent Card */
    .agent-card {
      background: white;
      border-radius: 15px;
      overflow: hidden;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
      transition: all 0.3s ease;
      cursor: pointer;
      transform: translateY(0);
      display: flex;
      flex-direction: column;
      height: 100%;
    }

    .agent-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 15px 40px rgba(102, 126, 234, 0.2);
    }

    .agent-card-image {
      position: relative;
      overflow: hidden;
      aspect-ratio: 1;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .agent-card-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.3s ease;
    }

    .agent-card:hover .agent-card-image img {
      transform: scale(1.05);
    }

    /* Agent Badge */
    .agent-rating-badge {
      position: absolute;
      top: 15px;
      right: 15px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 8px 15px;
      border-radius: 25px;
      font-size: 14px;
      font-weight: 600;
      box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
    }

    /* Agent Overlay Info */
    .agent-card-overlay {
      position: absolute;
      bottom: 0;
      left: 0;
      right: 0;
      background: linear-gradient(180deg, transparent 0%, rgba(0, 0, 0, 0.8) 100%);
      color: white;
      padding: 20px;
      transform: translateY(100%);
      transition: transform 0.3s ease;
      display: flex;
      flex-direction: column;
      justify-content: flex-end;
    }

    .agent-card:hover .agent-card-overlay {
      transform: translateY(0);
    }

    .agent-card-overlay-text {
      font-size: 13px;
      opacity: 0.9;
      margin-bottom: 8px;
    }

    /* Agent Info */
    .agent-card-content {
      padding: 25px;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
    }

    .agent-card-name {
      font-size: 20px;
      font-weight: 700;
      color: #222;
      margin-bottom: 8px;
    }

    .agent-card-position {
      color: #667eea;
      font-weight: 600;
      font-size: 14px;
      margin-bottom: 12px;
    }

    .agent-specialization {
      font-size: 13px;
      color: #999;
      margin-bottom: 15px;
      line-height: 1.6;
    }

    .agent-stats {
      display: flex;
      gap: 15px;
      padding-top: 15px;
      border-top: 1px solid #eee;
      margin-top: auto;
    }

    .agent-stat {
      flex: 1;
      text-align: center;
    }

    .agent-stat-value {
      font-size: 16px;
      font-weight: 700;
      color: #667eea;
      display: block;
    }

    .agent-stat-label {
      font-size: 11px;
      color: #999;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    /* Agent Social Links */
    .agent-social {
      display: flex;
      gap: 10px;
      margin-top: 15px;
    }

    .agent-social a {
      width: 35px;
      height: 35px;
      border-radius: 50%;
      background: #f5f5f5;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #667eea;
      transition: all 0.3s ease;
      text-decoration: none;
      font-size: 14px;
    }

    .agent-social a:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateY(-3px);
    }

    /* View Details Button */
    .view-details-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
      border: none;
      cursor: pointer;
      width: 100%;
      text-align: center;
      margin-top: 15px;
    }

    .view-details-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
      color: white;
      text-decoration: none;
    }

    /* Animations */
    @keyframes fadeInDown {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .agent-card {
      animation: fadeInDown 0.6s ease-out both;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .agents-section {
        padding: 40px 0;
      }

      .agents-grid {
        gap: 20px;
      }

      .agent-card-content {
        padding: 20px;
      }

      .agent-card-name {
        font-size: 18px;
      }

      .agent-stats {
        gap: 10px;
      }

      .agent-stat-value {
        font-size: 14px;
      }
    }

    @media (max-width: 480px) {
      .agents-section {
        padding: 30px 0;
      }

      .agents-grid {
        grid-template-columns: 1fr;
        gap: 15px;
      }

      .agents-title h2 {
        font-size: 28px;
      }

      .agents-title p {
        font-size: 14px;
      }

      .agent-card-content {
        padding: 15px;
      }

      .agent-card-name {
        font-size: 16px;
      }

      .agent-social {
        gap: 8px;
      }

      .agent-social a {
        width: 32px;
        height: 32px;
        font-size: 12px;
      }
    }

    /* Stagger animation for cards */
    .agent-card:nth-child(1) { animation-delay: 0.1s; }
    .agent-card:nth-child(2) { animation-delay: 0.2s; }
    .agent-card:nth-child(3) { animation-delay: 0.3s; }
    .agent-card:nth-child(4) { animation-delay: 0.4s; }
    .agent-card:nth-child(5) { animation-delay: 0.5s; }
    .agent-card:nth-child(6) { animation-delay: 0.6s; }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">Our Professional Agents</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current">Agents</span>
      </div>
    </div>
  </div>

  <!-- Agents Section -->
  <section class="agents-section">
    <div class="container">
      <!-- Section Title -->
      <div class="agents-title">
        <h2>Meet Our Expert Agents</h2>
        <p>Our experienced team of real estate professionals is dedicated to finding you the perfect property match</p>
      </div>

      <!-- Agents Grid -->
      <div class="agents-grid">
        <?php if (!empty($agents)): ?>
          <?php foreach ($agents as $agent): ?>
            <div class="agent-card">
              <!-- Agent Image -->
              <div class="agent-card-image">
                <img src="<?php echo htmlspecialchars($agent['image_url']); ?>" alt="<?php echo htmlspecialchars($agent['name']); ?>">
                
                <!-- Rating Badge -->
                <div class="agent-rating-badge">
                  ⭐ <?php echo number_format($agent['rating'], 1); ?>
                </div>

                <!-- Overlay -->
                <div class="agent-card-overlay">
                  <div class="agent-card-overlay-text">✓ <?php echo $agent['properties_sold']; ?> Properties Sold</div>
                  <div class="agent-card-overlay-text">✓ <?php echo $agent['experience']; ?> Years Experience</div>
                </div>
              </div>

              <!-- Agent Content -->
              <div class="agent-card-content">
                <h3 class="agent-card-name"><?php echo htmlspecialchars($agent['name']); ?></h3>
                <p class="agent-card-position"><?php echo htmlspecialchars($agent['position']); ?></p>
                <p class="agent-specialization">📍 <?php echo htmlspecialchars($agent['specialization']); ?></p>

                <!-- Stats -->
                <div class="agent-stats">
                  <div class="agent-stat">
                    <span class="agent-stat-value"><?php echo $agent['properties_sold']; ?></span>
                    <span class="agent-stat-label">Sold</span>
                  </div>
                  <div class="agent-stat">
                    <span class="agent-stat-value"><?php echo $agent['experience']; ?></span>
                    <span class="agent-stat-label">Years</span>
                  </div>
                  <div class="agent-stat">
                    <span class="agent-stat-value">★<?php echo number_format($agent['rating'], 1); ?></span>
                    <span class="agent-stat-label">Rating</span>
                  </div>
                </div>

                <!-- Social Links -->
                <div class="agent-social">
                  <?php if (!empty($agent['facebook_url'])): ?>
                    <a href="<?php echo htmlspecialchars($agent['facebook_url']); ?>" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                  <?php endif; ?>
                  <?php if (!empty($agent['twitter_url'])): ?>
                    <a href="<?php echo htmlspecialchars($agent['twitter_url']); ?>" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a>
                  <?php endif; ?>
                  <?php if (!empty($agent['linkedin_url'])): ?>
                    <a href="<?php echo htmlspecialchars($agent['linkedin_url']); ?>" target="_blank" title="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
                  <?php endif; ?>
                  <?php if (!empty($agent['instagram_url'])): ?>
                    <a href="<?php echo htmlspecialchars($agent['instagram_url']); ?>" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a>
                  <?php endif; ?>
                </div>

                <!-- View Details Button -->
                <a href="agent-details.php?id=<?php echo $agent['id']; ?>" class="view-details-btn">
                  View Full Profile →
                </a>
              </div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <div style="grid-column: 1/-1; text-align: center; padding: 60px 0; color: #999;">
            <p>No agents available at the moment.</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>

  <!-- Scripts -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
